---
title: 《随机漫步的傻瓜》读书笔记
date: '2021-07-10'
slug: fooled-by-randomness
---

几年前听我们厂长提过塔勒布的《随机漫步的傻瓜》这本书，说对他影响很大，但直到去年我才读它。[于淼两次提到](https://yufree.cn/cn/2019/08/04/skin-in-the-game/)这本书是塔勒布不确定性丛书的第一本，后面的书可以当做这一本的局部扩展，所以我感觉要是像我这样时间有限，先争取读完这本、把其它的留到将来再读（感觉可能性不大了）可能是明智的选择。

去年夏天读完，觉得确实有不少感触。冬天给母校作报告时，便化用出一个类似的标题叫《[随机漫步十八年的傻瓜](https://slides.yihui.org/2020-random-walk.html)》（指我自己）。报告中讲的一个中心思想便是这本书给我最大的启示：当我们解释一件事情的起因时，不妨将随机性也作为一个可能性。这句话听起来平淡无奇，但我感觉同样是知易行难。我们太过熟悉和依赖确定性的思维。谁为何成功、谁为何失败、谁为何飞升、谁为何狗带，也许根本就没个理由。正所谓：一开始我只相信，伟大的是感情；最后我无力地看清，强悍的是命运。

于淼的《[润物无声](https://yufree.cn/cn/2020/05/09/drift/)》也反映了这个意思，可以作为塔勒布这本书的简版。闲话少说，笔记贴上。书前面的推荐语中提到巴菲特小心地避开黑天鹅：

> 巴菲特如此总结一生投资赚钱的经验：投资成功，只要能够尽量避免犯下重大错误，投资者只需要做很少的正确事情就足以保证盈利了。
>
> 巴菲特的成功秘诀可以归纳为两个基本点：一是成大功，二是避大险。成大功，才能赚大钱，但避大险更重要。很多人开始成了大功，后来却未能避开大险，结果死得很惨。只有很少人活到最后，赚到最后，笑到最后。投资是长跑，比赛结束时才真正见分晓。
>
> 巴菲特分析，认识黑天鹅事件的错误是：“只关注历史经验（experience），而没有关注风险暴露（exposure）。”

关于经验的影响，后面塔勒布自己还会再谈。

## 前言 幸运的交易员

塔勒布的舌头比较毒，以下先是对文人的吐槽，后面还有吐槽历史学家、新闻记者等。不过下面这段话在我眼中倒也实在，有些艺术本来就是在制造、修饰、解释噪声。我并不觉得这种艺术有什么不好，只是小心不要把这种思维推广开来就好，即：不要试图从现实生活中无意义的噪声里寻求解释和意义。

> 虽然有以偏概全之嫌，我还是要指出，文人有故意将噪声（noise）和意义（meaning）混为一谈的倾向，也就是把随意构成的作品和刻意营造的信息混淆。不过这于事无损，很少有人会认为艺术是探索事实真相的工具，艺术不过是逃避事实或者让真相更称心愉快的方法。由于我们没有能力或者不愿接受随机现象，因此象征主义诞生，我们为各色各样的形状赋予意义，我们在墨渍的痕迹中探查人类的形象。

## 第一篇 黑天鹅事件

### 第一章 赚钱的随机性

塔勒布虚构了一个对随机性保持高度警惕的人物，叫塔利波，看样子是为了给他自己代言。比如塔利波不碰股票：

> 塔利波十分怀疑股票市场，认为那是某种投资骗局，因此死也不肯持有股票。

我也不碰任何投资理财的工具，包括股票，主要是我的财富安全感很高；即使我遭遇黑天鹅事件，我觉得我不会一下子就垮掉，因为我平淡而广阔的人际关系网给我上了一道强力保险（要是我发生意外，后面的观众朋友们你们一定不会见死不救的，对不对）。另外一方面，我不喜欢内心被钱拉扯，就像下面指出的：

> 心理学家卡尼曼（Daniel Kahneman）和特沃斯基（Amos Tversky）指出，大部分人宁可在别人赚 6 万美元时，自己赚得 7 万美元，而不喜欢在别人赚 9 万美元时，自己能够赚得 8 万美元。

朋友们问我为何不炒股时，我的回答便是，炒股的结果只有两种：要么是赔，要么是没赚够（无论是哪种我都不开心）。跟上面说的是一个意思。

自信的人容易感染别人，但那个自信满满的权威，也许只是个临时性的幸运的傻瓜：

> 同样，一个人有了好表现，不管那是必然如此，还是幸运女神眷顾的结果，都会促使他的血清素增加，而这又导致所谓的领导统御能力提升，也就是说，这个人“步步高升”。举止行为上一些细微的变化，例如能够冷静自信地表达个人意见，会使一个人看起来权威可靠，好像他赚那么多钱是应该的。细数他表现优异的原因时，随机的因素很少被考虑进来，直到它再次兴起，奋力一击，引发恶性循环。

### 第二章 奇特的结算方法

不以成败论英雄，我当然深为赞同。假如英雄降生在另一种历史环境下，他还会依旧是英雄吗？

> 首先我要老调重弹：不管是战争、政治、医疗或投资各方面，我们都不能以成败论英雄，而必须从“假如历史以另一种方式呈现”的另类成本来论断成败。这种以不同方式呈现的历史，我们称之为“另类历史”。我们不能单凭结果就判定一项决策的优劣，但这样的观点似乎只有失败的人才会接受，成功者总把成功归因于决策得好。

一把能装六发子弹的转盘手枪，里面随机装一颗子弹，要是打不中你就给你一千万。这个概率人人皆知。现实生活是一个更大的转盘，所以我们很容易忽略黑天鹅，并且去追捧那些千万富豪，却不知他们可能只不过是侥幸躲过了黑天鹅而已。

> 现实生活比俄罗斯转盘邪恶多了。首先，它不仅常常射出要命的子弹，它的弹夹还可装几百发、几千发子弹，而不像左轮手枪最多只装6发。试过几十次之后，我们便忘了里面还有一颗子弹，误以为自己很安全。本书把这件事称做“黑天鹅问题”，将于第七章讨论。这个问题和让一些探讨科学的哲学家辗转难眠的归纳法问题有关。它也和称做拒斥历史（denigration of history）的问题有关，因为赌徒、投资人、决策者总是觉得，发生在别人身上的事情，不见得会发生在他们身上。
>
> 其次，俄罗斯转盘这类游戏的玩法非常明确，只要会 6 的乘除法的人都知道它们的风险。但一般人却看不到现实生活举起的枪管。肉眼很难看到这些发生器（generator），因此我们可能在不知不觉中就玩上俄罗斯转盘，只是以另外较“低风险”的名称称呼它而已。我们看到有人赚得巨额财富，却没看清楚操作原理，因此不知道它们的风险，也没看到输家。这种游戏看起来容易得很，我们也玩得兴高采烈。

塔勒布认为能考虑随机性的人具有内省的特质。不过我并不是很同意他下面最后一句话的推理。他说的那个“目前”是 2001 年，也许那时候学位还不像现在这样通货膨胀，放在现在，我不太相信博士论文主要是靠过人的求知欲完成的。

> 我见过数百人来来去去，不得不表示，受过一点科学训练的人，往往比较有成就。对许多人来说，这样的想法有如第二天性，原因不见得和他们所受因果关系的科学训练本身有关，而在于决定献身科学研究的这些人，对于知识往往具有根深蒂固的好奇心，以及内省的倾向，有些人由于没办法潜心研究范围狭隘的问题，不得不放弃科学研究，却因此特别擅长于动脑筋思考。目前如果没有过人的求知欲，几乎不可能完成博士论文，而如果缺乏专精于某一学科的欲望，则不可能走上科学生涯。

开始表扬科学家以后，就接着吐槽 MBA 和会计了（当然谁都喜欢那种自然流露兴趣的人和谈话）：

> 20 世纪 80 年代时，和 MBA 或拥有税务会计背景的同事聊天，他们总是夸夸其谈财务会计标准委员会（FASB）制定的标准。但我得说，他们的兴趣实在缺乏感染力。这些物理学家叫人感兴趣的地方，不在于他们有能力讨论流体力学，而在于他们对各类知识性话题自然而然流露的兴趣，和他们谈话让人觉得愉快。

表扬《伊利亚特》不以成败论英雄：

> 英雄之所以是英雄，是因为他们的行为十分英勇，而不是因为战场上的成败。

同我一样，塔勒布难以控制图像媒介的影响，因而避开它，不知这是一部分人的共性，还是我们恰好都中了[波兹曼的毒](/cn/2018/04/amusing-ourselves-to-death/)：

> 听新闻媒体讲话有时会叫我跺脚，主要是因为我不习惯，而且面对会动的影像时，我会变得很情绪化。

借用爱因斯坦的毒舌：

> 爱因斯坦说过，常识不过是 18 岁以前学得的一大堆错误看法。

### 第三章 从数学的角度思考历史

塔勒布讨厌新闻和记者，因为他们报道了太多原始的噪声。近两天我才发现，依含大人早在 2013 年就[写过一篇日志](https://yihanxu.github.io/lessnews/)，表达了类似的意思，而[我到 2018 年](/cn/2018/03/hate-news/)才意识到这个问题，而且还远不如依含深刻。

> 关于噪声和信息的不同，我们可以拿新闻和历史来做比较。为了出人头地，新闻记者应该像历史学家那样看事情，并且淡化他所提供信息的价值，比方说，他可以表示：“今天市场上扬，但这则信息不重要，因为来源主要是噪声。”不过，如此小看手头上的信息，他肯定会丢掉饭碗。要求新闻记者以历史学家的方式去思考很困难，但可叹的是，现在的历史学家竟然越来越像新闻记者。

大量的噪声信息不仅令人分心，还有毒。不过毒舌塔勒布也说，幸亏有那么多不懂随机性的笨蛋同行被这些噪声牵着鼻子走，他才能赚钱。

> 信息的问题不在于它令我们分心且通常一无用处，而是在于它含有毒性。在更后面我们会针对信号过滤和观察频率做更技术性的讨论，探讨经常发生的新闻，其价值令人怀疑。我在这里只指出，对于尊重老东西的相关论点，可用以排除与胡说八道的现代新闻记者往来，且决策者处于不确定状态时，应该奉行的指导原则是尽量少接触新闻媒体。如果每天轰炸我们的大量“紧急”新闻中，有比噪声还好的东西，那只能说是沧海一粟。人们不了解新闻媒体引起你的注意才有收入可赚，对新闻记者来说，沉默可不是金。

赞扬席勒对理性和有效市场的否定：

> 关于信息对社会具负面价值的看法，有许多来自席勒（Robert Shiller）。席勒 1981 年发表的文章，从数学的角度探讨社会处理信息的方式。这可能是第一篇这样的文章，文章中谈到市场波动性的问题。他认为，如果股价是“某种东西”（例如一公司的折现现金流量）的估计价值，那么和那“某种东西”有形的表征（以股利为代表）相比较，市场价格的波动幅度未免太大。价格波动的幅度，大于它们所应反映的基本面因素；有时过度反应，涨得太高，例如价格因为好消息，应声上扬，或者根本欠缺明显的理由就上涨；有时却跌得太低。从价格和信息间的波动性差距，可以判断“理性预期”并没有发生作用。价格涨跌太大，没有理性反映证券的长期价值，因此市场一定有什么地方出了差错，所以席勒宣称市场不像财务理论所说的那么有效率。简而言之，高效率市场是指价格应该反映所有可以获得的信息，我们根本无法预测它的走势，也无法从中赚取利润。席勒的异端邪说引来一片讨伐之声，于是他惨遭威尔批判。

大力批判席勒的人里，有一位却成了一个避险基金的合伙创办人：

> 现代金融信条和高效率市场理论的卫道之士，竟然成立一个基金，想从市场的无效率现象中获利！

吐槽记者群体里的劣币驱逐良币问题：

> 记者那一行中还是有不少懂得深思熟虑的人，只是主流媒体新闻依然不动大脑，只顾提供引人注意的噪声，而且没有什么机制能够区分两者。事实上，聪明的新闻记者反而遭到了惩罚。第十一章将谈到的律师，不顾真相为何，只关心能够左右陪审团意见的论点；他太了解陪审团理智上的弱点。新闻媒体也是一样，只关心哪些东西能够吸引我们的注意力。新闻媒体的这种做法，尽人皆知，学术界的朋友一定不懂为什么我谈到这件事时会动气，我们这一行的问题出在必须依赖他们提供我们需要的信息。

引用希腊诗人卡瓦菲斯表明内行看门道、外行看热闹（噪声）：

> 他们全神专注于冥想中，事物隐藏的声音传到他们耳里，他们听得十分虔诚，而外面街道上的人，什么也没听到。

为了抵御短期内的噪声对（投资）情绪的影响，干脆不看信息。下面的理念和我倒是有些类似（读诗、等着重要消息传到我耳朵里而不是漫无目的瞎看），不过我承认有时候我仍然会手贱刷微博和推特：

> 最后，我必须承认，我也有这种情绪上的缺陷。但我的应对办法，是断绝获得信息的渠道，除非在极少见的状况中。这种时候，我喜欢去读诗，要是真有某个事件很重要，它总有办法传抵我的耳朵。

### 第四章 随机性和科学知识分子

归纳的经验可能很难甚至不能证实。有多少人能接受这句话？

> 而当经验论带给一个人信心的时候，可能比其他任何形式的垃圾还糟。

开始吐槽人文学者：

> 只要在文章后面列一堆所谓的科学参考文献，就可以让人文学者相信你写的是科学著作。

塔勒布提到一本书叫《知识的骗局》，这书道金斯在《魔鬼的牧师》中专门用一篇题为《被脱光的后现代主义》的文章评论过，非常搞笑。以后写道金斯这本书的读书笔记时我再详述。

> 随机性对事情的帮助可能很大。要区分天花乱坠的人和真正的思想家，还有另一种更为有趣的方式。有时你可以用蒙特 · 卡罗发生器复制某样东西，让人以为那是文学作品；但是你却不可能用随机的方式写出一篇科学作品。词汇可以随机组成，但真正的科学知识却没办法。

索卡尔一篇无意义词句组成的恶作剧投稿居然发表了，说明某些人文刊物的评审有些荒谬。不过这种试验有多大的可重复性呢？可能是钓鱼投稿碰巧钓到了。毒舌继续：

> 由于人文学者的想法含混不清，很容易被随机性所骗。

### 第五章 最不适者可能生存吗？

回音壁：

> 经验丰富的交易员康奈尔把这叫做消防站效应。他观察到，消防队员闲着没事干，久而久之，聊得太多，就会对很多事情形成相同的看法，而这些看法，在客观的局外人看来，十分荒唐可笑。

### 第六章 偏态与不对称

偏态的概念应该不是古尔德发现的，而是早就存在了，不过这个统计上的谬误倒是太常见了。也就是人们很可能用一个不恰当的汇总统计量来描述数据，比如均值、中位数都有它们各自的缺陷。我从来不明白的一点是，如果有原始数据，为啥不能至少先画一幅直方图看看呢？在没有看到分布的情况下，单值汇总很可能说明不了问题。

> 这就是不对称（asymmetry）现象。活不到 8 个月的人，很早就死掉了，而活过 8 个月以上的人，则继续活得更久。结果出现不对称时，存活期平均值和存活期中位数并不相同。古尔德因此发现偏态（skewness）的概念，因而呕心沥血写下《中位数不能传达什么》（The Median is Not the Message）一文。文内的主旨是，医学研究机构使用的中位数概念，不具备概率分布的特性。

攻击计量经济学：

> 自 19 岁以来，我大半辈子的时间都在研究和应用计量经济学，包括在课堂上和担任计量衍生性金融商品交易员时。计量经济学这门“科学”是指将统计学应用到从不同的时期（我们称为时间序列）选出的样本上。它做的事是研究经济变量、资料和其他事物的时间序列。起初，当我几乎一无所知时，很怀疑那些反映已故或已退休的人，他们的行为时间序列，对于预测未来是不是有帮助。比我懂很多的计量经济学家不问这种问题，因为那无异于自曝其短，徒然让人知道自己的愚蠢。知名的计量经济学家裴沙连（Hashem Pesaran）曾经回答类似的问题，他建议对方去研究“更多和更好的计量经济学”。我现在相信或许大部分的计量经济学一无用处，财务统计学家所学的很多东西根本不值一学。

### 第七章 归纳法的问题

怀疑论者休谟不相信根据经验观察得到的结论。无论观察到多少白天鹅，都无法下结论说世上的天鹅都是白的。这就是“黑天鹅问题”的起源。

> 休谟厌恶 18 世纪当时的科学受到培根的影响，从士林哲学（scholasticism）转而对天真的经验论产生过度的反应。士林哲学奠基于演绎法则，不强调对真实世界的观察。培根反对在没有实际成果的情形下，“结成学习蜘蛛网”。受到培根的影响，科学转而强调经验的观察。问题是，如果方法不适当，经验观察会引导你误入歧途。

因果关系可能不像观察中的那样明显，甚至观察到的因果关系可能并不存在。车祸更容易发生在家的附近，只是因为开车的人大部分时间在家的附近开，而开远途相对少。离家的远近，与车祸是否更容易发生，并没有关系。

> 车祸经常发生在家的附近。

塔勒布与尼德霍夫的异同：

> 虽然尼德霍夫和我的交易方式南辕北辙，他经手的许多金融商品最后都由我持有，但我对他仍非常敬重。他靠卖价外期权（out-of-the-money option）为生；我则靠买进它们为生。卖出价外期权是赌某个事件不会发生；但我买进价外期权，则只赌它可能发生。他试着赚取稳定的收入，我则喜欢偶尔一次来个大丰收。
>
> 虽然我们看起来是截然不同的交易员，表面上却有许多相同的个人特征。或许这些事情值得一提，因为我们都把个人的特征纳为交易的一部分，而且对于一般人所说的“工作”和“玩乐”的分野，不怎么在意。我们都试着活在经营科学实验室的错觉底下。我们都喜欢与学者、科学家为伍，不喜欢和商人待在一起；和成功的科学家交谈可以避免我们的思想变得呆板。我们都想过着维多利亚绅士型学者的生活，书籍散落四周，借以避开20世纪常见的许多纷扰。我们都努力凸显个人不俗的气质，以免在知识水平上看起来和群众没有两样。我们都很喜欢每天运动。尼德霍夫仿效的是维多利亚时期的绅士，他崇拜的英雄高尔顿（Francis Galton）是达尔文的表兄弟，对应用统计学贡献卓著。而我就像真正维多利亚时代的人，是个不折不扣的古典主义者，且迄今仍沉湎在希腊罗马文化中，我崇拜的英雄大多是文学人物。我们都极力避开媒体、电视和报纸，但尼德霍夫更是讨厌它们。我们都不喜欢闲谈扯淡，视之如瘟疫，因为那表示出现太多“混为一谈表”左栏的噪声。

波普尔对塔勒布的影响：

> 据说人们通常记得在什么时候、什么地方被某个重要的观念感动。我也记得一清二楚。受到索罗斯的激励，1987 年我在纽约第二十一街和第五大道路口的巴诺书店（Barnes & Noble）一口气看了 50 页《科学发现的逻辑》（The Logic of Scientific Discovery），并且疯狂买下双手抱得动的所有波普尔著作，担心以后会缺货买不到。

波普尔讲科学理论只有两种：一种是已证伪的，另一种是待证伪的。我在人大上学时，吴喜之老师便经常引用这句话。

> 如果一个理论没有包含一组可以被验证为错误的条件，只能称之为骗术—否则无法加以驳斥。

## 第二篇 打字机前的猴子

我没看英文原文，但下面的“资料”看起来像是台湾术语，也就是大陆的“数据”。这句话，我一般是这样转述的：从数据到结论很好，但不要只从数据到结论。

> 一般推论上的一大问题是：靠资料做结论的人，往往比别人更快、更有信心地堕入这个陷阱中。我们拥有的资料越多，淹没在里面的可能性越高。

### 第九章 买卖证券比煎蛋容易

多年前我就听说过回测，但从来不知道它是什么意思。下面塔勒布讲了以后我才明白。这不就跟统计里面做多重比较但不调整 P 值一样无意义嘛。在噪声里只要找的时间足够长，总能找出一种模式。

> 有位程序设计师帮我设计了一套历史资料回测程序（backtester）。这套软件程序连接到一个历史价格数据库，可以让我观察：利用不同的操作法则，能够得到什么样的绩效。由此得出的绩效数字，是根据过去的价格资料计算的。我可以只用机械式的操作法则，比方说，在纳斯达克上市的股票，只要收盘价比上个星期的平均价格高 1.83%，我就买进。订了这个法则，马上就能算出我的绩效如何。屏幕上会跳出那个操作法则得到的假设性绩效记录。如果我对结果不满意，可以把百分率调整为 1.2%。我也可以设定更为复杂的法则。就这么一直试下去，直到找到绩效令人满意的操作法则。
>
> 我到底在做什么？没错，是在一组可能行得通的操作法则中寻找存活者。我拿法则去套用数据，这件事称做数据探索。只要靠运气，我尝试的次数越多，越有可能找到一个非常适合过去数据的法则。一个随机系列总会呈现某种可察觉的形态。我相信西方世界一定有某种证券，它的价格和蒙古首都乌兰巴托的温度变化百分之百相关。

鲍林对维生素 C 治感冒甚至抗癌的迷信，不知道后人要用多少年才能不再相信。这件事[查理芒格](/cn/2018/08/poor-charlies-almanack/)也提过。我觉得这种事情就是因为成本太低，人们宁愿先信一下、试一下，反正也不会有什么损失，而且，万一真治好了呢？

> 虽然时代不断在进步，人们依然听信这种信息，以为某些疾病可以靠这些方法治好，而科学证据的说服力竟然不敌外表真诚且情绪化的证词。这种证词不一定都出自普通人嘴里，诺贝尔奖得主的越界发言也时有所闻，例如获得诺贝尔化学奖的鲍林（Linus Pauling），据说相信维生素 C 具有很好的医疗效果，本人每天大量服用。由于他的强力推荐，一般人便相信维生素 C 真的具有疗效。许多医学研究无法证实鲍林的说法，但一般人对此却充耳不闻，他们宁可采信“诺贝尔奖得主”的证词，即使他没有资格讨论和医学有关的事情。

书中提到一个“癌症丛集”的现象，可以纠正我们对“随机”的一个常见误解。这个误解就是，我们认为随机意味着“均匀”。比如要是我们观察到癌症在某些地区有丛集现象，也就是某些局部地区的癌症病人比周围地区多，那么我们很可能就会认为这些局部地区有什么不对劲的地方（律师发财的机会要来了）。实际上，就算你把癌症患者随机地往地图上撒，也会撒出一些“丛集”来。08 年我写过一篇日志，[根据抛硬币的结果判断哪枚硬币不均匀](/cn/2008/09/eyeball-test-fake-coin/)。凭直觉的话，我想多数人会猜错。就算随机产生 0 和 1，也容易观察到它们各自形成长串；而 0 和 1 频繁交替出现的结果，看似均匀，实际上更不随机。

[我一直坚定认为](/cn/2017/07/publish-negative-results/)，就算统计结果不显著，也有发表的价值。塔勒布也认为不显著也提供了信息。

> 什么事情也没发生这个事实，可能包含重要的信息，正如在《银色马》（Silver Blaze）中福尔摩斯指出的，奇怪的事是狗并没有吠。造成更大问题的是，许多科学成果没有发表，因为它们的数据并未呈现统计上的显著差别，不过实际上它们还是提供了一些信息。

### 第十章 生活中的非线性现象

这一章说的非线性是指类似[蝴蝶效应](https://yihanxu.github.io/butterfly/)的效应，比如一点起始的小优势或者运气，最终带来惊人的回报。这就像[我前年提过的](/cn/2019/07/flywheel/)飞轮效应。塔勒布对比尔盖茨也一样不客气：

> 信息时代促使人们的品位趋于一致，导致不公平现象更为尖锐—赢家几乎可掌控全部的顾客。软件制造商微软公司（Microsoft）和其喜怒无常的创办人比尔·盖茨（Bill Gates），正是邀天之幸大获成功的最佳写照。我们不能否认盖茨有很高的个人标准、工作伦理，而且智力高于一般人，但业内就数他最优秀吗？这一切都是他该得的吗？显然不是。大部分人选用他的软件，只是因为别人也都在使用他的软件，我就是这样。这纯粹属于循环效应（circular effect），经济学家称之为“网络外部性”（network externalities）。从来没人说那是最好的软件产品。比尔·盖茨的大部分竞争对手对于他的成功嫉羡不已，他能够赢得那么大一块饼，而其他许多人却必须为公司的生存努力，这件事叫人愤恨难平。
>
> 这种事情有违古典经济模式。依古典经济模式，事必有因，没有不确定性这回事，且好人终将出头（好人是指能力较强且拥有较优越技术的人）。经济学家很晚才发现路径依赖效应，之后大量发表这方面的论著。比方说，圣塔菲研究所（Santa Fe Institute）的经济学家布赖恩·阿瑟（Brian Arthur）埋首研究非线性现象后表示，经济优越性取决于概率事件加上正面回馈，而不是看技术优越性。也就是说，某个特定领域中定义深奥难懂的某种专长，并无法让人取得经济优越性。早期的经济模式排除了随机性，但阿瑟却表示：“非预期的秩序、与律师偶然见面、管理阶层一时起念……有助于确定哪家公司能够率先销售产品，以及哪家公司未来将居于主宰地位。”

塔勒布认为理论中的数学和真实世界相去甚远：

> 经济学发展成一门科学的过程中，什么地方出了差错？答案是一群聪明人觉得一定得用数学来告诉自己，他们的想法很严谨、他们研究的是一门科学。瓦尔拉斯（Leon Walras）、德布鲁（Gerard Debreu）、萨缪尔森（Paul Samuelson）等人急着引进数学模型建构技巧，却没有考虑到也许他们使用的数学，对于他们想要处理的这类问题来说有太多限制；或者他们应该注意，数学语言的精确性可能导致人们在尚未找到解答时，就误以为他们已经得到答案。他们所用的数学确实没办法在真实的世界中运作，原因可能是我们需要更丰富的操作程序—而且他们拒绝接受没有数学可能更好的事实。

相比起数学，塔勒布更推崇蒙特卡罗模拟：

> 正如我在第四章所说，在我们的随机世界中，数学只是一种思考方式，除此几无其他作用。

下面这个两极化现象也同样让我感到不安：

> 突然之间，我了解到这个世界的两极化现象对我打击很大。一个人不是大获成功，吸引到所有的资金，就是一毛钱也别想得到。出书也是一样，有时是每个人都抢着要出版，有时则是没人肯回你电话。这令我非常不安。太成功容易树敌，太失败则叫人气馁。如果可以选择的话，两者我都不要。

### 第十一章 我们是概率盲

上个世纪最有影响力的经济学家是两位心理学家：

> 从期刊列为参考文献、支持人数，以及对所属专业的影响来说，谁是上个世纪最具影响力的经济学家？不是凯恩斯，不是马歇尔（Alfred Marshall），不是萨缪尔森，也当然不是弗里德曼（Milton Friedman），而是心理学家卡尼曼和特沃斯基，他们的专长是发掘人类在哪些地方欠缺理性思考和最优化的经济行为。
>
> 关于我们如何感觉和处理不确定性，两人教了我们许多东西。他们在 20 世纪 70 年代初针对一群学生和教授进行研究，显示我们并没有正确了解突发事件。此外，他们也指出，在我们了解概率的罕见情况下，也似乎没在本身的行为中把它纳入考虑。自卡尼曼和特沃斯基的研究发表以来，称做行为财务学和经济学的一个完整新学科已经开花结果。它与商学院教的所谓新古典经济学公开冲突，这个正统底下的规范性名称有高效率市场、理性预期等观念。

## 第三篇 活在随机世界中

再次提到逃避噪声：

> 我最引以为豪的成就，是戒掉了接触电视和新闻媒体的习惯。戒掉之后，发现看电视比做其他事，譬如写这本书，还耗费精力。但我还是耍了一些花招，如果不耍些花招，我就没办法逃避这个信息时代的毒害。

### 第十二章 赌徒的迷信和笼中的鸽子

斯金纳的鸽子会在完全随机喂食的方式中“找到”某种它们认为能得到食物的模式。我们认为的因果关系，是否也是随机的结果呢？

> 我们生来不会把不同的事情独立开来看待。观察 A 和 B 两件事时，我们很难不假设是 A 造成 B、B 造成 A，或者两者彼此影响，我们的偏差会立即在其间建立因果关系。

就算有理性，也未必能逃脱本性的驱使（比如明知是噪声，还是控制不住想要去响应的情绪）。塔勒布对巧克力的处理，跟我对零食一样——我喜欢吃吗？作为活人，当然喜欢。但我吃吗？一般不吃。原因只是我一般不买。

> 这就像想吃巧克力时，把脑子和口腹之欲分离开来。我的做法是绝不在交易台底下摆巧克力。

### 第十三章 概率与怀疑论

留下概率的余地、否定以前的自己并不是圆滑：

> 在地中海沿岸被一神论主宰，因而信奉某种形式的唯一真理之前，许多重要的思想家都持怀疑论，此学派也随之传播到世界各地。罗马人并没有自身的宗教，他们的态度宽容，不会只接纳特定一种真理，他们有的是各式各样富弹性且彼此交融的迷信。十几个世纪后，西方世界才再度揭示批判性思想的重要性。
>
> 从古代作家西塞罗（Cicero）身上，我们发现了这种思想存在的证据。他宁可被概率牵着鼻子走，也不肯百分之百肯定某些事情。有人说他太圆滑，因为这么一来他便可以自相矛盾。没错，一般文学教授会指责他自相矛盾、屡屡变卦。但对于向波普尔学得如何自我批判的我们来说，这可能是我们更加敬重他的原因，因为他绝不会只因过去讲过，就冥顽不灵地坚持原来的意见。

对马科维茨及同行建立的长期资本管理公司的垮掉，以及他们在垮台后的表现（指责他人而不是从错误中学习），塔勒布提出了尖锐的批判。

> 科学家的言行可能被逼得像廉价辩护律师般，而不是单纯的真理追求者。提出博士论文的人，必须为它“辩护”；主试者列举令人信服的论点证明论文的观点不正确时，我们极少见到学生改变心意。但是科学比科学家要好。有人说，科学的进化是从一场葬礼赶往另一场葬礼。长期资本管理公司垮掉后，会有一位新的财务经济学家出现，将相关知识纳入他的学说中。同样，以前的老财务经济学家会抗拒排挤他，但他们比他更接近坟墓。

### 第十四章 掌控随机现象

如何掌控随机？这一章的建议不是技术性而是哲学性的，尤其是斯多葛哲学。今人常常祈祷，但古人并不相信这有什么用：

> 要特别指出的是，在所谓的地中海一神论传布之前，古人并不十分相信祈祷能够改变命运的方向。他们的生活充满危险，外敌随时入侵、命运说变就变，应付随机现象时，他们需要实质的教条。

斯多葛哲学的真正意义（恐怕这又和世间绝大多数道理一样，知易行难了）：

> 情感震颤之际，只要倾听，毋需如懦夫般哀求怨叹。
>
> 情绪起伏时，坚定不为所动。有那些情绪反应并没有错，也不失尊严—人生来就有情绪。错的是不能像英雄般，或至少像个有尊严的人那样挺直腰杆。这才是斯多葛哲学的真正意义，它要人与概率平起平坐。

维多利亚时期的英格兰士绅信条：

> 禁欲主义者乃集智慧、正直、勇气于一身之人，无畏于生命恶作剧造成的伤害，因此不受生命起伏波折的影响。

但斯多葛哲学总被人贴上“禁欲”的标签，这似乎也不是它的本意。是否是禁欲，取决于欲望有多强，以及个人的适配类型。同样一件事情，在一个人眼中是禁欲，在另一个人眼中可能完全是享受；比如我这篇笔记的后半部分是在袁阿姨家黑乎乎的没装修的地下室里写的，袁阿姨总怕我觉得黑，要给我开灯，而我其实很享受简陋而昏暗的环境，这样我更能集中精神。写完上楼感觉已经可以复兴在江湖中消失多年的古墓派……话说回来，我确实相信适当控制自己的欲望，能减轻随机事件对自己的影响。就像突如其来的新冠对我的物质生活毫无影响，因为我在衣食住行方面都没什么要求，把我在家里关一年还是七年，每天吃山珍海味还是喝稀饭，我都不在乎了。

下面这本书我去年在做一个 [Hugo 主题](https://github.com/yihui/hugo-prose)时翻过其中几篇，觉得确实还不错，等到猴年马月有空时再继续翻。

> 塞内卡（Seneca）写的《斯多葛哲人的来信》（Letters From a Stoic）一书，有较富于人性的一面，可读性极高，我常买来送交易员朋友；塞内卡后来也为命运所困，自行了结生命。

纵观全书，感觉确实如于淼说的，塔勒布在书中的戾气有点重（攻击性很强）。不过我觉得这书还是让我颇为受益，比如我需要时常想想自己是不是那只在随机噪声中寻找并相信“模式”的鸽子。他对噪声（媒体、新闻）的回避，也加深了我相同的成见，我不知这是好事还是坏事。同时，不以成败论英雄的原则也让我反思了很久：有些“英雄”，可能只是历史的宠儿而已。反正我个人是坚定地相信，我自己的“成就”，相当大一部分应该归因于我的好运气：在恰当的时间遇上了难得的机遇。这不是假惺惺的谦虚。我只是众多随机漫步的傻瓜中的一个好运的傻瓜。

其实，就连这篇读书笔记，也是随机的产物。我本来还有二三十本我更愿意写笔记的其它书，但今年就只写了这一本，原因只是我当时要作那个《随机漫步十八年的傻瓜》的报告，所以我把这本书的所有划线部分从手机里复制粘贴到了电脑上。既然贴都贴出来了，那就写吧。
