---
title: 季读（二）：一晴方觉夏深
date: '2021-06-30'
slug: awaken-to-summer
---

1. [读到](https://www.douban.com/note/801672138/)范成大“连雨不知春去，一晴方觉夏深”。如文中所说，这种忘却时间或进度、而蓦然回首物是人非的体验，多数人应该都有过，但只有诗人能写出来。前几天在家庭群里看照片上的幺爹，才发现他也已经白发谢顶，我爹三弟兄现在都统一成这种造型了。五年前我回国时，他还是壮年模样一头浓密的黑发。群里的照片我一直在看，但都没察觉到今年哪天他突然就老了。

    疫情一年多，也不知啥时候能晴。都快丧失了时间的流逝感。

1. 一篇讲浏览器标签栏问题的文章，在我浏览器的标签栏里开了八个多月，今天终于读完关掉了。一共花了五分钟左右，文章本身价值并不太高。它讲这大量的标签页都是人脑的外置记忆，即脑子记不住的就放在浏览器里存着。我稍微反思了一下，我开着的这大批网页中，有些页面上其实只有一点局部信息对我有用，但没来得及整理，所以就把整个页面放那儿了。要是能抓紧花三五分钟整理一下，也不至于积攒出这么多标签页。

1. 如果存在精神正常和失常，我们如何判断一个人是否正常或失常？罗森汉恩在上个世纪七十年代[做了一个试验](https://en.wikipedia.org/wiki/Rosenhan_experiment)，其结果极大影响了精神病鉴定标准。这个试验安排了八个正常人假扮精神患者，骗过了精神病医生，被收入院；入院后他们就恢复了正常人的行为，结果反而被视为精神病恶化，不让出院。这说明一旦被贴上精神病标签，就很难再摆脱这个标签。前年有人对这个试验提出了[一些质疑](https://www.nature.com/articles/d41586-019-03268-y)，但我看了两遍，作者似乎也没有什么铁证认为试验是编造的，只是怀疑而已。我不明白为何不试着重复一下这个试验呢？如果可重复，那么原始试验是否真实，似乎就并不那么重要了。

    谁是正常人，谁是疯子，有时候答案并不是那么明显。赫尔岑在《往事与随想》里面对欧文（那个空想社会主义者）的评论让我有所共鸣：

    > 欧文传记的作者在谈到这一点时写道，这好比一个关在病房里的疯子说道：“整个世界认为我得了精神病，可是我认为这整个世界才是得了精神病，我的不幸在于：多数是在整个世界一边。”

    身为少数派，对抗多数派还是相当有压力的，尤其是少数派只是孤身一人时。

1. 给娃找童话故事时，发现一个[皮皮阅读网站](https://www.ppzuowen.com/book/)。只是粗略扫了几篇故事，觉得还行，先留个书签在此。

    找故事时，也碰巧看到一篇文章讲[华裔娃学中文的理由和方法](https://www.dealmoon.com/guide/768932)，比较符合我的理念和做法，比如尽量早教中文、尽量避免中英混杂。在家我是尽量讲纯中文，若孩子口中夹杂出英文表达，且英文有很常见的中文表达，那么我会即时翻译，让他了解对应的中文；我发现多数家长都是相反，即：孩子一旦夹杂英文词汇，立马就跟着他用夹杂的方式表达，这样孩子根本没有学习中文表达的机会，而且还伤害两门语言并进入难以逆转的恶性循环。我唯一不太在乎的一点是写字，因为我觉得这项技能以后可能只对学书法的孩子有用了，多数人都会变成电子输入为主，而手写会变成一个日常几乎用不到的功能。我的大娃五岁半时我开始教他拼音输入法（拼音实在是难教），现在可以跪在地上照着故事书打字打差不多一个小时，也可以跟人打字聊天了。感谢杨阿姨和袁阿姨半年来一直捧场与他对话，这给了他不少动力去打字。文中提到很多孩子每周去中文学校学几个小时、但回家不复习，还不如跟家长每天在家学习二十分钟，我也是非常同意。感觉多数家长都没动力或恒心去坚持。反正我是觉得中文无比之重要，至少这是华人家长与孩子之间沟通的重要桥梁。要是不重视这座桥梁，那家长只剩一个选择，那就是恶补英文，把自己培养成地道的本国人（因为孩子会是地道的本国人）。我觉得这两个选择都很难，但家长教孩子中文比家长自己学英文（以及更难的英语文化）要简单得多。在我所见的家长里，似乎只有江堂一位壮士在后一个选择上发力。

1. 白居易的一句“[夜深知雪重，时闻折竹声](https://www.douban.com/note/786005230/)”让我回忆了几分钟小时候的雪景。从声音的角度写雪，让我觉得既有新意，又能勾起怀旧感。想来我很少注意听雪的声音。小时候屋后有一大簇柔嫩的长竹和一片硬挺的短竹（方言里分别叫窝竹子和桂竹子，我不知学名叫啥），记忆中下雪从未压断过竹子。可能是白居易当时生活在北方，雪比较大。这简单的声音传进诗人的耳朵，再用简单的文字表达出来，读来让我有些佩服。

    最近[袁凡提到](https://github.com/earfanfan/BlogComments/issues/25#issuecomment-855566405)小时候种棉花的营养钵。本来我已经完全忘却这东西，不过她一提，我就又回想起来了种棉花的种种事情。然后耳边回响起近三十年前弹棉花的声音，音阶和节拍大致是“哆、哆、哆、哆、哆、哆、索、哆”的重复。不知我记忆是否准确。

1. 看了一个[语文老师的访谈](https://www.douban.com/note/785874178/)。我从成人的角度来看，自然是觉得这位老师的一些理念都很好，比如“一个好的老师应当能够唤起学生行驶向远方的渴望”，这让我联想起今年看到的《小王子》作者埃克苏佩里的一段话：

    > If you want to build a ship, don't drum up people to collect wood and don't assign them tasks and work, but rather teach them to long for the endless immensity of the sea.

    狄金森的《没有一艘船能像一本书》这首诗，现如今我深有感触，但要是放在我的学生时代，我几乎不可能有共鸣。问题在于当年的我作为一个理科生，几乎无法理解这些文科的东西，而且语文基本上也是为了应试。后面《阅读的力量》一书作者讲“没有要求、没有任务、没有压力、不需要讲课的阅读，才是提高语文能力最有效的手段”，如今我也感同身受了——[只有考完试，才有心开始学习](/cn/2011/05/i-hate-exams/)。语文对我来说奥妙无穷，只是这个奥妙直到我脱离了学习语文的功利目的若干年后才开始显现。

1. [日本年轻人真的不思进取吗](https://www.douban.com/note/783475681/)？看文中的两个例子的话，答案是否定的。当公交车司机以便欣赏城市四季风景，或者当理发师以便二十多年来每周能有两个自由的下午能打棒球，这能叫不思进取吗？只要他们自己内心喜欢，何必追求世俗意义上的成功、[把自己搞得那么焦虑](/cn/2019/06/childcare-anxiety/)？中国社会内卷了几年，现在钟摆似乎有点往回摆的意思了，又开始躺平。我只是希望这种躺平心理是众人自己内心的选择，是出于淡泊名利，而不是出于绝望和丧气。

1. 五年前读到[贺铸的《青玉案》](https://www.douban.com/note/779764491/)，同史上众多读者一样，大爱“一川烟草，满城风絮”这句。以至从那以后，每到杨絮飞舞的暮春初夏，我便经常想起这句词。文中提到的李后主那首《长相思》，我也一样喜欢。山远天高烟水寒，塞雁高飞人未还。这种简朴淡远的笔调，我还掌控不了。这篇文章最后对写诗行为的解读很有意思：

    > 诗本身就是倾听者，写诗就是对黑暗的突围，就是在寻求另一种生存。

1. 有朋友在找会写毛笔字的人，说是帮她的朋友给她朋友的武术老师“杰里大师”写一幅字，看起来像是要感谢老师。写字这事我就[不献丑了](/cn/2019/04/pencil-signature/)，不过我看[这感谢信中蹩脚的中文表达](https://user-images.githubusercontent.com/163582/123175427-652ac380-d447-11eb-960c-e222936d745c.png)，实在寝食难安，于是多嘴说了句如果要改写的话，也许我可以帮忙。四十五分钟后，拼凑了一首藏头诗：

    > 杰俊展武魂，里心无羁困。  
    大道常求索，师门四季春。

    朋友说你应该去参加诗词大会。我本来想说“我这三脚猫功夫就不去凑热闹了”，结果瞬间中二病来袭，接着用几分钟写了一首打油诗回复：

    > 三脚猫功夫，不敢凑热闹。  
    若去诗词会，观众恐等爆。  
    要问为什么，写得太慢鸟。  
    诗方憋一首，柯已烂三遭。

    尽管是搞笑的打油诗，写完后我对最后一句感到非常满意。上帝在云端，只闪了一个典；最后我眉一皱，头一点；有生之年，貂尾续狗，终不能幸免。

1. [与其为孩子铺好路，不如让孩子学会如何走好路](https://www.douban.com/note/803282794/)。这当然是本爹深切认同的理念，也深感如今面弯腰铺路的父母们有些南辕北辙——本是出于好心，却把不该插手的事情都给办好了。若一切障碍、困难、危险都消除掉，那在这[平整的路](/cn/2019/02/helicopter-parenting/)上，娃该干啥呢？

    > 当我们试图构建完美无缺的安全系统时，我们就会制造出新的、不可预见的问题，这几乎无可避免。

    > 我们相信，保护孩子远离环境危害或交通事故这样的举措当然是对孩子好，但很多时候，为了保护孩子远离危险，所选择的方式却会阻止他们获得经验，比如步行上学、爬树或使用剪刀。而这样的保护会使孩子因此错失习得技能、学会独立或进行风险评估的机会。

    我也相信风险是不可能完全消除的，孩子迟早要面对家长无法控制的风险。家长再努力看管孩子，总有不留神的时候。这种“二十四小时监控孩子、但一不留神他就出大事”的例子，就发生在我一个朋友身上过。而我从一开始就克制我对孩子的保护本能，比如娃学骑车时，我是抱着“让他摔断胳膊也没事”的心态的。是啊，摔断胳膊到底有什么事嘛，去医院接上就好啦。况且如果平时的安全教育和练习到位的话，真正摔断胳膊的可能性也很低。反倒是平时保护太周到、而娃对危险没有足够认知的情况下，才更容易出现鲁莽行为而出大事。

    > 父母们也特别擅长运用二元对立的思维：“如果某件事做不到百分百的安全，那它就有十足的危险。”

    这种二元对立思维在我眼里太普遍了。一丁点风险都会被无限放大，导致无论概率高低，只要风险存在，那么它简直就像一定会发生。

    > 在《优秀的绵羊》这本书中，德雷谢维奇曾这样写道：“拥有更多，唯一的意义就是超过其他人。没有哪个国家非得 20000 颗核弹头，除非别国有 19000 颗。同样，没有哪个孩子必须要参加 11 项课外活动，想一想，要那么多到底能有什么用？——除非已经有学生参加了 10 项。”

    没有对比就没有伤害。经常有亲属或朋友问，你家娃暑假里报了啥班呢？我对这个问题感到不解，仿佛这该是默认选项一样——为什么非得给娃报个什么班呢？他才刚满六岁、学前班毕业而已。我已经坚持了一年零八个月教他识字，现在他有了足够大的识字量（数字就不说了，以免引起对比伤害），可以自主阅读多数儿童故事，而且他也喜欢阅读。家里有这么个安安静静阅读的小美男子，父复何求？为啥非得拿各种课外学习培训班打扰他？

1. 我后知后觉发现去年夏天那起[怀孕大象被菠萝炸弹炸死的事件](https://mp.weixin.qq.com/s?__biz=Mzg4MTYyNDc1Mw==&mid=2247595632&idx=1&sn=eced3da32e6d9f151d755e0d171932d4)。还能说什么呢？生而为人，我很抱歉。我看到这起事件，是因为[今年的东北虎事件](https://mp.weixin.qq.com/s/5PmXAjE535K9IeRYuL8bgg)，同样也是个悲剧。那头怀孕的大象，竟然站在河里站了好几天不肯上岸，一直站到把自己活活饿死。那是我第一次看到饿到皮包骨头的大象（让我想起小时候嚼干草过完冬天的水牛，而水牛虽然形销骨立，但不至于挨饿）。我呆坐了一晚。太造孽了。也许是暂时性的一叶障目，这种时候我总感觉人类文明在倒退，以及深感疑惑这种文明有什么意义。

1. 同样，[张桂梅的事迹](https://mp.weixin.qq.com/s/gnCqtdrAZm1VN5brSrhhCA)我也看了两晚上。心情略有些复杂。敬佩之心不必说，自然如滔滔江水。相比之下，我等皆是草芥。心情复杂的原因是，对这些娃来说，跳龙门之路如此狭窄和残酷。这种竞争究竟是必要的，还是人为设置的？高考就像一个斗兽场。我自己是早早杀了出来，但我越来越不敢往回看，因为斗兽规则似乎越来越严苛。女高的学生们在寝室熄灯后还在走廊里学习，其实我当年也差不多，只不过班里就我一人如此，而她们则是集体如此。以我现在的品性，恐怕是打死我我也吃不了那苦了。

1. 看到一位叫[张力文的学弟](https://mp.weixin.qq.com/s/VCndIq8ZIpdWp1kg0U-YXw)从人大统计硕士毕业后回到家乡当高中数学老师的事迹，我感到很佩服。这样的人太少见了。下面留言里有一条让我读完更加敬佩（我将原话中的“为了 1% 的 acc”修改成了“为了（提高）1% 的预测精度”）：

    > 做为张先生的高中同学和大学校友，我能感受到他已经将青春融入了祖国的山河中，交大的“饮水思源”让他产生了动力，人大的“实事求是”让他找到了答案。在临近毕业时，他说我原以为我是一个数据魔法师，可是我发现我只是一个数据傀儡师，为了（提高）1% 的预测精度，让自己和用户困在了系统里。生活是一支舞蹈，我不能让它带上镣铐。永别了，牢笼。

    文中没有提到这一点，但文中的视频采访里提了。这里说的“困在系统里”指的应该是去年广泛流传的那篇《外卖骑手，困在系统里》。去年微信上看到的让我回想最久的就是外卖骑手这篇和张桂梅那篇。

    记得曾经有人说脸书的悲哀是“招那么多顶级聪明的科学家就是研究怎样让用户多点击广告”。也许这个评价是偏颇的，但我感觉这个人造的牢笼是存在的，哪怕这个牢笼有其积极意义（比如拉动消费和经济）。在我的现实生活中，我只见过两个人对这个牢笼明确感到不安。一位是这里的张力文，另一位是[袁了凡](https://yuanfan.rbind.io/posts/laofu-is-thirty-now/)（本来这里提名了凡居士令我有一丝犹豫不安，但想了一会儿，决定相信居士能对付此处的消极）。现在看到牢笼二字总是想起了凡引过的“[以天下为之笼，则雀无所逃](https://yuanfan.rbind.io/posts/kill/)”。

    另外，由于我在[反中英混杂](/cn/2018/11/work/)方面的非理性倔强，我的狗眼看到力文用的一个词时顿时亮了起来，那就是“聘用通知”：

    > 在决定成为一名教师后，我前前后后面试了很多学校，也收获了不少的聘用通知。

    这是因为我受够了“收到 offer”这个极为常见的混杂搭配了，仿佛 offer 一词真的绝无翻译的可能。贤哉文也。

1. 快乐的秘诀是王阳明说的[饥来吃饭倦来眠](https://mp.weixin.qq.com/s/a8k5cIlv0KKu3BVtu5uYPw)吗？我自己是倾向于相信专注使人快乐，这也是我践行的生活方式。不过身处信息江湖，践行“饥来吃饭倦来眠”可能比龙场的石棺中要难得多。我可以吃饭不看手机、做饭不听节目、开车不听歌，但这些都是自己的事，自己可控，那涉及到与他人相关的事呢？我作为码农，貌似不可能不看 GitHub 吧。不知阳明先生会有何高见。

1. 瞿秋白在遗言《[多余的话](https://www.marxists.org/chinese/quqiubai/mia-chinese-qqb-193505.htm)》最后提到“捉住了老鸦在树上做窝”。这些年我对政治的态度越来越悲观。我最讨厌政治的地方就在于它使人难以逃脱：一方发起挑战，另一方不管愿意与否，都得被拖下水开打，因为没有人愿意被侵略或蒙冤。上了台阶的人也难以下台阶——哪怕他已经不再认同这个台阶，台阶上已经站满了人。你不再是你自己，而是一个象征。你具体是谁，对多数人来说已经不重要。

1. 大西洋报上有一篇《[读太多政治新闻有损你的幸福](https://www.theatlantic.com/family/archive/2020/10/reading-too-much-political-news-bad-happiness/616651/)》，开头有点意思，说佛教教导我们依恋是一切痛苦的根源。只要我们不渴望附着在任何事物上，我们就能找到平静。这个附着的对象之一就是观念。执念使我们痛苦。这个道理谁都懂，可谁愿主动放弃自己的执念呢？这简直是太难了。

    对政治新闻造成的执念，作者给出三个建议：一、关注、行动，而不要抱怨；二、有节制地阅读和讨论政治新闻；三、取消关注党派性太强的新闻来源，尤其是与自己观念相同的党派。我感觉这是树欲静而风不止，如上一条所说，政治让人太难摆脱了。

1. [这篇文章](https://mythirdbrain.substack.com/p/how-i-spend-my-attention)问了个好问题：如果你做一件事情时没有动用注意力，那么这件事是否发生过？视而不见、听而不闻的事情，我们经历或没经历过它有区别吗？

    去年开始重看火影忍者，每天看一集，为的是给大娃讲。带着消遣心态去看，和带着要给娃讲的心态去看，有很大区别。后者要求我记住一些情节，所以颇有些负担，仿佛看完一集之后还有一场考试一样，而我并不是个擅长讲故事的人。估计明年底能讲完这七百集，到时候我对火影剧情的掌握应该可以是专业八级水平了。

1. 《[你以为我在剑桥读经典，其实我不过是学会说话](https://mp.weixin.qq.com/s/nNl6qZtVx8OjyiT1rz6JJA)》一文读来让我很有共鸣，尤其是语言的准确性也是我看重的。关于准确性，文中举了一个例子，是位“很少用代词”的作家。这个很有意思，因为我平时也是督促娃说话时不要用“这个”“那个”指代事物，而要说事物的具体名字。只要稍微督促一下，娃很快就能习惯说名字而不是“那个”。

1. 读到范成大“[松阴一架半弓苔](https://www.douban.com/note/806198160/)”，其中的“架”字让我琢磨了好一会儿。我不知道作者的解释是否有道理，也就是只有松荫能成一架，别的树荫不行。松树是圆锥形的（长大后形状则不是很规则了），影子为什么是“一架”呢？或者说，一架树荫到底是什么形状？相比之下，《镜中》“登上一株松木梯子”的奇特量词“株”则还好理解一点。

1. 作为湖北老乡，袁凡的文字中常常让我听到久违的乡音，比如一些土话或语气词，或是让我想起儿时的一些事物，比如[菱角](https://yuanfan.rbind.io/posts/one-day-trip/)。这些事情常常让我在回忆中沉浸几分钟。关于声音，目前为止最触动我的是“[豌豆叭果](https://yuanfan.rbind.io/posts/some-thought-on-history/)”，就像上次看列弛[写到甑子](https://www.liechi.org/cn/2020/07/food-in-mind/)一样，我从离开家乡起，这么多年从来没在其他人口中听到过用“豌豆叭果”形容布谷鸟叫，也没听任何人提起过“甑子”这个工具。小时候的夏日早晨，我们一群小伙伴去上学的路上经常听到布谷鸟叫，它叫一声我们就跟着说一句顺口溜“豌豆叭果，爹妈烧火”。方言烧火的意思是做饭。这个声音让我联想起早晨路边草丛里的露水打湿凉鞋的感觉，脚底沾进了草屑或泥巴，在凉鞋底嘎吱嘎吱地滑。

    小时候我爹撑船去池塘或水库里打渔，有时会带一把菱角回来。我自己出去放牛或玩水时，看见菱角也会去捞来吃。记得这东西两端分别有一根长刺、中间一根短刺。嫩菱角可以用指甲剥开吃，老菱角就用石头砸开。味道清甜，就像秋天收花生后漏在地里一个多月、壳快要烂掉的那种花生。后来也许是因为水污染，也许是我不再玩水，长大后我再也没见过菱角。

    不过看袁凡的记载，我有一事不明：水煮个菱角，这点操作竟然还有人写菜谱？不知是要放糖还是醋还是酱油还是鸡精还是胡椒面还是豆瓣酱咧。

1. 列弛的《[静婆婆](https://www.liechi.org/cn/2020/10/jingpopo/)》让我想起一位婆婆，就是我姨爹的母亲。从小我就不知道该怎么称呼她，又从来不好意思问我爹。印象中，我舅家的表哥们似乎叫她“亲婆婆”，而我又不知道为什么这么叫，同样不好意思问（也许是亲家婆婆的意思）。就这样，我从小到大都没叫过她。同静婆婆一样，自我有印象起，这位婆婆也是一直佝偻着。小时候每到暑假，我和我弟不是在舅舅家，就是在姨妈家，或是在姑妈家，乐不思蜀。现在我已经不太记得多少姨妈家的事情，只记得这位婆婆总是冲我们笑，而我们想玩什么她就赶忙去找。记得有一次我和我弟说想做一把弓，她便找出镰刀，告诉我们去哪里砍竹子，然后去给我们找细绳作弦。

    每次我们一家去姨妈家走亲戚，这位婆婆总是对我妈竖起大拇指夸奖我们两兄弟，把我妈乐开花。可能就像静婆婆说的“好，真好……”具体怎么好呢？其实她也不是很清楚。上一次回国是五年前，但现在我已经想不起来那次有没有见到她，因为她总是像背景一样默默坐在屋里的一角。只记得某一年我在电话里向我爹问起她，我爹说她已经不在了。我都不知道她是什么时候去世的。
