---
title: 季读（一）：人间别久不成悲
date: '2021-03-31'
slug: expired-sorrow
---

目测浏览器里开着的标签栏数量已经破百。有些页面开着是因为有时候读到一篇文章有些感想，而为它写篇日志吧，好像能写的内容也没多少；不写吧，又觉得脑子里飘过的那么几点想法，没记录下来就像浪费了阅读时间一样。就这样犹豫半年，开着的页面就越来越多、浏览器也拥挤不堪。今日想， 也不必等想法成熟了再写下来。为了能把这么多标签清理干净，索性模仿统计之都的月读栏目，每个季度集中清理一遍读过的文章。

1. 读到姜夔一句诗，曰[人间别久不成悲](https://www.douban.com/note/794945183/)。不成悲，那成什么呢？[丰子恺讲](/cn/2020/03/tk/)艺术是发泄压抑苦闷的手段，文学也是艺术。若按常理，久别只能是悲剧，情绪只能是消极的。接下来姜夔却一厢情愿想象“两处沉吟各自知”来收尾这首《鹧鸪天》，勉强慰藉自己：那边也一样在沉吟。

1. [父母的四种类型](https://www.douban.com/note/794849567/)：纵容型、专断型、权威型、忽视型。毫无疑问，我会选择成为权威型，但我估计近距离了解我的人可能会觉得我是专断型，因为我的控制程度很高，但控制只是两个评价维度之一，另一个维度是热情，也就是关心孩子的需求和想法。我觉得这个维度在孩子太小的时候还不好评价，三五岁的孩子，需求相对简单，也就是吃喝玩乐。我在吃喝方面控制比较严格，但也花很多时间和孩子一起玩。控制尽管看起来严酷，但目的是为了让孩子逐渐学习自控。控制最好是伴随着解释，也就是告诉孩子为什么要控制，但孩子太小时也难以讲清楚道理。我能做的也只能是同时控制孩子和自己。比如讲不清社交媒体的危害，那么我就尽量做到不在孩子面前看手机。

1. 看了一篇《[一个就地过年的女儿的自述](https://www.douban.com/note/794740445/)》，觉得还是挺打动我的。去年一年中，我有一半痛苦便来自这篇文章谈的问题。我有尝试去理解，但无迹可寻，最终在绝望的情绪中暴躁了半年。待文中提到的书在微信读书上架后，我且读一读，看是否能拯救我这样的人渣。

1. [糖的黑历史](https://www.douban.com/note/794031591/)（导致的奴隶贸易和压榨），赫拉利在他的书中也强调过。那些令人愉悦甚至欲罢不能的物品，我们在享受的时候是很难去深究它们背后的罪恶的。比如，现今的社会中，到底是谁在压榨外卖骑手？他们的生存状况，和在甘蔗园里卖命工作的奴隶是不是很相似？

1. 送礼是送现金还是送礼品卡？如果面临这个选择，那么[行为经济学家的回答是送礼品卡](https://www.theglobeandmail.com/globe-investor/personal-finance/household-finances/ask-a-behavioural-economist-is-it-better-to-give-cash-or-gift-cards/article37410364/)。为什么呢？因为对收礼的人而言，消费现金比消费礼品卡更痛苦。现金是实打实的钱，眼看着它从自己手里花出去，会感觉在花自己的钱；而礼品卡呢，我们消费的时候只是感觉递出去一张神奇纸片或塑料卡片，没有割肉的感觉，仿佛免费捡了要买的商品，这种感觉更令人愉悦。

    我以前一直不能理解世上为什么会存在礼品卡这种东西。如果是我要收礼，我一定会选择现金，而不是礼品卡，因为现金不会限制我的消费自由，而礼品卡是锁定在特定商家上的，比如某商场或网站。要是我通常不去那商场或网站购物，那么就还得为了花掉礼品卡而去一趟。更坑爹的是，礼品卡是固定完整金额的，也就意味着要是这些钱花不完，那么就浪费了；要是面额不够，那我还得自掏腰包。所以在我眼中，商家发明礼品卡太邪恶了，兼用了心理和经济手段。
    
    不过呢，开头的问题并不一定是送礼者必须面临的选择。那篇文章提到的首选方案是询问收礼方需要什么，然后买他们需要的东西。心理学试验表明：收礼者收到他们明确索取的礼物时，会比收到未经索取的礼物更加感激送礼者；而在送礼者的心中，这是反过来的，也就是送礼者通常认为送别人没有索取的礼物会显得更体贴，这有点自作多情的意思了。
    
    对我而言，我其实是希望别人最好不要送我实物礼物，我嫌这些人情往来太麻烦。尤其是我未索取的礼物，坦白讲很可能会是我的累赘。若实在是要客气，我最愿意接受的礼物是对方身边多余的东西（比如家里多的一袋面粉或酵母），而千万不要专门为了我而购买一件东西。其次我可以接受我索取的礼物，但我通常没有这种欲望。若换作以前，我可能偶尔会想要一根好的羽毛球拍线，但现在也无所谓了，有什么线打什么线。其实礼物的价值也就两方面：经济价值和符号价值。作为收礼者而言，经济价值对我已经毫无价值，而符号价值（即心意）则可以通过其它渠道体现出来，比如一封信或一首诗或一个 GitHub 合并请求就可以是极好的礼物。

1. [德鲁克曾说](https://www.huxiu.com/article/7511.html)大学课程中只有短篇小说写作和诗歌赏析对培养管理者最有帮助，这个结论初看让我有点吃惊，但看了他的理由后，我也觉得信服：

    > 德鲁克自己说，他从未认为哪个人特别无趣。我理解为世界上没有无趣的人，却有着大量的不善于（愿意）观察，不能够以移情心去体会的人。德鲁克对人的观察，给所有的管理者提供了一个样板、楷模。倘若你能够对自己的同事、伙伴的行为、态度乃至价值观，有如此敏锐且练达的洞察，我想你就有了成为一个管理者最重要的基础特质。德鲁克在他的《管理的实践》中曾说，他认真地研究了当时（20 世纪 50 年代）大学中所开设的课程，发现其中只有两门对于培养管理者最有帮助：短篇小说写作与诗歌赏析。诗歌帮助一个学生练习用感性的、富有想象力的方式去影响他人；而短篇小说的写作则培养你的那种对于人以及人际的入微体察。

1. 贾浅浅风波我没什么好评论的，因为我没读过她的诗。光靠唐小林挑出来的那几首屎尿屁诗，我觉得远不够格评论一个诗人。看了[臧棣和戴潍娜的相关采访](https://www.douban.com/note/793703260/)，我觉得这个风波也没什么意思，只不过是又一次肤浅的吃瓜事件而已。吃瓜群众并不关心她的诗写得到底怎样，而唐小林恰好迎合了一种吃瓜群众常见的阴暗心理。这篇采访我也不予评论，但里面臧棣提到发表论文难的事情，我也觉得是个迫切需要解决的问题：

    > 臧棣：如果上 C 刊，这么困难的话，应该反思的是，我们的刊物管理制度上，有需要改进的问题。比如，这几年，大家一直在反映，学术人口呈几何式爆炸，每年毕业硕博生上百万，但发表学术批评的刊物，始终就那么多。这才是要反思的，也是该质疑的。
    
    戴潍娜也提到一个这个时代需要深刻反省的现象，也就是为什么如今难以见到观念不同却依然能成为朋友的人了？仿佛观念不同就只能成为一辈子的仇人。
    
    > 戴潍娜：文学圈在一天天僵化。文学旧体制里，多得是文学赞美家，却极少有文学批评家。民国时代，鲁迅他们那帮文人是白天对骂干仗，晚上又可以在一张桌子上吃饭喝酒的。我们现在缺乏这种文化氛围，要么是一拥而上吹捧赞美，要么就是直接钉上耻辱柱墙倒众人推。辩论的声音都被淹没了，当年白天争吵、晚上喝酒的那种君子风度和文人高雅的行事作派不存在了。

    [切斯特顿的时代](http://up.edzx.org/doc/2014/11/07/0ad0f71b532ace55f7486359cd4eae1b/NwcsvR62.pdf)也是这样，白天辩论归辩论，晚上也照样一起喝酒。观念不合一样可以是朋友，一样可以互相尊敬。为什么我们这个时代的变得对异见如此不宽容？是互联网造的孽吗？我不想伪装我自己多宽容，我在很多事情上也一样做不到宽容。

1. 说到切斯特顿，这纯属[依含司机开车](https://yihanxu.github.io/about/)骗我上了车，让我这几年看了好几遍《[哲学的复兴](https://www.chesterton.org/the-revival-of-philosophy-why/)》。后来这司机又想骗我上《永恒之人》的车，我承认这勾起了我的兴趣，因为这书都把 C. S. Lewis 骗上了车。不过我在微信读书上找了一下，没有找到中文译本，于是作罢（好了，这是一个送礼的好机会，下次想送我礼物的人可以考虑送这本书，但我只要中文译本，因为我的英文阅读速度实在太慢）。放狗搜了一下，找到一篇[《异教徒》的译后记](http://up.edzx.org/doc/2014/11/07/0ad0f71b532ace55f7486359cd4eae1b/NwcsvR62.pdf)，在里面看到了上面说的白天辩论、晚上喝酒的情形。这篇译后记有几处令我深思的地方。首先是切斯特顿年轻时曾悲观绝望到快要崩溃自杀，但这段经历的结果是他对生命的存在产生出深深的敬畏，从而逃脱了悲观主义的泥沼，也发展出谦卑的品质，这个结果令我颇为惊异。其次是信、望、爱，我承认我心里还远没有这么强大的能量：

    > 切斯特顿认为，基督教是一个充满悖论的宗教，正因为是非理性的，它才是快乐的，而在它之前的异教是理性的，因而是悲伤的。他以基督教的神学三德——信、望、爱，与异教的美德——正义、节制比较为例。正义在于认识到某个东西应当归于某人，并且将这个东西给他；节制在于认识到某种嗜好恰当的界限，并且坚守这个界限。可是，信意味着相信难以置信之事，望意味着在事情毫无希望之时抱有盼望，爱意味着原谅不可原谅之人。

    三个词中，信（faith）和望（hope）的翻译我觉得都没问题，爱（[charity](https://www.chesterton.org/the-prophet/confronting-cancel-culture/)）让我感觉不是很准确，不过也许这是我并不明白什么是爱。不知译为仁或慈是不是更好，因为它体现的更像是一种胸怀而不是感情。

    第三是他对浪漫的理解——浪漫是限制、是不合意、不迎合我们的趣味的存在，浪漫才是真实：

    > 家庭是浪漫的，因为除了配偶也许可以选择之外，其他人我们都不能选择——我们碰巧有一位小气的姑姑，碰巧生了一个倔强的孩子。现代人擅长逃避，借旅游逃离自己生活的街道，躲避自己活生生的邻人；借向往自由，逃避婚姻家庭。切斯特顿认为，家庭之所以于人有益，称得上是一个好的社会单位，正是因为它不合意，包含着许多差异分歧。只有当群体是非理性地选择组成时，我们面对的才是真实的人——那个有棱有角、会与我们发生抵触、能够成为人类代表的人。

1. 所以[哲学（形而上学）为什么需要复兴](https://www.chesterton.org/the-revival-of-philosophy-why/)？切斯特顿给的最重要的理由是：若你没有一套哲学，你就只能随波逐流，过着悲惨的日子。什么叫悲惨？这老头的回答太辛辣：悲惨就是你变得实际、进步、注重效率、相信进化、先做手头的事情、认为行动大于言语。要是没有哲学，你只能拾人牙慧。

    今年重读这篇文章时，发现一处不解。后来去 SE 哲学社区提了我的[第一个问题](https://philosophy.stackexchange.com/q/78808/50133)，得到的回答跟[依含说的](https://yihanxu.github.io/about/#comment-5246700124)是一样的。原来是扫描错误。

1. 李白一句“人行明镜中，鸟度屏风里”，只能用“如画”形容了。写河水溪水湖水，[诗人们都喜欢用镜子的比喻](https://www.douban.com/note/793310755/)。谈戴叔伦的《兰溪棹歌》时，作者引用了鲁迅的一段文字：

    > 我放佛记得曾坐小船经过山阴道，两岸边的乌桕，新禾，野花，鸡，狗，丛树和枯树，茅屋，塔，伽蓝，农夫和村妇，村女，晒着的衣裳，和尚，蓑笠，天，云，竹，……都倒影在澄碧的小河中，随着每一打浆，各各夹带了闪烁的日光，并水里的萍藻游鱼，一同荡漾。

    前年重新翻了一些鲁迅的文章，这一段我还隐约有点记忆。读着就像坐在那条船上一样，所以[再次拜服](/cn/2017/02/mingding/)鲁迅的写景功夫。

    戴诗中有一句“兰溪三日桃花雨，半夜鲤鱼来上滩”。这让我想起小时候春雨天我在池塘边的桃树下戴着斗笠钓鱼，会见到鲫鱼跃出水面，用尾巴奋力抽打水面，那是它们在产卵（方言里叫“板籽”，“板”的意思是一个片状物抽打到一个平面上）。这个时节钓上来的鱼，肚子里都有满满的鱼籽。

1. 盖茨基金会在《[新冠未平，世界又将迎战更大危机](https://finance.sina.com.cn/tech/2021-03-01/doc-ikftssap9333946.shtml)》一文中提到：

    > 除了新冠疫情带来的经济危机，更高的气温和不断变化的天气模式已经影响到撒哈拉以南非洲和南亚数以亿计的小农户。这些变化正在破坏作物和牲畜系统多样化，加剧极端天气，使得本来就在贫困线边缘徘徊的家庭更难摆脱贫困和饥饿。这其中，妇女和女童尤为脆弱，更易成为气候变化的受害者。
    >
    > 想象一下，如果你是肯尼亚、尼日利亚或印度的农民，一直依靠耕作两英亩的农场、努力提高产量来养活家人。然后，一场你完全无法控制的灾难降临了——可怕的旱灾，或是摧毁庄稼的山洪，抑或是一群能吃光一切的蝗虫。
    >
    > 这不是假设，这种情况正在世界各地上演。气候危机最残酷的一面在于：那些对全球排放“贡献”最少的人，往往受到最大伤害。在农业创造了一半就业岗位的地区，这可能导致系统性的经济崩溃，也意味着更严重的收入损失、贫困和饥饿。

    每每看到这样的报道（无辜的人却要承受伤害），对我的良知都是一种挑战，甚至是折磨。[这一切的起源](/cn/2018/02/omelas/)可能还是依含几年前提到的那篇《[那些离开 Omelas 的人们](https://yihanxu.github.io/walk-away-from-Omelas/)》。更让我感到郁郁的是身边没有人觉得这些事有什么不对，我提起这种事时，人似乎觉得我太幼稚或是徒劳。比如为什么在有人喝不到干净的水时，我们却要拿自来水浇自家草坪。诚然，就算我们不浇草坪，这些水也不能送到那些落后国家地区。问题是我们面对这种明显的不公，心里太坦然，不去想为什么我们配得上我们所得的资源，而有些人就天生不配。

    列弛在依含那篇日志下留言说，我们可能都不必损害自己的生活品质，举手之劳就能帮到那些受苦的人。我举个生活中的例子，就是冬天启动车之后热车的习惯，这是我数年来尝试制止都失败的事情。从上个世纪九十年代开始，汽车的化油器就被电子燃油喷射装置取代，所以冬天启动车之后停着不开、原地让发动机空转热车[已经毫无意义](https://www.familyhandyman.com/article/heres-why-you-shouldnt-warm-up-your-car-in-the-winter/)，只会[白白浪费汽油和排放污染、温室气体](https://www.washingtonpost.com/news/wonk/wp/2014/12/29/the-biggest-winter-energy-myth-that-you-need-to-idle-your-car-before-driving/)（不如启动后低速开几分钟）。可惜这个热车的传统过了三十年还有人坚信坚守。

1. 看依含的那篇日志时，我并不认识那小说的作者。整整三年后，一天我偶然想起若干年前看的动画片《地海战记》的片头有一首诗，内容我忘了，只记得里面好像用了个词，是“光亮”。放狗搜了一会儿，找到了：

    > 当语言变得沉默  
    光亮没入黑暗  
    生命在死亡里  
    一切方能成就  
    展翅飞翔的老鹰  
    为其虚空  
    散发着光辉
    
    之所以想起这首诗，是因为感觉生活里太缺乏光亮，于是想看看那首诗到底是怎么说的来着。[依含向我讨光亮](/cn/2020/01/mediocre/#comment-5212068235)，但这个我现在真没有。因为不确定“虚空”一词是名词还是形容词，而原诗是日语，我遂又问了一下列弛。结果他居然刨出来英文原文。我本以为这是日语原创。
    
    > Only in silence the word,  
    Only in dark the light,  
    Only in dying life:  
    Bright the hawk's flight  
    On the empty sky.
    
    好了，虚空是名词。我顺便在维基百科上了解了一下作者勒古恩。一个月后，我再看了一下依含的日志，发现那小说的作者 Le Guin 不就是这勒古恩么？看来将来得找她的小说读读，比如《一无所有》。三年前后、两个人、两件不相干的事情，指向了同一个我以前不认识的人。这颇有些巧合。想必依含向我讨光时不曾料到，这束光在我的联想和探究下，最后指向了勒古恩。

1. 通过《[知识，如何被背叛？纪念文学批评家乔治 · 斯坦纳](https://mp.weixin.qq.com/s/Nmxm3_O1UxidCuvqO0XDhw)》一文头一次了解到斯坦纳这个人，感觉此人异常犀利，有些观点也我也非常认同。比如他与我一样反对民族主义：

    > 民族主义作为一种整体主义意识形态，对个体有着强大的动员能力，但却容易忽略个体作为人的价值和意义，因而权力在利用它追求各种宏大理想时，也就极易滑入漠视个体甚至反人性的深渊。
    
    再比如我也最怕同时拥有书和剑的人（如自己推崇延迟满足却要用最强技术瓦解他人意志的[张一鸣](/cn/2019/06/postman-amusing/)）：
    
    > 文明没有抵抗住野蛮，文明本身孕育着反文明的力量。阅读歌德的人并不比不读歌德的人更少成为野蛮的同谋。在《后记》一文中，斯坦纳细致地介绍了犹太遇害者卡普兰在集中营写的《日记》，卡普兰发现，纳粹的威力在于，他们同时拥有书籍和利剑，“在同一个人身上，既有兽性，也渴望人文。”斯坦纳说这是“令人气愤的真相”，我们对文化抱有的希望，“似乎在打碎我们牙齿的时候，文化并没有在场。然而，如果我们不能逐渐理解一点卡普兰平静精确的情感，也许，打碎我们牙齿的时候，文化也会在场。”
    
    当然，[我头像](/cn/2020/02/manjushri/)中的书与剑不是这个意思……看完这篇文章后，我把《语言与沉默》加入了我的书单，不过还不知道什么时候能读。这书的标题恰巧是上面刚提到的那首诗的第一句。

1. 《[是什么，摧毁了北大方正和海航集团？](https://xw.qq.com/cmsid/20210201A06B9T00)》读罢，感觉就是一个字：贪。当然，也许这里面有主动的贪婪，也有被动的贪婪。多角化分散风险，也分散精力：

    > 过度多角化，分散决策者精力，侵蚀企业核心能力。
    
    我相信海航掌门人的这句教训在历史中已经被无数次重复，将来还会继续：
    
    > “认为自己什么都能干、什么都可以干时，祸就埋下了。”
    
    而任总就扛得住诱惑：
    
    > 华为有今天的全球竞争力，也离不开从成立之初就坚持“强而专”核心业务战略。华为尽管也实施多角化战略，但是有限的多角化及“核心技术关联多角化”。前年深圳南山区准备给华为一块地产，但让任正非给回绝了，因为他怕非核心业务的暴利诱惑骨干而损伤核心业务能力发展的注意力。
    
    尽管我的注意力也经常被撕成碎片，但我还在苟延残喘保护我的聚焦能力。有很多事情我都懒得分心去想，尤其是利益方面的事情。比如去年吕老师请我给学院做[一场远程报告](https://slides.yihui.org/2020-random-walk.html)，这我义不容辞，而她也告知学院通常有报酬，当时我就说不必破费。我不想为这个费心。对我而言，找出国内银行账号、再填些表格、或是提供证件资料之类的杂事，已经是一重精神损耗，而抵御我并不需要的金钱的诱惑，又是一重损耗。基于类似的理由，写书的版税我早已经明确决定，分文不取。

1. 我通常不喜读宏观文章或书籍，不过这十年来我还比较喜欢当年我在和君的老师王丰的年度《[大势观澜](https://www.hejun.com/page92?article_id=1171)》。今年的主题词是：反转、裹挟、浮华。后两个词也是我时常在脑子里想的主题；[我对 2018 年的总结](/cn/2019/01/confusion-seclusion/)其实也就是裹挟，而浮华则更是我三天两头批判的主题。关于反转，他这个问题的答案不就是斯多葛哲学么：

    > 运气是会反转的，要问的是当人生走背运的时候，人生和企业是否熬得住？能够支撑一生的信念是什么？
    
    关于裹挟，他捎带了一句私心话，也是我强烈赞同的——救救孩子：
    
    > 尤其是在“教育领域”，K12 主修课课外辅导班能直接禁止吗？（纯属我的个人偏见，但呼吁国家有识之士多深究此事）

    去年见到一句辅导机构的广告词，我真是生了好多天的气（人间至恶，莫过于挑拨玩弄人心的弱点而牟利）：
    
    > 您来，我们培养您孩子；您不来，我们培养您孩子的竞争对手。

    在浮华部分，他引了一些读书的数据：

    > 2020 年中国人每日短视频人均使用时长 110 分钟，人均阅读书籍时长 20 分钟；图书零售[码洋](https://baike.baidu.com/item/%E7%A0%81%E6%B4%8B)首次负增长，同比下降 5%，不足千亿元，实体书店销售规模下降 33%，一二线城市高于三四线城市；新书品种规模下降12%，新书码洋贡献率只有 13.82%（畅销书第一：《你当像鸟飞向你的山》）。

    前年我发出《[娱乐至死了吗？波兹曼错了吗？](https://yihui.org/cn/2019/06/postman-amusing/)》一文后，江湖上发生了一件大事，我至今都没顾上把它记录下来。这就是于淼和杨洵默两位少侠的华山论剑，打了个天翻地覆。在这场华山论剑中，于兄是南帝段智兴，杨兄是东邪黄药师，我是华山——提供场所（评论区）。辉格在 2015 年说美国图书销量增长，不用瞎担心，而上面王丰老师说 2020 年中国图书销量下降。二人的数据我都没去验证。我那篇日志最后说，娱乐至死的恶果再等几年会应该更明显；如果王丰老师的数据是准确的，那么似乎有那么点证实我的猜测了。当然，即便如此，我依然无法否定杨兄的“短视频也有学习功能、刷抖音也能获取知识”说法，即便直觉上我是抗拒这说法的。

1. 关于短视频，陈丹青在访谈《[为何艺术学院培养不出伟大的艺术家？](https://www.douban.com/note/789471686/)》中的看法与我的直觉相合（但我这很可能是确认偏误，即：只注意与自己观念相似的人）：

    > 短视频未必会对艺术普及产生很大的影响。从学问的方面来看，我不认为短视频流行之后，我们会比只通过书本和刊物来获取知识更好。虽然我们能非常及时地在任何地点获取任何知识点，但我们注意力集中的时间只会变得越来越少。对于获取知识来说，这是灾难性的。在短视频中，我们能获取趣味，但是不一定能获取知识。知识需要连续性和纵深度，只靠短视频，知识是累积不起来的。
    
    > 如今，我们接受知识的速度很快，但据说我们的注意力时长不超过八秒钟。时不时看手机都成了我的一个生理动作。我已经失去了小时候曾有过的那种体验——拿到一本书，就像吞咽一般的阅读，并全部记住书中所写的内容。我们的心都散掉了。

    为什么工匠精神这个词流行起来了？人心缺什么，嘴上就会强调什么：

    > 今天，我们提倡工匠精神，这反而证明工匠已经没落的事实。在工匠时代，世界上不存在着“工匠精神”这个词——因为工匠们都会遵守相应的工作伦理，让其作品维持在某个水准之上。

    所以为何艺术学院培养不出伟大的艺术家？

    > 当一类艺术被归纳为法则时，这意味着这类艺术差不多走到尽头。【……】艺术不是法则，对于艺术来说，最重要的是感觉和操作。这些东西只有师徒制才能传授，学院是做不到的。

1. 我家洗衣房里的灯是运动感应式的，人走进去就会自动亮。很多时候，我只是从洗衣房路过，而不可避免地会把灯晃亮。对这个自动感应开关，我感到很烦；它本是为了节省拨开关的动作，但结果是多数时候我需要做的是把自动打开的灯关掉。最后，我找了几张贴纸，把感应器蒙了起来，世界顿时清静了：真正需要开灯时，我抬手摁一下开关就好了。在《[被技术侵入的我们的生活](https://www.douban.com/note/788792479/)》一文中，强制老人刷脸、使用手机和健康码，都跟我家这个自动灯一样，本是想用技术制造便利，却反倒给一部分人增添了极大的不便，就是因为技术成了唯一的选择。

    社交网络的话题我已经说过几百遍了：

    > 社交网络的创立初衷是让更多的人们团结起来，但实际上社交网络分散了我们日常的注意力。Facebook 的创立总裁 Sean Parker 曾在《卫报》采访中承认，对于社交网站的运营者来说，他们每时每刻都在思考，如何才能尽可能多地利用用户的时间和有意识的注意力。
    
    说是让人们团结、连接，而结果却是更加分裂、更加疏远。朋友圈里有几个真正的朋友？你站在桥上点赞，设计点赞的人在楼上看你。点赞装饰了你的窗子，你装饰了扎克伯格和张小龙的梦。

    > 心理学博士亚当·奥尔特曾在《欲罢不能：刷屏时代如何摆脱行为上瘾》一书中提到，这些高科技产品的缔造者，深谙网络产品背后的设计原理，一方面激励推销给用户，另一方面在自己的孩子使用时却表现出非常谨慎。比如，乔布斯对自己的孩子使用电子设备进行了严格限制；而 Blogger、Twitter 和 Medium 三大平台创办人之一埃文 · 威廉姆斯只给两个年幼的儿子买了数百本书，却不给他们买平板电脑。

    我强烈反对以让人成瘾为目的的算法和[数据扎心术](/cn/2019/09/zucked/)。这样编织出来的信息茧房太难逃离了。不能让机器剥夺我们的自主选择权。日向宁次的父亲愿意代替哥哥一死，不是因为爱护哥哥，而是因为那是他生平第一次自主选择，哪怕是选择去死。自主选择，当然很可能会选错，但交给机器选择，它只会体现它背后的资本的意志，而我不相信它会有什么善意。

    > 推荐算法看上去让我们获得了更多的内容，实际上，我们的选择反而变少了。通过分析与再处理信息，算法原本应让我们从繁杂的劳动中解放出来。但在资本的操纵之下，失去中立性的算法从过去单一的分析工具，成为了不断过滤多样化信息的诱导剂。【……】逐渐地，用户获得的信息和内容完全由推送方来决定，这样以来，消费者的选择权被让渡出去，算法推荐也就成为了一种没有选择的选择权。在算法的迭代和演化过程中，用户的自我选择空间正在被逐渐压缩。

1. 继续说脸书。《[为何脸书沉迷于散布虚假信息](https://www.technologyreview.com/2021/03/11/1020600/facebook-responsible-ai-misinformation/)》一文指出了问题的根源：扎克伯格只有一个坚定的目标——增长用户。散布虚假信息、极端言论、阴谋论、促使人们两极化而打个不停，都有助于增长用户。脸书的员工多次用数据确认过，如果用于内容推荐的模型想要吸引和留住用户，那么用户的观念极化会变得更严重。明知如此，高层依然不愿放弃增长用户的目标。这文章读下来，虽然出场人物众多，但最终似乎并不明确，到底谁该为此事负责？采访的主人公最后也是糊涂的，他觉得他领导的“负责任的人工智能”团队不应对此负责（我觉得有点讽刺），认为把人工智能视作问题的根源是不公正的，称“就算脸书没有使用人工智能，谎言和仇恨言论依然会传播”。听到这种话，我的直觉反应是想打他五十大板，但他也许部分正确——人工智能可能不是主要推动力。把上亿人锁在一个“便利”的平台里，闹闹哄哄怎么可能不出事。我的本源问题是：为什么人需要与如此大量的人建立连接呢？一生就三五好友的生活，究竟有什么问题？这问题我也需要问我自己。

1. 读到一句“书卷多情似故人”，[博主说](https://yanshuo.name/cn/2019/12/guanshu/)最后一句境界有所亏：为啥要提寻芳客呢？好像也有点道理。痴迷读书就痴迷读书，我管它寻芳客信不信我案上有好书呢？道理有点像[列弛以前觉得](https://www.liechi.org/cn/2020/02/goodness-of-what/)《清夜吟》的后两句有说教气：月到天心、风来水面的清意味自己独赏就好了，为啥管别人知不知呢？于谦和邵雍这是不是一定程度上的发朋友圈行为？

1. [zoco 的读书笔记](https://zoco.fun/book-note/202102%E8%AF%BB%E4%B9%A6/)提到《文学体验三十讲》，引了一段于我有所共鸣的话：

    > 如果现在，阅读的能力仍是你生命中的一部分，那你就像带着护身符的幸运儿。人类的阅读能力是进阶的，在儿童时代，大家一开始都为认识字母表而高兴，接着为可以读个句子而开心，接着可以读点儿童话故事了。那些后来没有得到阅读灵性召唤的人，他们的注意力转移到新闻报道或者报纸上的商业版块去了。最后还剩下一小部分人持续地着迷于字词。他们得到过一种狂喜而具有魔力的召唤，在获得阅读能力之后，他们并没有就把它当成一种工具，而是完全掉入书的王国，并一步一步去挖掘这个世界是多么博大精深。

    每当我谈论注意力分散的问题时，有些人可能会认为我是怀着恶意在抨击那些不读书而只读些吸引眼球的网文的人，或是我觉得读书人比后者高明。我坦白承认我是有那么点意思，但这不是我的主要意思。我主要是认为在时间投资上，花一百分钟读一百条新闻，不如花一百分钟沉浸于一本书。因为前者涉及到频繁任务切换，读的东西不容易在脑子里留下印记。当然，我完全支持那种放松娱乐性的阅读——人需要休闲时间，只是泛读和精读需要相结合。我尽力多做精读，是基于一个重要的前提限制：我没那么多时间泛读。尽管如此，我精读的内容很多也是先从泛读中了解到，然后倒车回去再仔细读的。当感受到阅读的魔力召唤后，抵抗消遣性质的泛读诱惑也就相对容易了。花几个小时读一个人的一生，还是读一百个人的一瞬？答案对我很明显（只是对我来说，我不想推而广之）。

    在他[另一篇读书笔记](https://zoco.fun/book-note/2020%E8%AF%BB%E4%B9%A6/)中，他引了毛姆的《阅读是一座随身携带的避难所》，也是我感同身受的：
    
    > 在度过了生命的黄金年华之后，你会发现你能欣然参与的活动已为数不多。除了象棋、填字游戏、单机电子游戏，几乎没有一种你一个人就能玩起来的游戏。但是阅读就不一样了，它丝毫不会让你有这种困扰。没有哪一项活动可以像读书一样——除了针线活，但它并不能平复你焦躁的心情——能随时开始，随便读多久，当有人找你时也可以随时搁下。没有其他娱乐项目比阅读更省钱了，你在公共图书馆的那些愉快日子和阅读廉价版图书时的愉快体验正好说明了这一点。培养阅读的习惯能够为你筑造一座避难所，让你逃脱几乎人世间的所有悲哀。

1. 看样子列弛在《[冷冬](https://www.liechi.org/cn/2021/01/coldwinter/)》的这句话不止击中了[我一个人](https://jiayiliu.me/post/2020-05-22-ocd-relapse/#comment-5260035764)（比如还有[袁凡](https://yuanfan.rbind.io/story/galaxy-legend/)）：

    > 克制自己的欲望，特别是当它伪装成一种积极的形态出现时；克制自己的傲慢，特别是当它伪装成一种虚幻的正义感出现时。

    我在[《穷查理宝典》笔记](/cn/2018/08/poor-charlies-almanack/)中引用过正义的暴君。积极和正义都有很强的驱动力，甚至煽动力。驱动或煽动他人，是为了自己的欲望和傲慢吗？这问题有点扎心。一个人的积极和正义，可能在另一个人眼中是无法忍受的压迫。

    心即不轻，常行普敬。他引的这句话同样很难做到。上面提到的敬畏和谦卑的切斯特顿，到底是经历了什么转变历程呢？

1. [学校毁了创造性吗](https://www.thersa.org/blog/2018/04/do-schools-kill-creativity)？一天看到一个号称有史以来观看次数最多的 TED 演讲，自然也勾起了我的好奇心。这题目有点大。如果按理性的话，那么我是不应该点开它的，因为大而抽象的题目往往没有答案。往一个极端说，在没有受过学校教育的人里，一定有过脑洞清奇的发明家（毕竟公共教育系统的出现是近百年的事情，而不是人类历史一开始就有的）；而往另一个极端说，被教育系统“荼毒”了二三十年的博士里，也一定存在有创意的人。所以这个问题的答案一定不会是简单的是或否。按历史学家的研究习惯，孤例不证，所以演讲里提供的例子再惊世骇俗，其效果只能留在演播厅里。按照统计思维，回答某个因素是否导致了某结果，当然最好是做随机对照试验，但这在现在的社会现实条件下显然是不现实的——谁愿意把自己的孩子随机分配到上学或不上学的组里？退而求其次的办法是对比在学校受公共教育的学生和在家受家庭教育的学生，看哪组学生的创造性更好。然而创造性又是一个大指标，怎么衡量？演讲者 [Ken Robinson](https://en.wikipedia.org/wiki/Ken_Robinson_(educationalist)) 提到的例子偏向于文艺方面的创造性，而反驳者 Tim Leunig 援引的例子更偏向于工程方面的。一定程度上，他们两个人都没错。如上面陈丹青所说，文艺方面的创造性难以通过法则教出来；而科学方面的创造性，自然需要先打下坚实的基础，在这方面，学校的重要性不言而喻。讲出 2 + 2 = 3 的人在文艺里可能是创造，在科学里则是傻瓜。

    工业化的流水线式教育，必然会牺牲一些学生的创造性。老师不可能照顾到每一个学生，发掘他们的创造潜力。看到“学校毁灭了创造性”这样的标题，我估计很多家长都会感到兴奋，因为人在骨子里都存在一些叛逆。现代社会里，多数人都经历了学校教育，而且学校留下的印象可能是负面居多——一方面，学校的管束太多；另一方面，从学校里走出来的大多数学生，后来都只能平凡平庸（受成功的定义所限），所以可能也会隐隐觉得，学校当年没有挖掘出自己的潜力，让自己更成功。我倒是觉得，教育从来都是学校和家长双方共同的责任。关于创造性，学校的统一教学可能是会压制它，但家长可以尝试把这一环补上。

    这两个演讲里，Ken 的段子有点太密集，这会降低我对这个演讲的评价；而 Tim 最后一段话要求观众不要为他鼓掌，而是鼓掌致敬学校老师，这在我眼中显得有些不够硬气，尽管我并不怀疑他的诚意。看完这个演讲，我去了解了一下[纽科门蒸汽机](https://en.wikipedia.org/wiki/Thomas_Newcomen)，大概原理看懂了，但时间所限，关键的一个部分我仍然没看懂，就是这个蒸汽机是怎么实现两个阀门（即：喷冷水阀门和进蒸气阀门）从人工控制改进到自动开关的。那时候的工匠确实是很能捣鼓。

1. 在我拥挤的浏览器标签栏中，园主贡献了三个标签：《[审美的变化](http://www.loyhome.com/%e5%ae%a1%e7%be%8e%e7%9a%84%e5%8f%98%e5%8c%96/)》、《[做事情的美感](https://www.loyhome.com/%e5%81%9a%e4%ba%8b%e6%83%85%e7%9a%84%e7%be%8e%e6%84%9f/)》、《[好奇心和终身学习的能力](http://www.loyhome.com/%e5%a5%bd%e5%a5%87%e5%bf%83%e5%92%8c%e7%bb%88%e8%ba%ab%e5%ad%a6%e4%b9%a0%e7%9a%84%e8%83%bd%e5%8a%9b/)》。这三篇文章我自从打开了就一直放在那儿。也就是说，最早的那篇已经放了快一年了。三篇都让我很有共鸣。

    《审》文中，园主与我一样对静态文字感到更合意，我喜欢文字也一样是因为文字留下了无限的想象空间。留言中我说我连做菜一般都不看视频，怕视频限制了我的想象力。我也不是一味否定其它媒介形式，偶尔我也会觉得有些图片、照片和视频挺好。中学时，我也偏好读小说传奇类的书，但四大名著中，我最先读完的是《水浒》（从[初中同桌](/cn/2020/07/birthday-memories/)那儿借的），其次是《西游记》；《三国演义》读了二三十回读不下去，后来一直都没接着读完；《红楼梦》到上大学后才读完，也不太感兴趣。以前我也欣赏不了散文，近些年才转变过来。

    《做》文中，园主关于审美和占有物品的观念，与我一样。欣赏是一回事，占有完全是另一回事。再大的海景房、湖景房，天天看，也不过如此。占有要付出高昂得多的[成本](/cn/2017/11/boxes/)，而且容易厌倦。园主讲做事的美感在于退出眼前短期事务，站在更高层次观察和思考问题。上面切斯特顿也讲了，总是忙于做手头的事，是悲惨生活的标志之一。

    《好》文中，园主说人生的长期痛苦来自不知道人生的意义。是啊，人生的意义是什么呢？我有时也会陷入疑虑。不过园主的学习精神实在值得学习。不断学习，是永葆[青春](/cn/2020/05/youth/)的不二法门。

1. 我忘了最早是从哪里看到的响尾蛇效应，也就是英国政府为了减少印度（殖民地）德里的响尾蛇数量，鼓励民众杀蛇，并按杀死的蛇数量给予奖励，但结果出乎意料——蛇的数量不降反升，因为民众为了领赏，开始大量养蛇。等英政府发现漏洞后，取消了奖励，结果更糟了——民众一看，蛇不值钱了，就把养的蛇放生了，导致野外蛇的数量更多了。关于这类事情，维基上有个词条，叫[逆向激励](https://en.wikipedia.org/wiki/Perverse_incentive)，收录了很多其它类似的出于好意制定政策结果却促使别人干坏事的例子。

    这让我联想到里根夫人发起的“[向毒品说不](https://en.wikipedia.org/wiki/Just_Say_No)”运动。这场声势浩大的运动，最终似乎并没有效果，而且反而让参与者日后[更可能抽烟喝酒](https://www.scientificamerican.com/article/why-just-say-no-doesnt-work/)（但这个逆向激励的机制还不太清楚，可能是因为相比起毒品，烟酒的危害感觉太小了）。政客的口号是简单的、好心的，但她有设身处地考虑过如何让小学生拥有向别人说不的勇气吗？大人都难以拒绝别人，就更不用说小孩了。

1. 明王世贞评定的“古今咏梅第一”诗，是杜甫那首超长题目的《[和裴迪登蜀州东亭送客逢早梅相忆见寄](https://baike.baidu.com/item/%E5%92%8C%E8%A3%B4%E8%BF%AA%E7%99%BB%E8%9C%80%E5%B7%9E%E4%B8%9C%E4%BA%AD%E9%80%81%E5%AE%A2%E9%80%A2%E6%97%A9%E6%A2%85%E7%9B%B8%E5%BF%86%E8%A7%81%E5%AF%84)》。自古人皆折花折柳相送，以表相思，而送不了时不免遗憾嗟叹，如“馨香盈怀袖，路远莫致之”。哪知杜甫却说幸好你没有折梅送我——“幸不折来伤岁暮，若为看去乱乡愁”。最后一句“江边一树垂垂发，朝夕催人自白头”，诗人与梅花同白头却不偕老。梅花生机勃发，诗人却已迟暮。刻画此种反差，不亦[情深缘浅](https://music.163.com/song?id=112908)乎？
