---
title: 是莽撞人就来单挑：教学过程中与学员实时分享代码文件
date: '2020-07-31'
slug: livecode
---

年初我[在英文日志中写道](/en/2020/02/rstudio-conf-videos/)，从纯技术角度来看，今年的 RStudio 大会报告中最吸引我的是一个叫 [livecode](https://github.com/rundel/livecode) 的包。它做了一件很有意思也很实用的事情，就是把一个用户的文件广播出去，让其他人能（几乎）实时在自己的电脑上自动更新这个文件。这对教学尤其有用，比如老师在讲台上写一份代码时，学生可以在自己电脑上实时得到老师的代码，而不用跟着老师去手敲。

这个想法很棒，但我对它的实现有一处很不满意的地方，就是依赖包太多。现在我越来越觉得，[净土](/cn/2019/07/tidy-noise/)包的依赖实在是太笨重了，感觉一入侯门深似海，一旦依赖它一个包，就会引进一大坨依赖。比如我从来都不能理解为什么蜡笔包（[crayon](https://cran.r-project.org/package=crayon)）会成为这么多包的硬性依赖，它只不过是为控制台输出添加一点颜色而已，真的重要到非依赖不可吗？

如果是我自己来实现，我觉得硬性依赖只需要三个：httpuv、later（其实后者已经是前者的依赖）和 rstudioapi。我会这样去实现它：

- 去掉浏览器里的那个高亮显示代码的功能，换作在客户端直接把代码读出来，并实时更新到用户的 RStudio 编辑器中。只要服务器端开始服务代码文件了，客户端就可以用 later 包每隔一段时间读取服务器端的文件（`readLines()` 就够了），并用 rstudioapi 把内容写入编辑器中。这样用户可以直接在 RStudio 编辑器中同步阅读老师的代码。

- 这种实时更新有个问题，就是用户可能无法选取部分代码并运行，因为光标位置会实时变化。为了避免这个问题，我们可以给用户手工控制同步的办法，到了他自己想同步代码的时候，跑一个函数，就更新编辑器里的代码了。这样他可以在任何合适的时候自己与老师同步。

- livecode 用了 bit.ly 服务来缩写 IP 地址和端口，这是因为服务器的真实地址对学生来说有点难敲。我觉得这个实现也有点太重了。我更倾向于考虑使用 302 重定向，比如把 `yihui.org/live` 重定向到 `192.168.0.1:4321`，这样学生就不用抄后一个地址了。这个重定向可以在上课之前设置好，比如[通过 Netlify](/en/2017/11/301-redirect/)。

- 如果老师不太熟悉技术，那么可能会遇到一个麻烦，就是不知道本机 IP 是什么。livecode 用了一段 C++ 代码实现了获取 IP。在 *nix 系统下，IP 地址可以从 `ifconfig` 命令的输出中找到，但 Windows 下是什么命令我就不知道了。总之，这个有可能有更轻量级的实现，避开一堆其它依赖如 iptools。

- 以上实现也不需要 WebSocket 这么高级的技术。我不太确定的是老师的机器作为服务器的话，其 R 进程会不会因为学生频繁读取他的文件而被拖累或临时性锁死。

好了，我的时间只够敲出想法，具体的实现不知道猴年马月能有这个闲工夫，所以先把想法列出来，看有没有壮士来把这事办了。技术方面，以前我写过《[用 R 创建网页服务器](/cn/2018/09/r-web-server/)》也可供参考。
