---
title: 为什么生产率在提高而我们却越来越忙
date: '2020-07-25'
slug: productivity-busy
---

大半年前看到[一篇文章](http://groups.csail.mit.edu/mac/users/rauch/misc/worktime/)说人类社会生产率一直在显著提高，但它带来的结果似乎只是我们在购买越来越多的东西，并同时失去越来越多的自由时间。在前工业时代，[人们每周的工作时间比现在更短](https://groups.csail.mit.edu/mac/users/rauch/worktime/hours_workweek.html)。按理说，如果我们对当前（物质）生活水平感到满足的话，生产率提高应该是让我们在更短的时间内完成生产工作，然后可以享受更多闲暇时间。为什么结果是反过来的呢？

忙是为了挣钱吗？在[《原则》读书笔记](/cn/2020/07/principles-notes/)中我引了一篇[关于金钱和幸福关系的论文](https://link.springer.com/chapter/10.1007/978-90-481-2350-6_6)，它的大致结论是，我们通常想象的金钱与幸福的正相关只体现在那些尚在基本生存线下的人群中，而过了这条线之后相关性就不明显了。它还讲物欲旺盛的人会明显更不幸福，除非他们已是大款。

> People who prize material goals more than other values tend to be substantially less happy, unless they are rich. Thus, more money may enhance SWB when it means avoiding poverty and living in a developed nation, but income appears to increase SWB little over the long-term when more of it is gained by well-off individuals whose material desires rise with their incomes.

所以我们要永远沦陷在“买买买”和“忙忙忙”的悲惨轮回中了吗？

不说大众，就看我自己。我现在几乎已经戒除购物欲，而且也没有动机挣更多钱，为啥依旧这么忙呢？2017 年我提到过一篇《[忙到死](/cn/2017/07/busy-to-death/)》的文章，它提醒忙人要留出思考、讨论和倾听的时间。现在我重新看了一遍原文，不出意料，我并没有按它说的做，确切说是没有坚持。我现在是越忙越没时间停下来思考和计划工作、越没时间计划就越混乱，最终变成像没头苍蝇一样的瞎忙。我的浏览器里常年开着大几十个标签页，而且这还是在我努力关闭了很多标签页之后的结果；要是我不够狠心，恐怕每年会积攒出五百个我无法关闭的页面。2016 年我也写过一篇《[软件之死](/cn/2016/12/software-death/)》，里面已经显出我未来会忙到死的端倪。在厂里孤军奋战七年后，我才即将迎来我的第一位战友。事后想想，我为我自己招人招得实在太晚了。这位战友要是能提前一年招来，我写上一本书时在心理上也不会觉得那么疲乏。我的疲乏感主要来自两边的拉扯：一边要维护一堆 R 包，另一边要写书。两头兼顾太影响效率了，经常搞得我士气低落。以前我是指望着社区内能有人帮我搭把手，但[这样的靠谱厮](/cn/2019/04/996-icu/)真的是极其难得，通常都是因为种种原因，他们的热情维持不了多久，而我还得苦等下一位真心人。我们厂长把一些 R 包甩锅给了我，比如 rmarkdown 和 rticles，而我后面却没有一位接锅侠来帮我接锅。

当然，人总是容易为自己找借口，事务太多是忙碌的客观原因，但不是全部原因。时间安排不当肯定也是重要原因，碎片化的时间容易导致瞎忙。今天我便花点时间反思一下分心因素：

1. GitHub 未读消息。目前我尚有 116 条未读事项，有些可能已经积攒了三四个月。我不愿点开它们看的原因是它们太容易引发决策疲劳。很多事项都让我感到解决起来太花时间，而不解决又好像对不起人。这种犹豫状态便导致了好些事项页面都开在我的浏览器里。开着吧，不知道何年月能处理；关了吧，又觉得好像挺重要的。根据我过去的经验，很多事项我留在浏览器的标签栏里到最后也是狠狠心关掉了。与其这样，不如一开始就关掉算了。[去年我提到](/cn/2019/04/996-icu/)最耗费我精力的前三个 R 包是 knitr、rmarkdown 和 bookdown。眼看我新招的同事马上要入职了，希望我能顺利把这几口锅甩给他，然后把我查看 GitHub 事项的频率由每天若干次降低为每天结束工作前看一次，并根据新事项简略计划一下第二天的工作。

1. [COS 论坛](https://d.cosx.org)和 [Stack Overflow 问题](https://stackoverflow.com/users/559676)。这也是我每天都看几遍的地方。前者其实我不用很频繁去看，里面绝大多数问题都用不着我自己出马，只是我这么多年已经形成了看帖子习惯。接下来我想把这个两个论坛的阅读频率降低为每周一次（周五下午）。

1. 邮件。非紧急的邮件留到周五处理，重要的邮件每天工作结束前回复。

1. 博客评论。从随意查看 Disqus 改为周五下午集中处理，而 GitHub 评论则随同其它 GitHub 事项每天一起处理。

1. 微博查看频率降为每周一次。微信尽量留到晚上查看和回复。

1. Feedly 改为周末晚上看。

1. 带娃。这个时间很难调整或安排，甚至是预测。先走一步算一步吧。

想来想去，忙的原因可能是因为技术变得太便利。《选择的悖论》一书的作者有篇文章叫《[论效率之危险以及低速高质生活](https://psyche.co/ideas/why-efficiency-is-dangerous-and-slowing-down-makes-life-better)》，里面提到信用卡的副作用，就是让你多花钱：

> If people had to visit a bank to withdraw cash, they might spend less and save more. This is not mere speculation---for instance, [research reviewed](https://doi.org/10.1002/(SICI)1099-0771(199909)12:3%3c183::AID-BDM318%3e3.0.CO;2-F) by the Nobel Prize-winning economist Richard Thaler shows that people will pay more for an item with a credit card than with cash.

是啊，刷卡既方便，又能避免从手里递出现金给收银员的肉疼感，消费环节的最后一道阻力被消除。当然，现在的支付手段越来越便利，信用卡都只是小巫了，钱就更加失去了质感。机智的我[早已看穿这一切](/cn/2018/12/best-credit-card/)，所以我买东西尽量不把支付便利或者打折便宜作为理由（这两个理由都是追求“效率”的结果），而纯粹只是因为需要而买。

信息在人与人之间毫无阻碍地快速流通，表面上让我们可以更高效地获取信息、节省等待时间，然而这样让我们也暴露在太多低价值的信息中，从而要花掉更多的精力或心理能量。比如任何人都可以轻松在 GitHub 上报告软件问题；尽管公平地说，多数报告的质量都还令人满意，但总有那么些低质的报告让人感到需要控制情绪去回复。或比如社交媒体对人的训练，就算没有直接与自己有关的新消息，也难免去刷一遍，看看有没有其它吸引眼睛的新事情，而刷着刷着，就花了计划外的一小时在上面。

可是谁愿意主动降速？对我而言，我现在不是很有勇气将工作相关的信息降速，因为这样很容易造成误解——别人可能会认为你拒绝沟通。作为信息接收者，我已经因为降速而受了一次打击，不敢再造次，只好被胁迫着登上信息高速列车。而对信息生产和发送者来说，降速同样很难，因为那样会意味着利益损失或者忍耐，比如忍耐[默认缺失的十像素边距](/cn/2018/05/10px-margin/)。

综上，尽管生产率在提高，但生产目标越来越高（夹杂着琐碎的目标），我们并没有因为越来越有效率而变得能越来越快处理完我们的事情。分子分母都在涨，但分子可能涨得更快。何解？我也不知，感觉这是一项艰难的平衡艺术。
