---
title: 《原则》读书笔记
date: '2020-07-19'
slug: principles-notes
---

我现在不太记得我是怎么发现达里奥的《原则》这本书的了。模糊印象中，好像是 2017 年看见一硕在什么地方提过这本书，后来 2018 年初我在去圣地亚哥开 RStudio 大会，飞机上无聊翻开看了一会儿；一看不打紧，看完导言部分我就被吸引住了，因为我感觉作者似乎是个非常坦诚的人。导言中讲要做到知行合一非常困难，所以我们需要把原则写下来，以便解释知与行的矛盾。作为同样坚定信仰“写下来”的力量的人，第二天我在我的报告里就引了达里奥这句话，继续鼓吹“[我网故我在](/cn/2016/12/student-project/)”。

> 最好的方法是写下来，因为这样一来，你将能够改进你写在纸面上的原则。

导言中作者也同样告诫读者，不要盲从他分享的原则，而是要独立思考找出适合自己的原则组合。这种话说出来可以视作坦诚，也可以视作狡猾（把挑选原则的责任推到读者肩上，要是原则错了概不负责）。我相信作者是坦诚的，但也相信这本书同其它任何书一样，有它的缺陷。关于它的批评，我只读了阳志平[《原则》的原则](https://www.yangzhiping.com/psy/Principles.html)。心理学层面的专业知识我不了解，所以不加评价，但阳志平的文章提醒了我们，看起来再成功的人，也有其盲点或错误的知识，就如同达里奥自己在书中反复强调的那样。保持谦逊和心胸开阔，听起来平淡无奇，但真正能做到的人，应该也差不多是圣贤了。即使读了这本书并受到了震撼，我顶多也是偶尔考虑一下自己的思维有什么可能的漏洞，而不会沿着反省之路走多远，毕竟坚信自己是对的是容易得多的一条路。

闲话少说，现在调出两年前的读书笔记，开始整理这篇我拖了两年的读后感。拖延正是因为这篇写起来会又长又痛苦，于是次次逃避。另外，如果有客官读这篇笔记，我得事先提醒一下，这是笔记，不是总结，所以没什么逻辑和系统性，我的批注很水，而且漏掉了很多精华部分。这主要是写给我自己看的，我也不推荐其他人读这笔记。看总结的话，前面阳志平的文章以及 [Cedric Chin 的系列总结](https://commoncog.com/blog/principles-book-summary/)都不错。

# 第一部分 我的历程

人生中的决策其结果都有随机性，但学习如何作决策，能让我们避免盲目赌博。

> 这些决定实质上都是赌博，一些是大赌，一些是小赌。

## 2 跨越门槛 （1967—1979年）

我第一次关注到冥想是从赫拉利的书中了解到他每天都花几个小时冥想，而达里奥的书又一次提到了冥想。我至今也真正没付诸实践（我强烈怀疑我会睡着，因为我闭着眼睛集中精神入睡非常快），但我感觉写东西对我而言也是一种弱一些的冥想替代方式。做饭和写作是少数我能几乎完全掌控自己思维和注意力的事情。其实也不一定要正儿八经写作，有时候甚至我在回帖或回邮件或写代码时，突然就会冒出一个绝妙的主意。

> 在我的一生中，冥想对我帮助很大，因为冥想让我拥有平静的开放思维，让我可以更清晰、更有创造性地思考。

达里奥早年对股市预测错误让他得到一个教训，就是关注历史事件并从中学习可移植的智慧。我觉得这个经验可推广之，不一定是要得到严肃的教训，比如[阅读的意义](/cn/2018/08/reading/)之一是体验他人的生活（尤其是那种你自己不可能有的生活）。

> 你最好弄明白其他时间、其他地点、其他人身上发生的事，因为如果你不这么做，你就不知道这些事情会不会发生在你身上，而且一旦发生在你身上，你将不知道如何应对。

没有人拥有天眼，看不到全部也没关系，但先要知道自己可能不知道（一次知道自己不知道很容易，难的是把它养成思维习惯）：

> 没有任何东西是确定的：总是存在会给你造成重大损失的风险，即使在看起来最安全的押注中也是如此，所以，你最好总是假设自己没有看到全部。

有意义的工作和人际关系比赚钱重要。这话需要从两个角度去看：一是达里奥作为超级有钱的人，讲出这样的话会比那些还在贫困线上挣扎的人容易得多；二是达里奥对有意义的定义都包含了“深度”一词，这是我强烈认同、并努力执行的理念（有意抵抗浮浅的工作和人际关系）。

> 尽管赚钱很好，但拥有有意义的工作和人际关系要比赚钱好得多。对我而言，有意义的工作是指一项我能全身心投入的使命；有意义的人际关系是指我既深深地关心对方，对方也深深地关心我。

下面这句话听起来老生常谈，但有多少人读到这里会停下来哪怕十分钟时间想一下这些问题的答案呢。几个月前我看了一本书叫《[日本人的生活哲学](https://www.douban.com/note/754109077/)：Ikigai 让你每天充满意义和喜悦》。这是我近年来第二次关注这个所谓的“[生命甲斐](/cn/2018/03/ikigai/)”。说实话我并没觉得这本书多好，因为看完我都没有一处划线，但里面提了大约二十个系列问题，帮助读者反省生活的意义，那些问题与达里奥下面的问题有重复，其实都值得花一晚上时间想想。比如我自己想要什么？是财富或地位吗？显然不是，这些我都已经得到[足够](/cn/2017/07/enough/)多了。不敢说我一生的目标是什么，因为目标过些年可能还会变，但目前这个阶段我的人生追求两样东西：一是[自由](/cn/2019/12/forever/)，二是[真实](/cn/2020/01/mediocre/)。如果还要加上一个附属目标的话，那就是趣味——在不受他人肤浅定义的自由生活中，以积极思考的方式去主动感受真实的生活，并发掘其中的趣味（无论是人还是物的趣味）。

> 先确定你真正想要什么，你真正的目标是什么，然后想想你为了得到这些目标需要做什么。

下面达里奥继续强调“写下来”的重要性。其实关于这一点，重复劳动的忙人自然都能深刻体会。比如你总是收到来自不同人的类似邮件问问题，你自然而然就会萌生把答案公开写下来的想法，免得日复一日回答这些问题。David Robinson 也有[类似的建议](https://rstudio.com/resources/rstudioconf-2019/the-unreasonable-effectiveness-of-public-work/)：如果一个问题你已经重复回答了三遍，那么就把答案写在日志中。写下来的东西，不仅方便传播（丢给对方一个链接即可），也方便[随时修改](/cn/2018/09/long-post/)。达里奥也提到它便于让他人一起改进这些想法，这也是个重要的优点，其它形式如语音、视频都难以让他人参与修改。

> 接这些电话很费时间，所以我认定，更有效的方式是每天把我的想法写下来，以便其他人理解我的逻辑，并帮着一起改进它。

两个通过组合控制风险的例子：

> 我向雷恩加工展示，如何利用一种谷物期货和豆粕期货的组合锁定成本，这样一来，它就能向麦当劳提出一个固定报价。
> 
> 我向牲畜饲养者展示，他们可以如何通过对冲在自己的成本项目（育肥用牛、谷物和豆粕）和 6 个月后出售的产品（育好的牛）之间设定良好的价格关系，从而锁定强劲的利润率。我研究出了一种方法：出售不同部位的鲜肉时，约定在未来以固定的、远低于冻肉的价格交付，但依然能产生巨大的利润。我的客户深深地明白，他们所从事的业务的“机器”是如何运行的，而我正好了解市场的运行方式，这二者的结合，对于我们双方都有好处，同时也让市场在整体上变得更有效率。我设想出这些复杂机器的能力，让我们与那些瞎蒙的人相比拥有了竞争优势，并最终改变了这些产业的运行方式。

因为经济学不是我的专业研究，所以我可能是在以偏概全，但我感觉达里奥对经济学基本原理的理解很透彻，更厉害的是，他还能把复杂的原理以直白的方式解释清楚（参见他的视频《[经济机器是如何运行的](https://youtu.be/PHe0bXAIuk0)》）。

## 3 我的低谷（1979—1982年）

我不知道的一点专业知识（至于为何黄金和债券有这样的特点，我也不知道）：

> 黄金（它在通胀加速的情况下表现很好）和债券（它在通缩性萧条的情况下表现很好）

崩盘的三点教训：

> 第一，我离谱地过度自信，并放纵自己被情绪左右。我（再次）学到，无论我知道多少东西，无论我多么勤奋，我都不能自信地做出绝对的断言。
> 
> 第二，我再次领会到了研究历史的价值。归根结底，当时发生的不过是“旧事重演”。
> 
> 第三，这次事件提醒我注意，把握市场的时机是多么困难。

失败并不可怕。后面达里奥还会多次强调，失败、痛苦之后要做的事情是反思，而不是沉沦。多思考自己为什么觉得自己是对的，以及让其它独立思考者来挑战自己。

> 回头来看，我的一败涂地是在我身上发生过的最好的事情之一，因为它让我变得谦逊，而我正需要谦逊来平衡我的进攻性。我学到了一种很好的恐惧犯错的意识，这把我的思维定式从认为“我是对的”变成了问自己“我怎么知道我是对的”。我清楚地看到，回答这个问题的最好方式是找到其他的独立思考者，他们与我肩负共同的使命，但对问题的看法与我不同。通过以一种经过深思熟虑的辩论方式与他们交流，我就能理解他们的推理，并让他们对我的推理进行压力测试。我们都可以通过这种方式降低自己犯错的可能性。

达里奥总结的通往成功的途径：

> 1. 找到与我观点不同的最聪明的人，以便自己能够努力理解他们的推理。
> 2. 知道自己在什么时候不能有明确的意见，不急于下结论。
> 3. 逐步归纳永恒和普适的原则，对其进行测试，将其系统化。
> 4. 通过平衡风险来保持较大的回报，并降低下行波动。

同荣格讲的一样，要[直面自己的灵魂](/cn/2018/11/mediocre-self/)。当然，他们说的“直面”，当然是指直面自己的暗面，而不是光彩的那一面，因为后者无须勇气，而无须勇气的事情通常也不值得做。人总是有些莫名其妙的幻象，比如觉得自己有个光辉完美形象，要小心翼翼保护好，而当发生一些可能打击这个幻象的事情时，便会本能性地逃避。比如多年来我的英语听力都不好，而我常常羞于在没听懂的时候让对方重复一遍，因为我既不想打断别人、被看作没礼貌或破坏谈话的氛围，也不想被看作傻瓜。如果要改善我的听力，这是我必须跨越的一道门槛。

> 只有当你能承认甚至接受自身的弱点时，你才能做出对自身有益的改变。

挑战极限，四个字读起来比做起来轻松千万倍。我估计能每天挑战俯卧撑极限的人都没几个，就更不用说挑战思考和工作的极限了，而后者的难度大得多。疫情之前的几年，我每天做五十个俯卧撑或仰卧起坐，当时已经觉得有点难了。疫情开始后，因为不能再每周打羽毛球，所以只能在家养精蓄锐，改成俯卧撑和仰卧起坐都做。再后来逐渐增加数量，从五十到八十、一百、一百二，一直到现在的一百五。这肯定不是极限，但最后的几十个已经甚为痛苦了。不过呢，最早是五十的最后五十个很痛苦，而现在是一百五的最后五十个痛苦，前面五十、甚至一百个都没那么痛苦，这大概类似于下面达里奥说的“痛苦会逐渐消散”。提高痛苦忍受阈值后，后面道路会宽广许多。

> 我发现，想要追求卓越，你就必须挑战自己的极限，而挑战自己的极限可能会使你一蹶不振，这将造成很大的痛苦。你会觉得自己已经失败了，但这不一定是失败，除非你自己放弃。信不信由你，但之后你的痛苦将会逐渐消散，你在未来将会迎来很多其他机会，尽管当时的你也许看不清这些机会。你能做的最重要的事情是总结这些失败提供的教训，学会谦逊和极度开明的心态，从而增加你成功的概率，然后继续挑战自己的极限。

## 4 我的试炼之路（1983—1994年）

谚语一句（预测要有依据）：

> 靠水晶球谋生的人注定要吃碎在地上的玻璃。

训练电脑作决策（说实话我一直觉得机器学习里的“监督式学习”这个术语很不恰当，因为并没有监督的主体，这里达里奥训练机器的学习方式才真的是监督式学习）：

> 这很不错，因为这就像是一位国际象棋大师在帮助我对弈，只不过这位大师所依据的一系列标准是我理解而且相信其是符合逻辑的，因此，我们没有理由在任何时候出现根本性的分歧。

让人和计算机各自发挥各自的特长：

> 虽然计算机在很多方面比我们的大脑棒得多，但我们拥有的想象力、理解力和逻辑能力是它不具备的。正因如此，我们的大脑与计算机的合作才是绝配。

原则写下来才会清晰（算法化之后就更清晰了），并需要不断测试：

> 我相信，想要改进你的决策，你能做的最有价值的事情之一，是深入思考你的决策原则，同时以文字和计算机算法的形式把这些原则写下来，在条件允许的情况下进行返回测试，并以实时的方式，在用你的头脑进行决策的同时运用这些原则。

投资心得一则：

> 利用这种方式对待市场让我明白，成为一个成功的投资者的要诀之一，是只对你有高度信心的投资对象进行冒险押注，并对这些对象进行充分的分散投资。

邦德破产的原因：

> 混淆了经营和投机，而选择对冲的时机又太晚。邦德借入美元购买资产，如澳大利亚的酿酒厂。他这么做是因为美国的利率低于澳大利亚的利率。尽管他没有意识到，但其实他是在赌最终用来还债的美元不会升值。

对北京的印象：

> 北京到处都有很棒的、极为好客的人，他们教给了我们一项传统——在喊“干杯”的同时一口喝下杯中的茅台酒，并盛情地款待了我们。

达里奥不会中文的儿子在中国上了一年学（纯中文学校）。行万里路对一个人的格局的影响：

> 这段艰难但改变了麦修一生的经历，对他的价值观和人生目标产生了深刻的影响。因为他爱上了中国（他说他从那一年起就成为中国的一部分），也因为他明白了同情心相对于物质财富的价值，所以当麦修只有 16 岁时，他就成立了一家慈善机构——中国关爱基金会，以帮助有特殊需求的中国孤儿。

李光耀在达里奥家吃饭时点评世界领导人：

> 李光耀认为安格拉·默克尔是西方世界最好的领导人，普京是全球最好的领导人之一。他解释说，评判一个领导人时必须结合相关背景，即他们遇到的具体情况，进而向我们说明了，领导俄罗斯是多么困难，以及他为什么认为普京在这方面做得不错。他还回忆了他与邓小平的独特关系，他认为邓小平是所有领导人中最好的。

以别人的视角看事务确实很难，而我觉得当别人拒绝让你理解他的视角时（有些人很难敞开自己的心扉），这事难度还要增加百倍：

> 类似这样的邂逅让我明白，人类的伟大和不同凡响并不取决于财富或者其他世俗的成功衡量标准。我还明白，在没有真正通过别人的视角看待事物之前就对别人下判断，会妨碍对他们所处环境的理解，而且这样做很不明智。我建议你保持足够的好奇心，始终愿意去理解那些看问题与你不一样的人是怎么形成他们看问题的方式的。你将会发现这很有趣，而且益处无穷，而你获得的更丰富的视角将帮助你决定你应当怎么做。

一处引起我注意的翻译（driveway 指从私人住宅到公路之间的一段车道，因为中国的房子很少像美国这样有一段私有车道，所以这个词不好翻译）：

> 行驶道

两种类型的人（若为使命而工作，那么做到彼此坦诚就会容易得多）：

> 一种是把工作视为一项使命的一部分，另一种是为薪水工作。

依赖系统化决策而不是情绪化决策：

> 所有了不起的投资者和投资策略都是有弱点的。在弱点呈现时就对其失去信心是一种常见的错误，就像在其有效时对其过于迷恋一样。因为大多数人都有情绪化倾向，不会严格遵守逻辑，所以他们通常会对短期结果反应过度：情况不好时他们放弃，并以过低的价格脱手；好的时候他们又以过高的价格买进。我发现这个道理不仅对投资适用，对人和事物的关系同样适用：明智的人在经历各种沉浮时都始终盯紧稳健的基本面；而轻浮的人跟着感觉走，做出情绪化的反应，对于热门的东西一拥而上，不热的时候又马上放弃。

又一处有点逗的翻译（common sense 译为“常识”就可以啦）：

> 常识感

他提到了马科维茨的投资组合理论，但我仍然没看懂他自己发现的下面这个“投资的圣杯”在马科维茨的理论基础上作了什么本质改进，因为听起来都像是分散投资以降低风险（我感觉更难的问题是如何找到这些独立的良好回报流，而不是如何分散吧）：

> 我发现如果我拥有 15—20 个良好的、互不相关的回报流，我就能大大降低我的风险，同时又不减少我的预期收益。

类似的原则（不限于投资）：

> 想要拥有很多优势，而又不暴露于不可接受的劣势之下，最稳妥的方式是做出一系列良好的、互不相关的押注，彼此平衡，相互补充。

一百万美元不算多（达里奥想用投资者的钱测试他的上述原则）：

> 我知道，请求这些机构投资者投入这样相对不多的钱，将让他们难以拒绝。

记录、讨论错误，并持续作出改进：

> 这是一个可怕的、代价高昂的失误，而我不能做出太激烈的反应，比如把罗斯炒了以儆效尤，告诉大家我们不能容忍错误。因为错误总是免不了的，所以这么做只会促使其他人隐藏错误，而这将导致更大、代价更高的错误。我坚信，我们应当把问题和分歧摆到桌面上，从而总结应当怎么做才能改进。于是我和罗斯合作编写了一份交易部门的“错误日志”。从那时起，任何时候出现任何性质的不良结果（如一项交易没有执行、我们支付的交易费显著高于预期等），交易员都会记录下来，然后我们采取补救行动。随着我们不断跟踪和解决这些问题，我们的交易执行机制不断完善。
用一套程序确保问题会摆在桌面上，同时确保问题根源会得到剖析，这样才能实现持续的改进。

记录错误比处罚更重要（促进组织透明）：

> 如果一个错误发生，记入日志，你就没事；如果没有记，你就会有大麻烦。

公司的另几个头目提议与达里奥开个会，讨论他的人事管理问题，他才如梦惊醒：

> 他们为什么不直言相告？我哪里做错了？我的标准太高了吗？桥水要持续成为一个万里挑一的公司，我们之中就必须要有卓越的人，同时以极高的标准要求别人。我是不是要求太高了？

面临二选一问题时怎么办（尽量鱼与熊掌兼得）：

> 我必须从两种看上去都极为重要但彼此不相容的选项中做出抉择：（1）对他人保持极度的真诚，包括努力把我们的问题和弱点摆上桌面，以便我们直截了当地处理；（2）拥有快乐而满意的员工。而这又让我想起了，当面对两种你都需要但看起来矛盾的选择时，你需要耐心思考如何尽最大可能兼顾二者。几乎总有一条道路是存在但你还没有找到的，所以你应该努力寻找直到找到，而不是凑合着接受那个看起来明显的选择。

有些员工对达里奥暴躁的管理方式极为不满，但仍然有人理解他：

> 他们以及许多了解我的其他人，并不像另一些人那样强烈地觉得被我打击，因为他们知道我的心意是好的。如果他们不知道，他们可能早就辞职了。

如果人际相处原则不经过书面记录，那么矛盾可能永远无法分析清楚，就更不用说解决了：

> 在人际关系中，人们应当把各自的相处原则说得极为清楚，这至关重要。以此为起点，我们开始书面记录我们的原则，这种做法持续了几十年，最终形成了“工作原则”。

上述人事管理事件发生后的解决办法：

> 1. 把我们的真实想法摆在桌面上；
> 2. 存在经过深思熟虑的分歧，但人们愿意在相互了解的过程中更改观点；
> 3. 如果分歧依然存在，拥有一种大家一致同意的决策方式（如投票或者拥有清晰的权威），以便我们能够不带怨气地把分歧留在身后。

达里奥与神经科学家、心理学家和教育工作者的交流心得总结（我在《[财务自由](/cn/2018/06/financial-freedom/)》中提过大脑杏仁区和前叶）：

> 每个人的大脑都有两部分——层次较高的逻辑部分与层次较低的情绪部分。我称此为“两个你”。它们会争夺对于一个人的控制权。管理这一冲突的方式，是我们行为最重要的驱动因素。鲍勃、吉赛尔和丹提出的问题背后最大的原因，就是这一冲突。大脑的逻辑部分可以轻易理解了解自身弱点是一件好事（因为这是克服弱点的第一步），但大脑的情绪部分通常讨厌这么做。

## 5 终极恩惠（1995—2010年）

达里奥想寻找一种在任何环境下都能表现良好的资产组合，这里的环境主要由两个因素决定：增长率和通胀率，它们各自升或降，组合出四种情况。我自己不懂投资、也不做任何投资或理财（除了那个我不懂的 401K 之外，而那个我也没有任何研究，只用默认选项投资），所以我的财富保存策略就是他下面说的最差的那种，即：只存现金。这是因为我非常怀疑我去投资所花的精力是否能与它的回报匹配（我实在不想像赌徒一样忧心可能的损失），另外我也觉得我的工资实在是足够了。

> 我也知道不管持有什么类型的资产，总有一天它会失去大部分价值。这些资产包括现金，现金是长期投资产品里最差的一种，因为它会因通胀和税收因素而不断贬值。

他想让他的财富能长存，以保护家人。其实我并不太认同这种理念。也许他挑战“富不过三代”能成功，但我并不觉得用财富保护自家人是件好事。达里奥本人的人生很精彩，让他的后代再延续一遍精彩不是更好吗？当然，后面他还会谈他的慈善事业。

> 我不希望等我死后，我创造的、用来保护家人的财富尽付东流。

到这里，达里奥开始祭出管理公司的一样神器了，就是对员工进行心理测量，并为每个人制作“棒球卡”，把所有人的测量结果公开。这里最初的测量工具便是被本文开头阳志平批评的 MBTI 人格测试（[于淼也有提及](https://yufree.cn/cn/2020/02/12/intj/)）。

> 向所有人公开展示这些信息，更能起到解放作用而不是抑制作用，因为当这种做法常规化以后，人们就会像家庭成员一样彼此坦诚相待，在工作中舒适地做真实的自己。

有心理学家如此评论桥水（公司若能运营到这种境界，那确实是很优秀了，我在我们厂也差不多是这个感觉了，但不知其他同事感觉如何）：

> 以一种形式证明了，追求商业卓越和寻求个人价值的实现，不一定是相互排斥的，而是可以相辅相成。

他的另一个儿子曾患双相情感障碍，这段经历让达里奥意识到心理因素和身体里的化学物质很大程度影响了人的思维方式。

> 我们的思维方式在很大程度上是由心理因素决定的，是可以改变的。例如，保罗躁狂和抑郁的交替，是因为他大脑中的多巴胺以及其他化学物质分泌不稳定，所以控制这些化学物质，控制影响其分泌的活动和刺激因素，就可以改变保罗的状态。我了解到，富有创造性的天才和疯子可能只有一步之隔，能给人带来洞察力的化学反应也能造成扭曲，而一个人被自己的大脑困住是件极其危险的事情。当保罗处在“疯狂”状态时，他总是相信自己不合逻辑的说法，无论这些说法在别人听来是多么奇怪。尽管这在双相障碍患者身上表现得更为极端，但我在几乎所有人身上都看到过类似的迹象。我还学到了，人们可以控制大脑的运行，以带来比过去好得多的结果。

论什么是好的管理者：

> 在我看来，一个管理者能够实现的最大成功就是能够组织其他人在没有你的情况下把事情做好。次好的情况是你自己能把事情做好，最糟糕的是连你自己都做不好。

达里奥不是超人，2008 年他也到了他的极限：

> 我要更进一步地让你们知道，我已经达到了我的极限，同时我的工作质量以及工作与生活的平衡，都在受到不可接受的损害。

论决策者与投资者的区别：

> 我们都是自身所处环境的产物。投资者独立思考，预测尚未发生的事情，使用真金白银冒险投资。而决策者所处的环境鼓励形成共识而非表达分歧，培养他们针对已经发生的事情做出反应，训练他们的谈判能力而非冒险投资能力。关于自身决策的质量，投资者能得到持续的反馈，而决策者无法得到这种反馈，所以难以区分好的和不好的决策者。他们还要扮演政治家的角色。即使最精明能干的决策者也必须不断地把注意力从他们眼前正在处理的问题上转移，以对抗其他决策者提出的反对意见，而且他们面对的政治体系经常功能失调。

因为桥水的成功，媒体开始歪曲报道它。达里奥澄清曲解的办法是公开他的原则，以便外人能理解他，这是个很有勇气的行动。他本人意识到得到大量关注不是什么好事，也比较难得。枪打出头鸟、或树大招风的澳大利亚版本：

> 因为成功而得到大量关注不是一件好事。澳大利亚人称此为“高罂粟综合征”：田地里最高的罂粟最有可能被摘头。

论常人克服情绪之难：

> 我开始认识到大多数人都有一定的情绪障碍，不愿坦率地面对自身的问题和弱点。他们不愿直面扑朔迷离的形势和艰难的挑战，在遇到这些情况时，人们通常会觉得不舒服。兼具常识、创造性和主动寻求改变等个性的人，简直是凤毛麟角。

桥水自己招聘来的员工要落实原则一样也很难：

> 尽管桥水内部的几乎所有人都能很快地在思想上赞同这些原则，但要把这种认识转化为实际的行动，很多人还是需要努力。这是因为他们的习惯和情绪障碍依然比理性要强。

## 6 回报恩惠（2011—2015年）

达里奥准备卸任 CEO。他们分析继任者与他的差距之后，得出的结论是继任者缺乏达里奥身上的“塑造者”素质。他自己与《乔布斯传》的作者探讨之后，总结他眼中其它塑造者的共性：

> 结果是他们有很多共性。他们都是独立的思考者，不会让任何东西或任何人妨碍自己追求大胆的目标。对于事情应该怎么做，他们在头脑里有十分坚定的规划，同时又始终愿意在现实中检验这些头脑规划、调整做法，从而使规划效果变得更好。他们都极为坚韧，因为相对于他们在追求梦想的过程中经历的痛苦而言，他们实现梦想的决心更强烈。也许最有意思的是，他们关于未来的视野要比多数人宽广，或者他们自己就有这样的视野，或者他们善于从能看到更多东西的人那里学习。他们都能同时看到大图景和小细节（以及中间的层次），并能综合在不同层次上总结的观点，而大多数人通常是见此不见彼。创造性、系统性、现实性在他们身上合而为一。他们既是坚决的又是开明的。最重要的是，他们对自己的事业充满热情，对表现一般的手下不能容忍，同时想给世界带来巨大、有益的影响。

塑造者都在自我评估中不认为自己“顾及他人”：

> 在这份自我评估中，他们都在一项上打了低分：“顾及他人”。但这并不代表他们真的不关心他人。

其原因是（这里的“选择”我[前年引用过](/cn/2018/07/two-choices/)）：

> 每当面对是实现自己的目标还是取悦他人（或不让他人失望）时，他们都会选择实现自己的目标。

小心提防媒体塑造你的观点：

> 大多数人没有与本国及他国的领导层直接打过交道，他们基于从媒体了解到的情况形成自己的观点，因而变得非常天真，并持有不合理的偏执观点。这是因为与冷静客观的分析相比，戏剧化的故事和传言能够吸引更多的读者和观众。而且，在一些情况下，“新闻工作者”也有自己的意识形态需要推动。因此，大多数通过媒体棱镜看世界的人喜欢区分好人和坏人，而不是看各方的既得利益和相对权势，以及这些因素如何相互作用。

从整体利益出发思考和行事之难：

> 上述既得利益之间的冲突不仅发生在国际层面，各国内部也存在这种龌龊的冲突。尽管大多数决策者以为他们是真诚的，在以符合所有人最大利益的方式行事，但真正能这么做的人简直是凤毛麟角。更常见的情况是，他们的行为是为了支持自身选民的利益。例如，高收入者的代表会说高税率会遏制经济增长，而低收入者的代表的说法刚好相反。让所有人都努力客观看待事物的全貌已是很不容易，更不用说以符合整体利益的方式行事了。
> 
> 大多数决策者在踏入职业生涯时是理想主义者，离开时已经幻灭。

点名王岐山：

> 王岐山是一位历史学家、一位境界很高的思想者、一位很务实的人。他极为智慧又极为务实，我认识的这样的人很少。

他们两人都对历史为何重复感兴趣（达里奥在这方面的兴趣在开头说过了）：

> 我们都极为感兴趣的是，为什么几乎所有事情都是反复发生的、这些模式背后的驱动因素，以及在应对这些事情时哪些原则有效、哪些无效。

他们交谈后互相送书：

> 《千面英雄》《历史的教训》《基因之河》《论个人在历史上的作用》

其中第一本也是前年我开会偶遇的[一位朋友推荐](/cn/2018/01/derivatives/#comment-3748071377)给我的。达里奥引用了里面的一幅示意图，图中最让我有感触的是：

> 英雄总是会至少经历一次极大的失败。

从儿子麦修在慈善事业中的抉择联想到更广泛的抉择（有限资源如何分配，永远是难以抉择的难题）：

> 想想看，我们可以选择晚上出去狂欢一次，也可以选择拯救一个儿童的生命。这其实是我们经常面对的抉择。

## 8 从更高的层面回顾

痛苦是大自然在提醒我们有什么东西要学习，从而每一次痛苦都是一次学习的机会。这是这整本书给我的两个最大启发之一（一个是这里的直面痛苦，另一个是极度求真和极度透明）。这个看待痛苦的视角实在是冷酷。

> 不会感觉沮丧或透不过气，而是把痛苦视为大自然的提醒，告诉我有一些重要的东西需要我去学习。体验痛苦，然后探索大自然希望通过痛苦给我什么教益，开始成为我的一项游戏。这项游戏我做得越多就越擅长，也就越不会对这些情况感到痛苦，同时思考、总结出原则、利用原则获得回报的过程也变得越来越有收获。我学会了喜爱自己的痛苦，我想这是一种健康的视角。

达里奥觉得成功的满足感不是来自实现目标，而是努力奋斗。早早实现别人眼中“人生目标”的人，很快也会倦怠。所以可能我们对成功的普遍误解就是认为它是一刻的事情（过了某一刻，就算成功了）并且成功等于舒服，而它原本是一个长期持续的过程，这个过程中你需要持续发力，其实并没那么舒服，满足感会滞后，甚至滞后很久。

> 假如他们没有对另一些更大的、更值得追求的东西产生热情的话，他们通常最终不会快乐。

# 第二部分 生活原则

你眼中所见的难以容忍的坏事，真的就那么糟糕吗？达里奥回忆他曾在非洲看到一群鬣狗捕食一只小角马，让他感到非常不舒服。这让我想起 2016 年江堂讲[狐狸为什么可以偷鸡吃](https://youtu.be/cg387CixOwc)，以及那[追求自由的窃 · 瓦格拉](https://www.douban.com/note/761795546/)。我们可以同样地问，小偷真的很糟糕吗？这种问题（对正人君子而言）答案太显然了，我们根本就不会花一秒钟时间去想。

> 这件事是真的很糟糕，还是因为我有偏见所以认为它很糟糕，而事实上它好极了？

我们需要反省我们对好事情和坏事情的定义：

> 多数人把对自己或者自己关心的人不利的事情叫作坏事情，而忽视了更大的好。群体也有这种倾向：一种宗教的信仰者会认为自己的信仰好，其他人的信仰不好，导致两方信徒相互残杀，而且都坚信自己在做对的事情。通常，人们彼此冲突的信念或利益会妨碍他们从对方的视角看事情。这不好，也不理性。尽管我能理解，人们喜欢对自己有利的东西，不喜欢对自己有损的东西，但只根据事物对个人的影响就将其判定为绝对的好或绝对的坏，这是不合理的。这么做是在假定个人的愿望比整体的好更重要。

他认为“好”的定义要从进化的角度来下：

> 一个东西要“好”，就必须符合现实的规律，并促进整体的进化，这能带来最大的回报。
> 
> 进化是宇宙中最强大的力量，是唯一永恒的东西，是一切的驱动力。

引用荣格：

> 人需要困难，这对健康来说是必需的。

痛苦 + 反思 = 进步：

> 如果以正确的态度对待痛苦，感到痛苦就是你的幸运，因为这将提示你寻找解决方案以便继续前进。
> 
> 如果你发现自己不擅长做什么，你不应该为此难过，而是应该为发现这一点感到高兴，因为知晓这一点并妥善应对，将提升你实现自身愿望的可能性。

在《[脱不花的三盏灯](/cn/2018/11/tuo-bu-hua/)》中我提过求师之心，达里奥也说：

> 在你不擅长的领域请教擅长的其他人，这是一个你无论如何都应该培养的出色技能，这将帮助你建立起安全护栏，避免自己做错事。

多数人难以克服自身弱点，是因为面临下面五个抉择通常都会选错答案：

> 1. 不要混淆你的愿望和事实。
> 2. 不要为自身形象担心，只需关心能不能实现你的目标。
> 3. 不要过于重视直接结果而忽视后续、再后续的结果。
> 4. 不要让痛苦妨碍进步。
> 5. 不要把不好的结果归咎于任何人，从自己身上找原因。

## 2 用五步流程实现你的人生愿望

这一节我没做什么笔记，因为要划的话整节都需要划线。它提供了一个操作流程，我们可以对照去执行（但这一节被阳志平强烈否定了）。我划线的只有两处。一是如果想要进步，那么我们就要小心不要向别人显示出强烈的自尊心，否则我们会失去别人指出我们错误的机会：

> 自尊心起了阻碍作用。很有可能你周围的人出于不想伤害你，也不愿指出你的错误。

二是多数人都容易犯的错误：

> 一心想着执行，所以几乎不花时间来规划。谨记：规划先于行动！

## 3 做到头脑极度开放

聪明勤奋的人的两大障碍：

> 自我意识和思维盲点这两大障碍就是人的致命缺陷，导致聪颖勤奋的人无法发挥自身的全部潜力。

分歧前面有个重要的定语：深思熟虑。关于分歧的辩论，问问自己，我的目的是求真还是求自己对？

> 在深思熟虑的意见分歧中，你的目标不是让对方相信你是对的，而是弄明白谁是对的，并决定该怎么做。

头脑开放的对象需要因人而异：

> 很多人都会和你产生分歧，但你不应该考虑所有人的观点。跟任何人都头脑开放不一定有好处，你应该花时间和你能找到的最可信的人探讨观点。

他列举总结了头脑封闭和开放的人各自的特点，很值得我们对照反省：

| 头脑封闭的人 | 头脑开放的人 |
|--------------|--------------|
| 不喜欢自己的观点被挑战 | 想了解为什么会出现分歧 |
| 喜欢陈述 | 喜欢提问 |
| 关心别人是否理解自己 | 关心自己是否理解别人 |
| 会说这样的话：“我可能错了，但这是我的观点” | 知道何时陈述，何时提问 |
| 阻挠他人发言 | 倾听并鼓励他人表达 |
| 缺乏谦逊意识 | 担心自己可能是错的 |

上面几项头脑封闭者的特征，我至少占两项：喜欢陈述而不是提问，关心别人是否理解自己。我也不是不在乎理解别人，只是有时候一急躁就会优先解释自己的想法（从而做陈述）。

## 4 理解人与人大不相同

沟通不畅也许是生理因素造成的：

> 我不得不时刻提醒自己，没有理由发怒，因为他扭曲的逻辑是生理状况造成的。

情绪与理性之间的斗争前面已经提过了：

> 情绪和理性思考之间的斗争是最大的斗争。情绪主要是由潜意识性的杏仁核控制的，而理性思考主要是由意识性的前额皮层控制的。

关于养成习惯所需的时间，达里奥引的是 18 个月，而不是 [21 天](/cn/2019/04/slow-process/)。

> 只要频繁反复练习，你几乎可以养成任何习惯，产生自控力。

引用《习惯的力量》书中介绍的习惯养成法：

> 第一步是信号，用都希格的话说，“用信号来告诉你的大脑进入自动运行模式，以及使用哪种习惯”。第二步是形成常规，“可以是肢体性、心理性或情感性的常规”。第三步是奖励，这能帮助你的大脑发现这个特定的回路是不是“值得记下来以备后用”。

他自认为最有价值的习惯（也是我想效仿的）：

> 我养成的最有价值的习惯是利用痛苦来激发高质量的思考。

因为大脑会坚信自我完美的幻觉，所以我们要练习承认弱点并预防弱点带来的错误：

> 我发现通常最有效的方式不是期盼自己或其他人改变，而是承认自己的弱点，然后用明确的预防机制来避免弱点导致错误。这通常能加快成功的速度，提高成功的概率。

[认识你自己](https://zh.wikipedia.org/wiki/%E8%AE%A4%E8%AF%86%E4%BD%A0%E8%87%AA%E5%B7%B1)：

> 在任何生命历程中，了解人的特性都是必要的第一步。你做什么并不重要，只要你做的符合自己的个性和人生理想。

达里奥阅人无数，他确定，只要在基本生活线之上，幸福水平便和常规成功标准没什么联系了（这一点与 [Diener & Biswas-Diener 一篇论文](https://link.springer.com/chapter/10.1007/978-90-481-2350-6_6)结论相似）。一个木匠也可以过着比总统更美好的生活（这我绝对相信，我的生活一定比总统好千百倍）。所以你要坚持做自己：

> 你最需要的勇气不是驱使你战胜别人的勇气，而是不管其他人对你有何冀望，你始终坚持做最真实的自我的勇气。

依旧谈理性战胜情绪：

> 你最大的挑战是让深思熟虑的较高层次的自我管理情绪性的较低层次的自我。做到这一点的最佳途径是有意识地养成习惯，自动地做对自己有益的事。

## 5 学习如何有效决策

区分观点和事实（就像码农常说的“空谈无益、放码过来”）：

> 观点很廉价，几乎所有人都愿意和你分享观点。许多人会把观点表述为事实。你要区分观点和事实。

[Lewis 建议读老书](/cn/2019/01/confusion-seclusion/)，原因是经典经过了时间的考验，与达里奥的建议类似（但显然[这个观点不绝对](https://www.douban.com/note/545599246/)，只是奉劝世人不要时时被新潮流冲得东倒西歪）：

> 不要夸大新东西的好处。

引用荣格（做决策时要用逻辑、理性和常识，小心不要听命于低层次大脑）：

> 除非你意识到你的潜意识，否则潜意识将主导你的人生，而你将其称为命运。

在做事情的排序上，下面的建议与[芒格引用赫胥黎的话](/cn/2018/08/poor-charlies-almanack/)如出一辙：

> 先把你的“必做之事”做完，再做你的“想做之事”。

引用一句俗话（我咋没听过）：

> 每个傻子都能把事情复杂化，只有天才才能把事情简单化。

他主张计算机的“技术”与人的“艺术”相结合来做决策，认为在重要的决策上，技术还是比不过艺术：

> 软件开发工程师、数学家和博弈论研究者并不是最成功的，最具有理性、想象力和毅力的人最成功。

## 生活原则概要与列表

这一节总结了《生活原则》这一大章，忙人可以读这个摘要。下面只是其中一段，其实在第一部分《我的历程》中也出现过：

> （1）你想要什么；（2）事实是什么；（3）面对事实，你如何实现自己的愿望，而且要保持谦逊和心胸开阔，以便你能动用自己的最佳思维。

# 第三部分 工作原则

第三部分的开头是这部分的总结，后面才是正文。下面是总结里的摘抄。

勿论话好听不好听，只看对与不对（让我想起《[人生十二法则](/cn/2018/03/12-rules/)》中说的要倾听敌人的话，因为他们可能说出朋友说不出口的真相）：

> 虽然多数人爱听好话，但准确的批评更加难得。

追求赚钱还是高质量的人际关系？

> 很多研究显示，人的幸福感和他赚到的金钱之间相关性很低甚至为零，但是，幸福感与一个人所建立的人际关系质量高度相关。

桥水最初实施极度求真和极度透明的原则时，多数人感到很不舒服：

> 虽然他们在理智上认同，但往往在情感上经受挑战，因为这需要他们摆脱自以为是，去试图了解那些他们难以察觉的事实。

透明是为了避免第二种伪装的工作：

> 正如研究桥水的哈佛大学发展心理学家鲍勃 · 基根所说，在大多数公司，人们都在从事两个工作：一个是他们自己实际的工作，另一个是努力给别人留下自己如何工作的良好印象。

他辩护桥水不是邪教：

> 有人甚至把桥水描绘成一个像邪教一样的组织。其实，桥水能取得成功，恰恰是因为它走到了狂热轻信的反面。一群拥有共同价值观的人（这是个极佳的情况）与一群盲目狂热分子（这是个可怕的场景），二者之间有本质的不同，关键看有没有独立的思考。盲目狂热群体要求无原则的服从；而独立思考并挑战彼此的观点都是与盲目狂热背道而驰的行为，这也是我们在桥水的核心做法。

工作是为了养家糊口还是使命？

> 工作，要么是（1）你想从事用于养家糊口的一份职业，要么是（2）你想完成的使命，要么是二者的结合体。我敦促你尽可能把工作看成（2），当然也承认（1）的价值。如果你能这样想，那么几乎每件事都会做得比你不这样想时更好。如果有人把工作当成一场燃烧激情、完成使命的游戏，那么可以说，《工作原则》就是为了这样的人而写的。

以下是具体的工作原则。

## 1 相信极度求真和极度透明

求真和透明让人不舒服，但只有经过艰苦磨炼，人才能变得坚强：

> 的确，我们的行事方式跟大多数人所习惯的并不一样，但不能说这不符合人性，难道比从事艰苦体能训练的运动员和军人更不符合人性吗？

桥水受到的法律诉讼和监管调查很少，达里奥将之归结于公司的透明运作：

> 因为在极度透明的情况下，做坏事更难，发现事实、解决纠纷则更容易。

要与人分享最难分享的事情：

> 人们倾向于把拟公开的内容限定于不会伤害自己的事情。

## 3 打造允许犯错，但不容忍罔顾教训、一错再错的文化

达里奥说，所有人都会犯错，成功和失败者之间的区别在于，前者吸取教训，而后者只顾着逃避。

> 如果你回顾一年前的自己，而没有为自己所做的傻事感到震惊，就说明你还没有吸取足够多的教训。但仍然很少有人能够拥抱自己的错误。

重复这部分开头说过的一句话：

> 不要纠结于“埋怨”还是“赞美”，而要专注于“准确”还是“不准确”。

## 4 求取共识并坚持

自己保持开放心态，但也要远离封闭心态的人：

> 心态开放比聪明伶俐重要得多。不管他们知道多少，心态封闭的人都会浪费你的时间。如果你必须与他们打交道，要注意除非他们变得开明，否则无任何裨益。
> 
> 提防那些羞于承认自己并非无所不知的人。他们可能更关心外在的形象，而非真正达成目标。这可能逐渐导致毁灭性的后果。

别人提问不一定意味着说你错了，而是提醒：

> 但是我常常看到，有些人把建设性问题当成指责，反弹强烈。这是不对的。

如果价值观不能达成一致，最好是不要再来往。不过这项原则显然只适用于工作，而在生活中，斩断关系并没那么简单。比如要是一个人和他的母亲价值观不一致的话，总不能“解雇”母亲或向母亲“辞职”、不当儿子了吧。这正是我私人生活里最痛苦的问题（这里“母亲”只是举例、非实指我母亲），为此我耗费了无数个日夜的心神、也曾数次耗尽我的耐心，仍然没能找到妥善解决的办法。去年我提到“[我混蛋的一面](/cn/2019/08/seneca/)”，便是指这个。

> 这个世界上千人千面，很多人对事物有不同的看法和评价。如果你发现无法与某人就价值观方面达成一致，就应考虑是否还与此人来往。价值观不同，会导致很多痛苦的经历和不好的结局，最终还是会让你们疏离。一旦你发现此种情形，最好尽快分道扬镳。

## 5 做决策时要从观点的可信度出发

怎样才是有可信度的观点（决策时赋予这样的观点更多权重）：

> 最具有可信度的观点来自：（1）多次成功地解决了相关问题的人；（2）能够有逻辑地解释结论背后因果关系的人。

论主意和观点的廉价：

> 提出观点是容易的，每个人的脑子里都有成千上万的主意，很多人还很愿意说出来与人分享，甚至激烈地捍卫自己的观点。但遗憾的是，包括你自己的很多想法在内，很多观点都一无是处甚至是有害的。

不是说一律忽略所有观点。观点的推理过程比观点本身更值得关注：

> 关注可信度最高、与你观点不一致的人，尽量理解其推理过程。

关于分歧的辩论容易陷入[琐碎律](/cn/2018/05/law-of-triviality/)，学会抓大放小：

> 我见过人们在大的方面有共识，却浪费很多小时于细节的辩论。把大事抓好远比把小事做到极致更为重要。

## 6 知道如何超越分歧

依然是琐碎律：

> 几乎每个小组在大事上达成共识后，都为一些不太重要的小事争论不休，甚至成为仇家，全然不顾他们更应着眼于大事。这种现象也被称作小节上的自恋。

学会设身处地：

> 几乎所有人最初都发现自己很难克服一个障碍，就是通过别人的眼睛来看待问题。

## 用对人……

怎样的员工是对的员工（客观认识自己），以及怎样是健康的竞争（员工提升自我，而不是与其他员工竞争）：

> 我相信，一个人能否取得成功，最重要的因素是客观的自我评价，包括对自身缺点的认识。在一家健康的机构中，应该是员工与其低层次的自我进行竞争，而不是员工与员工相互竞争。你的目标是找到懂得这一点的人，给他们配备能使他们在岗位上施展才华的工具和信息，而不是事无巨细地对他们进行微观管理。

## 7 比做什么事更重要的是找对做事的人

如何找做对事的人：

> 1. 记住目标是什么。
> 2. 把目标布置给能胜任它的人（这是最佳情况），或者告诉他们怎样做能够达成目标（这属于微观管理，故略逊一筹）。
> 3. 让他们尽职尽责。
> 4. 如果在你培训他们并给其时间学习之后，他们还无法胜任工作，就辞掉他们。

## 8 要用对人，因为用人不当的代价高昂

关于找工作的一项建议（这样对找工作的人和招聘方都不好，而且是一种隐性腐败）：

> 不要凭借你的影响力帮别人找工作。

学习成绩有什么价值（前面《[应试教育](/cn/2020/01/hacking-tests/)》也有提及）：

> 学习成绩不能充分证明这个人是否具备你想要的价值观和能力。在很大程度上，因为学习成绩是最容易被衡量的，在学校里，决定成功的能力在于记忆力和调取记忆内容的速度，因此学习成绩是体现这些素质的绝佳标杆。学习成绩还是衡量一个人追求成功的决心，以及坚守志向的意愿和能力的良好标准。但是，当评估一位应聘人的常识、眼界、创造力或者决事能力时，学习成绩的价值就很有限了。由于这些品质才是最重要的，你在确定应聘人是否具有这些品质时，要看学业以外的东西。

## 9 持续培训、测试、评估和调配员工

员工业绩不佳的两种可能原因（学习相对容易补、能力则难一些）：

> 如果一个人工作干得不怎么样，要考虑这是由于学习不够，还是能力不足。

我们搁不下情面评价或批评熟人：

> 有个现象令我迷惑，面试官并不太了解应聘者，却总是肆无忌惮和自信满满地批评他们，而不会批评有类似缺点的员工，尽管面试官掌握更多员工表现的证据。这是因为，他们认为批评同事是有问题的，而批评外人却不那么严重。如果你认为事实对任何人都是最好的，那你就该认为上面那种想法是错误的，这也就是为什么坦率而持续的评估如此重要。

## 建造并进化你的机器……

成功的管理者应该像机器一样（我也对铺天盖地的任务感到无所适从）：

> 很多人面对铺天盖地的任务会感到无所适从。相比之下，成功者却能从琐碎事务中抽身出来站在高处，观察整个事情的原因和结果。这种高层面的视角能让他们像机器一样客观地看待自己和他人，了解哪些人、哪些事能做好，哪些人、哪些事不能干好，以及怎样把人组合起来形成最佳的工作成果。

## 10 像操作一部机器那样进行管理以实现目标

管理者的职责之一（提醒做事的优先顺序）：

> 人往往无意识地倾向于做自己喜欢的事而非需要做的事。如果他们忽视了做事的优先顺序，你需要为他们重新指引方向。

让上级及早了解风险，这并不意味着下级的失败：

> 如果不能驾驭而又未把责任提交给上级，那才是最大的失败。

## 11 发现问题，不容忍问题

要克服缺陷，先要承认缺陷：

> 承认有缺陷与接纳缺陷不是一回事，这是朝着克服缺陷努力的第一步。

## 12 诊断问题，探究根源

无法准确诊断问题的原因：

> 人们最常犯的错误就是把遇到的问题当成一时的差错，而没有借机对机器的运转进行诊断，以便实施改进。他们即时动手解决问题，却忽视了问题的根源，导致失败频频发生。全面、准确的诊断尽管要耗时多一些，但对未来大有益处。
> 
> 人们最常犯的第二个错误是诊断时不提及个人姓名。如果不把问题与造成问题的责任人挂钩，不探究他们失败的具体原因，就不会促进个人和机器做出改进。
> 
> 第三个最常见的错误未能把这次诊断中吸取的教训与之前的教训联系起来。

挑毛病容易，诊断和解决问题难得多：

> 别人不知道怎么做，并不意味着你就能知道怎么做。挑毛病是一回事，而给出诊断意见和有水平的解决方案是另一回事。

## 13 改进机器，解决问题

我不是管理者，这一节讲关于如何打造管理机器，目前对我而言有些难以消化。

> 设计你的机器并使之系统化。

## 14 按既定计划行事

领导者最重要的职责是招到为了成功而愿意吃苦的员工：

> 尽管一些才华横溢的新观点增添了很多亮色，但很多成功都来自一些日常平凡的事务，有时甚至是一些令人不快的经历，比如要找出且解决问题，在较长的一段时期艰难前行。

达里奥说的这种把目标变成现实的兴奋感，可能与我等码农把想法变成代码的兴奋感类似吧：

> 如果你专注于目标，为达成目标感到兴奋不已，意识到为了达成目标而从事艰难的工作是不得已的，你就有了端正的态度和适当的动力。如果你对需要奋斗的目标根本提不起兴趣，就不要勉强。从我个人角度看，我喜欢策划一些令人激动和美好的事情，愿意把它们变成现实。策划这些事情带来的愉悦感和将其变为现实的渴求，让我得以度过生命中的艰难时刻，使梦想成真。

我清楚计划的重要性，并感受过它的益处，但过去这一年，我的工作任务实在多到让我无暇计划往后的行动。

> 花足够的时间来设计一个行动计划。与将来执行计划所花费的时间相比，用于思考的时间微不足道，而且这些思考会使将来的执行更加有效。

如何缓解不可开交的忙碌：

> （1）通过优先排序或直接拒绝来减少工作量；（2）授权给合适的人去做；（3）提高工作效率。

引用丘吉尔（我以前引过与之类似的“[未必要有成功才能坚持](/cn/2017/12/need-not-hope-to-persevere/)”）：

> 成功就是从失败到失败，也依然热情不改。

## 15 运用工具和行为准则指导工作

不要指望光通过读书就能改变什么（桥水用的工具在附录中列出来了）：

> 除非建立好的习惯，否则成功不会降临。对于一个机构来说，成功要得益于工具和行为准则的帮助。
>
> 花一分钟想想，这个道理对你阅读本书或者任何书有何帮助。你读过多少本关于奉劝你改变行为的书，而你也希望改变但最终未能改变？如果没有工具和计划的帮助，你觉得通过阅读本书你能改变多少？我猜的是几乎没什么改变。

## 16 千万别忽视了公司治理

权力的制衡机制不可缺（这一段也解释了领导者为什么倾向独裁，独裁并不一定意味着他们坏）：

> 即便是最仁慈的领导者，也存在独裁的倾向。如果没有其他原因，也是因为他们管理着大量的员工，时间又有限，这就需要他们迅速做出大量艰难的选择。他们有时会对辩论失去耐心，而直接下达指令。还有大多数领导者并非那么与人为善，不能指望他们肯定能把机构利益放在个人利益之前。

## 将工作原则融会贯通

创意择优如何才能发挥作用：

> 让创意择优发挥作用，需要人们做三件事：（1）坦陈自己最诚实的想法，让大家公开讨论；（2）理性地表达分歧，以便大家进行高质量的辩论，拓展思路，尽量形成最优的集体决策；（3）用创意择优来处理所有不同意见（例如可信度加权决策）。

这本书我只读了一遍，但我感觉读一遍肯定是不够的，将来我争取重读一遍。在一遍的阅读中，上面我也提到过，它对我最大的影响是透明原则（在《[如何想静静](/cn/2019/07/inner-peace/)》一文中我提过）和对情绪脑的抑制（如：利用痛苦引发思考而不是单纯陷在痛苦情绪中、看别人对自己的意见时多看意见的对错而不要管意见是否让自己舒服）。前者对我而言相对容易实现，后者还是很有难度的。其实对我而言，克制别人对自己过分赞扬带来的心里美比克制批评带来的不快更难。而很不幸，我可能是（竖子）成名太早，现在凡是我露脸的场合，总是充满一片赞。

本文开头我说这篇笔记写起来会“又长又痛苦”，而痛苦有两个原因：一是面对一大堆自己认同的理念，不知猴年马月才能做到知行合一；二是我意识到我有一些大脑封闭者的特征，克服起来可能也会很难。作为坚定的佛系青年，我不羡慕、也不会去追求达里奥的成就，但很大可能我这辈子也无法拥有他那种程度的开放大脑——那是我更想要的。
