---
title: 如何想静静
date: '2019-07-19'
slug: inner-peace
---

约两周前有一位素不相识的文波兄来函，希望我写篇博客谈谈我如何静下心来研究一个东西，原因是他见我似乎产出颇丰：比如我作为一个非科班出身的码农，GitHub 打卡比他（专业码农）还勤得多，而且保持了六七年的满格；还有我自从 2005 年以来的这一两千篇中英文日志，看起来也有点厉害的样子。

这要分两头说。一方面是我真实的厉害与别人想象的我的厉害有多大差距，另一方面是我怎么做到把这些数字撑到远大于一般人的成绩。我觉得毫无疑问，别人到我的个人网站来溜达一圈，对我的实力评估肯定超出我真正的实力一大截。这些表面上的数字都有水分，比如有些 GitHub 打卡是自动的（我会每日自动编译一些包）、我写的日志里也有很多流水账、我简历页面上那超长一串演讲和报告几乎包含了我人生中所有的报告（包括课堂作业报告），所以初来乍到的客官们大可不必看了这些数量级后纳头就拜。

好了，挤掉部分水分后我们来谈谈静静的事情。为了我写起来方便，我就直接抄录邮件原文并就其各项问题逐一回应了。

> 我看到您学业达到博士，这个必定花费很多时间精力。

博士头衔应该只是个围城了，里面的人觉得也没什么，就是走个过程而已。多数人只要能被录取，最终应该都能混毕业。我读博的四年半时间里，全身心为这个博士头衔贡献的时间只有从[归隐](/cn/2011/06/study-furiously/)到[出山](/cn/2011/07/exams-done/)的一个月。剩下的时间一小部分贡献给了熬夜赶作业，大部分贡献给了写代码和混迹统计之都网站，极小部分贡献给了写论文和看文献。这肯定不是一个正常博士的时间分配，因为我的所谓科研的比例低到几乎可忽略不计。毕业之后[掰着指头一数](/cn/2014/01/five-years/)，博士期间去过 25 个城市、做了 34 场报告。整体而言，我觉得还算比较轻松。现在想想，那时候只需要维护一两个 R 包，是多么幸福的事情。

> 看到您 GitHub 从 2012 开始几乎都是满的，而我作为一个专业的程序员，居然没有您一般多，确实感受到了差距。而且我相信程序只是您的兴趣之一。

王国维提了诗词三境界，我也提个码农三境界：我找事、找我事、事找我。这里我特指开源社区的码农，不包含在公司里闷头喂自己公司袋盐的码农。我想多数开源码农应该停留在第一阶段，就是找事情做。如果找对了事情，开始小有名气，就会开始有人来找你事，因为开源项目里没多少前无古人的纯原创项目；每个项目几乎一定有类似的其它项目已经存在，所以人家不免要来比天比地比空气。等你埋头把你的项目欠缺的功能都补齐、可以与竞争者一较高低之后，你便强大到“事找我”的程度了。一个项目的成功容易催化下一个项目的成功，因为你已经有了一定的眼光和经验积累。陷入这个正向循环后，就算想退出 GitHub 江湖都没那么容易了。江湖里的人会把你绑架，日复一日给你各种反馈，酸甜苦辣都有，簇拥你前行。现在先记住“反馈”这个词，下文再谈。

> 还有您的博客更新多年，几千篇，这个也是我非常羡慕的，因为我也是有博客，但是一直拖拖拉拉，没有认真写几篇，反复挂掉又建最后又没去打理。

我知道有些跑步的人会上瘾。我个人对跑步没有任何爱好，所以我完全无法理解枯燥的跑步怎么可能使人上瘾。同理，不打羽毛球的人若听说我可以一直打五小时的羽毛球，一定也很难理解：不就是拿个拍子把球抡过来抡过去吗，怎么能打整整一下午。我想说的是，写博客也一样，到一定量级之后会让人上瘾。可能是拜我们的语文教育所赐，我们被摁着头写了十几年的作文，便坚定地认为写东西是一件苦差事。世上存在那种哪怕没有任何甜头、甚至只有苦头也要坚持做一件事的人，但这样的人应该还是少数。多数人的坚持，应该还是有甜头的存在。现在记住“甜头”这个词。

> 工作方面，看到您的简历，虽然非专业看不懂，但是相信必定是很有成果的。

我已经多次鼓吹“[我网故我在](/cn/2016/12/student-project/)”的观点了，只是真正的响应者甚寡。很多人听我忽悠，随手搭个网站，但也就撂在那儿不管了。他们没听到我的后一句话：网站是用来积累成就的，而简历可以是成就的堆砌汇总处。最初可以从堆砌小成就开始，把你写的作业、拍的照片、做的菜肴统统发上来。勿以事小而不堆。很多小事的价值，要过很多年你才能发现（比如[十一年](https://d.cosx.org/d/420778)）。除非你记忆力超群，否则凡是没有写下来的东西你很快就会忘，而你忘记的事情跟没做也没什么区别。换句话说，你差不多算是在白活。记住“堆砌”。

> 其实您自己觉得这些可能没什么，按部就班都会做到，但是我们一般人会觉得很难，可能专注力，毅力或者其他内在动力起到更重要作用，如果可以，很希望得到您的分享：
> 
> 您每天作息时间是怎么样的？您如何利用时间，如何解决拖延问题，如何避免不必要的打扰（比如手机、家人孩子）？坚持做这些事情的动力（因为我看到您的最初的网站以及一些插件，您肯定没有预料到会有后面的这么多人重视以及重要性，最初做这些的动力）？

注意力分散、拖延症基本上都是时代病，除非你归隐山林，否则很难治疗。我同样是这些时代病的患者，只不过可能病情略微轻一点而已。那些认为我光芒万丈、仿佛已经成圣成佛的人，不妨了解一下我[前些年的挣扎](/en/2018/02/career-crisis/)。要说我跟众人有何不同的话，那就是多数心里苦的宝宝都不会说，而我会说。我知道那些表面光芒万丈、内心苦痛挣扎的宝宝绝对不在少数。我深信“透明”这个原则。我的多数所思所想所做，都是公开的。我个人极度讨厌人为树立的围墙，可理解、但绝不喜欢于淼大人文末[提到的](https://yufree.cn/cn/2019/07/14/patent/)那种藏着掖着的人。

论毅力，它在我上大学本科期间已经逐渐消失了。在那之前，我还算有点毅力：严冬可以早起，炎夏可以背英汉词典。这是早年间[寒门](/cn/2019/04/chill/)背景的驱动。现在已经过上了吃馒头想蘸红糖蘸红糖、想蘸白糖蘸白糖的富足生活，来自生理层面的驱动就没了。我的专注仅限于我的四大业余爱好：~~吃喝嫖赌，哦说错了，是说学逗唱，哦不，~~ 看书、写东西、做饭、打羽毛球。除此之外，我同样觉得保持专注很困难，这个时代的噪声源太多了。目前我唯一成功克制住的是[社交媒体瘾](/cn/2018/01/craving-exploit/)：我已经关掉微信朋友圈近四年；今年我也克制住了推特，训练到可以看着那个新消息提醒的数字而偏偏就不点开它。但其实即使这样也是杯水车薪，仍然有太多噪声源，况且有些还不是纯噪声，是必须听以及必须处理的。

人人都一边说着想静静，一边又舍不得这光怪陆离、醉生梦死的红尘。空有转瞬即逝的迷茫，却没有[倒退的勇气](/cn/2019/01/confusion-seclusion/)。只要陷在这个矛盾中，就不可避免会沦为他人的木偶，他想怎么牵引你就怎么牵引。在这里我得[重提](/cn/2019/07/tidy-noise/)王维母亲那三个字：净、静、境。净的最大敌人是欲望，保留欲望就是保留被人挑逗的可能性。心理渴求赞扬，而又无法面对[多数人都是平庸平凡平淡](/cn/2018/11/mediocre-self/)、无法得到强力赞扬的现实，于是只能靠别人在你美颜自拍下的敷衍点赞续命。物欲旺盛，便容易被洗脑、网购些根本用不到的东西堆在家里。若连基本的脸净和家净都做不到，哪会有闲暇想静静？静静需要五感皆空，而你回想一下，你上一次没看、没听、没吃、没闻、没触碰任何东西是在什么时候？恐怕五感已经尽被外物锁死，人已经没有了真正的无聊时间，所有时刻都被无孔不入的信息占满；上茅房时是几乎一定在看手机，开车时一定同时放着音乐或其它音频节目。

静静到底是谁？静静是有质量的输出。我眼中这个时代最大的问题就是每个人的输入太多，输出太少。我们总在[被动接受输入](https://tjcx.me/p/consume-less-create-more)，而无暇顾及输出。信息输入量太大，就像郭德纲常说的恶心笑话：金针菇进，金针菇出。人们仿佛出于生理本能，认为吃得越多，就长得越好，而不去想想吃下去的到底消化了没有。于是肥胖、拉稀者繁，肌肉者寡。我平日最不乐意见到的就是静默转发，也就是转发别人的文章，自己没一句评论，或者只有干瘪的几个字评论和千篇一律的表情符。若看完一样东西后什么也讲不出来，那转它作甚、是何意呢？孟庭苇的一首歌《[风里的梦](https://music.163.com/#/song?id=276722)》中有不相关但相似的一问：

> 太多别人的传说，为何没有我的梦？

滚滚红尘和欲望并不一定是坏事。我在《[迷茫与倒退](/cn/2019/01/confusion-seclusion/)》中也说过，人的弱点都有转化为优点的潜力。问题只不过是你想让别人利用你的弱点，还是你自己利用自己的弱点。该怎么把弱点转化为优点呢？现在我们来说第一个关键词：反馈。对毅力不那么超群的人来说，做事若要有持续动力的话，则外界反馈必不可少。反馈有几方面作用：一是满足虚荣（表面上是个弱点），因为有人可能会夸你；二是扩张你的视角，促使你想你本来没想到的东西，这可能会让你的成果越来越宏伟；三是培养做事的惯性，因为路人的反馈有持续性，若处理得当，能有滚雪球的效应。我每天都在 GitHub 打卡，主要就是我每天都会收到新的反馈。若这地方根本没人搭理我，我也很难持续打卡。相比之下，我早已不用 Facebook，自然也没什么人来给我反馈，所以它对我毫无吸引力，我也就没有任何动力去为谁去哪儿旅游、谁的晚饭吃了什么而操碎我的心了。同样我也极少看知乎，因为我[非常排斥](/cn/2017/02/zhihu/)那里的总体氛围，也不觉得它对我有任何帮助，所以在那里别人很难给我反馈，我也就不会有兴趣去打卡。我倾向于看单对单的反馈，而不是群对单的反馈；当一大群人围上来的时候，反馈很容易失真。

反馈的前提条件是公开。把你的软件开源、想法公开、论文提前挂出来。那些藏着掖着的人，大约是不懂放长线钓大鱼的道理。常有人对我出版了四本书却从未收过一分钱的版税、并且还把书都免费公开发布出来感到惊奇和不理解，其实这只不过是我把版税变相为推广费了（每年几千？一万美元？我不知道，也没兴趣知道）而已。免费公开的书可以流传更广。我相信至少在统计学界，靠写书每年挣版税的人，其影响力一定远不如我，而且就算他每年拿一万美元专门给自己做推广，效果可能还未必如我，况且广告多了也招人烦。我一声不吭就同时收获了影响力和反馈，就问你这版税我要它有何用？何不行个方便，让读者以更便宜的价格买书算了。

再说第二个关键词：甜头。这初看又是一个弱点，奔着甜头做事，似乎无法长久。我说的不是普通甜头，比如吃糖、吃蛋糕的那种甜头，那是没有根基的甜头，转瞬即逝。记得有一幅漫画我看见过几次，但现在找不到了（更新：下面评论中有人[帮忙找到了](https://web.archive.org/web/20200605072514if_/https://static.highexistence.com/wp-content/uploads/2018/08/modern-life-depression-books-1.jpg)）。漫画上画的大约是三个人：第一个人在凡间地上鸟语花香，第二个人站在一摞书上，伸入云霄看见满世界压抑的乌云，第三个人则站在更高的一摞书上，看到了九霄层云之上的灿烂千阳。这灿烂就是我说的甜头。不读书的人，无所得无所失，反正就那样凑合着过；开始读书的人，可能会感受到繁杂阴暗的痛苦；而咬牙读下去的人，终能圆融贯通，看到金光乍现。最初我写博客是满足表现欲，碎碎念很多，而现在写博客则终于有点想静静的意思了。我喜欢在键盘上把一件事情掰碎了分析，把脑子里漂浮的念头都固化下来，这是我的甜头。我不知道别的客官会花多久，但我自己从 2005 年写到近两年才体会到这个甜头。世间有很多事情的进展都极慢，我们需要一些关于耐心的训练。比如种菜对我来说就不只是为了吃而种，而是要在朝朝频顾惜、暮暮去浇水的过程中见证它从一粒小种子慢慢长成一两米高的庞然大物。其实这个过程也只不过才几个月时间，但如今对已经几乎失去延迟满足能力的我们来说，几个月时间可能也很难熬，就更不必说在 2029 年收获写博客的甜头了。此处你需要停顿下来、清空脑子后感受一下，2029 年是什么概念。只羡慕贼吃肉、不见贼挨揍的人是吃不到肉的。

![黄瓜的生长](https://user-images.githubusercontent.com/163582/61556189-db864600-aa26-11e9-9a18-1ee09c0420f7.jpg#full)

对我来说，写代码的甜头在于站在别的巨人肩头指挥这些巨人排兵列阵，这主要是因为我自己的本事不够创造出巨人来。若我的软件写得漂亮，那多半是巨人的功劳，我跟着沾沾光。而为了找到适合我操纵的巨人，我也得静静，不能盲目跟风。比如我对所谓深度学习、人工智能的了解几乎为零，那里面的巨人软件我指挥不动，而且指挥者也已经太多，轮不到我插脚。从这个角度来说，刻意减少外界信息输入反倒是好事，我知道的越多便越难聚焦。指挥别人都没想到的小巨人，便是我特有的甜头。

最后说第三个关键词：堆砌。不积跬步，无以至千里。[道理都懂，就是不做](/cn/2019/04/slow-process/)。做也是东一榔头西一棒槌，[不注意聚焦](/cn/2019/03/influence-focus/)、不把做过的劳什子都归置到一处。有时候我不是很明白为什么大家要这样东奔西跑。比如我见涛妹前几天在微信读书上发了几篇颇有质量的书评，而两年前[他曾说要给博客除草](https://joegaotao.github.io/2017/06/11/blog-start/)；这几篇书评不就是绝佳的除草剂吗？为何要无怨无悔地把除草剂贡献给微信读书平台呢？发在社交媒体上的任何文字，无论是否有质量、思想，其生命周期大约也只有那么两三天；也许两三天内能被大范围传播，但很快就会被第二天的热点取代。堆砌在自己个人网站上的东西，十年二十年后仍可以在那里。无论这些东西看起来是蠢还是牛还是庸，那都是你生命的[印迹](/cn/2019/06/passed-youth/)，证明你曾经鲜活过。为了未来还能一直保持鲜活，你必须要保存下鲜活的历史记录，作为对自己的激励。

以上便是我的灵魂拷问。最后我回到文波兄说的作息时间问题。几年前没娃时经常熬夜到两三点然后睡到中午。有娃之后作息有规律多了，通常早上七点半左右在生物钟的召唤下自动醒，晚上十二点左右睡觉。我的拖延症从未治愈过，我也一样为此焦虑，只不过焦虑时多时少而已。我很想把我拖延的事情、经过和结果写下来，以告诉自己拖延一是没有好下场，二是那些事情并没有想象中的可怕（的确如此），但至今还没怎么公开写过这样的例子，将来还得找机会写写。未知、不确定的恐惧比已知的恐惧更可怕，这是拖延症的纸老虎。另一个造成拖延的原因是我每天都要面对一大堆决策，有时候很想掀桌不干了，这些大小决策会削弱我的意志力。我在公司是单人团队，基本上零沟通，所以工作时不容易被公司同事打断。打断我的多为我的软件用户，他们有问不完的问题和提不完的请求。我不是说这些不能提，只是这个量级和频率我一个人搞不定，会给我制造一定的焦虑。我的手机从不打扰我，我的手机只有两个用途：看书和看菜谱。我常年把手机调在静音状态，电话几乎从来不接（因为都是垃圾电话，我不知道这年头还要这电话功能有何用）。早上八点把娃扔到托儿所，所以他们白天也打扰不到我。晚上六点接回来之后，各种吃吃喝喝洗洗刷刷，大约一直到十点我才能回到电脑前。这期间若有闲暇，我一般在手机上浏览菜谱，但这种闲暇很少。每天在日三省吾身后（早上吃什么、中午吃什么、晚上吃什么），我会花一到两小时做饭。现在夏天我早上还会在菜园里瞅瞅，摘个黄瓜、拔个草、掐个苗、剪个韭菜、扒个菜叶子什么的。每隔几天傍晚去浇个水。今年总体来我的工作节奏相当散乱无章，不是我满意的状态。这周我正在琢磨规划下半年的工作，希望能把一本书整完。

如何想静静？要我说，不净者不静，卸下名缰利锁，轻装上阵才能更快找到静静；浅虑者不静，播种后立刻盼着结果、一看没有果实就放弃或立刻播新种，永远在焦虑绝望的牢笼中左冲右突，不知这牢笼除了日复一日用牙对准一点死磨，并无它法可开，也不知牢笼外的自由完全值得这份咬磨的耐心；无根者不静，身世浮沉雨打萍，无法立足，只有长时间堆砌大小成果、有了十足的底气之后才能静下来。

每当你觉得臣妾做不到的时候，不妨再读一遍《[别声张](/cn/2014/12/the-gadfly/)》。留点时间给自己，好在恍恍惚惚的生活中能留下一点印迹。当然，也不要光听我忽悠，若迷信我的话小心连年都过错。有人可能会在静静中爆发，有人会在静静中灭亡。我静静积攒半年日志发出来一定还有人批阅，而你可能静三天不更新日志客人就走光了。想清楚你的追求，并采用合适的手段实现。小马过河，深浅自己去试。
