---
title: 《人类简史：从动物到上帝》笔记
date: '2019-04-26'
slug: sapiens-notes
---

在今年年初我那篇《[迷茫与倒退](/cn/2019/01/confusion-seclusion/)》一文中，我提到尤瓦尔 · 赫拉利的畅销书《人类简史：从动物到上帝》对我的影响很大。该文下面的评论中，杨洵默兄提到了对这本书的一些批评，引人深思。我期待在我这一亩三分地里能多出现一些杨兄这样的读者，因为当一般人接触到一些看起来有不少证据支撑的新奇观点时，通常会本能性地接受它（抗拒的难度太大，因为要找更有力的反面证据，尤其是对于自己不熟悉的学科）。在那一系列评论里，列弛有几处发言尤为精彩，如：

> 鲁迅说介绍一个观点的时候，最好再同时介绍一些反对该观点的观点，以便读者思考。只是中文世界里，直到现在这样的习惯还是比较罕见。若是你已经看完了《人类简史》，看看批评的文章也是很过瘾的。

刚好昨天我看到[一篇文章](https://www.douban.com/note/715524114/)里有人讲：

> 马克思主义是复杂而开放的。马克思在阐述一条规律的时候，总能举出现实中的反例。

这一点上，列弛、鲁迅、马克思、齐泽克都不谋而合。在我眼中，赫拉利在他的简史三部曲中也同样鼓励读者保持极度开放的思想。例如他对部分宗教的批评力度之猛，甚至让我对他的人身安危感到担忧，我都觉得此公很可能会被极端分子暗杀。

杨兄引用别人的话评价这本书“对的全都不新鲜，新鲜的全都错”，从而完全不建议读这本书，但我更同意下面列弛的意见，即：如果这本书把不新鲜的对的那部分传播出去，也不失为一种贡献。

> 我推荐《人类简史》给一些朋友，是因为可读性，而不是科学性。同时我也推荐了我认为比较好的批评文章，以及提醒他们我觉察到的一些错误。我想，对不少人来说，《人类简史》应该是他们看的第一本跟人类进化相关的书，所以所谓"对的全都不新鲜"这部分对他们来说是有价值的。
> 
> 如果没有这么一本可读性（话题性）强的书，或许很多人根本不会接触人类进化的相关知识。在我看来读书是个动态的过程，通过《人类简史》而对这个主题感兴趣的人或许会在以后更注意跟人类进化和社会文化宗教相关的文章，以及同主题的其他书。这样积累后了解自然会更全面。至于看完后不甚感兴趣的人，那么我想里面的谬误产生影响的可能性也不大。

畅销书往往容易引起争议，这很容易理解。对我个人而言，我并不是很在乎这些争议或是书中的专业谬误，因为这些都超出了我的处理能力。我更关心的是这些书对我有什么启示、对我的人生有什么帮助。我不会因为赫拉利说智人的成功建立在“虚构的故事”基础上就跳将出去在大街上喊你们都醒醒吧，而是去思考怎样运用“虚构的故事”的力量去引导自己和他人做有意义的事（话说回来，“意义”通常也是虚构和想象啊）。七八年前我看《明朝那些事儿》也被深深吸引，这书可读性也极强，但我关心的并不是史实（这又是超出我能力范围的事情），而是它的精神主题。如果要我用一个词概括我从《明朝那些事儿》里学到的东西，那就是隐忍（不要指望明天就能达成目标）。这套书也重新捧红了不少历史名人，比如我就是因为看了这套书才关注王阳明的（然而《传习录》翻了几百字就看不下去了）。赫拉利这套书起码可以作为开胃菜，让那些本来对人类学、进化史、社会学不感兴趣的人开始关注这方面的东西，让人以更宏观的角度看问题。说实话，赫拉利的素食主义都有些影响到我这个吃肉不眨眼的肉食动物，尽管目前还没能把我改造成素食主义者，但起码他成功引起了我对家畜生存状况的关注。他所传达的悲天悯人的情怀，我想还是有其积极意义的。

言归正传，把前年的笔记拉出来遛遛。如果我引用的部分有事实或逻辑谬误，还请各位客官不吝赐教。这篇笔记始写于四月末，当时休病假一周，然而当时没写完，后来断断续续写到六月初才写完。

## 第二章 知善恶树

开篇赫拉利就抛出一个听起来吓人的观点，就是智人的成功全靠《故事会》（当然，我是瞎转述的）！

> 所以，究竟智人是怎么跨过这个门槛值，最后创造出了有数万居民的城市、有上亿人口的帝国？这里的秘密很可能就在于虚构的故事。就算是大批互不相识的人，只要同样相信某个故事，就能共同合作。

里面用标致汽车作为一个例子，引起了杨兄的强烈反对，他认为“标致汽车老板其实和古代的巫师一样”是一派胡言。

> 所以，究竟阿尔芒 · 标致这个人是怎么创造出标致公司的？其实，这和史上许多祭司和巫师创造神魔的方式殊无二致，而且就算到了现在，许多天主教的教堂每次周日礼拜也是用这一套来创造出基督的身体。说穿了，就是讲故事，再说服听众相信这些故事。
> 
> ……至于对标致公司来说，关键的故事就是由法国国会所编写的法律制度。根据法国国会的说法，只要经过认证的律师遵守所有适当的礼仪和仪式，在一张装饰得华华丽丽的纸上写下种种必需的咒语和誓言，再在文件底端龙飞凤舞签上姓名，就在这一分这一秒，新公司注册成立！

我并没有觉得这个类比有多不妥当（我估计杨兄可能过度解读了“一样”这个词）。标致公司和神魔都不是实体，都是人为创造出来的，这没啥啊。创造出这样的虚拟概念并笼络住一群人为之奉献，不一定是坏事。造汽车方便了我们的出行，拜神魔在一定程度上也可以让人类保持敬畏之心（当然也会有糟糕的副作用）。

如果要我举例子的话，我恐怕会用 Jupyter。这个“交互式计算打造科学计算和数据分析的人生赢家”的故事实在是编造得有些宏大。在这里我又得抄列弛的一句点评了：“与其说是因为它烂，不如说是因为它没有好到和其获得的名声相匹配的地步。”

当我们意识到一切都是故事，那么下一步就是看故事想把我们带到哪里，以及最终是谁受益。当然，人类的故事通常都复杂得要死，这些问题并不容易看清答案，但想还是要想一下的。

## 第三章 亚当和夏娃的一天

这一章试图描绘远古采集社会的生活容貌。我感觉它的问题是事实与推测、甚至是臆想的边界太模糊，作者总是用文学手法去描述，一不小心看的话，很容易就会把臆测当做有证据的推测。比如里面提到一种“远古公社”理论：

> 正由于男人都没办法确定小孩是不是自己的，对所有孩子的教养也就不会有偏心的问题。
> 
> ……
> 
> 这种“远古公社”理论的支持者认为，我们看到现代婚姻常有不孕的困扰，离婚率居高不下，不论大人小孩都常有各种心理问题，其实都是因为现代社会逼迫所有人类采用一夫一妻的核心家庭，但这其实与我们的生物本能背道而驰。

这只是引用别人的假说。人类要不要强制执行一夫一妻制度我无法发表意见（还是那句话：这种研究超出了我的能力范围），但我是赞同“幼吾幼以及人之幼”这样的理念的。如果我们能像对待自家孩子一样对待别人家的孩子，那我觉得孩子的成长以及家长自己都会轻松许多。这样会减少很多不必要的竞争和人类内耗。人类强烈的私有观是自己给自己上的一道无形枷锁（如[私有车](/cn/2017/11/boxes/)）。

> 今天多数文化仍然采用一夫一妻的核心家庭，男男女女都对彼此和孩子有强烈的占有欲，而且像是朝鲜和叙利亚这些现代的国家，政治权力还是父死子继。

我是倾向于反对权力和财富根据血缘关系传承的。占着祖上占过的茅坑有什么意思呢？

接下来作者要抛出一个被辉格大人强烈抨击的观点了。尽管赫拉利没有明说，但他的文字描述总是在向往远古的狩猎采集社会。

> 在现代的富裕社会，平均每周的工时是40～45小时，发展中国家则是60甚至80小时；但如果是狩猎采集者，就算住在最贫瘠的地区（像是卡拉哈里沙漠），平均每周也只需要工作35～45小时。他们大概只需要每三天打猎一次，每天采集3～6小时。一般时期，这样就足以养活整个部落了。而很有可能大多数的远古采集者住的都是比卡拉哈里沙漠更肥沃的地方，所以取得食物和原物料所需的时间还要更少。最重要的是，这些采集者可没什么家事负担。他们不用洗碗，不用吸地毯，不用擦地板，不用换尿布，也没账单得付。

[辉格大人认为](http://headsalon.org/archives/7957.html)农业社会确实恶化了人类营养和健康、文明有其暗面，但辉格大人绝不相信原始人有什么丰富的精神文化生活：

> 只有像《人类简史》作者那样的轻浮蠢蛋，才会宣称狩猎采集者也可以拥有同样丰富的精神世界和文化生活，也“可能经历过战争与革命，令人心醉神迷的宗教运动，拥有过深奥的哲学理论，无与伦比的艺术杰作……属于他们自己的所向披靡的拿破仑，以及他所统治的半个卢森堡大小的帝国；有着他们自己的天才贝多芬，只是没有交响乐团，唯以竹笛声催人落泪……”

赫拉利的原文是这样的：

> 这幅沉默的帷幕就这样罩住了几万年的历史。在这些年间，可能有战争和革命，有灵性激昂的宗教运动，有深刻的哲学理论，有无与伦比的艺术杰作。采集者之中可能也出过像成吉思汗这种所向披靡的人物，不过统治的帝国还没有新加坡的面积大；或许也出过天才贝多芬，虽然没有交响乐团，却能用竹笛令人潸然泪下；又或是出了像穆罕默德一样的先知，不过传达的是当地某棵栎树的话，而不是什么全宇宙的造物主。不过，这些我们全部只能靠猜测。

这一系列排比句写得太吸引人，以至于我们很容易忽略最后一句，我转述一下也就是：以上种种引人入胜的情形，我赫拉利都特么是瞎猜的，哈哈哈！

所以在原始社会好与不好、文明是在进步还是退步这个问题上，如果较真的话，我还是推荐看辉格；如果为了休闲娱乐，那看看赫拉利也没那么糟糕。文明的光辉是否足以遮挡它的阴暗，这问题有点主观，我个人并没有明确的答案。至少在精神健康方面，我觉得文明人并不比野蛮人强多少，而且我推测还会持续恶化。赫拉利举了个亚契人例子：

> 在亚契成年人之间的暴力其实非常罕见。无论男女，都可以自由改变伴侣。他们总是乐天且愉快，部落里不分地位高低，想颐指气使的人通常就会被排挤。虽然他们拥有的物质不多，但却非常慷慨，而且不会执着于成功和财富。在他们的生活里，最被看重的就是良好的人际互动，还有真正的友谊。虽然他们会杀害儿童、病人、老人，但他们的想法其实和今日许多人赞成堕胎和安乐死也没有两样。另外还该提的一点，是巴拉圭的农夫猎杀亚契人的时候，可是毫不手软。

我觉得这个杀死儿童和堕胎的类比不太合适，不过有时候我感觉文明社会的规矩守则确实是[太多了](/cn/2019/02/helicopter-parenting/)，把文明人都变成了套中人，把社会搞得太复杂，仿佛没了这些规矩的话就会天下大乱。不是每个地方都有着装规定（dress code），但我们也没见满大街的人都裸奔嘛。在看《[我如何极力控制自己不去控制孩子](https://www.buzzfeed.com/jcstearns/finding-limits)》那篇文章时，我学到一个很有意思的单词，叫 litigious，意思是“好诉讼的”。文明社会的最大受益人是不是律师？当然，在美帝还有第二大受益人，就是牙医。好，我终于是打电话约牙医洗牙了，然而结果不出意外，又让我对牙医感到深恶痛绝：那位小姐姐用尽各种洗脑手段，告诉我的牙有多少问题，后果多可怕，然后开出一张三千多美元的治疗方案。我问她，你觉得这些恐怖的问题什么时候会发作？她说很可能就是明天！切，六年前我第一次找牙医洗牙时，人就极力奉劝我拔掉智齿，后来每家牙医都这样说。到现在他们说的可怕的问题还没出现。我不是说我的牙一定没问题，我只是说牙医总是费尽心思、不管发作概率大小，总是把你的牙里面的各种可能的细枝末节问题扒出来，然后劝说你把它们都治了。我知道牙医为什么这么做，很简单：不让顾客自掏腰包的话，光靠保险提供的免费洗牙会让诊所破产的，因为对普通洗牙，保险公司只付给牙医极少的钱（在我看来牙齿保险完全就是个骗局）。举牙医的例子，是要说我们追逐的边际效应是多么微不足道（对我而言，牙不疼不痒能吃饭就够了，齐不齐、白不白我都毫不在乎），而在微不足道的边际效应上我们要付出多大的代价。不知将来会不会有一天出现专门负责修剪鼻毛的医生、用 X 光告诉你左边鼻孔的一坨半径三毫米的鼻屎有让你窒息的风险。

## 第五章 史上最大骗局

这一章又有一个耸人听闻的标题，但估计属于“对的都不新鲜”的那部分。对我而言，这是我第一次了解到农业文明的暗面。

> 农业革命所带来的非但不是轻松生活的新时代，反而让农民过着比采集者更辛苦、更不满足的生活。狩猎采集者的生活其实更为丰富多变，也比较少会碰上饥饿和疾病的威胁。确实，农业革命让人类的食物总量增加，但量的增加并不代表吃得更好、过得更悠闲，反而只是造成人口爆炸，而且产生一群养尊处优、娇生惯养的精英分子。普遍来说，农民的工作要比采集者更辛苦，而且到头来的饮食还要更糟。农业革命可说是史上最大的一桩骗局。

赫拉利有一句总结，像一记响亮的耳光：

> 这正是农业革命真正的本质：让更多的人却以更糟的状况活下去。

辉格认为与现代社会的新奇便利的科技和丰富的艺术比起来，在营养与健康上牺牲一点是非常值得的。这一点我完全同意他。然而我仍然在精神层面抱有疑虑。这一章中有一节《奢侈生活的陷阱》，里面谈各种让我们追求更好、更快、更高效的现代技术到头来反而让我们更忙碌、焦躁。

> ……我确实省下了所有麻烦和时间，但生活真的更轻松了吗？
> 
> 可惜事与愿违。在传统信件的年代，我们通常只有最重要、不得不联络的事才会写信。写起信来也不是想起什么就写什么，而是字斟句酌、考虑再三。而且，通常对方的回信也会同样慎重。对大多数人来说，每个月来来去去的信顶多就是几封，也不会有人急于立刻回复。但在今天，我每天都会收到几十封电子邮件，而且所有人都希望你立刻响应。我们以为自己省下了时间；然而，我们其实是把生活的步调加速成过去的十倍快，于是我们整天忙忙碌碌、焦躁不安。

我并非要走极端、退回到邮票信封信纸时代（当然我觉得偶尔收到这么一封手写的信也不错，比如小轩哥每年过年往我家寄张贺年卡），我承认电子通信的便利，但同时我也[不得不](/cn/2018/09/inbox-zero/)开始有选择性地抗拒它了，尤其是抗拒那些有意无意滥用这种便利的人。

在《革命的受害者》一节中，赫拉利介绍了人类如何残忍压榨家畜。这一节让人看了以后如果细思一下的话，很可能会变成素食主义者（赫拉利本身是素食者）。我看完只好闭眼当没看见，但它还是影响了我对牛奶的印象。大约在 2011 年，我去楼下邻居家吃饭，席间女主人谈起男主人以前如何白痴、连只有刚下崽的奶牛才会产牛奶这种事情都不知道；当时埋头扒饭的我心里咯噔一下，因为……我……也不知道这个啊，我也以为奶牛一辈子都可以随时随便挤奶。书中也介绍了这个：

> 奶牛、山羊和绵羊只有生了小牛小羊之后才会产奶，而且也仅限哺乳期这一段时间。

如果我们看了我们从超市买的奶是如何从幼崽口中被残忍地掠夺过来的，那我估计多数人以后都喝不下牛奶了。人类简直丧尽天良。

## 第六章 盖起金字塔

赫拉利认为现代人通常终其一生想要盖起某种金字塔，个个都像古埃及的法老一样，只不过金字塔的形态在不同文化下不一样而已（比如在美帝最常见的就是一栋别墅）。问题是我们很少去想为什么我们要追求这些把自己锁死的金字塔。

> 人类发现自己已经很难离开这些人工岛屿了，所有的房子、田地、谷仓，放弃哪个都可能带来重大的损失。此外，随着时间过去，他们拥有的东西越来越多，不易搬运，也把他们绑得死死的。

对农民而言，不仅是肉身被锁死，而且还要受统治者剥削：

> 农业带来的压力影响深远，这正是后代大规模政治和社会制度的基础。但可悲的是，虽然农民勤劳不懈、希望能够保障自己未来的经济安全，但这几乎从来未曾实现。不管在任何地方，都出现了统治者和精英阶级，不仅靠着农民辛苦种出的食粮维生，还几乎全征收抢光，只留给农民勉强可过活的数量。

历史记录的通常是一将功成万骨枯：

> 历史只告诉了我们极少数的人在做些什么，而其他绝大多数人的生活就是不停挑水耕田。

这几百万挑水耕田的人如何能在一个社会里合作呢？赫拉利的回答仍然是讲故事：

> 现在看来，虚构故事的力量强过任何人的想象。

说到故事，我总是想起小时候看的《宰相刘罗锅》的片尾曲：故事里的事，说是就是不是也是；故事里的事，说不是就不是是也不是；故事里的事，也许是真事；故事里的事，也许是从来没有的事；其实故事，本来就是故事，故事就是故事……

> 不管是汉谟拉比还是美国的开国元勋，心中都有个想象的现实，想象着这个世界有着放诸四海皆准、永恒不变的正义原则（例如平等或阶级），但这种不变的原则其实只存在于智人丰富的想象力里，只存在于他们创造并告诉彼此的虚构故事中。这些原则，从来就没有客观的正确性。

我们看历史上的故事会觉得那时候的人竟然信那样的故事，太荒谬了（比如法典规定如果有人杀了别人的女儿，惩罚就是别人也杀掉凶手的女儿，而不是杀掉凶手本人），而绝不会觉得我们今天相信的故事如《独立宣言》也可能有荒谬之处：

> 我们说《汉谟拉比法典》是虚构故事，并不会觉得难以接受，但说到人权也只是虚构的故事，听来就有些刺耳。

伏尔泰说：

> 世界上本来就没有神，但可别告诉我的仆人，免得他半夜偷偷把我宰了。

光靠《独立宣言》的嘴遁远不够，就像鸣人的嘴遁不管用一样，最后必须得凭实力打一仗才能把虚构的故事现实化：

> 而在 1860 年，大部分美国公民已经认为黑奴也是人，必须享有自由的权利，这时也是靠着血流无数的一场内战，才让南方各州只能黯然接受。

为什么我们心甘情愿生活在想象的无限月读中？赫拉利的解释：

> 有三大原因，让人类不会发现组织自己生活的种种秩序其实是想象：
> 
> 1. 想象建构的秩序深深与真实的世界结合。
> 
> 2. 想象建构的秩序塑造了我们的欲望。
> 
> 3. 想象建构的秩序存在于人和人之间思想的连接。

其中原因 2 尤其有意思，因为不同时代的人有不同的欲望，这些欲望受不同的想象的驱使。例如法老最大的人生目标就是建金字塔、死了以后把自己制成木乃伊躺进去。到了今天，谁还会干这种傻事呢；若像法老那么有钱，必须得买个奢侈的包包挂身上，或去椰林树影、水清沙幼的马尔代夫度个假啊。

究竟是谁在定义我们的人生追求呢？我们如何知道我们认同的意义是否真的有意义呢？

## 第八章 历史从无正义

近年来，我是越来越憎恶对人的分类。[我提倡](/cn/2017/08/political-correct-diversity/)近距离观察个人的具体个性，而少以门纲目科属种来谈论人群。抽象是万恶之源，它的恶不仅仅在于造成个体歧视，还容易引发无休止的人类内斗，因为每个人都可以有无数种属性，而总有些属性容易被归到劣等属性里，被歧视的人群就得耗费大量精力证明（或纯粹争吵）自己并不劣等，这样的仗根本就打不完，也毫无必要去打。赫拉利仍然用《独立宣言》作一面历史的镜子：

> 就算是1776年的美国《独立宣言》，尽管把人人生而平等喊得震天响，其实还是把人分成了上下等级。《独立宣言》区分了男女，男性从中得利，但女性却被剥夺了同样的权利。《独立宣言》也区分了白人、黑人和印第安人，让白人享有自由民主，但却认为黑人和印第安人是比较劣等的人类，不该享有平等的权利。当时许多蓄奴的人也在《独立宣言》上签了名，他们签署后并未释放奴隶，但一点儿也不觉得自己言行不一。在他们看来，黑鬼哪有什么“人”权？

现在看来这种歧视太无理了，那我们是否想过，就算两百多年后的今天，我们作为所谓的文明社会的人，心中还有多少三六九等的刻板印象呢。举个具体的例子，是什么阻挠我们[爱宇宙](/cn/2018/01/no-borders/)呢？其实不过就是我们认为我们归属的某个集体优越于其它集体而已，所以我们一定要在我们这个集体周围筑起高墙。若世界真的自由、平等、博爱，我们干啥还要签证嘛。

> 然而历史的铁则告诉我们，每一种由想象建构出来的秩序，都绝不会承认自己出于想象和虚构，而会大谈自己是自然、必然的结果。

可惜多数人都无法跳出这个想象的圈。我们之所以要遵从这些想象的秩序，只不过是因为一个字，就是懒。说得好听一点就是提高人与人的合作效率。如果没有阶层的想象，那我们就需要额外的精力去了解陌生人。

> 有了阶级之后，陌生人不用浪费时间和精力真正了解彼此，也能知道该如何对待对方。

作者举了诸多例子说明很多阶层只不过是想象，比如印度的种姓制度源于婆罗门教的神话传说，但不幸的是这些想象在历史长河中一步步被加固，就算我们用生物学去证明种姓制度毫无依据，也很难打破这个牢笼。说到这里，我赞同列弛说的，[用科学证明人与人的差异存在与否](https://www.liechi.org/cn/2019/05/watson-said/)这种事，从一起步就用错了科学，而且就算得到答案，也毫无意义。

> 大多数社会政治阶级制度其实都没有逻辑或生物学的基础，不过就是由历史的偶然事件引起，再用虚构的故事延续壮大。

最后赫拉利提供了一条法则来鉴别哪些事情只是人类以想象为依据去实施的：

> 我们究竟要如何才能判断，什么是真正在生物学上有所不同，而什么又只是人类说得煞有介事、自找借口？一项黄金法则就是“天生带来允许，文化造成封闭”。

这项法则听起来有点激进。赫拉利本人是同性恋，所以这里他有些忿忿不平：有些人天生就是同性恋，而文化却对这些人刻意打压。在这件事上，我们应该容易理解他的这项黄金法则，但这项法则有推广性吗？文化压制人的天性这种事，自古恒有之（例如存天理、灭人欲），那我们应该释放到什么程度呢？我觉得只要人类以集体方式合作、生活，就不可能完全释放天性；有一些自由，只能是零和博弈。

## 第九章 历史的方向

[从 2015 年起](/cn/2015/11/peer-review/)，我开始有意识地琢磨公平与公正的问题。赫拉利在第九章中丢出了这么一句话：

> 自从法国大革命之后，全球人民逐渐同意“自由”和“平等”都是基本的价值观。然而这两者根本就互相抵触！

嗨，在水深火热的美帝[连晒被子的自由都没有](/cn/2017/04/freedom/)，还谈个啥子平等嘛。就更不必说更严肃的自由了，比如[堕胎的自由](https://www.douban.com/note/719475468/)。

## 第十二章 宗教的法则

开头我说我甚至有些担心赫拉利会因为他的言论被极端分子暗杀。在这本书中，他的批判力度其实还不够强；到了他的三部曲的后两部《今日简史》和《未来简史》中，他基本上就是在说有些宗教纯属骗局，直言其虚伪性。

这里首先他赞许多神论，而抨击一神论的宗教：

> 真正让多神论与一神论不同的观点，在于多神论认为主宰世界的最高权力不带有任何私心或偏见，因此对于人类各种世俗的欲望、担心和忧虑毫不在意。因此，要向这个最高权力祈求战争胜利、健康或下雨，可以说是完全没有意义，因为从他全知全观的角度来说，某个王国的战争输赢、某个城市的兴衰胜败，又或是某个人的生老病死，根本不构成任何差别。希腊人不会浪费祭品去祭拜命运女神，而印度教徒也并未兴建寺庙来祭拜阿特曼。

多神教征服其它国家时，并不强行要求被征服的人民改变信仰。

> 多神论本质上就属于开明，很少迫害异教徒。

古罗马人征服别的民族之后，甚至愿意接受别人的神灵到他们自己的神殿，只有基督教例外：

> 古罗马人唯一长期以来不愿接受的，只有属于一神信仰并坚持要传福音的基督教。古罗马帝国并未要求基督徒放弃他们的信仰和仪式，只希望他们同时尊重帝国的守护神，并承认皇帝也有神性。这点可说是在政治上忠诚的声明。

罗马帝国有迫害过基督徒，但问题是一神论本身引起的争论导致教内互相残杀而死亡的人数远超过被多神教迫害致死的人数：

> 然而事实证明，就算把这些迫害的所有受害者全部加起来，在这三个世纪间，多神教古罗马处决基督徒的人数不超过几千人。但相对的是，在接下来的1500年间，虽然基督教号称主张爱与怜悯，但仅仅对信仰的诠释有些许差异，就引发基督徒自相残杀，死亡人数达到数百万。
> 
> 其中最恶名昭彰的，就是在16、17世纪间席卷欧洲的天主教与新教徒之战。所有这些人都相信基督的神性，也相信他关于爱和怜悯的福音，只是对于“爱”的本质意见不合。新教徒认为，神如此爱着世人，所以让自己化为肉体，容许自己受到折磨、钉死在十字架上，从而赎了原罪，并对那些信他的人打开了天堂的大门。而天主教徒认为，虽然信仰是必要的，但光这样还不够。要进入天国，信徒还必须参加教堂礼拜，而且要多行善事。这点让新教徒无法接受，认为这样形同交易，对于神的爱和伟大是种贬抑。如果进不进天堂必须取决于自己的善行，岂不是放大了自己的重要性，而且暗示基督在十字架上为人类受的苦以及神对人类的爱都还不够？
> 
> 这些神学争论愈演愈烈，最后在 16、17 世纪间，天主教徒和新教徒彼此杀红了眼，造成几十万人丧命。1572 年 8 月 23 日，强调个人善行的法国天主教徒，袭击了强调上帝之爱的法国新教徒。这场攻击称为圣巴塞洛缪节大屠杀（St. Bartholomew's Day Massacre），短短 24 小时间，就有 5000 到 10000 个新教徒遭到屠杀。消息从法国传到古罗马的天主教教皇耳里，叫他满心欢喜，立刻安排举行庆典，还委托瓦萨里（Giorgio Vasari）在梵蒂冈的一个房间里将这场大屠杀绘成壁画作为纪念（目前这个房间禁止游客参观）。不过 24 小时，基督徒自相残杀的人数，就已经超过了整个古罗马帝国曾经杀害的基督徒人数。

一神论有个大难题，这个难题恰好是我前年在《[职业羞耻感](/cn/2017/02/shame/)》最后一段提出来的问题。即：如果有个唯一、全能、无私、正义的神，他为什么会允许邪恶存在；我认为他要么没那么全能，要么没那么无私。抑或就像上面新教徒所质疑的一样：神是在与人类做交易吗？即：你信我我就保佑你，那些不信我的人，你们是死是活与本神无关（这器量似乎与我等码农也差不多嘛：你用我的软件我就帮你，你要不用那你就与我无关）。这让我想起丰子恺的一篇文章《佛无灵》，里面他老姑母的一句“佛无灵”让他长篇大论解释了信佛不是同佛做买卖，不能因为个人遭了不幸就怪罪神佛，信佛应该是信其精神并相应地去修行，而不是信佛像，或把佛当作保护神。我在《[人生有何意义](/cn/2018/03/meaning-of-life/)》中也引过胡适类似的话。

> 二元论之所以成为一种深具魅力的世界观，原因就在于人类有一个挥之不去的“恶的难题”（Problem of Evil），苦苦无法解决。“为什么世界上会有邪恶？为什么有苦难？为什么会有坏事发生在好人身上？”如果神真的是如此无所不知、无所不能、事事完美，又怎么会允许世界上有这么多的苦难？这让一神论者伤透了脑筋。

世界宗教史并不全部是神的历史。有些宗教是肉身凡胎的人创造的，比如佛教。[前年我也说过](/cn/2017/04/like-transitivity/)，虽然我不是任何宗教的信徒，但佛教的哲学相对比较能打动我。原因可能是佛教更贴近个人，而且它宣称的痛苦来自欲望这一点也无可辩驳。佛教修行中，我们绝大多数时间面对的都是自己的内心，而不是某个神。

> 一神论宗教的最高原则是：唯一真神确实存在，那么他想从我这里要什么呢？佛教的最高原则，则是：痛苦确实存在，我该如何逃离呢？

我没有找到赫拉利本人是否有宗教信仰，但他在后面的两本书中提到他每天会冥想（[内观](https://zh.wikipedia.org/wiki/%E8%A7%80_(%E4%BD%9B%E6%95%99))）两小时，感觉应该是受佛教影响比较大。

如果人并没有一个（宗教）所谓的灵魂、支配我们的不过是体内的生化反应，那我们的道德和法律体系会不会崩塌？

> 越来越多科学家认为，决定人类行为的不是什么自由意志，而是荷尔蒙、基因和神经突触——我们和黑猩猩、狼和蚂蚁并无不同。我们的司法和政治制度碰上这些发现，多半是视而不见、不愿面对。但坦白说，现在这面堵在生物学以及法律和政治学之间的墙，究竟还能维持多久？

## 第十三章 成功的秘密

赫拉利认为历史更像是混沌系统，而没那么多我们想当然的必然：

> 如果承认历史并非必然，等于就是承认了现在的民族主义、资本主义和人权都只是巧合的产物。

有学者认为文化就像寄生虫，并且比寄生虫更厉害，因为就算宿主死了，它还能传播到另一个宿主：

> 任何一个文化概念（像是基督教在天上的天堂），都可能让某个人毕生致力于传播这种想法，甚至为此牺牲生命。于是，人类死亡了，但想法持续传播。

## 第十四章 发现自己的无知

经书中多为故事，并不包含基于数学的近现代知识：

> 早期的知识体系常常是用“故事”构成理论，而现代科学用的则是“数学”。

而精确的数学有时候也处理不了复杂的现实，这里赫拉利专门提到了统计学：

> 在过去两百年间，为了处理现实中更复杂的层面，数学发展出一个新的分支：统计学。

他举的统计学的例子是精算的萌芽，即：为了解决牧师去世后的遗孀生计问题，有人用类似今天的保险模式预先筹集一笔款项（相当于今天的保费），而款项的数额则取决于每年多少牧师去世、留下多少遗孀以及这些人还能活多久。

就算是现代科研也有其本质局限性，就是它几乎不可能纯粹客观，它多少会跟政治、经济、宗教有牵连：

> 科学研究之所以能得到经费，多半是因为有人认为这些研究有助于达到某些政治、经济或宗教的目的。

赫拉利认为有两股推动科学研究的特别力量：帝国主义和资本主义。

## 第十六章 资本主义教条

宗教杀害了数百万人是出于仇恨，而资本主义杀害了数百万人则是出于冷漠和贪婪。英国人十七世纪初每人每年的糖摄入量几乎为零，到了十九世纪初则增长到八公斤。在此背景下，无数的非洲奴隶丧命：

> 从 16 世纪到 19 世纪，大约有 1000 万非洲奴隶被运到美洲，其中有大约七成都在甘蔗园里工作。奴隶的劳动条件极度恶劣，大多数奴隶生活悲惨、英年早逝。而且欧洲人发动战争俘虏非洲人，再从非洲内陆千里迢迢运至美洲，数百万非洲人就这样在战乱或运送过程中丧命。而这一切，不过就是为了让欧洲人能够在茶里加糖、能吃到甜点，让人能够靠着贩糖而获取暴利。

其实在当今文明社会，我们跟当年的欧洲人的区别只不过是他们杀害、压榨非洲奴隶，而我们杀害、压榨动物（家畜）而已。

我们以为现在是歌舞升平的时代，但就算全球经济大饼已经显著变大，却仍然有很多非洲农民和印尼劳工整日辛苦劳作所得还不如五百年前的先人（这就像农业骗局一样）：

> 虽然人类和全球经济看来都在继续成长，但更多的人却活在饥饿和困乏之中。

资本主义的辩护之一是：

> 只要我们再等等、再等饼变大一点，就能让人人都分到够大的一块。

我这几年特别注意“够”这个字。我们真的还知道什么是[够了](/cn/2017/07/enough/)吗？我觉得人心的贪婪增长速度会超过饼变大的速度、吃到大饼的人还想吃更大的；而另一方面，我们也在变得越来越冷漠，这在我看来有几个原因：一、[信息过载](/cn/2018/08/attention/)，我们的同情心被我们所听闻的海量不幸事件摊薄了；二、[娱乐至死](/cn/2018/04/amusing-ourselves-to-death/)，娱乐节目如同《美丽新世界》中的索麻，不断麻痹我们；三、我们习惯了贪婪以至于意识不到我们的冷漠，例如我有个邻居，几乎每周都有吃不完烂掉的水果和菜，我多管闲事跟他建议了好几次让他买菜时少买一点，可他显然并不以为然。并不是杜甫的时代才有朱门酒肉臭、路有冻死骨。

## 第十七章 工业的巨轮

赫拉利接下来很快就提到我们的冷漠问题了，他大篇幅描述了现代畜牧业的残忍（如工业上如何对待鸡和牛）：

> 大西洋奴隶贸易并非出于对非洲人的仇恨，而现代畜牧业也同样不是出于对动物的仇恨。这两者背后共同的推手，就是冷漠。

过去的节俭被消费主义击垮，我们都被鼓励过度消费：

> 我们都成了乖巧的消费者，买了无数种我们并不真正需要的产品，而且有的根本就是昨天才知道的。

在过去的伦理体系下，普通人想要上天堂真的是难如登天，因为多数人（即使是教徒）也极难达到一些常见要求，如慈悲、宽容、克服愤怒和欲望；而现在呢，赫拉利讽刺地说道：你只要打开电视，就知道你已经活在天堂里了；根本不用自己守着清规戒律、达到什么要求。

## 第十八章 一场永远的革命

工业革命让时间观念深深刻在人们脑中，任何事情都要规划时间。下面是一则与主旨没太大关系的轶事：

> 甚至还有些天才的德国物理学家，居然找出一套方法，只要靠着钟声在广播中的微小差异，就能判断伦敦当时的天气。

说到工业社会带来的精确时间观念，我不禁想起《[奇特的一生](/cn/2011/05/i-hate-exams/)》：我们的钟表随处可见并且越来越精确，而我们的一生很大一部分却都是虚抛浪掷、无所事事。

赫拉利在另外两部曲中也谈到恐怖主义的本质是为了吓唬人、制造影响，它的实质破坏没有我们想象的那么大。

> 在“9 · 11”恐怖袭击后的一年，虽然恐怖主义和战争喊得震天响，但说到某个人被恐怖分子、士兵或毒贩刺杀的可能，其实还比不上他自杀的可能。

这与我在《[我们为这个世界能操碎多少心](/cn/2017/10/media-emotion/)》一文中提到的是类似的。每年因糖尿病而死的人数远多于恐怖分子杀死的人，但恐怖分子吸引到的我们的注意远大于我们对糖尿病的注意。从这个角度来看，张一鸣就是当今中国登峰造极的恐怖分子。

## 第十九章 从此过着幸福快乐的日子

童话故事的结尾通常是王子和公主从此过着幸福快乐的日子。这本书临近尾声时，开始讨论人类对幸福快乐的追求，不过这些讨论都很佛系，我很中意。

首先，我就不爱洗澡更衣，觉得这事的舒服程度根本不足以抵消它的麻烦。西方国家的人还早上起来洗澡，在我看来根本就是虚伪嘛。白天脏了应该晚上洗洗睡啊，等到早上再洗大概只是为了别人而洗的吧，即：怕白天接触的人觉得自己脏臭。

> 现代社会丰饶富裕，我们很习惯每天都要洗澡更衣。但在中世纪，农民好几个月都不用洗澡，而且也很少会换衣服。对现代人来说，光是想到要这样生活，就觉得真是臭到要命、脏到骨头里，完全无法接受。只不过，中世纪的农民似乎一点都不介意。这种衣服长时间没洗没换的触感和气味，他们早就已经习惯。他们并不是因为太穷而无法负担换洗衣服，而是压根儿就没有这种期望。于是，至少就衣服这一件事来说，他们其实很满足了。

我很想知道有几家的娃天生就爱洗澡的，感觉通常都得靠大人连哄带骗；等他们养成洗澡的习惯之后，再去祸害他们的下一代：

> 就算是在富裕的社会里，小孩通常也不喜欢洗澡，得花上好几年的教育和管教，才能够养成这种理论上应该很舒服的习惯。一切都只是期望的问题而已。

我觉得这只不过是芝麻大点事，却被现代文明人无限放大。

在《[财务自由](/cn/2018/06/financial-freedom/)》一文中，我引了《人类简史》中的这段话来说明我们的需求是怎么被勾出来的：

> 有没有可能，第三世界国家之所以会对生活不满，不只是因为贫穷、疾病、腐败和政治压迫，也是因为他们看到了第一世界国家的生活标准？

关于这些花花世界的需求，于淼大人在《[钓愚](https://yufree.cn/cn/2019/05/10/phishing-for-phools/)》一文中引了一条建议：

> 保持专注与警惕，只关心你需要的而不是别人强加给你的需要。

我看到之后回复说现在不仅仅是强加的需要，而更多是勾引出来的需要。年初我在《[迷茫与倒退](/cn/2019/01/confusion-seclusion/)》中说过人越来越会利用人性的弱点，从而创造出各式各样莫名其妙的需求。

如果科学发展为我们带来了长生不老的灵药，我们会不会获得终极的幸福快乐？不一定。比如肯定只有巨富能首先享受到这项成果，而多数人只会更加愤怒和焦虑：

> 那些无力负担这些医学奇迹的人（也就是绝大多数人），一定会愤怒到无以复加。纵观历史，穷人和受压迫者之所以还能自我安慰，就是因为死亡是唯一完全公平的事。不论再富有、权力再大，人也难逃一死。光是想到自己得死，但有钱人居然能长生不老，就会让穷人怒火中烧、不可遏抑。

赫拉利引用了一句尼采（我没考证尼采[是不是真的说过](/cn/2017/02/kaiti/)）：

> 只要有了活下去的理由，几乎什么都能够忍受。

他用养小孩作为例子。无论你的父爱母爱多么泛滥，你都无法否认养小孩实际上是件苦差事；一位整天哭闹的小霸王，到底为啥要辛辛苦苦养他呢。用尼采的话来解释大概就是，一件事只要我们为之赋予意义，不管再苦再累我们都可以心甘情愿做下去。谁会觉得养娃没有意义呢？

所以幸福快乐的本质和成因就是意义吗？佛系青年赫拉利开始谈佛教了：

> 佛教认为，快乐既不是主观感受到愉悦，也不是主观觉得生命有意义，反而是在于放下追求主观感受这件事。

只有放弃对主观感受的追求，心里才能变得澄明、自在。这大概就是不以物喜、不以己悲。不然，这个追逐的过程就会让人累趴。

> 人想要离苦得乐，就必须了解自己所有的主观感受都只是一瞬间的波动，而且别再追求某种感受。如此一来，虽然感受疼痛，但不再感到悲惨；虽然愉悦，但不再干扰心灵的平静。

好了，停下追逐的脚步，涅槃吧，人类。

> 佛教与现代生物学和新世纪运动的相同点，在于都认定快乐不在于外在条件。但佛教更重要也更深刻的见解在于，真正的快乐也不在于我们的主观感受。我们如果越强调主观感受，反而就越感到苦。佛教给我们的建议是，除了别再追求外在成就之外，同时也别再追求那些感觉良好的心理感受了。

## 后记 变成神的这种动物

一定程度上，智人已经变成智神了：科技让我们可以轻松眼观六路、耳听八方、日行千里。我们寻求娱乐和舒适，却永远无法真正满足。在书的最后，赫拉利表达了对人类前途的担忧：

> 拥有神的能力，但是不负责任、贪得无厌，而且连想要什么都不知道。天下危险，恐怕莫此为甚。

纵观这篇笔记，我并没太把这本书当做史书来读。现在的出版物里，《简史》泛滥，我个人不是很喜欢简史这种标题，因为它看起来像是想要特意迎合快餐读者的口味。这本书对我的主要意义在于寻找内心的平静，也就是说，我读它几乎完全出于个人目的。我控制不了人潮，也无此兴趣，但我希望首先能取回对自己的控制、在喧嚣中能静下心来想想自己到底想要什么。
