---
title: 身健在，且加班
date: '2019-04-05'
slug: 996-icu
---

古人通常努力[加餐](/cn/2018/11/eat-more/)，今人却很不幸，要努力加班。上次我回国的时候就[感慨过](/cn/2017/01/blog/)北京不是人待的地方，涛妹和太云半夜还在加班。今日看见一个星标数大得惊人（近二十万）的 GitHub 库，叫 [996.ICU](https://github.com/996icu/996.ICU)，它曝光了那些黑心加班公司，也有良心公司名单。这些黑心名单和报道真是令人窒息。

[上上次](/cn/2015/09/memory/)我回国的时候跟北京的高中同学聚会的时候，谈起工作，他们都对我的工作模式感到不可思议，羡慕得不要不要的。首先是在国内很少见在家远程工作的模式；其次是我的工作内容我做主；再次是没有年假一说，自己想放假就可以放，提前跟公司知会一声就可以了。

这些是表面上的模式，实际运作大约是这样：远程工作省下了不少通勤时间，这一点非常合我心意，因为我觉得上下班的通勤实在是浪费时间。我每天也就是在接送小孩上花十分钟左右开车（托儿所离家只有一首歌的时间），剩下的时间就是端坐在家，而电脑是我的第一大时间杀手，厨房第二。理论上我有充足的时间工作，但作为码农，我每周真正花在写代码上的时间平均应该在五小时以下。我的很多时间都花在 GitHub 上批折子，这些永远批不完的折子让我很是身心疲惫，所以我也变得[心肠越来越硬](/cn/2018/09/inbox-zero/)；今年我已经开始不由分说就关闭一些不靠谱的折子，因为这些小主显然没有读我的折子指南，也不提供我要求的信息，我只能手起刀落，咔嚓一刀剁翻之，省得在眼前不停嗡嗡嗡。

关于我做主的工作内容，从 2016 到 2018 年还算我能主导，而到了今年，我发现我维护的 R 包似乎已经到达了我的极限（目前是 23 个）。过去的两个多月，我就一直像扔杂耍球一样在扔那些包，把它们一个个扔上 CRAN，再着手打理下一个已经积攒了一堆事项的包。这 23 个包当然不是个个都重要或耗费精力，有些都没用或没人用，或者极度稳定、不需要维护（如 mime）。若按费劲程度排序，大致如下：rmarkdown、knitr、bookdown、DT、xaringan、rticles。这六大魔王通常需要大块时间照料，剩下一些喽啰包每隔几个月也要浇水施肥：pagedown、tinytex、tufte、servr、blogdown、xfun、animation、evaluate、formatR。再剩下一批我基本上不用打理的包：fun、highr、markdown、mime、MSG、printr、Rd2roxygen、testit。我做码农这几年快到了立地成佛的地步，原因就是我看到太多这个代码世界里的贪嗔痴，有时觉得挺无奈的。我在 bookdown 书的最后附录中给了一条[佛系建议](https://bookdown.org/yihui/bookdown/faq.html)，但似乎也没多少人愿意听。现在已经有好些人帮我分担压力，如靠谱厮[俞丽佳](/cn/2017/04/copss-2/)从我桌上端走了 animation 包、另一位靠谱厮[谭显英](/cn/2018/03/copss-5/)壮士发死力帮我扛着 DT 包、一位忠厚的法国友人 Christophe Dervieux 在比我早的欧洲时区提前几个小时就帮我批掉一些 GitHub 折子并重复那些我重复了一遍又一遍的话、TC 君帮我照料着 xaringan 并偶尔也在 blogdown 库里现身，但即使这样也仍然不太够。GitHub 上的折子仍然像野草一样疯长，这种数量级的折子本身可能并不可怕，也不是每个折子都很耗费精力，但很容易引起决策疲劳；就算每个折子只需要我做个小决策，数量多了也受不了，所以我最高兴看见的就是早上起来时一些折子我还没过目就被关掉了。如果有客官感兴趣，我欢迎任何人帮我批复任何库里的任何折子，也欢迎提着补丁来帮忙修理八阿哥或实现新功能，或者像俞丽佳一样把整个包连锅端走。我唯一的期望是这样的壮士能有点毅力，这方面谭显英壮士是个极好的例子：连我都对 DT 包的维护感到有些吃力，他居然到现在还没被逼走，但愿这事不要影响到他的本职工作。上面六大魔王里，其实 rticles 现在已经只是小魔王了，因为前不久我花了一周时间把它[大力精简](https://github.com/rstudio/rticles/commit/2b5091ed3)了一下，之前的代码实在太特么冗余了（虽然是我们厂长写的），非常不利于维护和新手贡献；要是有人想背锅，这口锅很轻，可以优先考虑，前提是有 LaTeX 功底。

如果这些锅能去掉一半，那我觉得我还能回到自己做主的工作状态。去年我就有两本书的计划，但直到现在都四月了还一字没开动。这么下去，我的一年一包一书的链条怕是要断掉了。

至于休假，理论上无限量，但肯定得拿出工作成绩来，否则休假会休得理亏。我从 2015 年 3 月到 2018 年 8 月这四年多都没有主动请过假，这是因为我感到亏欠而弥补[当年的过错](/en/2018/02/career-crisis/)。当然，不主动请假不意味我一天也没休息过，法定假日我通常会休息，主要是因为娃同样放假在家，我没法干活；然后就是娃生病，经常就是废掉一整周时间。我这四年的第一次主动休假就是那次我写《穷查理宝典》[读书笔记](/cn/2018/08/poor-charlies-almanack/)的那周，结果一周五天我就用了三天写那篇笔记。

回过头来说加班之事。我们厂鼓励休息、甚至想执行强制休假政策，希望员工有饱满的精力把事情做好，并不在乎你究竟工作多长时间，所以朝九晚五对我们来说毫无意义。你要觉得半夜效率最高，不妨白天玩一天，夜里干三小时活儿，那也是可以的。我们厂长本人可能是厂里[最勤奋的码农](/cn/2018/05/github-contributions/)，他先通过自己的勤奋实现了财务自由，然后终于可以专心致志写他的代码了。我不知道他通常几点下班，但早上一般四五点就开工了，很可能是朝四晚五的模式。这种工作模式听起来很疯狂，但写代码就是他最大的爱好，所以他字典里应该压根儿就没有加班这个词。

这次的 996.ICU 风波让我想到如下一些问题，这些问题我都没有确定的答案，因为我不了解别人的公司和员工，只能从我自身的情况出发琢磨，而我又不是一个有代表性的公司雇员。

1. 为什么我们的工作永远干不完？

    这个问题可能与具体的某个公司与员工无关。我不知道如今还有多少人每天放工时还有那种“今天的工作做完了”的感觉。对我而言，我就没有任何一天有这种感觉。每天浏览器里都是三四十个标签栏，多数是 GitHub 的那只八爪猫图标。我甚至都没有“下班”的概念。只要人往电脑前一坐，就可以轻松看见接下来很多天的活儿，根本看不到出头之日。好在我还有选择权，可以选择扔掉一些任务，但如我前面所说，就算只是做这个选择工作，也是够苦恼了：一群人可能都在眼巴巴看着我，我凭啥处理这个人的报告而丢弃那个人的报告呢。
    
    软件的工作永远干不完，可能终极原因还是人心太贪婪，我们总要这样或那样的新功能、要更快、更美，永远无法满足。我常年抨击 LaTeX 的本质原因就是因为它助长了人心对排版的贪婪，在 Markdown 世界里我们则可以被迫克制，很难去舍本逐末。而从 bookdown 的开发来看，我时不时就感觉 LaTeX 的棺材板快压不住了，bookdown 被逼着去取代 LaTeX 成为新的恶龙，尽管这是我最不愿看到的结果。
    
    这一点可以推论到别的行业吗？我不知道。为什么京东淘宝要 996？是不是因为网购的人数和需求在疯狂增长导致他们的员工永远干不完活儿？为什么我们的网购意愿越来越强烈？是不是我们越来越贪婪？
    
    我们是不是在自掘坟墓？
    
    小学时，每次见我在外面玩家里的长辈总是要问一句：作业做完了没有？那句充满满足感的回答“做完了！”似乎永远也不能在成年人的世界里重现了。
    
    “代码写完了没有？”
    
    “什么叫写完？”

1. 为什么工作时长成为了这么重要的衡量指标？

    我们厂从来不计算我的工作时长，连我自己都不知道我到底每天工作几小时，感觉大约是三四个小时，反正绝对是远小于八小时。
    
    我觉得那些大厂用工作时长这个指标来考核职工的原因之一无非是因为时间指标在计量上方便而已。很多指标的设立和使用并不是因为它们有道理，而是方便。比如我认为公正的法律应该是个性化的（考虑每个人的背景甚至生化特征），但采集个性化的数据实在是不可能的任务，而且有些指标很难评估（比如精神伤害程度），所以只能大家统一使用公平的法律了，即用公平代替公正。同样，工作质量的评估也是一件繁琐又模糊的工作；在大厂里，与其费时费力去评估每个员工为公司带来的效益，还不如就一刀切，每天大家都集体工作十二小时，就算某些员工效率奇高，也得被迫留下来，这样要么就是白混时间，要么就故意降低工作效率以迎合加班时长。这便是那个著名的[古德哈特定律](https://zh.wikipedia.org/wiki/%E5%8F%A4%E5%BE%B7%E5%93%88%E7%89%B9%E5%AE%9A%E5%BE%8B)的体现：当一个指标变成目标后，这个指标就再也不是一个好指标。如果工作时长成为最重要的指标，那么就意味着工作效率和质量都可以牺牲。为了提高一厂的效益，本应该注重员工的效益贡献，而因为这个贡献跟工作时长有某种想象中的正相关关系，于是就臆想延长时长来提升效益了，然而脑力工作和搬砖不一样：不是搬的时间越长，搬的砖就越多啊。
    
    估计道理谁都懂，但厂里就是不放手，厂与厂之间还形成了隐性的互相绑架：你加班我就更拼命加班，否则我就有被你干掉的风险。

1. 有多少人还喜欢自己的工作？

    我不知道有多少人能理解稻盛和夫这样的工作狂，他把工作当做“塑造高尚人格的修行”，提到两个选择：要么你选择一份喜欢的工作，要么喜欢你现在的工作。现实通常不会给你第一种选择，所以你只能想办法喜欢自己的工作了。这让我想起我刚上大学时很不喜欢高等代数、数学分析这些数学课，觉得太难（尤其高代，如同天书），所以最后只好假装喜欢，记得我似乎在封页上写过“洒家最爱高代数分课”之类的话语。想来有些幼稚，不过还是有一定效果，稍微减弱了我的排斥心理。
    
    现在我很幸运地拥有了第一种选择，还比较喜欢自己的工作，有时候也跟我们厂长一样，可以从早码到晚，而不知加班为何物。另外我也很幸运，在家工作，不会出现那种“半夜下班回家孩子已经睡了、早上出门时孩子还没醒”的情况。
    
    其实我对加班、工作量大本身并没有很强烈的反对意见，尤其是年轻人，就应该多吃点苦，如稻盛和夫所说，磨砺心性，以便将来遇事能稳重处理，而不是凭本能和情绪去处理。但是如果加班的强度大到带来下面这两个后果时，我就强烈反对加班了：一是影响到身体健康，加班不能加到医院或重症监护室去；二是强烈影响到家庭，比如父母和孩子住在同一个屋檐下却长时间见不到面。注意我只说了身体健康而没说身心健康，因为我觉得加班造成心理负担在一定程度上应该是可以接受的，我们需要这样的压力锻炼，只要不太过分就好（比如整天被凶狠的上司催逼到崩溃）。

    稻盛和夫说喜欢和投入会形成正向循环，也就是你越喜欢工作，投入就会越多，而产出也会越高越好，然后这种成就感会让你更喜欢这份工作。我感觉这个循环在脑力工作里应该相对容易实现，而对体力工作则不太适用：应该没什么人愿意在工地上多搬砖或骑自行车多送几份外卖。

1. 是雇主太无情还是员工太懒？

    在 996 风波下，绝大多数人可能都会一边倒，讨伐雇主，这时候逆行的人至少会是政治不正确。我觉得这事应该每个人自己具体想想我们参与这场风波是不是有足够的底气，也就是我们在工作中已经全情投入、没有摸鱼偷懒的心理。有没有人纯粹是怀着少干活多拿钱的心思来蹚浑水的呢？我觉得一定有，因为这是人的自然心理。

    为了避免有人蹚浑水，其实还是要回到那个衡量工作产出的问题上。如果有别的方式能更准确地衡量工作产出，那么就没必要死磕时间这个指标了。靠谱的员工要是三小时能完成产出，那么中午下班也可以；蹚浑水摸鱼的员工，就算留他十二小时在公司也是白搭。有些行业相对容易衡量工作产出，也就容易制定激励机制；在《[穷查理宝典](/cn/2018/08/poor-charlies-almanack/)》中，芒格举了联邦快递的例子：夜班工人只要把货物装上飞机就可以回家，薪水不按小时付，而是按装了多少货物而定。这种情况下，偷懒毫无意义。

1. 如果加班这么悲催，为什么不换工作？

    一方面，估计多数加班的人都没有足够的能力跳槽到更好的工作环境中，而正是因为加班，他们也没多少机会提高自己在其它方面的能力，所以就恶性循环被锁定在一个加班岗位上了；另一方面，加班成为多数公司的常态，就算跳槽，结果很可能也是一样加班。

1. 城市套路深，要不要回农村？

    既然在大城市加班如此悲催，那是否可以考虑放弃这灯红酒绿以及所谓的遍地机会、归隐田园？在大城市像狗一样挣钱买房买车的付出，如果拿到农村，应该是可以毫无压力地满足温饱。反正我们现在的社交也基本上变成了网上的虚拟社交，那肉身在何处也没多大关系了，所以精神生活方面也不会有多大损失。想来想去，我只能想到一个留在大城市的理由，就是为了孩子的未来。大城市的教育也许更好，机会更多，但我们有没有想过，我们拼死拼活留在这里，谁能保证我们的孩子将来不是跟我们一样加班？我们到底是在帮他们还是在坑他们？《黑客与画家》中格雷厄姆说在过去的学徒制下，孩子十岁就学会钉马掌了，而在现在的学校教育系统下，十岁的孩子几乎什么实际生活技能都不具备，生活完全不能自理，某种程度上就是个小废人。

    所以要不要回农村，有一间茅屋、面朝粪坑、喂马、劈柴？
    
    回不去啦，我们都被绑架啦。看见了更好的生活之后，我们的身和心都回不去了。问题只是，那更好的生活往往都是别人的生活，与我们无关，我们也无法企及。

    而且就算是农村，也被加班侵蚀了，这是个社会病和时代病，不是公司专有的现象。上个冬天我爹和其他村里的叔伯婶娘们凌晨两三点就起床，去一户人家剥桔子皮，因为每天上午有卡车来把剥好的桔子拖去镇上的罐头厂。这种事情以前从来没有过。在我小时候，通常就是桔子成熟的季节有桔贩开着卡车来把桔子拖走，家家户户顶多就是摘桔子的那几天集中加班忙一下（而且晚上照常睡觉），而不会一个冬天都半夜爬起来在电灯下剥桔子皮。我不明白这些桔子罐头的消费需求是怎么冒出来的。人类的胃并没有在近几年突然变大一号吧？

1. 为什么有些国家就不用加班呢？

    [比如瑞典](https://www.douban.com/note/714122219/)。相比之下，感觉我们整个国民心态都坏掉了。双十一的销售额根本不值得庆祝，那个数字背后是满满的贪婪；百度的春晚红包技术战役听起来感天动地（如何改代码、如何紧急采购服务器等），但细思恐极：十亿人在一年中最重要的夜晚竟然觉得那几毛钱的红包比家人更重要。真呀么令人[迷茫](/cn/2019/01/confusion-seclusion/)。如果我是个有影响力的公众人物（可惜我无志于此），我会号召大家除夕夜都把手机关掉扔一边，不许抢红包。

    如果我们在心态上有节制，也许就不会有这么些需求，而整个世界都会清静许多。可惜人通常只向上看，不会回头向下看。忆苦思甜可能会被看作神经病。

综上，加班可能只是一个表象。通过 996.ICU 群众的强力敲打，这冰山一角也许能敲掉一块，但我们恐怕是无法奈何水面以下的大冰山了。
