---
title: 政治与英语
date: '2019-03-28'
slug: politics-and-english
---

去年我偶然[看见](/cn/2018/11/phd-or-work/)有人提奥威尔的《政治与英语》时，我还以为那是一本书，直到今年我才知道，原来它只是一篇文章“[Politics and the English Language](https://en.wikipedia.org/wiki/Politics_and_the_English_Language)”（[这里有全文](http://www.orwell.ru/library/essays/politics/english/e_polit/)）。看了这篇文章之后让我觉得相见恨晚，奥威尔有个观点跟[我前不久说的](/cn/2018/11/work/)差不多：语言的模糊与思想的模糊高度相关，你说不清楚的东西很可能是因为你没想清楚。至于反对不必要的被动语态，我[好些年前](/cn/2009/11/common-sense-in-english-writing/)看“The Elements of Style”就已经在脑子里打下了深深烙印，奥威尔也同样这样建议；类似地，他反对过度使用否定句，这个问题我也有意识到，但有时难以避免，尤其在诗词里，比如写中学老师的那首[水调歌头](/cn/2018/10/middle-school-teachers/)里我用了三处否定、给导师的[空泛一联](/cn/2017/10/zhao-couplet/)中两次否定、给编辑部的新年致辞的[一坨诗](/cn/2017/01/lucky/)中也是两次否定、最早的[一首五律](/cn/2015/10/wind/)也有个“不”字，简直是提笔就是“不”和“无”的否定，真是个汗颜的模式。

这篇文章用五段样例文本总结了当时英语写作的四个毛病，其中第四个是使用无意义的词语。在他举的例子里，我很高兴看见了科学（science）一词，因为这正是我[前年提过的一个词](/cn/2017/08/political-correct-diversity/)：凡是标题或口号里带着科学字样的文章，我都会条件反射式地产生警觉，因为这个词实在是被用烂了，它的高度抽象使得它几乎没什么实际表意的用处。第三个毛病是矫饰的用词，这也是我以前在《[江阔云低断雁叫西风](/cn/2014/06/on-writing/)》中说过的。

在政治上，语言的模糊一方面有很强的传染性，大家互相模仿这种机械的文风（我感觉这跟中国人里的中英混杂传染有些类似），另一方面也是政治家有意用模糊的语言掩盖真相。我觉得下面这段是这篇文章里写得最好的一段：

> In our time, political speech and writing are largely the defence of the indefensible. Things like the continuance of British rule in India, the Russian purges and deportations, the dropping of the atom bombs on Japan, can indeed be defended, but only by arguments which are too brutal for most people to face, and which do not square with the professed aims of the political parties. Thus political language has to consist largely of euphemism, question-begging and sheer cloudy vagueness. Defenceless villages are bombarded from the air, the inhabitants driven out into the countryside, the cattle machine-gunned, the huts set on fire with incendiary bullets: this is called pacification. Millions of peasants are robbed of their farms and sent trudging along the roads with no more than they can carry: this is called _transfer of population_ or _rectification of frontiers_. People are imprisoned for years without trial, or shot in the back of the neck or sent to die of scurvy in Arctic lumber camps: this is called _elimination of unreliable elements_. Such phraseology is needed if one wants to name things without calling up mental pictures of them.

尤其最后一句：模糊的用语正是为了避免让民众脑中产生具体的意象。

奥威尔讲清晰语言的最大敌人是缺乏诚意。这一点我在《[脱不花的三盏灯](/cn/2018/11/tuo-bu-hua/)》中提过，在那里我举的例子是赞扬人：现在人们的赞语普遍苍白无力，我认为根本原因就是没有用心。而为什么我们不再用心赞？我觉得是社交媒体制造的点赞文化驯化了我们：不用费劲去想或打字，用手指头秒戳一下那个点赞按钮、或发送一个大拇指表情符就好啦；棒棒哒，么么哒，然后呢，没有然后啦。

从这篇文章里的正例、反例以及奥威尔自己的语言来看，他似乎最看重那种能直接勾起读者的画面想象的语言。如此看来，奥威尔跟那位整天点评“[如画](/cn/2015/09/memory/)”的金圣叹和青睐“不隔”之诗词的王国维若是泉下相逢，估计会像失散多年的兄弟，见面击掌痛饮三百杯。
