---
title: 影响力聚焦
date: '2019-03-01'
slug: influence-focus
---

两周前我在 GitHub 上看到一个开源项目叫 [Marp](https://github.com/yhatt/marp/)，大意是基于 Markdown 做幻灯片。在它的项目主页上，我注意到它的一幅屏幕录像动图，展示了它的实时预览功能。

![Marp 的实时预览功能](https://web.archive.org/web/20190824115121im_/https://yhatt.github.io/marp/images/marp-cast.gif)

当时我心里咯噔一下，心想这种一边敲 Markdown 源代码一边实时预览的功能搞不好在 [xaringan](https://github.com/yihui/xaringan) 中也可以实现。当时我还顾不上马上去实现，但在脑子里琢磨了一下需要哪些零部件。

- [x] 幻灯片页面与 R 之间可以通过 WebSocket 通信，所以我可以把 Markdown 源码发送到网页端；
- [ ] 网页端接收到 Markdown 源码之后能否转换为 HTML？
- [x] 通过 R 包 rstudioapi 可以获取 RStudio 编辑器的信息（比如当前行的位置），从而算出当前行对应幻灯片哪一页，以及当前页的完整 Markdown 源码；
- [x] 网页端通过 remark.js 的 API 可以获取当前幻灯片的页码或导航到特定页面；

第二个问题我稍作研究，发现有现成的办法。其实我就是在浏览器控制台里敲了一下 `remark.` 然后自动补全，发现有个 `remark.convert()` 方法可以将 Markdown 转化为 HTML。这样零件基本上都齐活了，就差拧螺丝了。

后来我不眠不休花了三天时间把螺丝拧了拧，基本上[组装好了](/en/2019/02/ultimate-inf-mr/)：

![究极无限月读](https://user-images.githubusercontent.com/163582/53144527-35f7a500-3562-11e9-862e-892d3fd7036d.gif)

这么一来，麻麻再也不用担心我做幻灯片时顾首不顾尾、顾尾不顾首了。在 RStudio 编辑器内移动光标时，幻灯片会自动跟随翻页。如果点击幻灯片页面之后再翻页，那么编辑器内的光标也会自动移动到相应的源代码的第一行上。在编辑器内敲 Markdown 源码时，不用保存文件，就可以边敲边在右边实时预览。

---

以上都是题外话。我要说的是一个我观察到无数遍的现象，就是多数人做事似乎都不太注意影响力建设，这一点恰好是本螺丝工的强项之一。而影响力建设不起来，一个非常常见的原因是不注意聚焦。我已经无数次感叹现如今想吸引人的注意力多么困难，因为吸引注意力的手段进化越来越快、越来越狠（算法驱动）。作为普通的肉身凡胎，我们剩下的为数不多的手段就是聚焦：让你的每一件工作、每一点精力都聚焦在同一个地方发光。比如写文字就只在同一个地方写（不要微博、公众号、豆瓣、微信读书书评到处跑）、开发软件就只在一个地方出没（[没必要](https://d.cosx.org/d/420471/13)注册 Gitlab 账号）、搭网站就只搭一个。如果不聚焦，你的精力和付出看起来就像没装灯罩的灯泡：就算灯丝再亮，房间里总体感觉仍然很暗。我几年前曾劝诫小楠君，不要买一大把域名在手里，而是只做一个域名，把自己每一个项目都变成同这个域名下面的一个文件夹。

这种发散现象太普遍了，我甚至怀疑人有这种本能。包括敝厂的网站，域名也是一大箩筐。当年上线 ShinyApps.io 我心里就觉得很不合适，因为这个域名看起来与 RStudio 毫无关系；我倾向于用 rstudio.com 的子域名，比如 apps.rstudio.com，这样可以同时公司品牌和 Shiny 应用品牌增加影响力。独立分开的结果是公司要费力解释这个域名并为它摇旗呐喊，这是我们的产品啊，啊啊啊；然后 ShinyApps 那边也要摇旗呐喊，我们出厂于 RStudio 啊，啊啊啊。其实有啥子必要喊嘛。同理，现在 rstudio.cloud 又是一个域名，叫 cloud.rstudio.com 多好。GitHub 账号也是，教育培训的团队专门新建了一个账号。厂子不大，厂房倒是各地建了一大堆，各自装修挂牌，白白错过规模效应。

这个话题跟 Marp 项目有啥关系呢？太有关系了。当我看到这个 GitHub 库时，它的页面上写着我们已经搬迁到另一个账号下，当前库已经废弃，不再维护。我抬头看了看星标数，接近八千，已经是极为成功、极有影响力的 GitHub 项目了。我估计我这辈子都到不了这个数。积攒了两年的影响力，就这么废弃掉、从头再来，实在可惜。其实 GitHub 项目是可以迁移的，迁移给别的个人或组织账号都可以，这样可以保留所有历史数据。从头再来的 Marp 新库过了一年时间，积攒了三百八十个星标。从八千到三百八，就问你惨不惨。

我老说我其实码力（代码能力）中等水平，很多人不信：你楞个儿有名，写代码的本事应该是杠杠的呀！嗨，根本不是这么回事儿。充其量我比较会拧螺丝，拧好之后把这些劳什子归置在一个地方而已。摆出来的劳什子多了，看起来也就厉害了。人来一看，嚯~\~哦！这也是你做的，那也是你做的。至于那劳什子究竟是个啥劳什子，多数人并不会关心，也没那闲心仔细一件件钻研。
