---
title: 渴望
date: '2018-12-19'
slug: craving
---

关于渴望这个话题，我想写它已经有一阵子了。这里的渴望没有毛阿敏的《[渴望](/cn/2018/09/traveller/)》那么高端，只是我成长过程中的一些幼稚的渴望罢了。我第一次明确想到这个话题是今年一月说[社交媒体制造的渴望](/cn/2018/01/craving-exploit/)时，而第一次隐约考虑这个话题则大概是[七年前](/cn/2011/05/i-hate-exams/)我说那本《金银岛》时了。我写这篇回忆杀，主要是想对比一下我自身现今和过去的渴望。我总感觉现今的渴望太廉价——这些渴望被人为、快速制造，随即又被人为、快速满足，比如点赞和网购。我从小到大渴望过的东西很多，而且多数最终都没被满足，或者至少是没被完全满足，但事后想来，这些无法满足的渴望可能也正是尘世生活的一部分意义。稻盛和夫在《干法》中引用他父母小时候的教导说：年轻时的苦难，出钱也该买。年幼的稻盛和夫无法理解这句话，说把苦难卖了还来不及呢；我想过不了多久，世上应该也不剩多少人能理解它了。叔本华那个痛苦和倦怠之间的钟摆，可能最终会停在倦怠那一端。

## 童话书

我的童年几乎没看过什么童话书，唯一一次有印象的是在表哥家看到一本，被那奇幻的世界震撼到，它吸引我的程度远高于糖果。我在他家没能一口气看完，于是央求他们让我带回家接着看。童年最深刻的精神生活莫过于想象。实在无书可看，只好找高年级的语文书看。我还记得我在大伯家看姐姐的五年级语文课本，里面有《渔夫和金鱼》的故事，边看边脑补那节节变化的大海。虽然我上大学之前都没见过大海，但这想象中的大海也留给我深刻的印象。说到《渔夫与金鱼》，其实多数人生道理真的是早在幼儿园和小学已经学完了；另一个对我影响深刻的故事是《小马过河》，哪怕在我成年后，我也无数次想起这个故事。

后来上了大学，书的匮乏问题一下子解决了：学校的图书馆、海淀图书城、北大校园里的地摊（人大当时没有这个传统）、以及学校周边各种小书店。这书山书海实在令人狂喜。小时候对童话书的渴望并未消失，于是大一的时候我就买了本《格林童话》补课。结果是显然的，那渴望已经过期，不过童话里的道理永远都不会过期。

## 武侠书

待我识字多一些之后，在大伯家捡到一本武侠书，看得如痴如醉。那书没头没尾，我也不知道书名是什么，但里面的故事也让我想象出另一个奇幻的世界，并且还痴心妄想能练就里面诸如铁砂掌、轻功之类的功夫。我还记得有一次验证我的铁砂（脚）掌练到什么程度，从一个水泥台子上跳下来，结果地上一粒小石子儿硌得我抱着脚跳。看武侠对童年的主要影响就是整天棍棒不离手；要不是我学习成绩还不错，搞不好现在成一名撑杆跳运动员了，因为整天杵根棍子到处蹦跶。当时为了找一根笔直的棍子，还把人家新种的杉树苗给偷偷砍了一根。这便是为什么我看[江堂的童年故事](http://jiangtanghu.com/cn/2017/04/10/daddy-story/)时深有共鸣的原因。

我真正看武侠小说已经是出国念洋博士的[第四年](/cn/2012/08/quo-vadis/)，主要是因为中奖得了个 Kindle，然后下载了一堆 PDF，把武侠看个饱，其实也只看了金庸的。初中高中也在别人家捡到过武侠书，但数量也是屈指可数。

## 故事书

与童话书和武侠书相比，故事书没有到匮乏的程度，因为故事篇幅小一些，可以看到的媒介多一些，比如每过一阵子大概可以从别人家找一本新的故事会来看。记得故事会的最后一篇通常是长篇，那些故事我后来基本都忘光了，只有一篇关于用摔坏的手表推断杀人时间的故事略有印象（这似乎不适合小学生看）。七年前我提过那本《金银岛》是我小学时一个夏天跟在一个收旧书的大爷的自行车后面偷偷从他车筐里窃出来的，那是我人生中看过的第一本外国小说。过了这些年，我再找来电子书看了一遍，那种寻宝的神秘感和与敌方交战的紧张感已经消失了大半。

另一个故事来源是我姑父家的报纸，这也给他们留下了一个顽固的印象，就是我去他们家第一件事总是先从柜子里把最近的所有报纸翻出来一张张看。其实我最爱看、最先看的是幽默版块，也就是看笑话，报纸上多数内容对小孩来说都是极其枯燥的，那时候的媒体还没有吸引眼球的概念。

上初一的时候我寄宿在镇上的一位叔父家，我们那里的叫法叫幺爹（其实爹的兄弟都叫爹，比如大伯叫大爹）。极其幸运的是，幺爹是小学语文老师，所以家里有一样绝世宝藏：就是语文教辅。说是宝藏，其实我初一那一年一共也就在他家找到两本。一本讲古代文人的轶事，我看得津津有味，但看完一遍之后就再也没见到那本书；还有一本没什么故事，大概是写教学方面的东西，偏偏是这本没意思的书一直在家，有意思的那本却消失了。

## 蚕宝宝

大约四五年级起，班里开始流行养蚕。最初的蚕卵不知道是谁弄来的，总之后来就变成了开春上课时，同学们每个人胳肢窝里悄悄夹着一团棉花，棉花上放着一些蚕卵。我们就是用这种办法靠体温孵出幼蚕的。刚孵出来的蚕是黑色的，芝麻点大，一口气就能吹不见，养到后面蜕几次皮了就越来越白白胖胖。

我后来成了养蚕大户（几百条的规模），主要原因是我很幸运：我家后面正好有一棵小桑树，我带着桑叶去学校跟别的同学换了不少蚕卵和幼蚕。持续养东西会让人成瘾，因为它很容易带来成就感，不管是养大小动物还是种植物。我觉得这一点最好的体现就是养娃，当然种菜也是一个很好的例子。当你看着一个生命一点点长大时，就会跟它建立越来越强的连接，也就是火影中说的羁绊。我小学三年级的时候用一个矿泉水瓶子装了些沙子，里面放颗花生，放教室后面每天浇浇水，后来那颗花生真长大了。这是我对种东西最早的记忆。后来我捡到一个破葫芦，在后院种了一颗籽，到夏天那棵葫芦就顺着花椒树长得铺天盖地，一个夏天吃了不少美味的葫芦炖腊肉。

养蚕的一大乐趣是听它们吃桑叶：是听，不是看。一纸箱子的蚕一起吃桑叶时，那咔哧咔哧的声音让旁听者觉得很满足，会盼着它们快吃快长大。蚕吃了桑叶会拉黑色的小颗粒屎，那时候的我也算是一位铲屎官，每天把一条条蚕从一个盒子挪到另一个盒子，好把屎倒掉。我第一年养蚕比较成功，后来它们都吐丝、结了白色和金色的茧子把自己包起来，最后变成蛾子、咬破茧子出来交配产卵、死掉，第二年我就有了大把的蚕卵。第二年养蚕时发生了一次不幸的事故：我怜悯蚕在室内太冷，于是把箱子搬到后院让它们晒晒太阳。等我从外面玩回家时，箱子里白白胖胖的蚕宝宝一条不剩，都被鸡吃了。我被自己生生蠢哭了，咋忘了鸡这个天敌的存在！其实类似的事情还发生过一次。一日我爬树掏鸟窝，掏得几只刚孵出来的小鸟，看着仿佛小鸡仔一样。我欣喜地捧回家准备养着，仍然是等我从外面玩回家发现小鸟不见了，地上只剩几根鸟毛；后来我强烈疑心是被邻居家的猫偷吃了。就像辛辛苦苦种的白菜被猪拱了，也便造成了我儿时对养蚕的遗憾和渴望。

再后来，不知为何大家又不养蚕了。我没了蚕卵，便开始异想天开，随便抓一些普通蛾子关在盒子里，想让它们产出蚕卵来，或是到桑树上仔细找找，看能否找到疑似蚕卵的东西，甚至想抓条毛毛虫回去养，看能否变成蚕。这事自然是以失败告终。上初中后一周才回家一次，没了养蚕的条件，因为没法每天去喂，所以养蚕的梦想也就结束了。

养蚕之事过了多年，我到美国之后又想了起来，心中依旧念念不忘，但不知道哪里有桑树，心想要是能找到桑树，也许下次回国可以偷渡几粒蚕卵过来重操旧业。今年夏天我在家附近的小公园遛娃时，终于第一次在美国见到了一棵桑树，上面已经结了很多桑葚了。可能是我以前眼拙，我本来也是动植物盲，也许桑树很常见，但我没留意到过。不知在美帝本土能否搞到蚕卵，毕竟偷渡有风险。

## 电视机

和我的同龄人一样，我小时候有极大的电视瘾（同时要时刻提防大人回家被发现），主要是爱看动画片和武侠片。小学期间一直只能在别人家蹭电视看，直到快上初中了家里才有了电视机。因为蹭电视无法保证连续性，所以有些片子缺头、缺尾或隔三差五缺一集。更夸张的是有些动画片我是纯粹只能靠别的同学讲来听，比如我对圣斗士星矢的了解全来自于同学的口述评书（我还记得一次上学路上走到学校外墙了，一个高年级同学讲到舜被石化的场景），这片子直到我上大学了才看到它真正的面貌。动画片中我最喜欢看铠甲打斗类的，比如《魔神英雄坛》和《魔神坛斗士》，这时候我已经可以在自家看了，但还是会碰上停电。后来还有一部《天空战记》有些类似，但我只在别人家看过一两集，只记住了里面有个修罗王一平，还有若干其它不知名的王，总之念念不忘，也是等到上大学后才补上。非打斗类其实我也喜欢看，现在印象还比较深刻的是一部《大狗副警长》，我每天晚上蹲在我叔家和堂弟一起看。

作为一个情商和理解能力发育迟缓的小朋友，我至今记得有一次在邻居同学家看《聪明的一休》时，看着看着他突然说马上就要结束了。我当时很惊讶，心想你怎么知道这一集要播完了呢，现在只不过是一休和尚看着一群乌鸦飞向远方的落日而已。长大之后回想，这种乌鸦飞向落日的画面确实通常意味着结束，不过以我当时的脑子，是无论如何都无法把这两件事联系起来的，也不知道故事情节到哪里算是接近尾声了。

武侠片看了一箩筐，印象最深的还是《九阴真经》，我已经[提过几次了](/cn/2017/02/nakasendo/)。这部片子我是某个暑假在二舅家看的，最后黄药师和欧阳锋三场决斗的场景深深印在了我脑子里，因为当时实在是太担心黄药师打不过欧阳锋。这片子长大之后重看仍然觉得很经典，只不过欣赏的角度跟小时候很不一样了。以前[我还提过](/cn/2014/12/the-gadfly/)《莲花争霸》，这部剧播到最后一集时，我家电视不幸坏了，只有声音没有图像，所以大结局我是从变身收音机的电视机上听来的。大一时，我在宿舍走廊上听到隔壁宿舍有人在放《莲花争霸》的主题曲《江湖路》，心想原来这片子在湖南也播过（进去看见是班上一位湖南小哥在放音乐）。至今我车里还有这首歌。小学六年级时还播过一部《仙鹤神针》，剧情我忘光了，只记得大结局大概是正派主角用一片炸了很多洞的树叶对着一本秘笈，终于发现了秘笈的读法原来是每隔几个字连起来读（这加密办法也太低端了），于是瞬间学会了神功。现如今我车里也仍然有叶丽仪唱的这部剧的主题曲。还有一部剧叫《小侠龙旋风》，我在我那个[最要好的小伙伴](/cn/2018/11/fermented-tofu/)家看过一集，觉得很奇幻，符合我的胃口，后来不知道是什么原因没有接着看。前几个月[列弛说金丝大环包](/cn/2018/08/serious-japanese/#comment-4101379223)的时候我一看就知道，这也是看过《白眉大侠》的主儿。有一阵子播陆小凤，也是碰上我家电视坏了，我爹叫了人来修，我仍然守在电视机前，看那荧屏画面随着维修工的捣鼓时有时无，每当画面从清晰转向麻点时，我都急得直喊哎哎哎你不要再动电视了。

无论是动画片还是武侠片，满足的都是想象力，或许还有一些英雄正义感（比如《包青天》，但这剧中铡刀铡下满地滚的头经常吓得我接下来几天都有心理阴影）。现实世界中我杵根棍子、用吃奶的力气也蹦不了一米高，所以那个虚拟的飞檐走壁世界才格外吸引人。动画片和武侠剧我大概还知道是假的，但当年还播了一部神剧叫《排球女将》，这对小学生来说就有些难辨真假了；主角小鹿纯子那跳起几米高的必杀技让我们无比羡慕和崇拜，我被这片子吸引得入了迷，在我叔家看完回来后还要捡个玉米棒子苦练旋转日月和晴空霹雳的招数。神话类的电视剧自然也能满足想象力，这里面对我这代人影响最深的可能不是《西游记》就是《新白娘子传奇》。小学时的我偶尔一次在别人不知是初中还是高中的语文课本上读到《论雷峰塔的倒掉》时，心里还激动了半天，因为那里面提到了白娘子，于是翻来覆去看了几遍，看是否有更多关于白娘子的消息，然而并没有，怪鲁迅惜字如金，我只知道螃蟹里面可能有法海，但我捉到过的螃蟹里也并没有见到他说的法海。我的一位高中同学上大学之后学会了制作多媒体，第一件作品便是一套儿时女神白素贞专辑，谈起这个都能看见他眼中摇曳的小火苗。我小时候有一次对面山上有人家用大喇叭放《千年等一回》，听得我心潮澎湃；在村里能听见一次放歌的机会实在太少，就更不必说放《千年等一回》了（现在这也是我车里的曲目之一）。上初中时，有一次去远处走亲戚，他家正放着《封神榜》，我也就那天看了一集，以后再也没在别的地方看到过，我们自家的电视没有那个台。

小时候的这些着迷和如今让我们着迷的事物对比起来，有两个显著的区别。一是小时候的迷恋是有尽头的：剧播完了，也就完了。二是无论你如何着迷和渴望，你都无法对抗一些物理条件，比如停电或电视坏掉，一天只有一集，错过就错过了。如今的剧，最大的特点就是可以无限看；优酷土豆爱奇艺油管子，任何一家视频网站，只要你打开，你就可以娱乐至死，没有数量限制，没有频率限制，没有电源限制，没有硬件限制。还有一个可能因人而异的区别，就是我小时候的迷恋会影响我的物理生活，比如我会自制飞刀或打狗棒，或爬树、上房（我能活到今天也算是个奇迹）。如今这个世界制造的迷恋和渴望更像是一种精神鸦片，它只会束缚我们的脑子，甚至对我们的物理生活有害，比如因为一部剧可以一口气看完而不必苦等，所以我们很容易通宵看完它。我们渴望更高品质的衣食住行，但《渔夫和金鱼》的故事早告诫我们，这种渴望不会有好下场。

弗洛伊德在《文明及其缺憾》中提到一种廉价的幸福，是那种在寒冷的夜晚把脚伸出被窝冻一会儿再缩回来的幸福。如果我们现在想重现小时候的幸福感，可能唯一的途径就是这种缩被窝的方式了。且不谈这种方式多幼稚，就连我们是否还有能力把脚伸出温暖的被窝都是个问题，因为如今的被窝实在太温暖。

## 西红柿

吃的方面我曾经有很多渴望，先从西红柿说起。我家菜园里通常是夏天一园子青椒，冬天一园子萝卜白菜。小时候我很羡慕别人家夏天种西红柿，也不知为什么我家不种（后来想想应该是大人实在顾不上，而且青椒种了可以卖，西红柿则不然）。因为常年吃青椒萝卜白菜，我觉得西红柿都是人间美味。

如今在美帝自个儿种过西红柿之后，才又一次觉得西红柿是人间美味；这次不是因为稀缺，而是超市里买的西红柿通常确实没有西红柿味。自己在土里种出来的西红柿，吃在我嘴里有一股味精的味道。小时候因为没什么零食可吃，我有时候都会倒几粒味精在手心舔舔，也曾从花椒树上摘几粒青花椒，直接生嚼，麻得相当过瘾，坐在屋外台阶上低头看嘴里被麻得哗哗下流的口水。

## 方便面

农村人一天三顿并没有什么区别，早中晚都是大米饭就菜，不像城里人，早饭是一顿特殊的饭（多为面食）。我小时候有些同学的家长不愿大清早起来做饭，就给孩子买几箱方便面（我们当时叫快餐面），早上起来泡个面了事。我很羡慕有方便面吃的同学。当时有两种味道的方便面：麻辣和鸡汁。大家会攒下一些调料包，放学路上把那些粉末倒手里舔着吃。我其实也吃过一段时间的泡面，所以也吃过调料包。那麻辣味道的调料确实是又麻又辣，有时候我嫌干吃太辣，就从水缸里舀一瓢冷水，把调料包冲着喝，也很解馋。这种对方便面的馋从小学延续到了初中。上初中时，住校的学生是两个人睡一张床，我同铺每天晚上都会拿一包方便面在床上摸着黑干嚼，有时候也分我一块。前不久[我提过](/cn/2018/10/middle-school-teachers/)我初中班上有两个小混混头目，他就是其中之一，不过他跟我关系倒是不错，不知他如今身在何方。到了高中，我吃泡面便纯粹是为了省钱，也是在这三年里我彻底吃够了泡面，后来再也不想吃了。

## 青桔子

再说水果。小时候上街赶集（我们方言叫赶场），闻着街上的苹果香蕉味馋得不行，但几乎没机会吃到。我唯一还有印象的是有一次我爹赶集买了四个苹果带回来放桌上，等他再出门回来时，这四个苹果已经在我和我弟肚中。他当时假装批评了我们。过年时有些亲戚家会买甘蔗，这货让人又爱又恨，因为它很甜，但吃起来实在费牙，这也是[江堂提过的](http://jiangtanghu.com/cn/2017/04/10/daddy-story/)；我啃得牙龈出血是常有的事。一年中毕竟过年也就那么几天，剩下的日子里几乎不会有机会啃甘蔗，一个解馋的办法是啃玉米杆，那里面的芯也有轻微的甜味。

村里自产的水果基本只有一样，就是桔子。柑桔和稻谷是我们那里主要的农作物。我对桔子的渴望有两个时间段：一是早熟的桔子刚刚能有几个可吃的时候，那时我爹上山劳作回家会剪两个青皮桔子带回来，虽然还有些酸苦味，但对熬了大半年的我来说已经是上等美味；二是过年过后剩下的黄桔子：每年每家卖完桔子之后会留一些放在干稻草里储存，到过年时拿出来招待客人，青桔子从秋天放到冬天皮会变黄，瓤也会变甜，过年过后好吃的都吃完了，只剩下桔子，由于天气仍然很冷，所以桔子都冰冰的，于是我也喜欢吃又冰又甜的桔子。有时候我弟给我剥个桔子，我都会嫌他的手把桔子瓤捂热了而去草堆里扒一个出来重新自己剥。如今在美帝吃不到刚成熟的青桔子，只能买到熟透的黄桔子，这种情况下只有放冰箱里刚拿出来的桔子才能让我吃出回忆的味道。

最近这几个月我哄娃睡觉的音频是梁冬和吴伯凡的《冬吴同学会》，我总觉得这位我以前没听说过的吴伯凡同学像是我的一位知音，他讲的很多农村往事都让我很有共鸣。有一期他提到小时候剥桔子时桔皮上的油会滋到眼睛里，这正是我吃桔子印象最深的生活体验之一。在我小学上学路上，我经常带着一个桔子在路上剥，一路走一路把皮扔到池塘里，看那桔皮的油在水面像放烟花一样爆炸、散开、五彩斑斓。

## 偷柚子

人穷的一个结果是总盼着捡便宜。一笔意外之财通常能带来无比的满足感。比如我有个同学曾经捡了五块钱，立刻去买了根两毛钱的雪糕吃，可把我眼红坏了，因为五分钱的冰棍对我都是奢侈品。我小时候最大的一笔意外之财是有一次在一个池塘边的草垛里找到十几个鸡蛋（里面好像还有鸭蛋），来回跑了好几次终于把它们都搬回了家。有些鸡鸭不愿意把蛋生在鸡窝里，于是找一个草垛藏里面下蛋，不想被我无意发现了。打那以后，我就经常在各家各户屋外的草垛里扒拉，也曾零星找到过几个蛋，没再有过那么辉煌的成绩和狂喜。

实在没便宜可捡的时候，我们的口号是创造便宜也要捡，也就是去偷鸡摸狗。当时有个大爷种了一片柚子树，树林就在我那最好的朋友家门前。等到柚子成熟时，大爷会时不时进树林巡查一番。有时候要是我们俩正在作案，就赶紧爬到树上躲着他，大爷在下面用眼睛扫扫没人也就走了。有时候大爷意识到有人偷过，也会对着空气破口大骂。这时的我对柚子是一种紧张而刺激的渴望。

我也曾觊觎过别人种的梨和桃，但这些树不如柚子树大、种得又稀疏，作案环境不好，容易被人看见，所以没敢下手。

当然，作案也不能太频繁和猖狂。一种正常的、不会挨骂的捡便宜方式是在果农收完果实之后去找人家摘剩的，比如桔子。这也是很有趣的活动，主要是剩的肯定不会多，得仔细一棵棵树去找。虽然桔子本身不是什么稀罕物，但这种人为制造出来的稀缺条件会让我产生一种渴望：爬了二十棵树之后终于找到一个别人没注意到的桔子，也是让人很欣喜的。

## 红薯干

夏天很多人家都会晒红薯干，我们管红薯叫苕，而红薯干则叫苕米子。我家也晒，但晒完通常就不炒了，或者是用沙子炒，炒出来没那么香脆。有同学家是用油炸，上面还会沾上芝麻，香脆无比，令我羡慕得不行。红薯干要是晒完不炒或炸的话，会极其耐嚼；一条高韧度的红薯干放嘴里不知要通过多少口水才能磨烂。我的牙口至今还算不错，可能跟小时候啃这些东西有关（我直到上初中才第一次刷牙，而且只刷早上那顿，这种事放今天简直不敢想，若按现代人被灌输的牙齿保护恐惧来推测，我的牙早该掉光了）。

几个月前我翻菜谱翻到了红薯干，发现不过就是把红薯切条、放盘子里蒙上保鲜膜、用微波炉转四五分钟转到熟，然后拿出来放架子上晾干。我见如此简单，便做了一些，成功复制出了那嚼不烂的红薯干（晾干时间越长越难嚼），然后也拿炸锅炸了一些，差不多也算是小时候的味道了，但只是空有酥，没有香，我也懒得捣鼓芝麻版本了。红薯干的渴望，是没有对比就没有伤害的那种，即：如果我没见过别人吃油炸的红薯干，我应该也不会心生这种渴望。

## 吃面食

南方人以米饭为主食，我前面说过我们一天三顿都一样，早上也吃米饭，所以面食就是个稀罕物。小卖部的面包、村里唯一一个早点店的包子、骑自行车的小贩的馒头，全都是勾魂的东西，但不到非常时刻通常很难吃到。我记得有一次我病得厉害，我爹带我在村里卫生院打完针出来，就在旁边早点店给我买了两个包子，作为对病号的特殊照顾。小学五年级时，我们数学老师的老婆在学校做过一阵包子，好些同学大清早都去买她的包子当早饭。我也是早上从爹手里领几毛钱，高高兴兴去学校，在那红火的灶台前买两个包子。当时吃包子的同学有一项特权，就是可以在教室外面把包子吃完了再进去上早自习，这样能少读十来分钟书。

家里也不是绝对不做面食，只是机会太少。我记得我奶奶会用面糊裹着花椒叶子放锅里油炸，炸出来有花椒叶的特殊香味，那味道我大致还记得，但后来再也没吃过。春天里大约在天气转暖的时候，他们会做毛裹团子，吃起来像包子，不过是糯米面。

那年头有些流动小贩会在各村卖东西，我印象很深的一类小贩我们叫他们货郎子（我们方言里喜欢在名词和代词后面加个子），因为那些货郎总是挑着两大筐稀奇古怪的小玩具，勾人心魄，但大人总是叫他们走开。还有一类小贩是卖吃的，其中有卖馒头的，骑着自行车一路吆喝：卖……馒……坨（方言）……后来我再也没吃过那么香甜的馒头。大人们为了阻止我们吃，会编各种谎话骗我们，我记得最清楚的一大谎言就是，他们总说那些馒头是别人用屁股坐出来的。这种骗小孩的话还是有些管用的，因为我们看着馒头的形状，确实会联想到屁股。

上初中去了镇上，早餐就完全变成了面食，主要是包子，也有花卷。我每天最盼望的就是吃早饭。早读结束的铃一响便以百米冲刺的速度冲向学校的包子铺。初一有一天早上我冲得太快，在一个坡上把别人班上一位路过的女同学撞到了坡下，她摔得不轻，后来还被送去了医务室，然而我头都没回。第一节课上课前，他们班的班主任带着她挨个班上指认嫌犯，本来她并没有记住我，但我们班上一个多嘴的男生立刻把我卖了。当时我一边怨恨这个男生，一边害怕得要死，因为我不知道我该赔多少医药费、以及如何向我爹汇报这件事。上高中之后我禀性难移，哪怕教室在五楼，也一样能在吃早饭大赛中跑出全校前几名。有一次连鞋都跑飞出去一只，偏偏又被一个我很不喜欢的男生看见、回去飞着唾沫星子在班里讲述了一番。上了大学终于不用猛奔，因为不用抢、也没再饿得眼冒金星了，不过也蘸着老干妈吃馒头作为晚饭吃了两年，依然觉得很好吃。

## 吃冰棍

说完吃的再说说喝的。今年四月我[提过当时渴望的冰棍](/cn/2018/04/san-jiu/)，最初也是由小贩骑自行车在各村叫卖。那个车后座放冰棍的泡沫箱子可能是我人生中最早的科学之谜：为什么这么热的天里要把冰棍捂在棉被里？

夏天我们身边唯一的冷源就是井水。我是喝生井水长大的，家里极少烧水喝（其实连开水壶都没有）。夏天从深井里打一桶水上来之后我就直接把头伸到桶里喝个饱，凉气沉丹田。有时候当天的饭菜若有剩（尤其是招待过客人之后），晚上就把菜盘放水桶里，然后把水桶吊在井里，也就是把水井当冰箱用。

除了冰棍，我也期待饮料，比如那种细长、分两节的塑料包装的橘子水。用牙在袋子头上咬个小洞，慢慢吮吸，享受香甜的色素水。喝完之后把袋子放地上，用脚从袋口踩踩平，最后猛踩袋身，经常就是一声巨响，但那包装袋挺厚的，有时候也未必能踩爆。

写到这里我想起一种叫麦饭石的饮料，它在我们小时候很流行，但我们长大后它就消失了，于是我放狗搜了一下，不想豆瓣上有个帖子，[炸出来一大片宜昌人](https://www.douban.com/group/topic/11240862/)。看来不只是我一个人还在心里念叨。

## 罐头瓶

小学时每天中午都回家吃饭，吃完饭再回学校睡午觉。大家一般会带一瓶水或凉茶去学校，那时我会羡慕别人装水的罐头瓶，因为我家没有那种高级的瓶子，有的只是一堆酒瓶，所以我就用空酒瓶灌一瓶白水带去。我也羡慕别人有茶可以喝，因为那被炎热的空气烤热的井水实在是不好喝。

上高中时同学们也是人手一个罐头瓶，课间去接水喝。高一班里有个细心的同学注意到我没有杯子，于是有一次回家专门给我带了一个。后来我读到曾国藩的[一副挽联](http://www.wcai.net/couplet/fuxiaosong/001.htm)，开头是一饭尚铭恩，我心想我也曾有过一瓶铭恩的往事。我记得他有个特别的个人兴趣，就是非常爱看军事方面的东西；有一次晚会他讲了一个军事故事，留下一个谜题（陷入沼泽的坦克被敌军包围如何逃生），见没人能答得上来，便点名让我猜答案，但我哪能知道答案。<!-- 这个同学叫陈晓波。 -->

这种细心的同学还有一些。比如高三我同桌到周末就会请我吃顿大餐；高二我在为难要不要问爹要几百块钱去参加化学竞赛培训时（就是我在《[土人](/cn/2018/09/countryman/)》里说的那个培训），有个同学在一边看在心里，回宿舍拿了五十块钱悄悄塞给了我，然而伊的家境也并不好。<!-- 前一个同学叫王怡，后一个叫曾艳。 -->

## 乒乓球

我对乒乓球的兴趣直到上研究生之后才开始淡化。小学时没什么像样的体育运动，乒乓球是最方便的。学校有个坑坑洼洼的土篮球场和一个破篮筐，课间打篮球时我在一群孩子中跑半天也摸不到一回球。除此之外就只有四个水泥砌的乒乓球台，我们默认把它们分配给了三四五六年级，每个年级一个台子。台子中间没有专门的球网，我们就摆上一列砖头作网。每天中午以及傍晚放学之后都有一大群小孩在那里打乒乓球，因为资源有限，所以要排队。一般是三个人打，一个人站一头作大王，拥有三分，另外两人站另一边，分别是二王（两分）和三王（一分），谁的分先丢完谁就走人，如果前面的王下场了，后面的就依次升一级。我那时球技一般，有时候我们的语文老师会和我们打，他的球特别转，我们基本上一接就死。班里还有另一个同学也能拉出弧圈球，让我很羡慕。

到了放假期间，学校不开门、我们在家又渴望打球的时候，便会拉两张大方桌拼一个球桌，虽然桌子通常不够长，但也够过过球瘾了。即使是这样的条件，在我家也没有，因为我家都找不出两张大桌，所以也只能在别人家打。没有球桌的时候就只能对墙打，不过其实连房子的墙都不平整。

我人生第一个乒乓球是我奶奶从她手绢里掏出一两毛钱给我去小卖部买的。我跑去买回来后，我堂弟也吵着要，于是我又拿着钱去再买了一个回来。家里没有球拍，我爷爷就找来一把不用的木锨，用那上面的木板锯了一个木球拍。因为木锨是弧形的，所以那球拍也是弯的。在有这么一把木球拍之前，我都是用瓦片打球的，所以装备上已经算是很有进步了。说起我奶奶，我又想起有一阵我们几个小孙子很想要粉笔，她便给我几毛钱让我去小卖部看看有没有卖粉笔的，我跑去之后人家说没有，失望而归。上小学时我们胆子不够大，不敢拿老师的粉笔，后来我上初中之后心想怎么那时那么胆小，于是有时候周末放假会揣一包粉笔回家在墙上地上写写画画。

初中校园里只有两张水泥球桌，更不够打。男生普遍爱打乒乓球，有时候午休时间还会偷偷跑去打。有一次隔壁班几个男生去打球被他们班主任抓到（就是[之前曾提到过的](/cn/2018/10/middle-school-teachers/)杨少明老师），后来被罚吃乒乓球拍，他们真的是把球拍咬碎了，但应该是没吃完。

我上高中之后，学校里的乒乓球桌总算多了，虽然依旧是水泥桌。我只记得有一次我和一个同学午休时冒险偷偷跑去打了个饱。高中学业重一些，没那么多时间了，兴趣也减弱了一些。确切说是运动方面的更多兴趣转移到了篮球，但我这身板根本不是打篮球的料，大家一起玩时，我仍然摸不到几次球，所以我更喜欢一个人抱着宿舍另一个同学的球去球场上扔，或是就在宿舍里猛拍。我就是在宿舍自己拍球时学会转身运球和胯下运球的，那跟学转球一样纯粹是为了好玩，没什么实战价值。因为我自己没有球，每次只能等别人不打的时候才能拿来玩玩，所以我当时对篮球也有强烈的渴望。我对篮球的兴趣，上大学之后就消失了，但后来到了美帝[又曾燃起过一阵](/cn/2011/07/exams-done/)，再后来找到了我人生的真爱，也就是羽毛球，对其它球类运动的兴趣也就都烟消云散了。

我从小就对有弹力的球充满渴望。比如邻居一个同学有一次不知从哪里搞来一个有一圈圈彩色纹路的皮球，在家拍个不停，我看着就很羡慕，求过来拍一会儿还没过到瘾就得还给主人玩。还有一次另一个小孩搞来一个小弹力球，扔地上可以弹老高，我觉得简直太神奇和好玩了，于是小伙伴们分别站在高高的草垛两边，把球从上面扔过来扔过去。

如今在美帝，我两岁的娃一次去看完牙医，牙医叔叔就奖励给他一个弹力球，一个老子渴望了特么一整个童年的弹力球。搬家后有一次我给人回答了一堆 LaTeX 问题，作为报答，他送了我一张乒乓球桌。两年多来，我总共大概在这球桌上就打过四次球。

## 玩具枪

男孩子小时候都喜欢枪，尤其是火炮枪（一丁点火药，打了也就是冒个烟而已），我从来没有过自己的玩具枪。我爷爷曾经教我用一节竹筒做过一种简易枪，就是竹筒前面挖两个相对的孔通过竹节，上面的那个孔再继续向前开出一道槽，后面靠近竹节处挖一个小孔，然后用一片弹性好的篾片，一头插在后面的孔里，扳弯篾片后另一头插在前面贯穿的孔里，稍微穿过那个孔一点点。竹筒的前端是开口的，后端有竹节封闭。这样插好篾片之后，把一粒小石子从枪口放进来，挡在篾片上，按一下扳机，也就是那篾片，把篾片从孔里顶上枪膛，这样篾片就会向前把石子弹出去。这枪基本上毫无威力，作为玩具只能说聊胜于无了。

后来他又教我做了另一种叫哨子枪的枪，也是用竹筒，只不过是用空气压缩原理，而不是篾片弹力。这哨子枪就是一节两端都开口的细竹筒，前端开口之后的竹子不要了，后端开口时，要在离竹节大约三五厘米的地方割开，然后把一根筷子插在这个竹节里。如果插不牢的话，就在筷子根部缠一些纸之后再插进去。玩法是在竹筒的两端各塞一团浸了水的纸（要压紧），然后用筷子顶好一端的纸团，用手掌猛拍竹节，用压缩的空气把另一端的纸团打出去。这枪比前面那种枪好玩一些，主要是因为它会砰地一声响，而且越用力拍越响，因为有少许水的缘故，打出去之后还会冒一丝水雾，很有枪味。做这种枪我不知浪费了多少根筷子。后来我嫌塞纸团、捡纸团麻烦，就演变为只塞一团纸，然后把枪往田里或湿地里一插，拔起来就会有一团泥塞在枪头，用这团泥作子弹，打起来就方便多了。

村里有大孩子会用自行车的链条做链条枪，这是我人生中的未解之谜之一，我从没弄明白过链条是如何做成枪的，而且还可以上火药，真的可以打响。这种枪可望不可及。我小时候唯一一次摸玩具枪是我表哥得了一把打塑料小子弹的玩具枪，我实在很想玩，又赶上他正好不在家，我从他家回自己家时便未经允许就拿回去了；玩了一阵放在屋里靠近窗口的地方出去玩别的，等我再回家时枪不见了。我从未弄清楚是谁偷走了那把枪，但心里充满愧疚，毕竟是没跟人说就拿走了、拿走又弄丢了。

## 弹山雀

这小标题有点异类，它来自我最近随机听到的一首歌，叫《[盗将行](http://music.163.com/#/m/song?id=574566207)》。它的歌词总体而言让我觉得有些奇怪，里面有句叫取腰间明珠弹山雀。我在想写一写弹弓的时候想起这句词了，于是用了这么个标题。

枪的愿望难以满足，主要是没有威力的武器对小男孩来说玩起来不过瘾。弹弓算是一种既有一定威力又方便自制的玩具。因为它有危险性，所以小学老师都禁止我们玩，但这无法阻止我们在家偷偷玩。最初我没有强力的皮筋，只能用扎头发的小皮筋连一串起来做弹弓，但显然威力不够大。后来好不容易找到了皮筋，绑树杈上做了个弹弓，提着到处找鸟打，但鸟通常都有很高的警觉性，发现有人瞄准它就会飞。唯有一次在我家后面的一丛竹子里我打到过一只喜鹊，打到的主要原因是它在竹丛里被我吓得惊慌失措、想飞出去却被竹子到处挡住。真正打下来一只鸟之后我又觉得它很可怜，后来再也不弹鸟了，改作无害的打靶。

## 刀剑棍

拜武侠剧所赐，我喜欢舞刀弄棍。在我大约六七岁或七八岁时，爹赶集回来给我带了一把塑料剑，这是我有印象的小时候他曾给我买的两个玩具之一。我高高兴兴玩了几天之后，觉得这剑不够锋利，于是拿着菜刀想把剑尖再削尖一些。一把破塑料剑，怎么能削得锋利嘛。

大一些之后，我曾找到一把破伞，伞骨上有一些连接伞布和伞把的细铁片，我便拆下一根来，把它在磨刀石上仔细着磨尖，然后对着一块破门板练飞刀。这飞刀的问题就是前后一样重，所以无法确保刀头能飞向前、插在门板上，能不能插上基本靠蒙。

有一年暑假在我舅家玩时，一个哥哥带着我们走了很远去铁路边玩。在那里我学会了一样技能，就是用火车轧铁钉。把铁钉放在铁轨上，火车开过去之后就会把它轧扁。拿回家再在磨刀石上磨一磨，就做成一把小刀了，可以用来削铅笔。我小学时期没有像样的文具，包括铅笔刀，铅笔基本都是用菜刀削的。

## 红色笔

在学校我常常羡慕的是别人的文具，比如我几乎从没用过的双肩书包、文具盒，以及橡皮、尺子等等。有时候写错了字没橡皮，就吐点口水抹抹，抹得作业本上一团黑；需要用尺子的时候就找块硬纸板。然而有些文具实在没有替代品，比如红笔。我连普通的笔都是用纸裹的一根圆珠笔芯，还时常不好写。那时数学老师经常叫我们同桌交换答卷，他念答案，我们互相批卷子。偏偏他又特意强调一定要用红笔，最好是红墨水笔。每当这个时候，我都很窘迫，只能在每一道题同桌改完之后赶快借笔改一下再还给人家。

还有两个很难替代的文具是量角器和圆规。上初中之后由于考试的时候也要用，我觉得实在不方便老问别人借，才问爹要钱买了。

其实自制文具也有其乐趣。比如我曾用一种草本植物（我不知其学名）的茎做过自来水笔，作为钢笔的替代品，就是麻烦点，写一会儿就要再蘸蘸墨水。再就是用猪油涂在两张白纸之间，涂匀了之后就可以作演草纸，用一根小棍在上面写字，写完之后把两张纸分开一下再合上，就又可以重新写了，这是一种无限演草纸。

## 放鞭炮

我小时候喜欢过年的主要原因还不是因为有好吃的，好吃的东西对我的吸引力还不如放鞭炮。可能也是拜武侠所赐，我就喜欢爆炸（跟火影忍者里面的迪达拉一样）。过年放的鞭炮会残留一些没炸的，我便会去把它们都捡回来。如果引信还够长的话，就用火钳夹一块烧着的木炭，把那些鞭炮一个个点着了放掉。有一种鞭炮威力很小，我们叫千子鞭。这种鞭我通常拿在手里，点着了再扔出去炸，有时候还可以扔到水里炸，玩起来很过瘾。还有一种炮，很粗，威力也很大，炸起来巨响，我同样喜欢玩。最喜欢的玩法就是拿一个瓷缸子，点着这个炮仗之后立马用瓷缸子把它盖着，有时候甚至盖好后还要压上一块砖头，然后跑远，看瓷缸子像卫星一样被发送上天。当然，常在河边走哪有不湿鞋，常玩鞭炮哪能不失手。有一次我脑残，被这种炮仗把脸炸了一道口子。因为那个炮仗的引信太短了，我不太敢直接点，于是把它夹在竹林里两根竹子之间（就是前面说的打喜鹊的竹林），并裹上一圈纸，想通过点燃纸之后把引信点燃，等纸烧上去我能有时间跑开。问题是，我是把炮仗倒过来放的，因为我想着火从下面向上容易燃一些。当然是容易一些，我点燃纸之后不到一秒，那炮仗就在我面前爆炸了。我低估了火苗会窜多高。后来大人问我的脸怎么了，我只好撒谎说是摔的。每当回想类似的事情，都觉得我能完好无缺活到今天是个奇迹。

对那些引信太短的鞭炮，我会把里面的火药取出来，倒在一块鹅卵石上，然后再盖上一块鹅卵石。起爆方式有两种：一种是用脚直接猛踩，这需要一点胆量；另一种是在两三米开外，用一块大石头或砖头砸向那堆着的鹅卵石，砸中了通常就是一声巨响。还有一种非爆炸的玩法，是把一些鞭炮从中折断，火药朝里，摆成一圈，点燃其中一个之后，火焰互相发射，瞬间一片烟火海。这就没什么刺激性了。

上初中因为有了一点零花钱，所以可以买鞭炮玩了，但在学校里肯定不能玩过节放的那种鞭炮。当时有一种摔炮，就是摔在地上就会爆炸，这又是我人生的一个未解之谜，因为我拆开看过，里面似乎只是些小石子，到底是什么特殊的石子儿能爆炸呢。零花钱不多，能买的也有限，难以满足对爆炸的渴望。有时候我会调皮在教室里偷偷往墙上扔一个，把大家吓一跳。还有一种叫擦炮，就像擦火柴一样，可以擦着了扔掉，它会冒一会儿烟之后才爆炸，所以非常安全；我最爱把它扔到水里炸鱼。这种爆炸的渴望，后面我还会在化学试剂部分说。

## 扒卡车

在学会骑自行车之前，我出门基本一律靠步行。上学或放学路上要是遇见一辆大车，我们会跟着猛跑扒在后面拖箱外，像猴子一样挂着搭便车，刺激又省力。有时候遇到拖拉机也会扒，但容易被车主发现。有一次不知因为什么，我家附近那个开大拖拉机的司机叔叔要主动载我们几个小伙伴一程。我记得我因为不知道怎么开车门，就从司机那边开着的门上去、硬从他面前挤到旁边副驾的座位上。坐在高高的驾驶室里、被突突突冒黑烟的拖拉机载着，恐怕那种感觉就是传说中的春风得意马蹄疾。

## 下池塘

[去年我提过](/cn/2017/12/night-rain/)小时候我一直盼望能有机会到水里划船玩，最接近这个机会的是一次看见岸边泡着一块门板，也没敢真划进池塘。我爹很早就学会了驾船的技能了，偶尔划着别人的船去水库里打渔，但我只敢远观。

我不敢下水的原因是大人最频繁叮嘱的事情就是不要玩水，每次出门玩，后面都会有人喊一句：不要玩水啊！而且他们有时候讲些什么水鬼之事，听着也挺恐怖的。有一年夏天我在舅舅家玩，舅舅家的几个哥哥带我在他们家门口的池塘边上泡了一会儿，那好像是我唯一一次下池塘。村里有些人会狗刨，炎炎夏日的傍晚便跳进池塘洗澡，看得我心动不已。还有一位小叔很胆大，他跟我们说他一会儿游到池塘中央、在水底站着举起手来，让我们看看能否看见他的手。

因为一直心痒，有时我沿着不太深的沟渠放牛，见四周没人就会偷偷下水泡一泡，但仍然不敢在水里久留。直到今天我也没学会游泳，我觉得这事对我好像非常困难，一方面是我下水就沉，另一方面是我觉得水里贼冷，别人游得欢的时候，而我在水里无论怎么折腾用劲，都仍然冷得直哆嗦。初来美国时，跟几个人去一个水上乐园玩，我大约是脑子进水了，在那儿玩跳水，跳板很低，我每次就像一条死鱼摔在水面，然后扒拉几下就能到岸边。后来终于疼得受不了，决定头朝下扎进水里，浮上来时就不知道方向了，眯着眼扒拉几下没摸到池边，顿时慌了神，差点把朕淹死在三米深的小水池里。

## 钓鱼竿

钓鱼是小时候最痴迷的乐趣之一。最初我什么工具都没有，于是找来一根缝衣针，用钳子把它夹弯，做成一只鱼钩。没有鱼线，就用化肥袋子上拆下来的尼龙线。没有鱼竿，就随便找根竹棍子。没有浮子，就用干枯的大蒜茎。不知道用怎样的蚯蚓，就用锄头在后面地里随便挖几条大蚯蚓（后来才知道要用细蚯蚓）。总之，一切齐活，在屋旁别人家的池塘里试钓，后来还真钓上来一条。那种鱼竿提起来时水下传来的一阵强有力抖动的感觉真是令人上瘾。有了这个初始的激励，我便在器具路上一发不可收拾。为了做鱼竿，屋后的竹子不知被我砍了多少根，也去小卖部花几毛钱置办了鱼线鱼钩（我还记得有一次买五分钱的鱼钩，我挑选的时候偷偷藏了一只在左手里）。

我再大一些之后就央求我爹给买了根专门的鱼竿，是那种可以收缩的节竿，看起来是神器，但说实话用起来也一般，而且连接处容易裂（裂了就缠胶布），唯一的优势是比普通竹竿长一些，能伸得更远。在买这根鱼竿之前，我曾打过别人鱼竿的主意。那是一个池塘的主人在池塘边搭了个棚子，有时候晚上睡在那里防止别人偷鱼。有一次我玩到那里，看见棚子里有一根节竿，就偷偷把最前面的一节给拔下来拿回家了。后来他不知怎么发现了是我干的，去我家告诉我爹，于是我被狠狠骂了一顿。

我对鱼的渴望有三方面的原因：一是前面说过的总是盼着捡便宜，二是鱼作为荤菜出现的频率相对较低，三是钓鱼、捉鱼都很有成就感，而且有种未知的刺激，因为预先不知道会捉到一条怎样的鱼。第三个原因应该是最重要的。有时候下大雨导致池塘漫堤，别人养的鱼就会顺水游到水田里，我最盼望这种事情。沿着田埂一路走一路在下面的田沟里找，看是否有黑色的鱼背，要是能发现一条鱼，那激动的心情就跟捡到钱了一样。

我十岁那年，在一个池塘外面的排水口处玩的时候，在杂草遮掩的小水坑里偶然发现几条黑色的不明生物，体型比我见过的鱼都大，而且我也没见过身子是黑色的鱼，所以我最初不确定那到底是不是鱼。最终我还是斗胆把它们抓了出来，看样子是鱼，其实就是黑鱼，只不过我不认识黑鱼而已。我把战利品高高兴兴扛回家，过了几天就是我十岁的生日，家里按惯例请客吃酒，那几条黑鱼就被端上了宴席。照规矩，主人要等所有客人吃完饭之后才能吃，所以尽管我是名义上的主角，但我最终还是一口都没吃到我捉回来的鱼，一肚子委屈。

在捉鱼方面，我从小就羡慕别人的一项技能，就是站在池塘边或水沟里徒手捉鱼。前面提到的那位狗刨的小叔就有这个本事。看他们捉起来好像非常简单，只要在水里张开双臂，小心翼翼地突然合上双手，就可以捉到一条鱼，这比钓鱼省事多了。我模仿了无数次，仍然一条鱼都没捉到过。我同样羡慕的是有时候见人在水沟里上下各筑一道坝，拿水桶把中间的水舀干，然后就可以瓮中捉鱼了。这样的事情我也干过，但累个半死也没捉到几条小猫鱼。

我爹撒网打渔的技术很高，小时候他打渔都叫我跟着背鱼篓。他能把网撒出任意形状，普通池塘当然不在话下，连狭长的水沟里他都能把网撒成狭长的形状。每一网撒下去收上来，网兜里都是各式各样的东西，除了鱼之外可能还有虾、泥鳅、螺、菱角、枯枝烂叶等等。他便蹲着把网兜一个个清理干净，把鱼扔进鱼篓。虾相对少见，而且味道比鱼更鲜美，所以吃饭时我最期待吃到虾。有时我也会叫上我弟和堂弟，三人一起去捞虾。捞虾的工具是一张网兜，两头分别系在两根竹竿头上。因为我们人小，一人扛不动这张虾网，所以三人中两人各扛一根竹竿，喊着一二三把网扔下水，然后拖上来，第三人负责在网里拿出小鱼小虾（虾网撒不远，只能在岸边捞小鱼虾）。我对小淡水虾的渴望至今都没有消失。回国时若能在谁家餐桌上见到一盘虾，我仍然会猛吃。这种餐桌上由于稀缺诞生的渴望，还有一个听来似乎有些不可思议的例子，就是小时候冬天吃饭时，我会跟我弟抢白菜的茎，因为一棵白菜只有很小一部分茎。

有一阵我爹不知从哪里搞来一套电鱼的工具，我跟着他在大小水沟电鱼。他穿着水靴、背着电瓶，双手各拿一根金属棍在水草下面四处试探，我便看着电翻的鱼浮上水面，然后他拿网去把它们捞上来。那电瓶有股难闻的味道，后来想想应该是铅酸蓄电池中硫酸的味道。

除了水里游的鱼，我们还捉鳝鱼。夏天的傍晚，我和我弟就提着一大篓子鳝鱼笼，埋到各个水田的角落里。鳝鱼笼是棒槌型的，篾片编织而成，鳝鱼可以通过大头那边的洞钻进来，但那个洞是削尖的竹签围成的，鳝鱼可以很容易顺着钻进去，但无法再逆着钻出来，因为会被扎到。过一夜后，第二天大清早我们便去把那些笼子刨出来，经常收获一小桶鳝鱼（偶尔也有泥鳅，甚至是蛇），也是一件很有成就感的事情。后来我在舅舅家玩，发现他们还会从洞里钓鳝鱼。回家后我曾用铁签磨尖了自制鳝鱼钩，但问题是我实在不知道怎么找鳝鱼洞。沟渠两岸通常有无数的洞，我不知道怎样的才是鳝鱼洞，那些洞里面有的是蛇，有的是螃蟹。所以我也从来没成功钓出过一条鳝鱼，这是小时候的一件憾事。

## 自行车

我是在五年级学会的骑自行车。那时候学车都是拿大人的二八载重自行车学，人和自行车差不多高，跨不上车，只能左脚踩着左踏板，右脚从三角架中间穿过去踩着右边的踏板，然后右脚快速向后踩一下把左脚撑起来，再左脚向下踩一下让车前进，就这样不断重复，都无法做到踏整圈。连人带车摔了若干次跤，才慢慢掌握了平衡。刚学会自行车那阵，时刻都想骑车出门玩。有了一样交通工具，就可以轻松去远方玩了，比如河边。后来逐渐攻克各种挑战，比如上坡下坡、单手骑、撒手骑。

毕竟家里只有一辆自行车，我不能想骑就骑，而且那车对我也太笨重。后来村里开始有人买轻便型的自行车，我看着也很羡慕。我邻居同学家就有一辆。有一次我们要去舅舅家，我爹便去借了他的自行车。我终于能趾高气昂地坐在自行车座上、整圈整圈地骑车了，心里别提多兴奋。

## 纸烟盒

小男孩聚在一起玩的游戏通常有赌博性质，比如打弹珠和扇画片。我六年级开始用一毛钱买来的两颗弹珠起家参战，到小学毕业时已经赢了两百来颗。那时流行两种画片，一种是普通纸折成的正方形画片，看谁能用自己的画片把对方的画片拍翻过来（传说刘在石很在行），另一种是纸烟盒折成的三角形画片，在三角形的中腰把顶角折向底边，这样放在地上顶角会立着，玩法就是用手猛扇一下风，或在地上画片前用手拍一下，画片翻过来了就算赢。

正方形画片的赌博性质淡一些，因为随机性弱一些。它的吸引力在于，虽然纸张不是极度稀缺的资源（也有点稀缺了），但硬纸还是比较稀缺的，而硬纸折成的画片比较容易把对方的画片拍翻，所以我们总想赢别人的优质画片。烟盒做的三角画片则有些门路：首先，玩家的烟的总价钱高低决定玩家的顺序，为了获得扇的优先权，你也可以用一大摞便宜烟；其次，最先扇的人有个特别优势，就是第一步是把大家的画片摞在一起放一个人的掌心，最先扇的人先把这个人的小臂打一下，让画片掉地上，当时可能就会有些画片随机翻过来，那些就已经归这个人所有了，剩下的就是按顺序扇，谁扇翻哪些、哪些就归他所有。烟盒画片都有标价，所以输赢很容易计算。玩这种游戏导致的结果就是大家都疯狂收集烟盒，无形中可能也为村里的卫生环境做了贡献。当时我盼望去铁路边玩，除了可以在那里轧铁钉之外，还有一个重要的目标就是捡烟盒，因为铁路边常常有我们从未听说过的烟牌子，捡回去就是独一无二的宝贝，而定价也可以自己随便忽悠。

所以世上很多东西的价值都来自人的主观判断和设定，就算是破铜烂铁、烟盒废纸，只要你提供一个竞争的环境、要参与者付出努力才能得到，它们的身价可以翻无数倍。这样的例子太多了，像我以前说过的[钻石](/cn/2018/06/diamonds/)，以及《曾国藩三部曲》中曾国藩打的一百把腰刀（刀本身没多大绝对价值，但只有少数人能获得）。人不管在什么阶段，都会被实质上毫无价值的东西牵着鼻子走，这个现象不局限于童年。

## 谜之歌

我也不知道为什么我会渴望着听歌。无论是听见对面山上的人家放《千年等一回》，还是河对岸的喇叭放《明天会更好》，我都会听得着迷。我叔叔也喜欢听歌，所以他买了个录音机，平时没事就放放磁带，尤其到了过年，更是把[洗剪吹](/cn/2017/10/wash-cut-blow/)的歌放得震天响。他也是村里少见的买了麦克风和音箱在家唱歌的人，农村人一般比较害羞，他则不然。三舅家也是少数买了录音机的人家，放得最多的磁带就是王菲、高胜美。受小时候听歌的深切影响，我至今喜欢一种在如今看来有些土的风格，就是在歌里面加一些旁白，典型的代表就是杨钰莹《晚霞中的红蜻蜓》。上高中后任贤齐开始红得发紫，加上武侠剧常用他的歌作为主题曲（如《神雕侠侣》《楚留香》等），所以我就更加喜欢了，但我自己没有随身听和磁带。不过这难不倒我，在《[土人](/cn/2018/09/countryman/)》一文中，我提过我当时用电话录音的方式从别人的随身听录了不少歌，晚上可以在被窝里抱着电话听；有听的就不错了，哪管什么音质。

## 酒精灯

我喜欢把东西放在瓶瓶罐罐里煮或烧，但可烧的东西有限。比如我曾把白酒倒在一个细颈瓶子里，加热后让酒精蒸汽喷出来，然后点着它，在一旁坐看火舌。再比如有一阵子我跟一个小伙伴莫名迷上熬松香，放学路上在松树上抠一些凝固的松油，回家装在瓶子里加热慢慢熬，熬了做什么也不知道，毫无目的，反正最终就是把固态的松脂炼成液态的松油。

加热这些瓶瓶罐罐的最大问题是热源只有一种选择，就是蜡烛，而蜡烛这种高碳燃料总是燃烧不充分，瓶底一会儿就烧得漆黑，导致看不见瓶子里的状况。后来上了化学课，发现化学实验里都是用酒精灯，烧起来很干净，于是十分心痒，总想从实验室顺一盏灯回家，但终归没这个狗胆，因为少一盏灯很容易被发现，我最多只敢拿个小瓶偷偷倒一些酒精装走，而量太小，烧得不够过瘾。

后来我发明了一种蜡烛的新玩法，就是把用完的圆珠笔芯最前面的那个小钢珠想办法抠掉，然后用嘴含着笔芯，鼓着腮帮子，通过笔尖的小孔吹蜡烛的火焰，这样可以吹出一条细长的火焰丝，就跟烧气焊一样。也许是人工加氧、并抑制火焰规模的缘故，这样蜡烛会燃烧充分一些，炭黑也少一些。我以为这样能像烧焊一样产生超高温，但并没有熔化过任何金属，连锡都没熔化过（我家有很多锡，是因为我爹的渔网网脚需要用重重的锡块以使得渔网能快速下沉）。

## 强酸碱

在《[卅载芳华](/cn/2018/10/middle-school-teachers/)》中，我写过我在家玩过的化学实验，苦于材料太少，无法玩出好玩的实验。我做过的最高级的实验也仅限于电解水、收集氢气，然后在瓶口把氢气点着，听砰地一声爆炸（小瓶氢气，没什么威力）。不过这个我做了无数遍的实验倒是让我一直有个疑问，就是为什么我的盐水里会产生一些绿色的混浊物。这件事我从初中一直想到高二才最终搞明白：我用的是铜丝作导线，氢被还原的同时，铜被氧化了。想明白后我还给校报投了一篇文章解释这个现象。后来刊登后，化学老师（兼班主任）还给了我十块钱的巨额稿费，我不知道到底是真的有稿费，还是他找个借口自掏腰包周济我的。

在家除了电解水，就是拿醋泡铝丝制氢气。醋这种弱酸实在没多大意思。我一直期待着能搞到一些强酸碱，或强氧化剂。后来在高中实验室偷了一些氢氧化钠出来，把铝丝放里面制氢气。能偷氢氧化钠，是因为它是固体，容易携带，拿团纸一包就带出来了。类似的还有金属钠，我也包出来过。而强酸都是液体，很难搞出来，所以我从来没有在家玩过。班里有个同学有一次去市里不知什么地方买了一瓶浓硫酸，拿回宿舍倒了一些在试管里，拿水稀释，结果试管一下子变得很烫（这本来应该在意料之中的），他吓了一跳，赶紧把试管插在床头的铁管里。我们就看着那管硫酸呼呼冒烟，最终平静了下来。

高二时学校里举办一个所谓的科技节，我想出一个钻木取火的主意，于是找了两个配角同学跟我一起扮作原始人，光着脚在操场前的看台上表演钻木取火。当然我是没本事真的把木头钻燃的，我只不过是在一段木头上挖个洞，洞里放一些高锰酸钾和白磷，这大概是最干柴烈火的搭配了，我拿根木棍随便钻两下就会烧起来，加上白磷燃烧会有大量烟雾，所以适合表演用。那白磷的特殊臭味我至今记得。

生活中能找到的强氧化剂有限，唯有一次，有个同学说他家里有硝酸钾，我便求他带一些给我。那包硝酸钾晶体我在宿舍玩了好些天，主要玩法是拿一根一次性筷子，点燃之后吹掉明火，然后戳在一团硝酸钾上，顿时筷子就会剧烈燃烧起来，再加上钾的焰色反应，甚是壮观、好看。

可以说整个初中高中我学习化学的最大动力就是为了能在自家捣鼓出什么绚烂的化学反应，要是能爆炸就最好不过了（我是不是被上学耽误的诺贝尔）。我遍阅我能找到的化学读物，边看边琢磨哪些材料可能找到、哪些反应可以试试。在同学们纷纷邮购贝塔斯曼的书时，我在邮购往年的化学报合集，并如饥似渴地看、抄那些方程式。

## 新老师

小学初中的老师普遍都偏凶，所以要是碰上一个不凶的新老师，就如同久旱逢甘霖。小学三年级不知从哪里来了一个语文老师，她只在我们学校待了一年，教完我们一年语文之后就走了，我也不知她为什么走了、以及去了哪里，甚至已经全然忘了她的名姓。她很照顾和怜悯我，见我的作业本捉襟见肘（我有时用捡的烟盒的背面写作业），就收集了一摞废白纸送我。还有一次我听邻居说她曾去我家家访，但不巧我们不在家，便错过了。我整个上学期间从来没有过别的老师去我家家访过，家访这个词对我来说只存在于书本上。她的语文课上，我回答问题格外积极。这些问题通常都是，某篇课文的中心思想或大意是什么，我经常是老师的话音刚落就举手，连想都还没想好，有时候甚至归纳的段落大意跟段落本身长度也差不多了，不过她总说我回答的对。

初一初二这两年里学校会接收一些实习老师，这也是我们最喜欢的老师。因为这些老师是来实习，没多少经验，也希望最后能得到我们的好评，所以会倾向于讨好我们，跟我们打成一片，如同知音大哥哥大姐姐。我小学初中时最讨厌的作业之一就是写日记，真的是烦透了，但实习老师来了之后，我就很愿意写一些心里的真实想法，老师的批注也很有感情。每年我们最伤心的时刻就是与实习老师的离别。我也不知道那是怎样一种感情。最后一节课的最后告别时，班里总是一片啜泣声。这些老师的名姓我如今也都不记得了，同样不知他们身在何方、以及后来是否真的踏上了讲台。这是苍茫人海沉浮、童稚真情一瞬的渴望。
