---
title: 《穷查理宝典》笔记
date: '2018-08-24'
slug: poor-charlies-almanack
---

我第一次听说《穷查理宝典》是 [2012 年 3 月](https://github.com/yihui/ideas/issues/26)，但直到去年我才读它。前后一共大约花了十三小时、到十二月读完，划了不少线。这几天趁感冒专门放个假，来重新整理一下笔记。这些零碎的笔记主要供我自己回顾使用，并非写给来往的各位客官；如果没有读原书的话，缺少上下文可能会有些跳跃和费解。

## 第二章 芒格的生活、学习和决策方法

芒格非常推崇达尔文的研究方法，一是称赞他有毅力，二是称赞他注重搜集反面证据。下面的话是他引用赫胥黎（达尔文的忠实信徒）：

> 也许所有教育最有价值的结果是，当你不得不完成一件事情的时候，不管你是否喜欢它，你都有能力去完成这项必须的任务。这是每个人应该学的第一课，然而，无论一个人多早接受教育，这可能是他彻底学到的最后一课。

完成不喜欢但又不得不完成的事情，的确是人生最重要、也最难学到的一课。在美国统计学会的 [Amstat News 一个采访](https://magazine.amstat.org/blog/2018/04/01/data-is-my-job/)中，我基本照搬了上面的话来回答“如果时光倒流，你将有什么建议给二十岁的自己”这个问题。

在前面《[利害](/cn/2018/08/pros-cons/)》一文中，我曾提到如果一个人觉得自己的做法是无比正义、有爱心的，那么他就会忽略潜在危害。芒格引用格拉汉姆对此有进一步解释：

> 给你带来麻烦的不是坏主意，而是好主意。你也许会说：“那不可能。那是相互矛盾的。”他（格拉汉姆）想说的是，如果一件事情是个坏主意，你不会做过头。但如果一件事情是个好主意，蕴含着重要的真理，那你就没办法忽略了。然后你就很容易做过头。所以呢，如果你把它们做过头了，那些好主意是让你遭受可怕后果的好方法。

这个悖论很有意思。用我们的老话来说，就是简单四个字：物极必反。这让我联想到《黑客与画家》中引用 Lewis 的一段话：

> Of all tyrannies, a tyranny sincerely exercised for the good of its victims may be the most oppressive. It would be better to live under robber barons than under omnipotent moral busybodies. The robber baron's cruelty may sometimes sleep, his cupidity may at some point be satiated; but those who torment us for our own good will torment us without end for they do so with the approval of their own conscience. They may be more likely to go to Heaven yet at the same time likelier to make a Hell of earth. This very kindness stings with intolerable insult.

普通暴君的暴行还有停歇的时候，而追求正义的暴君则被内心的使命感驱动，永不停歇地推行他的正义法则，不管这样做到底是给民众带来好处还是坏处。

芒格也很推崇富兰克林的智慧，在书中引用过很多次他的话和做事方法。下面是芒格论诚实：

> 我们看来，本杰明·富兰克林是对的。他并没有说诚实是最好的道德品质，他说诚实是最好的策略。

我也不太相信道德品质，我认为道德品质都是脆弱的，而且通常是反人性的。如果你换个角度来看，把某些道德品质当作策略，事情则会简单很多。做人要诚实，不是因为它是优秀的道德品质，而是那样做能给你免去记忆谎言的麻烦，释放更多脑力去你该做的事情。达里奥的《原则》通篇都推崇极度透明，应该也是看中透明能把我们从猜疑中解放出来这一优点。

## 第三讲 论基本的、普世的智慧（修正稿）

芒格比较赞赏亚洲文化，尤其是中国。在谈论桥牌时，他说中国人的桥牌打得好，顺便揶揄一下：

> 要是他们也实行资本主义，天知道他们该发展得多好。

讲真，我现在已经完全搞不清这些意识形态之下的经济发展有什么本质区别，以及为什么我们要选择戴一顶社会主义或资本主义的帽子。

芒格一直嘲讽学院派的思维方式，我觉得听听他的说法对广大大学生（尤其是研究僧）会很有帮助：

> 所以如果你们的教授并没有教给你们正确的跨学科方法——如果每个教授都想过度地使用他自己的模式，对其他学科的重要模型弃之不用——你们可以自己改正那种愚蠢的做法。他是个笨蛋，并不意味着你们也要成为笨蛋。你们可以向其他学科学习能够更好地解决问题的模型。只要养成正确的思维习惯你们就能做到这一点。

话糙理不糙。每个人都有拿锤子找钉子、擅长什么就只研究什么的趋势，但为什么要把学院派单独拎出来批判呢？因为那是多数人的教育必经之路。如果你在求学阶段就被束缚了视角，以后恐怕也很难再开眼了。

巴菲特从小就意识到父亲有强烈的（右派）意识形态偏见：

> 他认为意识形态是危险的东西，决定离它远远的。他终生都离意识形态远远的。这极大地提高了他认知的准确性。

芒格论最低工资是否该提高：

> 如果你把准确、勤奋和客观当成你笃信的意识形态，那倒不要紧。但如果你们因为受到意识形态的影响，而确凿无疑地相信最低工资应该提高或者不该提高，并认为这种神圣的想法是正确的，那么你们就变成了傻子。
> 
> 这是一个非常复杂的系统。生活总是环环相扣的。如果综合考虑，你们猜想提高或者降低最低工资会让整个社会变得更加文明，那是没有问题的。这两种想法都对。

很多问题都不太可能有一个明确的是或否的答案，不要急于站队，甚至根本就永远别去站队。最低工资的提高，也许会让社会养更多懒汉；最低工资的降低，也许会让包工头更多压榨廉价劳动力。

芒格吐槽的重灾区是心理学（其次应该是经济学），这一点上他的姿态十分傲娇以及直言不讳：

> 许多心理学教材虽然不乏闪光之处，但大体上都是垃圾。

他说这话的原因是那些厚厚的心理学教材没有谈论很多他认为是最重要的话题，比如妒忌、[心理否认](https://zh.wikipedia.org/wiki/%E5%BF%83%E7%90%86%E9%98%B2%E5%8D%AB%E6%9C%BA%E5%88%B6)、激励机制引起的偏见、多因素的组合效应。关于心理否认，他引用德摩斯梯尼的话：

> 个人想要什么，就会相信什么。

这就像我[相信斯坦福监狱实验](/cn/2018/06/spe/)一样，因为那是我想要的结果。

> 心理学教授回避心理否认问题的原因之一在于，如果要做有关心理否认的实验，他们肯定会违反道德规范。要证明痛苦如何导致人类精神失常，你们想想看，这种实验必须对你们的同类做些什么，而且你们还不能告诉他们将会受到什么伤害。所以很明显，道德规范导致这种实验行不通，尽管做实验是展示痛苦如何导致人类头脑失常的最佳方法。

因为要研究心理否认就必须做违反道德的实验，所以心理学家不愿意研究这个话题。心理学家不仅是回避对人类的心理否认研究，就连巴甫洛夫的狗的实验结果也会在教材中避而不谈，因为这些实验都太残酷了。我不知道芒格说的是巴甫洛夫的哪篇论文，但我估计这里芒格对心理学研究的批评有点过头。他说他自己没有上过一节心理学的课，我很好奇他是怎么知道心理学研究者忽视他说的那些话题的。

年初我[曾提过](/cn/2018/01/derivatives/)芒格关于工伤赔偿制度的观点，因为这样的制度更多导致的是诈骗（吸引狡猾的律师、医生、工会）：

> 所以与其创立一种有漏洞的制度，还不如就不要赔偿了——就让生活艰辛一些。

芒格谈论父亲的教育方式时说间接的教育方式更有效，也就是不直接告诉你道理，而是让你自己在做事和思考中去领悟这个道理。这让我想到我爹。他作为一个农民，自己可能从来没想过什么教育方式的问题，也很少给我讲道理，他只做一件事，就是无论刮风下雨，都总是辛勤劳作。记得大约是我上高中的时候，有一次在家里听大人们闲聊，我姑妈提起他有一天下大雨还在地里给橘树整枝，这种间接获得的消息往往更让人震撼。芒格对这种间接影响方式有一个心理学视角的解释（人类保持一贯性的倾向）：

> 优秀的文学作品需要读者略加思索才能理解，那样它对读者的影响会很深，你会更牢固地记住它。这就是承诺和保持一贯性的倾向。如果你动脑筋才懂得某个道理，你就会更好地记住它。

芒格引用富兰克林讲如何说服人（我在[一篇英文日志](/en/2017/12/how-i-learned-r/)中引过这句话）：

> 在大多数情况下，要说服一个人，从这个人的利益出发是最有效的。

承接上面关于工伤赔偿制度的讨论：

> 我个人最讨厌的是那些让欺诈变得容易的制度。

因为这种制度名义上帮助了少数真正需要的人，但实际上是让多数人的利益受损，骗子得利更多。所以他推崇海军的制度：不管由于什么原因，只要船触了礁，船长就得卷铺盖走人或受罚。

> 我赞成海军的规定，那就是在追求正义——追求让更少船只触礁的正义。考虑到这些规则带来的好处，我不会在乎有位船长受到不公平的对待。

前面提过芒格推崇达尔文：

> 去年我突然意识到自己真是个白痴，居然连现代达尔文主义都没看过。

所以我找来《物种起源》，但看了几章就觉得有些看不下去，可能这书不适合睡前看。

继续吐槽学术界（仍然是心理学）：

> 考虑到学术界的惯性，所有学术界的缺陷都是非常难以解决的。

为什么学术界的缺陷难以修正？我觉得还是象牙塔的问题。象牙塔不是纯粹的坏事，学术界需要一定的隔离来保证它的独立性（例如不要让世俗偏见影响了教育、不要让公司财团影响了科研），问题只是要隔离到什么程度。有些学术圈可能可以脱离外界现实而独立存活，这就意味着他们难以得到外界反馈，从而难以纠正系统里存在的问题。比如我认为学术界目前最大的问题就是不关心学生的找工作问题，或者说相比起对科研成果的重视，老师对学生是否能找到一份好工作这个问题的关心微乎其微，就更不必说是否关心工作几年甚至几十年之后再反思学院教育对学生日后工作的作用。学术界太注重孵化学术型人才。说到隔离，世上还有一个隔离大户，就是以佛教为代表的部分宗教。这里面如果出了问题，那么问题可能会存在很久（不知龙泉寺之事属实乎）。

芒格论为什么天才不愿意从事心理学研究，原因之一是临床心理学有一个尴尬的问题：

> 相信虚幻的东西往往能够提高幸福感。

所以天才会选择从事尖端的自然科学研究，而不会染指心理学或经济学这种软科学。这倒是跟我的选择一致：就统计学应用来说，我也倾向于关注自然科学的问题，而不愿意接触社会科学。

第三遍强调容易诱发欺诈的制度的危害：

> 应该尽可能地设计各种防止欺诈的制度，哪怕有些人的悲惨遭遇将会因此而得不到补偿。

## 第四讲 关于现实思维的现实思考？

这篇讲稿讲了五个观念，用来推导如何白手起家创造出可口可乐这家企业。我觉得这有点事后诸葛亮的意思，要是创业如此简单，他咋不自己去创一个呢。

> 第一个有用的观念是，简化任务的最佳方法一般是先解决那些答案显而易见的大问题。

在可口可乐的例子中，芒格说的两个大问题是：我们要有一个品牌、我们要生产一种广受欢迎的产品。这不都是废话吗，而且答案一点也不显而易见呀。

> 第二个有用的观念跟伽利略的论断如出一辙。伽利略说，惟有数学才能揭示科学的真实面貌，因为数学似乎是上帝的语言。伽利略的看法在乱糟糟的日常生活中同样有用。如果缺乏数学运算能力，在我们大多数人所过的生活中，你们将会像一个参加踢屁股比赛的独腿人。

芒格说的数学在这个例子里基本上只是算两样东西：一是全世界的消费者平均每人每天喝多少水（然后用可乐取代这里面的一部分水）、二是在一百五十年里让企业价值成长为两万亿美元的话，回推回去在一百五十年前每瓶可乐应该挣多少利润。无怪乎芒格说他从不用电脑，只用一个计算器和一张破旧的复利表。

> 第三个有用的观念是，光是正面思考问题是不够的，你必须进行反面思考。就像有个乡下人说过的，他要是知道他的死亡地点就好了，那他就永远不去那里。实际上，许多问题是无法通过正面思考来解决的。所以伟大的代数学家卡尔·雅各比经常说：“反过来想，总是反过来想。”毕达哥拉斯学派也同样通过逆向思考证明“2的平方根是一个无理数”。

反过来想确实是一种有用的思维方式。考虑如何让可口可乐成功的方法时，应该也考虑它如何失败的各种可能性。

> 第四个有用的观念是，最好的、最具有实践性的智慧是基本的学术智慧。但有一个极其重要的前提：你必须以跨学科的方式思考。你必须经常使用所有可以从各个学科的大一课程中学到的概念。如果能够熟练地掌握这些基本概念，你解决问题的方法将不会受到限制。由于各个学科和亚学科之间的壁垒极其森严，跨出划定的界线去研究其他学科被视为冒天下之大不韪的事情，所以学术界和许多商业机构解决问题的方法非常有限。你必须反其道而行，采用跨学科的思维方式，用本杰明·富兰克林的话来说，就是：“如果你想要完成，就自己着手去做。如果不想，就让别人去做。”
> 
> 如果你们在思考问题的时候完全依赖别人，时常花钱请一些专业顾问，那么每当碰到你们那狭小的知识面之外的问题，你们将会遭遇很大的灾难。你们不但要浪费很多精力去处理复杂的合作问题，而且还将会遇到萧伯纳笔下那个人物所说的情况：“每个职业最终都是蒙骗外行人的勾当。”实际上，萧伯纳笔下的人物还低估了萧伯纳讨厌的那些行业的危害。通常来说，你的眼界狭窄的专业顾问并不是故意给你误事，而是他的潜意识偏见给你们带来麻烦。他的利益出发点跟你们不一样，所以他的认知往往是有缺陷的。他还拥有下面这句谚语所揭示的心理缺陷：“在拿着铁锤的人看来，每个问题都像钉子。”

每个职业最终都是蒙骗外行人的勾当。这话很尖锐，不过我觉得它一定程度上是对的；人不为己，天诛地灭嘛，多数职业都首先是为了求生，而不是为了献爱心。同样要命的是每个职业都有自己的偏见，越专业的人可能偏见越强烈。

> 第五个有用的观念是，真正的大效应，也就是lollapalooza效应，通常在几种因素的共同作用下才会出现。例如，多年以来，许多人的肺结核之所以能够治愈，是因为他们同时服用了三种药物。其他的lollapalooza效应，比如说飞机的飞行，也是遵守同样的模式。

某种程度上这也是废话，因为世上很少有只靠一种因素走向成功的案例。成功往往是多种因素交互作用的结果。

书中名言、警句、金句比较多，如：

> 如果你认为你是一个有些影响力的人，试试看能不能指使别人的狗。

又如（据说是牛顿说的）：

> 我们造的墙太多，而修的桥太少。

前面芒格说学术界的问题难以修正，但这里举了芝加哥大学引进理查德 · 泰勒的例子，说还是有希望修正的。因为泰勒一直取笑芝加哥大学奉为圭臬的“理性人假设”，引进泰勒可以促使当前芝大的教授们从反面思考：

> 芝加哥大学这么做等于是在模仿达尔文，达尔文终身大部分时间都在进行逆向思考，想要证伪他自己最爱的、历经千辛万苦才得到的理论。只要学术界有部分人愿意像达尔文那样逆向思考，让最好的学术理论充满活力，我们就可以满怀信心地期待那些愚蠢的教育行为，就像卡尔森 · 雅各比（注：卡尔森 · 雅各比，1804—1851，德国数学家）可能会推断的那样，最终将会被更好的教育方式取代。

爱因斯坦说自己也依赖于自我批评：

> 他的成就取决于四个因素，首先是自我批评，然后才是好奇心、专注和毅力。

## 第五讲 专业人士需要更多的跨学科技能

前面刚引用过萧伯纳的那句话，这里又重复一遍，并补充了一个例子（专业人士会阻止他人跨学科的努力，因为这样会影响他们的权威性）：

> 萧伯纳笔下有个人物曾经这么解释专业的缺陷：“归根到底，每个职业都是蒙骗外行人的勾当。”早年的情况证明萧伯纳的诊断是千真万确的，16世纪主要的专业人士——修道士——曾将威廉·丁道尔烧死，原因是他将《圣经》翻译成英文。

芒格论专业人士的麻烦之处：

> 1. 激励机制造成的偏见，拥有这种天生的认知偏见的专业人士会认为，对他们自己有利的，就是对客户和整个文明社会有利的；以及
> 
> 2. 铁锤人倾向，这个名称来自那句谚语：“在只有铁锤的人看来，每个问题都非常像一颗钉子。”

书中有一处我以前不知道的冷知识：使用维生素 C 来预防普通感冒，这是[化学家鲍林](https://zh.wikipedia.org/wiki/%E8%90%8A%E7%B4%8D%E6%96%AF%C2%B7%E9%AE%91%E6%9E%97)提出来的。不过看了维基之后发现这位老先生晚年也掉进了维 C 的坑，这就是一个活生生的“把好主意做过头”的例子（见第二章格拉汉姆的话）。

芒格讲在寻找最佳的专业教育模型时，不妨参考飞行员的训练：

> 1. 要教给他足够全面的知识，让他能够熟练地掌握飞行中用得到的一切知识。
> 
> 2. 把这些知识统统教给他，不仅是为了让他能够通过一两次考试，而是为了让他能够熟练地应用这些知识，甚至能够同时处理两三种相互交织的复杂的危险情况。
> 
> 3. 就像任何一个优秀的代数学家，他要学会有时候采用正向思维，有时候采用逆向思维，这样他就能够明白什么时候应该把主要的注意力放在他想要的那些事情上，而什么时候放在他想要避免的那些情况上。
> 
> 4. 他必须接受各门学科的训练，力求把他未来因为错误操作而造成损失的可能性降到最低；最重要的操作步骤必须得到最严格的训练，达到最高的掌握水平。
> 
> 5. 他必须养成核对“检查清单”的习惯。
> 
> 6. 在接受最初的训练之后，他必须常规性地保持对这些知识的掌握：经常使用飞行模拟器，以免那些应付罕见重要问题的知识因为长期不用而生疏。

## 第六讲 一流慈善基金的投资实践

如何消除思考的副作用？引用费曼的话：

> 首要的原则是你必须别欺骗自己，因为自己是最好骗的人。

芒格不欣赏复杂的投资方法，而是推崇伯克希尔那种对看好的少数国内公司长期投资的方法（当然这毫不奇怪），并对现代投资从业青年只顾逐利的追求表示遗憾：

> 美国越来越多有道德感的青年才俊醉心于收益丰厚的资产管理及其随之而来的现代摩擦，而对那些能够给别人带来更多价值的工作则不屑一顾。

## 第八讲 2003年的金融大丑闻

引用厄普顿 · 辛克莱（为什么有公司迫切追求用现代金融工程技术提高公司的市值）：

> 让人们去理解那些跟他们的利益冲突的事情是很难的。

这一讲主要是抨击股票期权的记账方法（以低于市场价的价格发给员工股票，员工若以市场价卖掉股票，得到的收益不记为公司的薪酬支出，而税务部门计算公司所得税的时候会把这部分减去，所以这种记账方法让公司既不减少账面上的盈利，也能享受税收的好处）：

> 股票期权的标准记账方法与那些更广为人知的简单欺骗作假手段本质上没有什么区别。

## 第九讲 论学院派经济学：考虑跨学科需求之后的优点和缺点

芒格没上过一节经济学课，却大谈学院派经济学的优点和缺点，因此他给自己授予胆量黑带：

> 我在胆量方面是黑带水平。

抨击心理学系不研究邪教（我怀疑这抨击不靠谱，应该会有人研究的吧，但芒格特意研究邪教这事本身值得赞赏，我觉得这是很有意义的一件事）：

> 我花了整整20年才搞清楚邪教如何招揽教众以及这种方法为什么会有效，但大学的心理学系到现在还没搞清楚，所以我走在它们前面。

谈经济学的优点时，大赞曼昆的经济学原理，举了两个例子：

> 机会成本是一种超级力量，所有希望获得正确答案的人都可以使用。还有，激励机制也是一种超级力量。

下面这段话可以是对统计学家最好的提醒（避免铁锤人综合征）：

> 实际上，每个人都会（1）过度强调那些有相关数据的因素的重要性，因为它们让人们有机会使用在高等学府学来的统计学技巧，并且（2）不把那些可能更加重要但没有相关数据的因素考虑在内。这是我终生试图避开的错误，我从来不后悔自己这么做。

生物学家托马斯 · 汉特 · 摩根为了避免过度强调可以被测量的因素的重要性，用了一个极端的办法，就是干脆在系里禁止使用计算器。下面说的用采矿的方式找金子，就是通过测量、计算的方法得到重大发现：

> 我就像一个在1849年的萨克拉门托河（Sacramento River）边寻找黄金的人。虽然才智有限，但我能够弯腰捡起大金块。只要能够捡到大金块，我就不会让我系里的人浪费稀缺的资源，用矿金开采的方法去找金子。

谈经济学的缺点，其一是物理学妒忌。说到妒忌，顺便狠狠踩了弗洛伊德一脚：

> 弗洛伊德是世界上最愚蠢的白痴之一，但他在他那个年代很受欢迎，而且阴茎妒忌这个概念也变得很流行。

经济学无法做到物理学的精确程度，不要盲目相信市场有效理论：

> 我是希望经济学采用硬科学的基本治学方法，养成指明其借鉴知识的来源的习惯，但我并不希望它由于物理学妒忌而渴望一种无法达到的准确度。大体上来说，那种包括波尔茨曼常数在内的准确而可靠的公式是不可能在经济学中出现的。经济学涉及的系统太过复杂。渴望做到物理学那么精确不会给你们带来任何好处，只会让你们陷入麻烦之中，就像麦肯锡那个可怜的傻瓜。

批评经济学界太强调宏观经济学（我去年[也说过](/cn/2017/02/shame/)我很难理解宏观经济学）：

> 经济学界太过强调宏观经济学，而对微观经济学的重视程度不够。我认为这是错误的。这就像不懂解剖学和化学，却想要掌握医学一样。除此之外，微观经济学是很好玩的。它能够帮助你们正确地理解宏观经济学，它就像耍杂技那么好玩。与之相反，我并不认为人们研究宏观经济学能够得到那么多乐趣。最重要的原因是，他们经常犯错，因为他们想要理解的系统实在是太复杂了。

不要做自己不认同的事情：

> 我认为你们在生活中并没有必要去推销那些你们自己永远不会购买的东西。即使那是合法的，我也不认为那么做是一个好主意。但你们不应该完全接受我的观点，因为那会让你们有找不到工作的风险。你们不应该接受我的观点，除非你们甘愿冒着只能在少数几个地方找到工作的风险。

讽刺经济学教授的单一思维（这话是不是可以延伸到整个教授群体）：

> 那些人上过四门经济学课程，入读商学院，智商都很高，写了许多论文，但他们却一点综合能力都没有。之所以发生这种情况，并不是因为那些教授知道如何综合各种知识却不传授给学生，而是由于那些教授本身也没有好好掌握综合能力。他们接受的不是一种综合的教育。我记得凯恩斯或者加尔布雷思（注：加尔布雷思，1908—2006，加拿大裔美国经济学家，曾任美国驻印度大使，两次获得总统自由勋章）说过一句话，经济学教授的思想是最经济的。他们终身使用的是他们在研究生院学到的一点点知识。

感叹经济学家不注重心理学，哪怕是一点点心理学知识就能很简单解决问题：

> 这是塞缪尔·约翰逊提出来的。实际上，他说如果一个学者能够通过少量的工作轻轻松松地去掉自己的一个无知，却不去做，那么这个学者的行为就等于背叛。这是他的原话，“背叛”。所以你们能够明白我为什么喜欢这些东西。他说如果你们是学者，那么就有责任努力让自己别成为白痴，所以你们必须尽量完善你们的知识体系，尽可能地消灭自己的无知。

再次谈工伤赔偿制度的可恨，矛头指向立法者：

> 罪魁祸首是那些立法机构。这些机构的许多成员是从法学院毕业的，可是他们却通过了鼓励欺骗的法律；他们不认为自己的所作所为对文明社会有极大的破坏作用，因为他们并没有考虑到说谎和欺骗造成的二级后果或者三级后果。

谈到钻制度漏洞，他用了[维克多 · 尼德霍夫](https://en.wikipedia.org/wiki/Victor_Niederhoffer)的例子。

> 哈佛大学经济学系的维克多 · 尼德霍夫的故事是一个利用制度漏洞的绝佳例子。

我头一次听说这个例子是当年在村里上高等线性模型课的时候，上课的老师是个资深股票玩家，通过炒股赚了不少钱，对金融界的名人轶事也了如指掌，非常能说。有一天不知道怎么就扯到这个例子上，听得我下巴都掉了。大意就是难课没有学生愿意选，所以只要选了课，教授就会给甲等高分。结果这位老兄就专门选最难的课，虽然一次也没去上过课，但门门成绩都甲等。

> 所以，正如人们根据那种叫做“互惠倾向”的心理因素可以预料到的，在研究生上的高级课程中，教授们给出的分数总是甲等。所以维克多·尼德霍夫什么课都不选，专门选哈佛大学经济学系那些最高级的研究生课程，当然啦，他每门课程都得到了甲等的成绩，而且几乎没有去上过一节课。当时哈佛大学的人还以为这学校又出了一个天才呢。

当然，这只是尼德霍夫传奇故事中的一个很小的插曲而已。

芒格以李嘉图的比较优势理论为例子，批评经济学家不考虑二级、三级后果（贸易确实为双方带来好处，但落后的国家得到的相对优势更大）：

> 如果你们试图与一些经济学教授谈论这个话题——这我已经做过三次——他们会吃惊地回避，好像你们冒犯了他似的，因为他们不喜欢这种讨论。这种讨论会让他们的漂亮学科变得一团糟，因为如果你们忽略二级和三级后果，经济学就会简单得多。

关于道德与公平：

> 人们往往没有认识到，人世间大多数结果都是不公平的，而且道德规范有时候必须不公平，才能取得最好的效果。【……】容忍对某些人有一点不公平，以便对所有人更为公平，这是我向你们所有人推荐的模式。

南海泡沫事件之后的数十年里，英国禁止企业公开交易股票，结果是：

> 长时间禁止股票公开交易的做法并没有让英国衰落。

可能是在那次泡沫事件中出现了太多把资本市场当赌场的疯狂赌徒，清理掉这些赌徒带来的好处大于关掉股票市场的坏处。

巴菲特和芒格都极力反对金融衍生品，芒格如此直白表述：

> 衍生品系统简直是神经病，它是完全不负责任的。

他引用了《诚信的背后：华尔街圈钱游戏的真相》这本书（我没看过）。

## 第十讲 在南加州大学GOULD法学院毕业典礼上的演讲

芒格很崇拜孔子，在演讲时看到现场的家长想起孔子的“孝道”，认为这些思想很重要，亚洲人在美国的地位上升就是证明：

> 请留意在美国社会中亚洲人的地位上升得有多快。

芒格开始讲他人生中的重要的道理。其一：

> 要得到你想要的某样东西，最可靠的办法是让你自己配得起它。

其二：

> 正确的爱应该以仰慕为基础，而且我们应该去爱那些对我们有教育意义的先贤。

其三：

> 获得智慧是一种道德责任。【……】你们必须坚持终身学习。

关于学习，他引用怀海特：

> 人类社会只有发明了发明的方法之后才能发展，同样道理，你们只有学习了学习的方法之后才能进步。

其四是要掌握所有重要学科的重要道理，他声称：

> 真正重要的大道理占了每个学科 95% 的分量

95% 应该是约指，只是说像帕累托法则一样，少数大道理占了整个学科的大部分分量。我很好奇有没有这么一本书来概括所有学科的重要大道理呢？要是有这么一本宝典，岂不是多数人都可以在短时间里大幅度变聪明了？统计学的重要大道理是什么？对我个人而言，我觉得就两个：回归（或者说条件概率、条件期望）和风险函数。我不是指具体的技术，而是指思维方式。

其五，再次提及要避免强烈的意识形态：

> 另外一个要避免的是极端强烈的意识形态，因为它会让人们丧失理智。你们看到电视上有许多非常糟糕的宗教布道者，他们对神学中的细枝末节持有不相同、强烈的、前后矛盾的神学观点，偏偏又非常固执，我看他们当中有许多人的脑袋已经萎缩成卷心菜了。（听众大笑。）政治意识形态的情况也一样。年轻人特别容易陷入强烈而愚蠢的意识形态当中，而且永远走不出来。当你们宣布你们是某个类似邪教团体的忠实成员，并开始倡导该团体的正统意识形态时，你们所做的就是将这种意识形态不断地往自己的头脑里塞。这样你们的头脑就会坏掉，而且有时候是以惊人的速度坏掉。所以你们要非常小心地提防强烈的意识形态，它对你们宝贵的头脑是极大的危险。

如果避免强烈的意识形态？这是芒格给自己的铁律：

> 我觉得我没资格拥有一种观点，除非我能比我的对手更好地反驳我的立场。

他把上面的铁律跟下面的话（[我去年提过](/cn/2017/12/need-not-hope-to-persevere/)）类比，不过我没看出类比的点在哪里：

> 未必要有希望才能够坚持。

芒格为什么推崇达尔文（长达二十年的准备）：

> 达尔文认为，任何对人类起源提出新解释的科学理论都将会遭遇广泛的歧视，所以他在公开发表他的理论之前，先谨慎地对各种可能出现的反驳进行了准备。因此，他花了整整20年，努力地完善他的理论，并为这种理论做好了辩护的准备。

不要无节制服务自己（比如通过透支信用卡满足自己）：

> 一种叫作“自我服务偏好”的心理因素也经常导致人们做傻事。

自怜无用论：

> 每当你们发现自己产生了自怜的情绪，不管是什么原因，哪怕由于自己的孩子患上癌症而即将死去，你们也要想到，自怜是于事无补的。

引用富兰克林讲如何说服人：

> “如果你想要说服别人，要诉诸利益，而非诉诸理性。”

如何让自己客观公正：

> 养成一些让你能够保持客观公正的习惯当然对认知非常有帮助。我们都记得达尔文特别留意相反的证据，尤其是在他证伪的是某种他信奉和热爱的理论时。如果你们想要在思考的时候尽量少犯错误，你们就需要这样的习惯。

其六，做自己有强烈兴趣的事情：

> 如果你们真的想要在某个领域做得很出色，那么你们必须对它有强烈的兴趣。我可以强迫自己把许多事情做得相当好，但我无法将我没有强烈兴趣的事情做到非常出色。

这道理似乎很简单，但我的观察是，强烈兴趣似乎是一种很稀缺的能力，绝大多数人都有自己感兴趣的东西，但兴趣程度通常一般。哪怕是人人都感兴趣的吃喝玩乐，要说在这方面的兴趣到强烈程度的人，还真是不多见（十年前我说的那个[在世界各个景点跳舞的人](/cn/2008/06/follow-your-heart/)可算一例）。在我身边认识的人里面，我就这么随便一想的话，好像只有鸟兄（张翔）一人而已，像是现代徐霞客。

其七是如何对待打击：

> 你们在生活中可能会遭到沉重的打击，不公平的打击。有些人能挺过去，有些人不能。我认为爱比克泰德的态度能够引导人们作出正确的反应。他认为生活中的每一次不幸，无论多么倒霉，都是一个锻炼的机会。他认为每一次不幸都是吸取教训的良机。人们不应该在自怜中沉沦，而是应该利用每次打击来提高自我。

我[去年提过](/cn/2017/11/epictetus/)爱比克泰德，这一句是我印象比较深刻的：

> 富裕并非拥有许多财产，而是拥有很少需求。

## 第十一讲 人类误判心理学

芒格终于要大谈他感兴趣的心理学了。因为他是班门弄斧，所以他得解释为什么要作为一个外行来讲心理学问题。理由之一是引用第欧根尼：

> 从来不得罪人的哲学家有什么用呢？

芒格讲自己积累了一套自认为有用的心理学体系，这过程就像[小红母鸡的故事](https://en.wikipedia.org/wiki/The_Little_Red_Hen)一样。

> 还有那个保育院故事展现出来的决心：“‘那我就自己来吧。’小红母鸡说。”

再次强调逆向思维和错误的例子：

> 我总是试图通过伟大的代数学家雅各比提倡的逆向思维来考虑问题。【……】我非常热衷于收集错误判断的例子。

他几次提到邪教，但都没深入谈他的研究成果：

> 纯粹的好奇心驱使我去思考邪教的问题，那些毁形灭性的邪教通常只需要一个长周末就能够将完全正常的人转变为被洗过脑的行尸走肉，并永远让他们保持那种状态，它们是怎么做到的呢？

又开始吐槽心理学教科书（无益于他研究邪教）：

> 经济学家雅各布·维纳（Jacob Viner）说过的一句话。他说许多学者就像寻菇犬，人们喂养和训练这种动物来寻找地下的块菌，除了这项专长，它别的什么都不会。

他唯一赞赏过的心理学书籍是《影响力》，这也是我[去年提过](/cn/2017/12/influence/)的。

### 奖励和惩罚超级反应倾向

举例说明联邦快递的工人为什么不能快速完成工作，原因是公司按小时付薪水，那工人当然愿意把时间拖长一些。如果修改一下激励机制，工人会以最快速度完成工作回家：

> 如果他们按照班次来支付薪水，并允许夜班工人在把所有货物装上飞机之后提前回家，那么这个系统会运转得更好。
> 
> 也许最重要的管理原则就是，“制定正确的激励机制。”

惋惜斯金纳过度强调激励机制的威力（不过我注意到斯金纳的一项结论很有意思：随机模式的奖励能使反射行为保持最长时间，这大概可以解释为什么有些本质是随机数发生器的游戏会让人上瘾，包括赌博）：

> “铁锤人倾向”并没有放过布兰夏德和斯金纳这么聪明的人。如果你们不注意的话，它也不会放过你们。

谈激励机制引发的偏见，比如所谓的专业人士总想绑架客户，让你一直使用他的服务：

> 在我这漫长的一生中，我遇到过的管理顾问没有不在他们的报告结束时写上这个相同的建议的：“这个问题需要更多的管理顾问服务。”

如何应对这样的有潜在偏见的专业顾问？

> 1. 如果顾问提出的专业建议对他本身特别有利，你就应该特别害怕这些建议；
> 
> 2. 在和顾问打交道时，学习和使用你的顾问所在行业的基本知识；
> 
> 3. 复核、质疑或者更换你得到的建议，除非经过客观考虑之后这些建议看起来是合适的。

收款机与激励机制的联系（收银员无法揩油）：

> 收款机的发明能够使不诚实的行为难以得逞，所以它对文明社会作出了杰出的贡献。

斯金纳的研究结论之一（所以千万不要奖励坏行为，比如员工从店里偷钱）：

> 得到奖励的坏行为特别容易形成习惯。

收款机的发明者帕特森说（意思是你死了带不走你的钱，所以不如生前多做慈善）：

> 寿衣没有口袋

芒格是如此赞赏收款机这个发明对人类文明的贡献，称帕特森配得上这个墓志铭：

> 罗马诗人贺拉斯自撰的墓志铭：“我并没有彻底地死去。”

批评心理学的教科书不谈激励机制引起的偏见和对策：

> 如果有的事情在生活中极为明显，但很难通过容易做的、可重复的学术实验得到证明，那些心理学的寻菇犬就会忽略它。

激励机制引起的偏见会让人钻制度的空子，所以立法机构应该多了解这些偏见：

> 如果高等学府提高教育质量，传授更多的心理学知识，而学生也能吸收更多心理学知识，那么我们的立法机构和法院将会设计出更好的制度。

一个简单有效的奖励系统（斯金纳说即时奖励最有效）：

> 祖母的规矩就是要求孩子在吃甜点之前先把他们的胡萝卜吃掉。

惩罚的效果：

> 惩罚也强烈地影响到行为和认知，尽管它的弹性和效果不像奖励那么好。

### 讨厌/憎恨倾向

巴菲特的讽刺：

> 穷人和富人的主要区别是，富人能够一辈子起诉他们的亲戚。

讨厌和憎恨让人忽略对方的优点、恨屋及乌、扭曲事实。

### 避免不一致性倾向

为了节省运算空间，人类大脑不愿作出改变：

> 没几个人能够列出许多他们已经改掉的坏习惯，而有些人哪怕连一个都列举不出来。与此相反，几乎每个人都有大量持续很久的坏习惯，尽管他们自己也知道这些习惯不好。

引用富兰克林（防止坏习惯的养成比改变已有的坏习惯要容易得多）：

> 一盎司的预防比一磅的治疗更值钱。

新思想为什么难以取代旧思想：

> 正如在世界顶尖大学任教的凯恩斯爵士谈及他那些高级知识分子同事时指出的，新思想之所以很难被接受，并不是因为它们本身太过复杂。新思想不被接受，是因为它们与原有的旧思想不一致。

又来怒赞达尔文：

> 查尔斯·达尔文是最成功地化解第一结论偏见的人之一。他很早就训练自己努力考虑任何有可能证伪他的假说的证据，尤其是在他认为他的假说特别出色时更是如此。

仪式是为了建立一致性：

> 所以文明社会发明了许多庄严肃穆的入会仪式，这些仪式通常是公开举行的，能够让新成员更加忠心。

我们可以利用这种人脑避免不一致性的倾向：

> 这种倾向通常会使人们成为被某些有心机的人所操控的“受害者”，那些人能够通过激发别人潜意识中的避免不一致性倾向而博取对方的好感。

举例仍然是富兰克林，作为一个小人物如何让大人物上钩帮忙？先让大人物帮他的小忙：

> 经常设法请那个人帮他一些无关紧要的小忙，比如说借一本书给他之类的。从那以后，那个大人物就更加欣赏和信任富兰克林了，因为一个不值得欣赏、不值得信任的富兰克林与他借书给富兰克林的行为中暗示的赞许并不一致。

这种倾向可以用来培养善意，也可以培养恶意：

> 如果有个人受到操控，故意不停地去伤害另外一个人，那么他就会倾向于贬低甚至憎恨那个人。

不要向年轻学生灌输值得怀疑的政治理念：

> 我认为那些有这种风气的教育机构是很不负责任的。在一个人心智尚未完全成熟之前，不能给他的头脑套上一些锁链，这是很重要的。

### 好奇心倾向

点出了教育机构常被忽略的一个功能：

> 最好的现代教育机构（这样的机构在许多地方都为数甚少）能够增强人们的好奇心，而好奇心则能帮助人们防止或者减少其他心理倾向造成的糟糕后果。好奇心还能让人们在正式教育结束很久之后依然拥有许多乐趣和智慧。

### 回馈倾向

回馈指以德报德或以牙还牙。化解过激的敌意的方法（托马斯 · 墨菲）：

> 如果你觉得骂人是很好的主意，你可以留到明天再骂。

销售人员会利用顾客潜意识中的回馈倾向先为你提供一个小的恩惠（比如为你冲一杯咖啡），然后获得你的更大回馈，比如多付五百美元。如果这五百美元要让你自掏腰包，你可能不会上当，但如果是别人买单，你可能就会轻易上钩了。

> 这种潜在的损失多少会让你对销售员的示好保持警惕。但假如你是采购员，花的钱来自别人——比如说某个有钱的雇主，那么你就不太会因为要额外付钱而反感销售员的小恩小惠，因为多付出的成本是别人的。在这样的情况下，销售员通常能够将他的优势最大化，尤其是当采购方是政府时。

西奥迪尼在校园中做了一个实验，先让大学生无条件每周花大量时间去照顾少年犯，结果没有人愿意干这事，然后实验员紧接着问你是否愿意每周花一个下午带少年犯去参观动物园，接受率则大大提高（这有点类似锚点效应）：

> 西奥迪尼的实验员所做的是作出小小的让步，于是对方也作出了小小的让步。

宗教中的回馈心理（古罗马人认为杀人献祭可以得到上帝的帮助从而打赢战争）：

> 人们基于回馈心理，认为只要行为端正，就能从上帝那里得到帮助，这种观念有可能一直以来都是非常具有建设性的。

人类对取悦而不是被取悦更感兴趣：

> 人类生活中最美好的部分也许就是情感关系，情感关系中的双方更感兴趣的是如何取悦对方，而非如何被取悦——在回馈倾向的作用之下，这样的情况并不算罕见。

### 受简单联想影响的倾向

如何避免因为过去的成功而做蠢事（比如在赌场赢了钱而继续赌下去）：

> （1）谨慎地审视以往的每次成功，找出这些成功里面的偶然因素，以免受这些因素误导，从而夸大了计划中的新行动取得成功的概率；（2）看看新的行动将会遇到哪些在以往的成功经验中没有出现的危险因素。

憎恨和讨厌引发的简单联想错误：

> 我常常看到人们贬低他们讨厌的竞争对手的能力和品德。这是一种危险的做法，通常不易察觉，因为它是发生在潜意识层面的。

波斯信使综合征：

> 古代波斯人真的会把信使杀掉，而这些信使惟一的过错是把真实的坏消息（比如说战败）带回家。对于信使来说，逃跑并躲起来，真的要比依照上级的心愿完成使命安全得多。

哥伦比亚广播公司的前董事长佩利就有波斯信使综合征：

> 【……】特别讨厌那些告诉他坏消息的人。结果是，佩利生活在谎言的壳子之中，一次又一次地作出了错误的交易，甚至用大量哥伦比亚广播公司的股票去收购一家后来很快被清盘的公司。

伯克希尔如何对待坏消息：

> 伯克希尔有一条普遍的规矩：“有坏消息要立刻向我们汇报。只有好消息是我们可以等待的。”还有就是要保持明智和消息灵通，那就是让人们知道你有可能从别处听说坏消息，这样他们就不敢不把坏消息告诉你了。

### 简单的、避免痛苦的心理否认

再次引用这句话来推行对抗心理否认的方法：

> 未必要有希望才能够坚持。

### 自视过高的倾向

禀赋效应：

> 人们一旦拥有某件物品之后，对该物品的价值评估就会比他们尚未拥有该物品之前对其的价值评估要高。这种过度高估自己的私人物品的现象在心理学里面有个名称：“禀赋效应”。人们作出决定之后，就会觉得自己的决定很好，甚至比没作出这种决定之前所认为的还要好。

大义灭亲者对文明社会的贡献：

> 我们这个文明社会中最有用的成员就是那些发现他们管理的机构内部出问题时愿意“清理门户”的负责人。

面试者往往更看重自己在面试过程中的判断，而轻视求职者过去的业绩（芒格任某学术招聘委员会主席时都不走常规招聘程序，称只需要看书面材料就够了，无需面试）：

> 自视过高往往会导致糟糕的雇佣决定，因为大部分雇主高估了他们根据面试印象所得结论的价值。防止这种蠢事的正确对策是看轻面试的印象，看重求职者以往的业绩。

人会为自己的糟糕表现找借口：

> 我听过一个教育孩子的故事特别有效，那个孩子过了50年还对学到的教训念念不忘。那孩子后来变成了南加州大学音乐学院的院长。他小时候曾经从他父亲的老板的仓库里偷糖果吃，被他父亲发现之后辩解说，他打算过会就放回去。他父亲说：“儿子，你还不如想要什么就拿什么，然后在每次这么做的时候，都把自己称为小偷。”

强迫自己客观：

> 避免因为自视过高而做傻事的最佳方法是，当你评价你自己、你的亲人朋友、你的财产和你过去未来的行动的价值时，强迫自己要更加客观。这是很难做到的，你也无法做到完全客观，但比起什么都不做，放任天生的心理倾向不受约束地发展，却又好得多。

### 被剥夺超级反应倾向

这个倾向我在几个月前[谈爆栈网的投票机制](/en/2018/05/right-easier-than-wrong/)时提过，大意是被剥夺比得到更让人痛苦，比如有人不加解释地给你的帖子来个负分就会让你感到很恼火，而被点赞则感觉了了。

具有团体意识的组织都会倾向于拒绝与自身知识有矛盾的外来知识。

> 被剥夺超级反应倾向通常能够保护意识形态观点或者宗教观点，因为它能够激发直接针对那些公开质疑者的讨厌/憎恨心理倾向。这种情况会发生，部分原因在于，这些观点现在高枕无忧，并拥有强大的信念维护体系，而质疑者的思想若是得到扩散，将会削弱它们的影响力。

为什么宗教团体要用酷刑惩罚背叛的信徒：

> 当公开批评者是一位从前的信徒，那么敌意会更加强烈，原因有两个：（1）遭到背叛会激发额外的被剥夺超级反应倾向，因为失去了一名同志；（2）担心那些矛盾的观点会特别有说服力，因为它们来自一个先前的同志。前面提到的这些因素有助于我们理解古代人对异教徒的看法。数百年来，正统教会基于这样的理由杀害了许许多多异教徒，而且在杀死他们之前通常还会施以酷刑，或者干脆就将他们活活烧死。

如何对抗团体意识：

> 有一种办法能够化解这种受到刻意维护的团体意识，那就是建设一种极端讲礼貌的文化，哪怕双方的意识形态并不相同，但彼此之间要保持彬彬有礼，就像现在美国最高法院的行为那样。另外一种方法是刻意引进一些对现在的团体意识抱怀疑态度而又能力突出、能言善辩的人。德雷克·伯克（注：德雷克·伯克，1930—，美国律师和教育家，哈佛大学前校长）曾经成功地改变了一种造成糟糕后果的团体思维。他在担任哈佛大学校长期间，否决了不少由哈佛法学院那些意识形态很强的教授所推荐的终身教职人选。

赌徒的被剥夺超级反应倾向：

> 被剥夺超级反应倾向也是导致某些赌徒倾家荡产的重要原因之一。首先，它使得赌徒输钱之后急于扳平，输得越多，这种不服输的心理就越严重。其次，最容易让人上瘾的赌博形式就是设计出许多差点就赢的情况，而这些情况会激发被剥夺超级反应倾向。有些老虎机程序设计者恶毒地利用了这个人性弱点。电子技术允许这些设计者制造出大量无意义的“BAR-BAR-柠檬”结果，这些结果会促使那些以为自己差点赢得大奖的蠢货拼命地继续加注。

### 社会认同倾向

朱迪斯（《教养的迷思》）研究发现，孩子最尊重的是他们的同龄人而不是父母或其他成年人：

> 所以对于父母来说，与其教训子女，毋宁控制他们交往朋友的质量。后者是更明智的做法。哈里斯女士在新发现的理由支持之下，提供了一种如此优秀和有用的见解，像她这样的人，真是没白活。

社会认同倾向的最佳影响时机（比如销售人员在封闭环境下给一群人压力、或邪教如何让人入教）：

> 在既困惑又有压力的时候，最容易受社会认同倾向影响。

社会认同倾向还会让我们目击暴行时集体袖手旁观。

### 压力影响倾向

芒格再次怒赞巴甫洛夫，尤其是高度评价他在著名的条件反射发现之后继续对狗做各种残忍的实验。他认为做这些实验带来的好处（对心理机制的了解）远胜于保护狗狗的爱心：

> 现在，几乎每个人都会抗议拿狗这种人类的朋友来做实验。【……】很明显，巴甫洛夫是当今医学界被遗忘的英雄。

芒格敢这样讲，原因之一是：

> 我对社会禁忌向来很反感。

这一段肯定会引起动物爱心人士的强烈抗议，但跟前面他反对工伤赔偿制度一样，表面上很残忍，实际上只不过是优化的目标跟其他人不一致而已。他要优化的是整体人类的利益，这过程中必然会损失到一部分人或物种的利益。

表扬前面提到的朱迪斯（像达尔文一样的思维方式）：

> 毫无疑问的是，热衷于摧毁自己的观念也是促使她成功的因素之一。

## 不那么沉默的合伙人

这是一篇关于芒格的小品文（合伙人指的就是芒格）。根据芒格的描述，似乎有一类保险业务很让保险公司伤脑筋：

> 伯克希尔的保险业务如此成功，是因为它从来不接跟石棉和环境伤害有关的保单，许多保险公司就因为接了这些保单而破产。

他们引以为豪的保险公司总部很低调（巴菲特风格）：

> 但别费力在国民保险公司的办公室寻找豪华轿车或者古董。它的总部依然位于奥马哈市一座不起眼的写字楼里，职员人数也并不多。

芒格和巴菲特都不认同华尔街的赚钱方式，也反对频繁的证券交易：

> “整个投资管理业并没有给所有股票组合的所有者们增加任何价值，”芒格说，“管道维修业的情况不是这样的，医疗行业的情况也不是这样的。沃伦百分之百赞同我的观点。我们看到聪明人准备进入投资管理业就会摇头。那是对天赋的浪费。”

成功人士的赎罪：

> “凯恩斯通过为他的大学赚钱和为国家服务来赎回他的‘罪’。我的赎罪方式是参加许多和投资无关的社会活动，沃伦的赎罪方式则是用他的投资成功来充当一名伟大的导师。我们热爱为那些早就信任我们、当我们年轻而贫穷时就信任我们的人赚钱。”

## 乐观主义在会计中没有容身之地

这是芒格在安然丑闻事件之后发表在《华盛顿邮报》上的短文，主旨是会计准则需要建立在悲观谨慎的态度上。

> 公众已经注意到那些为非作歹者的错误，并呼吁对他们施以更严厉的刑事处罚。但公认会计准则的错误更为重要，因为改变这些会计准则，以及它们被采用的方式，能够有效地防止未来再出现安然这样的大灾难。【……】从会计准则中得到最大安全的办法是，强制人们在做账的时候采用悲观谨慎的态度。长远来看，悲观谨慎的会计将会给公众带来巨大的利益，而几乎不会对公众造成任何危险；而乐观主义的会计是对公众的一种威胁。【……】安然对其衍生品交易采用乐观的会计，对太多可疑的、尚未收回的收入进行“提前处理”，在账本上把它们记为利润。

谁获益，谁就会为蠢事说好话：

> 那些从蠢事中获益的人往往会对蠢事大加称赞，而消除蠢事会让某些人感到痛苦。

## 贝西克兰兴衰记

这是一篇芒格虚构的寓言，基于一片孤岛（贝西克兰，Basic Land）创造了一个小国家，然后讲它的兴衰史。建国之初严禁投机行为、证券期权或衍生品：

> 除了一种在严格限制财务杠杆作用的法律下产生的通过可靠的交易所而签订的“普通”商品交易合同外，没有任何证券期权或衍生品的交易行为。

由于国家发展得太好，国民无所事事就开始赌博，导致国家衰落。芒格又一次揶揄了[金融衍生品](/cn/2018/01/derivatives/)：

> 这种赌资现在被称为“金融衍生品”。

## “贪无厌”“高财技”“黑心肠”和“脑残”国的悲剧

芒格用讲故事的方式重述次贷危机的整个过程，以凯恩斯的话结束：

> 当一个国家的资本发展成为赌场式操作的副产品时，结果可能会很糟糕。

好了，花了三天终于写完了，这好像是我有史以来最长的一篇日志，不过主要是因为引文比较长。

初读芒格可能会觉得这老头是个自大狂，观点好尖锐。不过作者是不是自大狂跟我们是不是读他的书也没啥关系，我们要看的不是态度，而是事实与真理。我觉得成功人士通常都会在某些方面有些极端，要是没有明显过人之处，他们也不会出类拔萃。芒格对金融衍生品的绝对排斥可能值得推敲，但对心理学（我很犹豫要不要加“学”这个字）的观察和总结还是很有智慧的。他提倡的跨学科思维、逆向思维、自我批评都很值得学习。
