---
title: 如何在 Markdown 中引用诗词或歌词
date: '2018-07-07'
slug: quote-poem
---

在 blogdown 包提供的诸多 RStudio 插件中，我个人最满意的当然是“[New Post](https://bookdown.org/yihui/blogdown/rstudio-ide.html)”这个插件，可以说它彻底扫清了我写日志的启动障碍。过去我用 Jekyll 写日志之所以感觉写不下去是因为启动的心理成本太高：需要手工建一个 Markdown 文件，然后手敲一系列 YAML 元数据（标题、日期之类的），最后才能开始写正文。因为这第一步我都不想做，所以也不用谈写日志本身。

如今在 blogdown 中新建一篇日志就像用 WordPress 或其它有图形用户界面的网站系统一样，所以我可以写得飞起。不过偶尔还是会碰到一些需要手工重复劳动的事情，其中之一就是引用诗词（或歌词）。因为是引用，所以语法是每一段前加 `>`，但问题是如何保持换行。在 Markdown 语法中，普通的换行（敲一下回车键）是没有意义的，它跟空格没有区别。只有在代码块中，普通换行才会被保留。在非代码环境中，如果需要一个硬换行，那么需要在行末加两个空格。

如果没有行末的两个空格：

```
> 缺月昏昏漏未央，一灯明灭照秋床。
病身最觉风露早，归梦不知山水长。
坐感岁时歌慷慨，起看天地色凄凉。
鸣蝉更乱行人耳，正抱疏桐叶半黄。
```

那么引用出来的效果如下：

> 缺月昏昏漏未央，一灯明灭照秋床。
病身最觉风露早，归梦不知山水长。
坐感岁时歌慷慨，起看天地色凄凉。
鸣蝉更乱行人耳，正抱疏桐叶半黄。

因为我自己经常需要引用诗词和歌词，所以前段时间干脆在 blogdown 里写了个 RStudio 插件，让用户可以在 RStudio 中选择几行文字，然后点“Quote Poem”插件，就可以自动加上引用符 `>` 和行末两个空格了（下面的空格肉眼不可见，除非鼠标选中文字）：

```
> 缺月昏昏漏未央，一灯明灭照秋床。  
病身最觉风露早，归梦不知山水长。  
坐感岁时歌慷慨，起看天地色凄凉。  
鸣蝉更乱行人耳，正抱疏桐叶半黄。
```

上面的源代码输出的结果才是正确的：

> 缺月昏昏漏未央，一灯明灭照秋床。  
病身最觉风露早，归梦不知山水长。  
坐感岁时歌慷慨，起看天地色凄凉。  
鸣蝉更乱行人耳，正抱疏桐叶半黄。

那有人可能会问，既然代码块环境能保留换行，那怎么不用代码块环境呢，在每一行后面都加两个空格好麻烦哦：

````
```
缺月昏昏漏未央，一灯明灭照秋床。
病身最觉风露早，归梦不知山水长。
坐感岁时歌慷慨，起看天地色凄凉。
鸣蝉更乱行人耳，正抱疏桐叶半黄。
```
````

代码是代码，引用是引用，这是两码事，语义完全不同，而且通常样式也不同。要是你把引用的文字放在代码环境中，或者把代码放在引用环境中，我会宰了你。

附注：以上的例子是王安石的诗。我看到这首诗是因为朱自清考证月夜到底有没有可能有蝉声（有人质疑他的《荷塘月色》中的蝉声）。同时这又是一个[叠字](/cn/2018/05/reiterative-character/)的例子。
