---
title: 财务自由
date: '2018-06-27'
slug: financial-freedom
---

世上还有哪个词比“财务自由”更吸引人的吗？恐怕是没有了。当然，圣贤除外，但圣贤毕竟是少数。我不是圣人，所以我也一样爱财，只不过在目前的工作状态下我并不贪财而已。我对财富的渴望并不在于财富本身，而在于重分配权。换句话说，我并没多少需要满足的个人物欲，我有兴趣的只是将财富按照我的意愿重分配给他人。本质上这其实是自私的想法（比如我认为索罗斯做慈善完全是自私的行为，其敛财手段太卑劣）。

我不知道将来会不会有这么一天我能按我的意愿自由分配财富。以前我并没有想过这个问题，只是得过且过，今年看《原则》时它才正式浮现到我脑中。上个月注意到一个叫 [Afford Anything](https://affordanything.com) 的网站，发现站长的很多观点和我很有共鸣，于是邮件订阅了一下，然后每周大概会收到一到两封邮件，宣讲她的观点，讲如何通向财务自由。看了这么多邮件之后，我想集中总结一下，并混杂一些我的想法。

## 如何创造一个赚钱的副业

不要过度节约或盲目省钱，比如不要花一个小时找优惠券就为了省一块钱，要考虑省下的钱对应的时间、心理和精力成本。

没时间做一项副业？整块时间可能是没有，大家都很忙，但每天二十分钟也许是有的。你每天刷微信微博的时间应该会大大超过二十分钟吧？早上起床前和晚上睡觉前是不是绑在手机上？想想从那里你得到了什么，再想想你为什么穷（本来你很富，可是你把最宝贵的资源——时间——都心甘情愿支付给了网红、大咖和点赞之交们[^1]）。

太累没精力？找适合自己的解决疲惫的办法，比如大量喝水（中国人的普世药方）、少沾酒精、不要暴饮暴食、多吃水果、减少日常决策。我个人尤其看重最后一项：决策疲劳是一种很普遍但又隐形的疲劳。比如我几乎从来不用想每天穿什么衣服，反正我一年四季都在家，也很少专门花时间琢磨做什么饭（我一般在买菜时就大致想好了，做饭时只需要打开冰箱几秒钟就可以决定）。

不知如何创业？这才是关键问题。你的副业应该具备三个特征：工作时间灵活（无须早九晚五）、在家就可以工作、能赚钱。怎样的项目有这样的特点？站长认为你的副业收入必须是基于互联网的，但不意味着你得开网店或做微商，而是说以互联网为媒介。不要问你想做什么样的项目，而是问你可以帮到谁。想好你想帮什么群体的客户之后，再去获得你需要的技能，比如搭网站。

我觉得站长说的三个特征还缺了一个重要特征：有扩展性。这个特征也许包含在第三个特征“能赚钱”中了。可扩展的意思是你的业务增长几乎独立于投入的人力，比如如果你投入一年时间创建了一个会员网站，你得保证将来会员数量翻倍时不需要你再投入一年时间进去，要能让这个网站有自行发展壮大的能力。这一点很重要，否则创业者肯定会扛不住。比如我要是想做一项副业，我肯定不会选择提供 R 语言问题的个人咨询，就算它是我的长项，我也只能一次帮一个人，这不会有规模效应。相比之下，如果我能每次回答问题之后都录一个相应的视频存入一个收费网站让后来者观看，那么这个网站也许可以为我带来持续的收入，而我不必去面对单个的客户，即：用视频代替我的肉身。

## 幸福生活的公开秘诀

让生活变得幸福的秘诀绝对不在于买买买，而在于两个字：感恩（或知足）。多数人的物质生活已经够幸福了：有水、有电、有网、有空调、有沙发、有西瓜。某种程度上来说，我们都已经财富自由了。想一想吧，世上还有人穷到需要杀死自己的四个孩子再自杀，还有国家在战乱中，还有人喝不到干净的水、吃不饱饭。

前面《[爱比克泰德](/cn/2017/11/epictetus/)》中我引用过：富裕并非拥有许多财产，而是拥有很少需求。

当然，看见更好的生活能不动心没那么简单。罗隐在《英雄之言》中说连英雄豪杰如刘邦、项羽都会因为看见秦始皇的骄奢生活而动心想取而代之，凡人就更不必说了。

> 意彼（刘邦和项羽）未必无退逊之心、正廉之节，盖以视其（秦始皇）靡曼骄崇，然后生其谋耳。为英雄者犹若是，况常人乎？

赫拉利《人类简史》第十九章《从此过着幸福快乐的日子》提到了类似的观点（举例是 2011 年埃及革命）：

> 有没有可能，第三世界国家之所以会对生活不满，不只是因为贫穷、疾病、腐败和政治压迫，也是因为他们看到了第一世界国家的生活标准？

## 简化优于优化

优化的意思是最大化你的财富。把财富最大化作为目标是不明智的，因为无条件最大化财富会大大分散你的精力，比如为了五十块钱的开户奖励而开个银行账户、为了省五分钱去一个远的加油站加油。最大化财富的问题在于可能的路径太多，选择太多，你不可能照顾到这么多选择，你得更有效地利用你的脑力，把少数几件事做到极致。

## 房东的噩梦

站长是靠投资房产通往财务自由的。把房子租给别人，不可避免会遇到糟糕的租客。有一封邮件中她分别讲了一个好房客、一个普通房客和一个糟糕房客的例子。糟糕的例子是房客搬走之后家里脏得不像样。最后的结果是她找来她认识的清洁工和维修工，和他们一起打扫房子，在二十四小时之内像打仗一样把房子打扫干净、全面重新粉刷、并撤换地毯。预估花费四千美元。下一个租客在第二天搬进来的时候完全不会想到就在二十四小时前这个房子还脏得像猪圈。

站长说这是作为房东来说最坏的噩梦，但也不过如此，一年最多发生一两次。财务自由不意味着你光躺着数钱，有时候还是需要卷起袖子上阵冲锋的。

从这个过程描述来说，我感觉她蛮会鼓励工人的。一般情况下我觉得那些清洁公司不会愿意下班后还帮你干到半夜一点。大约是她的拼命精神打动了他们，完成这个看似不可能的任务之后，大家一起蹲着吃盒饭，我想他们心里应该是充满了成就感（工作被赋予了特殊意义——救人于危难，而不是普通的打扫和维修）。

## 斗战胜佛

你的生活一团糟，事情堆积成山。如何让自己变得不可战胜？站长认为要培养习惯，只有习惯的力量是不可战胜的。生活的衣食住行方方面面都要朝着有利于培养习惯的方向优化，比如多喝水、不吃垃圾食品、不要吃午饭（她指的应该是上班族中午午休花很长时间出去吃一顿饭）、每天锻炼二十分钟。然后用一串小事启动大事，并把这种行为培养成习惯。

## 拥有越多，价值越小

站长以照片为例子，问：你的手机拍了那么多照片，有几张是你过几天还会再看的？如果不看，你拍了作甚。在照相这个问题上，我比较极端（尤其是近年来），我是不爱拍照的人。我基本只用脑子记住我记得住的画面，若实在记不住，忘了就忘了。

拥有的物件多了之后，其实你分不清是你占有着这些物件，还是物件占有着你（这就跟《人类简史》中说的不知道究竟是我们驯化了农作物还是农作物驯化了我们一样）。东西多的结果是你需要花时间整理、存取、升级、维护。少而精，不要多而泛。站长推荐了《怦然心动的人生整理魔法》，这是我[以前提过的](/cn/2015/10/tidy/)。

## 本能的恐惧与逃避

大脑里的杏仁区负责直觉反应，前叶负责理性思考。当人遇到危险或困难时，容易被杏仁区主导，下意识地会逃跑或退却。美国海豹突击队的选拔测试中有一项就是选拔能用前叶克制住杏仁区的人：让候选者带着氧气瓶沉到水底，然后突然把他的氧气管子打个结让他无法呼吸，一般人的反应会是赶紧浮出水面，不然会窒息，而有人则会冷静地考虑如何把管子重新打开。

当遇到你不想或不敢做的事情时，先去想做这件事需要哪些步骤。考虑步骤，而不要考虑那个也许很可怕的后果，这样会让你更容易着手做这件事，而不是让杏仁区控制你。

## 任何与所有

这个网站的核心观点是很简单的一句话：

> You can afford anything, but not everything.

即：你负担得起任何东西，但负担不起所有东西。比如相当一部分人只要努把力，应该都有财力满足任意一项心愿，但没有人能够满足所有心愿（就算你是王思聪也没这个本事——比如你花钱把天安门城楼上的那幅头像换成你自己的试试）。这条定理可以有很多推论，比如码农可以实现任何软件功能，但不能实现所有功能，或修正任何缺陷，但不能修正所有缺陷（高德纳大人除外）。如果没有优先级和适当的取舍，我们的生活注定会浑浑噩噩。

## 时间是如何蒸发的

站长每隔 15 分钟记录、跟踪一下自己当前正在做的事情，也就是每周记录 672 次（4 x 24 x 7）。结果发现时间的蒸发通常是由于两个任务切换之间的漫无目的游荡，也就是当你做着一件事想起做另一件事，起身去做那件事时，被一路上其它的事情吸引了注意力，导致你去做一些计划之外的事情。并不是时间不够用，而是你没有真正注意你的时间花在哪儿。

## 如何打破一个坏习惯

当你养成一个坏习惯时，你可以从五个方面分析这个坏习惯是怎么来的：

- 地点
- 时间
- 情绪状况
- 他人
- 触发这个坏习惯之前你在做的事

每次坏习惯侵蚀你的时候，都把这五方面的因素记录下来，然后分析一下究竟是什么本质原因触发了这个坏习惯。比如你要是总想出去吃餐馆，也许只是因为你工作倦了想换个环境，而换环境有很多种办法，比如你去健身、散步都可以换环境，这些都是更健康的换环境的方式。

## 为自己而活还是为别人的期望而活

我们总是操心自己在别人眼中的形象如何，但别人如何看待我们，这是我们自己无法控制的。我们能控制的只有我们自己，把自己该做或认为有价值的事情做好，至于别人如何评论，则随他去吧。不要盲目听从别人的意见，不要因为他们认为你应该做什么，你就去做什么。

每天要勇敢地做一点自己不敢做的事情。接受他人可能会不喜欢你或你做的事情这样的事实。做自己，过你自己内心期待的生活，与他人无关。

## 如何达成目标

就动力而言，内驱比外驱更有效。有些事情换一种说法就可以把低效的外驱转变为内驱。比如“我要每个月多挣一万”就是外驱的方式，而“我要挑战自己更好地经营我的生意”就更像是内驱。外驱通常是结果导向的，而不问是否享受过程（如减肥）。

谨慎用一件事去奖励另一件事。比如用看一小时电视作为读一小时书的奖励，这样是在暗示读书乏味无趣，而看电视则有趣得多。

设置过于明确的目标可能会让你失去更大的愿景。比如福特曾想制造“重量两千磅以下、售价两千美元以下”的汽车，结果造出来的车有重大安全隐患，没法给人开。

把目标替换为行动计划能减少你的压力，并有助于真正实现目标。比如如果目标是“我要写一本书”，这听起来很可怕，所以不要这样讲，而是换成“我每天上午九点到十一点是写书的时间”；或者如果目标是“我要减肥十斤”，那么可以替换为“我每天下午四点运动半小时，晚餐吃沙拉”。目标会因为行动的执行而自然达成，你不必每天顶着个巨大的目标而活。

## 狄德罗效应

法国作家狄德罗青年时期退学想成为一名作家，这与其父的意愿相悖，所以其父与之断绝了父子关系，而狄德罗也失去了经济来源。在贫困的朴素生活里，他在简单的一桌一椅上却非常高产。后来他的贫困和著作引起了俄国的叶卡捷琳娜二世的注意，后者向他提供了巨额的经济支持。于是狄德罗开始换了一件新袍子；过了一阵，为了与新袍子相配，他把嘎吱响的破椅子也换了，再后来就是桌子、镜子、金钟……最终花光了俄皇给他的资助。

买买买会产生惯性，买了一样东西，就会觉得家里其它东西也需要更换，从而可能会一直买下去。这就是狄德罗效应。比如住公寓时，家里最多摆得下一张长沙发；等买房之后，看着空旷的客厅，便想着要两张沙发，或是看着空旷的卧室，想着再买几张床；买了一身好上衣，便想配好裤子；买了好裤子，又想配好鞋；买了高档厨具，便想买更高档的食材；买了好车，便想加更好的汽油。

由俭入奢易，由奢入俭难。我们还回得去过去的简单生活吗？

## 巴甫洛夫的狗的后半段故事

关于巴甫洛夫的狗，想必是人人皆知的故事了，不就是条件反射嘛；然而这个故事并不是到摇铃铛流口水就结束了。后来有一次巴甫洛夫的实验室被洪水淹了，而狗还被关在实验室里。那些狗在快被淹死的惊恐和绝望中挣扎着活了下来。等它们被转移到安全的地方之后，巴甫洛夫发现狗拒绝进食，之前建立的条件反射规律被打破了。巨大的精神创伤可以打破动物的习惯。再后来，巴甫洛夫发现，如果饲养员陪伴着这些狗的话，它们就又开始进食了。这个故事的旨意是：当你感到迷惘时，不妨与其他人建立连接，这样更容易让你找回自己。

[^1]: 我不是鼓励不要关心朋友，我只是觉得一个普通人能真正关心的朋友数量绝对比朋友圈的量级小得多。
