---
title: 是莽撞人就来单挑：一个所见即所得的（R）Markdown 编辑器？
date: '2018-06-20'
slug: wysiwyg-r-markdown
---

**2020-12-14 更新**：好了，不用折腾了。[RStudio 可视化编辑器已经横空出世](https://rstudio.github.io/visual-markdown-editing/)。请忽略下文。

---

纯就编辑体验来说，R Markdown 写写中小型文档还可以，但到了写大规模的文档就有点令人头疼了，比如写书。这种情况下需要尽可能减少分心因素，不然很难连续取得进展，而坦白说，阅读大型 Markdown 源文档并不是一件让人愉悦的事情，让我写书的时候有些眼乏。其实我的不满之处并不多：

1. 我不喜欢看见表示斜体的下划线和表示粗体的双星号，我想直接看见斜体和粗体。

1. 我不喜欢看到超级链接，尤其是链接很长的情况下，很是干扰阅读；若链接能直接附着在文字上会好很多（可以像 Google Doc 那样点击编辑更新链接）。

1. 章节标题在源代码编辑器里没什么醒目标记，上下翻阅文档时，基本不知道自己看到哪一小节了。

除这些之外，引用和列表如果能以可视化形式表现出来更好，但看它们的源代码也不是太让人不舒服，而且我写书的时候并不常用引用段落。

所见即所得的编辑器容易被高级码农吐槽和鄙视，我自己也经常吐槽 Word，认为纯文本文件优于用手直接戳戳戳的二进制文件。那我怎么现在又开始期盼所见即所得的编辑器了呢？其实并没有，我并不想要一个完全的所见即所得编辑器，我只希望上面三个元素的源代码能暂时藏到屏幕背后去，我们编辑的仍然是一个 Markdown 文档，只是略微换一种让作者更舒服的展现形式而已。

本厂 RStudio 近期还没有把编辑器变成所见即所得的计划，所以我把想法写出来，看看是否有莽撞人能来揭榜。这事有两条可能的路：

1. 如果你精通 JS/HTML，你可以从头写一个编辑器，实现上面三项需求。

1. 如果你想站在巨人肩膀上，我已经花了一些时间调查了一大圈，各种所见即所得的编辑器中，我觉得有戏的是 [ProseMirror](http://prosemirror.net) 和 [Toast UI Editor](https://github.com/nhnent/tui.editor)。目测前者轻一些，后者重一些（而且暂时[不适合写代码段](https://github.com/nhnent/tui.editor/issues/186)）。

当网页版的编辑器搞定之后，剩下的事情就是如何把编辑的内容和本地文件关联起来，也就是如何打开和保存文件。此时又有两条路：一是用 Shiny，框架现成（比如点保存按钮之后就 `writeLines()`），但重一些；二是自制一个能在 R 环境中通过网页读写本地文件的工具，这个其实也并不太难，看看我的 [servr 包](https://github.com/yihui/servr)如何借力 httpuv 大概能明白（通过 Websockets 与 R  交流）。当然，等 [Chrome 的文件读写](https://developers.google.com/web/updates/2019/08/native-file-system)原生支持出来以后就不用这么复杂了。

这个编辑器的一个明显缺点是，代码段中的代码无法像在 RStudio 编辑器中可以直接运行，但这个问题可能也不是太大的问题，取决于你的 R Markdown 文档有多少需要边写边跑的代码。对我而言，我的写作中并没有多少需要即时运行并看结果的代码。就算需要看代码运行的结果，也可以通过写轮眼的无限月读（`xaringan::inf_mr()`）来实时编译预览，或不可挡的 `bookdown::serve_book()`。即便如此，还是大大损失了 RStudio 的代码功能，如自动补全。比起上面我的三个痛苦，这个代价我可以接受。

好了，需求和可能的实现就说到这儿，再说下去我感觉我自己就快要开挂上场了。下面有请莽撞人登场，况且况且况况且。
