---
title: 软件测试方法之意念力法
date: '2018-05-29'
slug: mind-test
---

上周有 TinyTeX 用户[报告说安装失败](https://github.com/rstudio/tinytex/issues/45)，我放狗一搜，发现已经[有人在 TeX.SE 上报告过](https://tex.stackexchange.com/q/432617/9128)。接下来的事情就比较有戏剧性了，也让我对 LaTeX 这个项目多少又失去了一些信心，因为我一直感到核心开发者似乎并不在乎测试他们的代码。

书说简短。TeX Live 的安装包坏了，但核心开发者自己并没有发现，这也就罢了（说明他们没有自动化测试）；当用户报告出来时，各位可以[掰着手指头数数](https://tex.stackexchange.com/a/432649/9128)这位开发者在答复中说了几遍“should be fixed”但结果是安装包仍然是坏的。我特么追问都快追疯了。但凡有一点靠谱，当用户第二遍报告同样的问题仍存在时，总该自己亲自测试一下了吧（第一遍修正时不测试我就原谅你了），然而并没有，伊仍然只用伊的意念力去测试，于是我得第三遍、第四遍、第五遍测试并回复说安装包仍然是坏的。

我在第一个评论中就建议伊可以用 AppVeyor 云端测试，中间伊诉苦说 SVN 库太大，等等。然而最终呢，还是用了我的建议。其实很简单，几分钟就能搞定基本配置，而且千秋万代都可以用，这种一本万利的事情为何不能早点做。开发者仅仅依赖在脑子里靠意念力测试一下就完事，着实让我等用户心累。

理想情况下，软件发行应该有一个前提条件，就是首先得通过测试。比如这个 TeX Live 安装包是每日自动编译更新的，而更新时并不管它是否真的能用，只是盲目编译。我不知道现代软件开发者里还有多少人用这种盲目的发布方式。如果软件本身是坏的（通不过自动测试），那就先不要自动发布，这难道不是很浅显的道理么。就算盲目发布吧，当出现问题时，是不是该把每日自动更新临时改为手工更新呢？每次修正都又要等至少二十四小时，而且一测再测还是坏的，实在心焦。

当然，写测试是一件体力活儿，并没有什么乐趣，我自己也不是很爱写测试（欢迎用户们帮忙给我的各种 R 包贡献测试），所以我有时也理解为什么别人的软件没有测试，但在这个例子里，这种错误实在太低级了：安装包不能安装，我要这安装包有何用，这样的问题应该是非常容易用自动化方式检测出来的。

顺祝 SVN 早日灭亡。
