---
title: Markdown 用户身上的 LaTeX 遗毒
date: '2018-05-17'
slug: markdown-quotes
---

昨日在 TeX.SE 上[回答了一个问题](https://tex.stackexchange.com/q/431626/9128)，人问怎么双引号 ``` `` ''``` 在 Markdown 中不对劲。我以前好像重复过这句话：Markdown 不是 LaTeX。我以为这是显而易见的事实，但中毒太深的 LaTeX 用户可能会忘记它。只是写一对引号而已，LaTeX 里非得用这种杀马特语法，两个反引号加两个单引号表示一对双引号。也许这样规定语法有它的道理或历史原因，但初学 LaTeX 的人肯定会被这种语法惊到，进而在脑子里记住了一条奇葩规则，然而再也忘不掉，原因便是斯德哥尔摩症（你被劫匪劫持久了会对劫匪产生感情）。等到了简单的 Markdown 世界，本来会飞的你反而连爬都不会爬了。双引号怎么写？双引号特么就是双引号：`" "`，伟大的 Pandoc 自然会帮你翻译成相应的奇葩语法，你不必费那劲琢磨是 ``` `` '' ``` 还是 `&quot;` 什么的。

扎克伯格的套头衫经常被人引作防止决策疲劳的例子，我也是很怕决策的人，尤其是琐碎决策。决策不管大小，都会消耗人的意志力，而意志力是一个有限的东西。在吃饭穿衣这种小事上消磨意志力之后，投入工作的意志力就会减少；扎克伯格放弃穿衣服的决策绝对是明智之举。当然，作为码农，我更怕的是琐碎软件决策，比如一幅图下面要不要加[十像素的边距](/cn/2018/05/10px-margin/)，这种鸡毛蒜皮之事对我意志力的消耗实在是不划算，可这种决策时不时还得做，着实头疼。作为作者，我也怕写作之外的决策。LaTeX 对我而言实在无法让我集中精力写内容，而总是在根据排版结果做一些琐碎决策，比如因为某些字距太大所以要不要另起一段、图漂走了要不要把图的高度缩小一点、不小心触碰到特殊字符然后去查某个字符应该怎么写（经典的例子恐怕是波浪线 `~`），等等。如果作者总在发愁这些事情，那么哪还会有足够的意志力撰写正文。

所以有些人追求极简并不一定是因为就喜欢极简，而是出于被迫：要做的决策越多，决策质量可能也就会相应越低。
