---
title: 用网页技术取代 LaTeX：前传
date: '2018-05-15'
slug: relaxed
---

我一直认为网页技术比 LaTeX 要有趣得多，而且 LaTeX 把作者从样式中解放出来、让人专注于内容写作是天大的谎言。我只相信网页技术（HTML + CSS）能实现这个美丽的梦想，但需要加一个前提，就是基于 Markdown。

LaTeX 的毛病在于语法太奇葩、繁琐，高质量的输出要求高质量的人力投入。显然，有人会幻想，能不能用低人力投入创造高质量文档输出呢？我觉得这不可能，天下没有免费的午餐。不过如果能把这件事加一个前提，它就有可能了，就是控制你使用多种文档元素的欲望。文档元素种类越有限，排版越容易。

LaTeX 在排版方面的强大既是它的优势，又是它的弱势。有人会问，怎么一个软件的强大反而是弱势？对，它太强大了导致本该写内容的普通作者被吸引到排版工作上，强大就变成了缺点，况且强大还要基于对 LaTeX 的深度理解。LaTeX 中可以定义无限多种环境和命令，这也是优点和缺点。

相比之下，网页语言 HTML 只支持有限种标签，也就是说你有学完它的可能性，虽然大多数标签可能你都用不到。这个限制是它的优点。它的兄弟语言 XML 则跟 LaTeX 一样，具有无穷尽自定义的缺点（所以不适合直接写作）。Markdown 则更进一步限制了文档元素的类型，你能写的元素类型非常有限，也就意味着你没有机会去玩花哨的东西。其实这“有限”的文档元素类型已经很丰富了：标题、段落、列表、引用、图片、链接、表格、公式，等等，但人总是太贪心，心甘情愿把自己锁在[功能地狱](/cn/2012/04/reference-and-footnote/)中，并编造出一系列强加于他人的排版规则。

精美的 PDF 的唯一优点就是看上去精美，剩下的跟网页一比简直几乎处处弱到爆，没有交互、没有多媒体、没有自适应、难以原样复制粘贴（可能会有乱码）。说到底，它只是为了打印机而存在，可是[论文一定得打印在纸上吗](/cn/2018/04/paper/)？

用网页技术取代 LaTeX，归根到底其实就一个问题：如何让网页看起来有 PDF 的精良质量？过去我并没有明确的答案，如今在这个问题上至少可以给出一个前传了：有好事者写了一个包，叫 [ReLaXed](https://github.com/RelaxedJS/ReLaXed)，显然这个名字是模仿了 LaTeX 的命名，不过这种风格的名字[敲起来真要命](/en/2017/12/typing-names/)。ReLaXed 便是基于 HTML 和 CSS 排版，从它目前给出的例子来看，PDF 质量有些惊人（尤其是海报的例子），源文档也相对比较简单，我很看好它。

之所以这个只能说是“前传”，还不是正片，是因为它离 Markdown 还差一步，至于这一步是大是小，我现在也没法估计，但起码已经有了曙光。待洒家忙完这上半年的项目之后，再来仔细琢磨一下。当然，莽撞人不必等我，可先行去啃这块骨头。
