---
title: 十像素的边距
date: '2018-05-14'
slug: 10px-margin
---

书接上文的[琐碎律](/cn/2018/05/law-of-triviality/)。这两天正好碰到一个我认为非常典型的琐碎律例子，起因是 GitHub 上的一个 knitr 事项 [yihui/knitr#1543](https://github.com/yihui/knitr/issues/1543)。我想说说我作为开发者为什么不喜欢用户报告这种类型的事项：

1. 最重要的原因当然是因为这本质上是美观问题（请求在 HTML 控件底部留白），不是软件缺陷。但凡涉及到美观的问题，可以说琐碎的可能性都很大，你觉得好看、他觉得不好看，可以无休止争论下去。

1. 这种问题对用户而言有非常简单的解决方案（自定义一行 CSS），而且我已经给了明确的答案。换句话说，我并没有堵死你的路。

1. 这个报告发错了地方（与 knitr 无关），这种事情经常发生，我可以理解，用户往往面对一长串工具链不知道该向谁报告。

1. 这个报告源于一个 [leaflet 事项](https://github.com/rstudio/leaflet/issues/542)，原题主在那里报错了地方，被 leaflet 的一位开发者迁移到我这里，然而我这里仍然是错的地方，被我关掉了，然后另一位 leaflet 开发者也来回帖说发错了地方。至此，一个十像素边距的问题通过原题主惊动了两个 R 包的三位开发者。

1. 原题主并没有放弃，并接着把这个事项[迁移到 rmarkdown 库](https://github.com/rstudio/rmarkdown/issues/1343)中，并且触犯了我的一个大忌：重发问题或报告时，不指出之前在别的地方发过的历史记录，所以新看见这个报告的人不知道之前的回复和讨论。我相信很多人只是出于无心，但我真的很不喜欢这种事情发生。厂长看见了这个事项，决定把我说的那一行 CSS 写进默认模板中。至此，十像素的问题惊动了三个 R 包的四位开发者。

1. 在这个 rmarkdown 事项中，我看见原题主还在另外两个库中记录了相关事项（[BiocStyle](https://github.com/Bioconductor/BiocStyle/issues/47) 和 [openrouteservice](https://github.com/GIScience/openrouteservice-r/issues/18)），可见伊对这十像素的执着。这种问题要换做是我，我压根儿就懒得给自己开一个帖子记录（两年前我自己就发现了这个问题而且自行用 CSS 解决了），而伊却陆陆续续在不同的库中发帖，颇有屡败屡战之势。这得是有多闲。

最终我放弃了治疗，为了避免琐碎继续恶化，我还是一咬牙把这十像素的边距加进了默认 rmarkdown 模板中，让世界清静下来。
