---
title: 论临时变量名 tmp 与代码的语感
date: '2018-04-24'
slug: tmp
---

在审阅谭显英壮士的一个补丁时，我[注意到](https://github.com/rstudio/DT/pull/532/commits/bc15293d1b4)一个在码农中极为常见的变量名，那就是万能的 `tmp` 变量。一方面可能是受教科书式代码影响（教科书的例子通常比较泛），另一方面也是不想费脑子想一个具体的变量名，所以一旦需要一个新的不那么重要的变量，先蹦入脑海的就是 `tmp` 之类的变量名。

```js
var tmp, i, j;
for (i = 0; i < data.length; ++i) {
  tmp = data[i].slice();
  for (j = 0; j < order.length; ++j) data[i][j] = tmp[order[j]];
}
```

这段代码要做的是把数据按照 `order` 的列序重新排列。用 `tmp` 当然无妨，确实是用完就可以丢弃的变量，但若改成 `row`，那么我觉得这段代码的意义在没有注释的情况下会更加清晰：

```js
var row, i, j;
for (i = 0; i < data.length; ++i) {
  row = data[i].slice();
  for (j = 0; j < order.length; ++j) data[i][j] = row[order[j]];
}
```

先按行循环，提取第 i 行（用 `slice()` 是为了复制一份数据，免得不小心修改 `row` 而导致牵连修改原数据对象、反之亦然），再按列序重排。

代码注释固然是个好习惯，但如果能做到代码本身可以部分扮演注释的角色，那就更好了。那如何做到代码即注释呢？就需要尽量使用有意义的变量名，让代码读起来就像文字一样。这种把代码进行人类语言化的能力跟前面说的[抽象力](/cn/2018/04/abstract-code/)一样，也需要长久练习才能获得，让代码也拥有语感。
