---
title: 《娱乐至死》笔记
date: '2018-04-12'
slug: amusing-ourselves-to-death
---

去年[五月初](/cn/2017/05/amusing-to-death/)我接触到尼尔·波兹曼的《娱乐至死》，五月底读完。这本书在我过去这一年的日志里提起过几次，是去年对我影响最大的四五本书之一。虽然这本书写于上世纪八十年代，但其中的现象跟当今社会依然高度匹配，道理依然适用，甚至可以说当今社会跟当时比起来完全是有过之而无不及；换句话说，我们是在加速娱乐至死。以下是我的一些分章摘抄和感想。我在微信读书上只划线，不在手机上写评论，因为太慢而且睡前看书不想动手。由于距离读完这本书已经过去快一年，有些摘抄的文字的上下文我已经记不太清，也不太记得当时我是怎么想的，所以下面附注的想法可能有偏于当时我看到这些文字时的想法。

## 媒介即隐喻

我发现西方世界似乎特别喜欢用“隐喻”这个词（metaphor）。读完这一章，我感觉“隐喻”这个翻译似乎不妥当，说是“象征”可能更恰当一些。媒介的作用在于树立一种形象。早在八十年代，波兹曼已经看出政治的本质：

> 政治家原本可以表现才干和驾驭能力的领域已经从智慧变成了化妆术。

秃头和胖子没有当选总统的希望，选民会偏好外观形象好的总统。其实中国也一样，上上届国母最为人诟病的不就是形象太土么，有多少人关心她这个人究竟如何呢；而本朝的国母则招人喜爱多了，同样，脸好看就什么都好。川普当选，是一样的道理，他太擅长吸引眼球，动不动搞个大新闻，其本人形象也总是那么显眼，就算有些媒体丑化他，其实也是帮他的形象打了广告。某种程度上，我认为正是那些拼命攻击他的人帮他选上了总统。

> 与其说经济学是一门科学，还不如说它是一种表演艺术

说的是经济靠广告驱动。当今社会更可怕的是，广告可以靠数据驱动，不仅仅是表演艺术的问题了。

> 在电视上，话语是通过视觉形象进行的

电视是波兹曼在那个年代攻击的主要对象。他认为自从有了电报，人脑就被全盘改造了，因为信息传播太快。电视更糟糕，它提供了视觉形象，可以不间断吸引我们的注意力，让我们无暇思考。

> 媒介的形式偏好某些特殊的内容，从而能最终控制文化。这种启示来自“十诫”中禁止以色列人制作任何具体形象的第二诫：“不可为自己雕刻偶像，也不可做什么形象，仿佛上天、下地和地底下水中的百物。”和很多其他人一样，我那时很疑惑，为什么上帝要规定人们应该或不应该怎样用符号表现他们的经历。除非颁布训诫的人认定人类的交际形式和文化的质量有着必然联系，否则把这种禁令归于伦理制度之中的做法是不可理喻的。我们可以冒险做一个猜测：那些如今已经习惯于用图画、雕塑或其他具体形象表达思想的人，会发现他们无法像原来一样去膜拜一个抽象的神。犹太人的上帝存在于文字中，或者通过文字而存在，这需要人们进行最精妙的抽象思考。运用图像是亵渎神祇的表现，这样就防止了新的上帝进入某种文化。我们的文化正处于从以文字为中心向以形象为中心转换的过程中，思考一下摩西的训诫对我们也许是有益的。即使这些推想有不妥之处，我仍然认为它是明智而中肯的。我相信，某个文化中交流的媒介对于这个文化精神重心和物质重心的形成有着决定性的影响。

抽象的神可以跨时空、跨文化传播、存在于人的心（想象）中；有雕像的神存在于人的眼中。这是本质区别。此时我们可以再回顾一下胡适在《[不朽——我的宗教](/cn/2018/03/meaning-of-life/)》中的话。

> 书面文字使思想能够方便地接受他人持续而严格的审查

柏拉图认为但凡有智力的人都不会冒险用文字表达自己的哲学观点，这说的书写带来的知觉革命。在各种媒介表达方式中，显然我是青睐文字方式的，因为文字可以做到最准确的表达，即使第一次没有表达准确，还可以继续修改（我会多年持续修订我写的各种乱七八糟的东西），这是别的媒介方式不具备的特征，比如录像、音频、照片等。如果是重要的事情，我一般不太愿意跟人直接谈话，因为我的脑子在谈话过程中不够快，往往谈完之后我会意识到有疏漏，但无法撤回修改。书写则有无穷的自由度。

## 媒介即认识论

> 我们的很多心理学家、社会学家、经济学家和其他当今的政客往往借助数字来陈述事实，否则就一无所能。

事实的表达方式在单一化。

> 印刷术树立了个体的现代意识，却毁灭了中世纪的集体感和统一感；印刷术创造了散文，却把诗歌变成了一种奇异的表达形式；印刷术使现代科学成为可能，却把宗教变成了迷信；印刷术帮助了国家民族的成长，却把爱国主义变成了一种近乎致命的狭隘情感。

新工具的出现带来的结果可能会出人意料。即便有上述种种缺陷（这个排比句太讽刺了），印刷术还是利大于弊。电视的出现排挤了印刷品，“让公共话语的严肃性、明确性和价值都出现了危险的退步”。

## 印刷机统治下的美国

富兰克林建议一个教派的创始人发表文章阐明自己的信仰和原则，以驳斥关于这个教派的谣言，但最终被那个人拒绝了。以下是拒绝的原因：

> 在人类社会存在之初，上帝以启蒙人智为乐，他让我们意识到，有些我们尊为真理的其实是谬误，有些我们斥为谬误的却是真正的真理。他不时地为我们拨去迷雾，使我们不断完善自己的原则，改正自己的错误。在这个过程中，他得到了无限的满足。现在我们不知道我们是否达到了发展的终极，是否达到了精神知识或神学知识的完满，我们担心，如果我们裹足不前，不愿意接受他人的意见，那么我们的后人会效仿我们，认为我们——他们的前辈和创立者，所做的一切都是神圣的，是不可丝毫背离的。

这个原因让我惊掉了下巴。不要把教义写下来，竟然是为了防止后人认为前人做的一切都是神圣、不可背离的。这种谦逊程度在现今的宗教中还能找到吗？这个教派还有一个更甚的诫令：

> 不可记录汝等之教义，更不可将其印刷成文，否则汝等将永远受其束缚。

开个玩笑：其实教徒们学会用版本控制系统就好啦，这样就不会受单一版本的束缚，还可以很方便派生（fork）其它教派；若有需要还可以很方便合并教派（pull request）。

> 印刷书籍比任何其他方式都更有效地把人们从现时现地的统治中解放出来……铅字比实际发生的事实更有威力……存在就是存在于铅字之中：其他的一切都将渐渐地成为虚无。所谓学习就是书本的学习。

存在就是存在于铅字之中。这也是我近几年宣扬的观点：存在就是存在于网页中。吾网故吾在。如果你没有个人网站，你就不存在（见 blogdown 书的前言第一段）。我不完全是在开玩笑。

> “如果印刷机存在，这世上是否还可能有《伊利亚特》？”他反问道：“有了印刷机，那些吟唱、传说和思考难道还能继续吗？这些史诗存在的必备条件难道不会消失吗？”

这是引用马克思在《德意志意识形态》中的话。形式决定内容。印刷机是一种话语结构，会排除或选择某些类型的内容、选择某一类型的听众。印刷机让美国的公众对话变得严肃而理性。

## 印刷机统治下的思想

> 首先，用当今的标准来衡量，那时的听众具有超常的注意广度。今天有哪一个美国听众能够容忍7个小时的演讲？或者5个小时？甚至3个小时？尤其是在没有任何图片的情况下？其次，那时的听众必须具备非凡的、理解复杂长句的能力。道格拉斯在奥托瓦半个小时的演讲中包括了三个关于废除黑奴制度的决议，这三个决议句法复杂，措辞符合严格的法律行文。林肯的答词更为复杂，他引用了他在另一个场合进行演讲的书面稿。虽然林肯的语言风格一向以简约著称，但在这些同道格拉斯进行的辩论中，他的句子结构却是复杂而微妙的，丝毫不亚于他的对手。

注意“尤其是在没有任何图片的情况下”。图片问题我[去年已经提过](/cn/2017/06/illustration/)。如今，如果没有图片，恐怕演讲者无法演讲、听众也坐不住。我们是怎么沦落到这地步的？当然，这个不绝对，有些演讲确实离不开图（比如讲实物而不是讲道理）。我自己作报告从来都是一堆 GIF 动图，很多人已经记住了我的这个风格，所以我还没开讲他们就知道会有一波 GIF 来袭，所以上次我在圣地亚哥的 RStudio 大会上讲 blogdown 就没用动图。过去我总称，取悦听众是为了让他们离开时留下记忆，波兹曼在书的前面提过类似的理由，但问道：你要想想听众离开时到底记住的是什么？是搞笑图片、笑话，还是你讲的主题？这是个好问题。

道格拉斯在听到听众对自己经久不息的掌声之后批评这些听众说：“在讨论这些问题的时候，沉默比掌声更得体。”竟然是这样一个演讲者……就问你服不服。演讲者谁不希望掌声如雷？他竟然反过来要求听众安静下来好好思考一下他说的话。

> 我们也应该承认，到1858年，照片和电报的发明结束了理性王国的时代，但这样的结果却是一直到20世纪才明显表现出来的。

作者没明说为什么到 20 世纪才结束。我想这五十年大概是当时的理性王国的子孙逐渐辞世的时间。比如马克吐温在 1858 年时 23 岁，他 1910 年去世。到 20 世纪之前，美国仍然有辉煌的文学创作。

> 这就是为什么一个好的读者不会因为发现了什么警句妙语而欣喜若狂或情不自禁地鼓掌——一个忙于分析的读者恐怕无暇顾及这些。

阅读有序排列、有逻辑命题的文字能促进理性思维。阅读过程中需要大量的脑力投入去分析文字、挑战作者，这样的读者不会冲着作者的段子、抖机灵或俏皮话去。我们可以对比一下当今的知乎文化，或那些“一秒鼓掌、两秒起立、三秒热泪盈眶”的娱乐节目。

> 杰弗逊当然是不信耶稣的，他担任总统的时候，写过不同版本的4本福音书，其中绝口不提那些“奇妙”的故事，只保留了耶稣教义的伦理内容。

这说的是理性至上时代里一些知名领袖的表现，包括杰弗逊总统和另一位叫托马斯 · 潘恩的人。我没听说过潘恩这个人，根据波兹曼的描述，似乎他是一个开国元勋，但他在对《圣经》细致分析之后，认为其中的神性故事都是荒诞不经的，并同时承认耶稣是“德高望重、亲切和蔼的人”。他甚至讲：

> 所有的教堂，不论是犹太教、基督教或土耳其教，在我看来都只不过是人的发明，是为了吓唬和奴役人类、垄断权力和利益而建立的。

波兹曼说潘恩因为写了《理性时代》而失去了在开国元勋神殿中的位置，而且被美国历史课本刻意回避了。

波兹曼说 18 和 19 世纪人们在教义之间的争论是通过行文理智、逻辑严密的小册子或书进行，其中他提到一个叫爱德华兹的人（称他是“美国历史上最聪明、最富创造力的人之一”、“对美学理论的贡献和对神学的贡献几乎一样重要”），以及他的一本被认为是“美国最杰出的心理学研究著作之一”的《信仰的深情》。这么高的评价搞得我都有点想看一看这本书，可惜微信读书里还没有上架。

> 各教派之间的纷争在18世纪是通过论述严谨的说理进行的，到了19世纪则是利用建立大学作为解决矛盾的应急手段。有时候我们会忘记，美国的教堂为我们的高等教育制度奠定了良好的基础。

哈佛、耶鲁等学校创建的初衷都是为了解决宗教问题，这是我以前不知道的，我也没想象过历史上曾有这么一个时代：研究宗教像研究学术一样严谨。

## 躲躲猫的世界

躲躲猫不是躲猫猫，而是 peek-a-boo，是在美国逗小朋友玩的把戏，用手遮住脸然后放开，让小朋友一会儿看见、一会儿看不见一样东西。在我的老家，这叫“伊妹儿啦”。在这一章里，躲躲猫的意思是，一会儿这个信息、一会儿那个信息进入你的视野，没有连续性、没有意义、但其乐无穷。

> 我们匆匆地建起了从缅因州通往得克萨斯州的磁性电报，但是缅因州和得克萨斯州可能并没有什么重要的东西需要交流……我们满腔热情地在大西洋下开通隧道，把新旧两个世界拉近几个星期，但是到达美国人耳朵里的第一条新闻可能却是阿德雷德公主得了百日咳。

这是引用梭罗的《瓦尔登湖》。电报让信息脱离语境，消除了时空隔阂，让信息的价值根植于它是否新奇有趣。什么叫“脱离语境”？波兹曼说你可以问自己下面这个问题：

> 早晨的广播或电视，或者早晨的报纸，有多少次为你提供了需要改变一天计划的信息，或让你决定采取本来不准备采取的行动，或帮助你更加了解了你需要解决的问题？

或者更具体地，问这样一些问题：

> 对于解决中东的冲突，你准备采取什么行动？对于解决通货膨胀、犯罪和失业问题，你有何高见？对于保护环境或降低核战争危险，你有什么计划？对于北大西洋公约组织、石油输出国组织、美国中央情报局、反歧视行动计划和伊朗巴哈伊派教徒遭受的残暴行径，你准备采取什么行动？

波兹曼说：“我可以大胆地帮你回答：你什么也不打算做。”你什么也不打算做，最多只是两年或四年一次花几分钟投票给你认为可以做事的人（记住，他一定不能是个胖子或秃子）。而波兹曼对此继续毒舌：

> 投票选举是逃避政治无能的表现

看到这里是不是整个人都绝望了。

波兹曼点评写书：

> 写书是作者试图使思想永恒并以此为人类对话做出贡献的一种努力

这跟大鹏说的“[写博客，得永生](http://www.pzhao.org/archives/17808/)”是类似的，不过博客比较散乱，书相对系统一些。肉体都会灭亡，但思想可以转生。

> 源于电报和摄影术的一个更重要的产物也许是伪语境。

有了电报和摄影术，我们可以人为制造语境，跟你没有半毛钱关系，但让你心跳加速、前仰后合或热泪盈眶。一个伪语境的代表是纵横字谜，这在报纸杂志上随处可见，尤其是坐飞机时，总会看到它。当然现在的人都被手机吸引过去了，填纵横字谜的沉浸感已经远不如手机应用。再举一个伪语境的例子，就是洪涛宣布《我是歌手》名次的长时间停顿，有人骂洪涛，但我总是想，那些在电视前眼巴巴等着的观众才是真正的蠢货，导演要的就是用无意义之事吸引你的注意这个结果，你骂洪涛，也是他想要的结果（节目得到更多关注）；同理，若干年前我就得出结论，《非诚勿扰》绝非相亲节目，也不是孟非说的什么生活服务类节目，它一定是故意找一些容易引起争议的劣质男女嘉宾到台上来，让观众有足够的谈资，让每个人都可以评头论足发表自己的高见，如果能骂起来就更好了，导演恨不得你们能打起来，让你们一辈子住在这个空中楼阁里。通过非诚勿扰撮合的男女嘉宾，有谁会关心他们下台后会怎样？

> 正如有些精神病学家指出的，我们每个人都会筑起自己的空中楼阁，但如果我们想要住在里面，问题就出现了。

电报和摄影术制造了躲躲猫的世界，而电视则让我们直接住进了空中楼阁，它做到了图像和实时信息的完美结合。

> 就在同时，用罗兰·巴特的话来说，电视还赢得了“神话”的地位。他认为，以神话的态度看待世界，人们对于这个世界就不会有任何质疑，对于自然真实的东西就会变得熟视无睹。神话是一种深深扎根于我们无形意识中的思维方式，这也就是电视的方式。

## 娱乐业时代

如果上一章还不够让人抑郁，那么我想这一章足以让一个尚有理智的人崩溃。问题不是出在电视上播放的一段段内容本身上，而是这些内容量大而且支离破碎，这根本不是正常人脑能处理的。一个悲剧应该让你一个月难以入眠，而现在的情况是无时无刻不是各种悲剧喜剧填满你的耳朵和眼球。你来不及悲伤，笑神经也越来越麻木。

> 娱乐是电视上所有话语的超意识形态。不管是什么内容，也不管采取什么视角，电视上的一切都是为了给我们提供娱乐。正因为这样，所以即使是报道悲剧和残暴行径的新闻节目，在节目结束之前，播音员也会对观众说“明天同一时间再见”。为什么要再见？照理说，几分钟的屠杀和灾难应该会让我们整整一个月难以入眠，但现在我们却接受了播音员的邀请，因为我们知道“新闻”是不必当真的，是说着玩的。新闻节目的所有一切都在向我们证明这一点——播音员的姣好容貌和亲切态度，他们令人愉快的玩笑，节目开始和结束时播放的美妙音乐，生动活泼的镜头和绚丽夺目的各类广告——这一切都告诉我们，没有理由为电视上的不幸哭泣。

大概跟所有人一样，我是个喜欢幽默的人，但现在的娱乐节目（我已几年不看，只是偶尔旁听一下）真的让我笑不出来。国内的娱乐节目如我前面所说，动不动一秒鼓掌、两秒起立、三秒热泪盈眶，让我非常反感。唱歌的节目一定得自幼死了爹娘、北漂二十年住地下室吃方便面才能成为被选中的歌手，搞笑节目正急速朝卖丑的方向前进（通过丑化形象达到搞笑效果是最低级的搞笑方式），很难见到一点机智的幽默，在这一点上，说实话我依旧只服郭德纲（这里不谈人品什么的，只谈艺能）。为什么歌手要比惨，为什么搞笑艺人要卖丑？因为他们要使尽浑身解数吸引我们的眼球，他们本身的能力值太低，只能靠额外的装备硬撑，满足观众越来越难满足的胃口。

## “好……现在”

电视节目中，只要主播说一声“好……现在”，那就代表要切换话题了。说这三个字的时间就是你看电视时所有能用来思考的时间，即：你根本没有时间思考，你的脑子像一个垃圾桶一样，被源源不断地倒进杂物。

> 电视新闻并不想提醒观众某条新闻有严肃的内涵，否则观众在新闻播完后必定还要继续思考，这样就会妨碍他们观看下一条新闻。其实，观众并没有什么机会分出几秒钟进行一些思考，因为电视屏幕上的图像会源源不断地出现。图像的力量足以压倒文字并使人的思考短路。

## 伸出你的手投上一票

里根总统说“政治就像娱乐业一样”，弗兰克 · 斯凯芬顿则说：

> 政治是美国拥有最多观众的体育比赛

还能说得比这更讽刺吗？

## 赫胥黎的警告

那如何解决娱乐至死的问题？波兹曼认为从理论上来说，只能靠“我们的学校”，但这也是非常困难的。几年前我在 Ames 村里一所中学里的墙上看见标语，说是让小朋友们远离 Facebook 和 Twitter，但我不知道这到底是否有效果。我们正处于教育和灾难的竞赛中，谁能跑赢？说实话我比较悲观。全书最后引用《美丽新世界》的作者赫胥黎作为终结：

> 人们感到痛苦的不是他们用笑声代替了思考，而是他们不知道自己为什么笑以及为什么不再思考。

在《1984》和《美丽新世界》的两种死法中，我们大约是要走向后一条路了。
