---
title: 人生十二法则
date: '2018-03-31'
slug: 12-rules
---

在隔壁我写的《[新闻的意义](/cn/2018/03/12-rules/)》中，Aaron Swartz 质疑我们为什么需要追踪实时新闻：

> Instead of watching hourly updates, why not read a daily paper? Instead of reading the back and forth of a daily, why not read a weekly review? Instead of a weekly review, why not read a monthly magazine? Instead of a monthly magazine, why not read an annual book?

我非常赞同，所以我一般也不看时下流行的书。不过今年还是有两本刚流行起来的书吸引了我的眼球，一本是《原则》，我已看完；另一本是昨天瞅到的所谓的《人生十二法则：混沌的解药》（12 Rules for Life: An Antidote to Chaos），我并没有买来看，也不打算真的看，因为[亚马逊评论区](http://a.co/cW9ohAE)已经有人做了详细总结；跟《[影响力](/cn/2017/12/influence/)》那本书一样，我只是看一眼别人的总结，并对总结再总结。

1. 站立时要站直、挺胸。驼背是动物示弱的表现，你越示弱，你就越容易遭到捕食者的攻击，从而陷入恶性循环。

1. 要像帮助别人一样帮助自己。人有不自尊自爱的本能。如果你自我鄙弃，变糟的不仅仅是你自己，还会影响周围的人。

1. 谨慎择友。你可以选择与那些伤害你的人断绝关系，而不必感到愧疚。

1. 作为成年人，你应该与昨天的自己比较，而不是与那些看起来耀眼的名人对比。你只需要相对昨天的自己有一点进步即可。未成年时，偶像有很好的示范和激励作用，但到了三四十岁了你基本已经定型，再想追求成为偶像那样的人，已经不太现实。况且你看到的所谓偶像，只给你看了他们光辉的一面，而阴暗面你则一无所知。

1. 不要让孩子们做那些会让你不喜欢他们的事情，因为你作为成年人的情绪力量太强，你会控制不住自己的怒火。

1. 批评别人之前先把你的房间收拾整洁。不要把自己的能量浪费在释放恨意或恶意上，而是做一些将来能让你自豪地向别人谈起的事情。

1. 追求有意义的事情，而不是整日用权宜之计应付人生。权宜之计是在牺牲未来换取当下的安宁，你应该看得更高。当你获得更多知识时，要注意保持谦逊。要意识到自己的短处。不要急于批评别人。

1. 讲真话，至少不要撒谎。撒谎会让你变弱。意义存在于真相中，撒谎是掩盖真相，也就是让人生失去意义。

1. 假定那个发言的人知道一些你不知道的东西。一段对话好坏的标准是看对话结束时，你是否变聪明了一点。即使是你的敌人，你也需要倾听，他们会编造关于你的谎言，但也会直言一些你的朋友们不会说出口的真相。

1. 发言时要精确。无法用语言精确描述的问题通常也无法解决，就像恐怖片中未知的东西才是最可怕的一样。

1. 骚年玩滑板时不要去干涉他们，就算他们玩的是很危险的动作（比如从栏杆扶手上滑下来）。他们只是在发育阳刚之气、培养面对危险时的勇气。

1. 在路上遇到一只流浪猫要摸摸它。在你经历人生重大坎坷时，你可以借助一些小事来恢复。在一段难熬的时期里，你需要缩短时间线去思考或做事，比如下一分钟、下一小时做什么，而不要想下一个月怎么过。用有意义、积极的小事引导自己走出黑暗。

在我看来，法则 1、6、12 本质上一样，都是心理暗示，跟破窗效应一样。细小的心理暗示可能会成为好事或坏事的开端。站直提醒自己要自信、扫一屋再扫天下、抚摸流浪猫召唤自己的爱心，都是微小的积极心理暗示。要知道这本书的作者是心理学家，所以这所有 12 条法则基本都跟心理有关。

关于法则 2，我觉得确实是多数人的心理误区，我们总是觉得自己弱到爆，而别人都很厉害，也就是这山望着那山高。我自己早就跳出了这个坑，多数时候我都不会在嘴上或心理谦虚，我觉得谦虚不是什么传统美德。人不应该骄傲自大，但也没必要谦虚，谦虚可能会带来负面心理暗示，总觉得自己不如别人。我相信每个人都会有比别人强的一方面，只要有这么一面即可，不必艳羡那些所谓牛人名人的强项。这也跟法则 4 有联系。到了一定年龄后，就该淡定了，大方承认自己的弱项，也要确定自己的强项。可惜不知道为什么我们的社会文化创造了这样一种[羞于承认自己弱项](http://thestudyofthehousehold.com/2018/03/29/2018-03-29-don-t-hide-your-scientific-weaknesses/)的氛围。顺便说一句，这也是我觉得《原则》一书可贵的原因之一。

法则 3 在人情社会中比较难做到，但我觉得人们通常高估了跟一个“朋友”绝交的损失，另一方面我们也太过担心自己在别人眼中的形象：别人怎么看我，通常没那么重要（多数“别人”的存在与否，都不会对你的生活造成多大影响）；这种担心，就跟法则 10 中提到的无法命名的恐惧以及《[石化森林](/cn/2017/08/petrified-forest/)》中提到的想象的恐惧一样，会萦绕心头，凡人无法与之抗衡。

法则 5 提醒我们要对小孩多一些容忍，很多火都没必要发。同一件事情，在小孩和成人眼中看来会完全不同。有时候我觉得成人的脑子已经被太多社会规则绑架、毒害。比如小孩不肯把自己的玩具分享给别的小朋友玩，对他们来说这完全是正当行为，而在我们眼中则会带着道德规则解读为自私的行为。这种情况下，我觉得完全没必要向两三岁的小朋友强行灌输“分享的美德”。

法则 7 又是一个世俗之人容易掉进去的坑。前几天去世的黑石创始人彼得森[回首人生总结了七点经验教训](http://finance.sina.com.cn/money/smjj/smdt/2018-03-26/doc-ifysqcvp2486362.shtml)，其中最重要的一点就是不要用长远利益换取眼前利益。比如他对尼克松政府说不就是一个令人佩服的例子，一般人都不会有这个勇气和远见。另外，彼得森也大方承认了自己的两次人生错误，包括一次抄袭论文。这种名人自爆阴暗面的勇气也值得世人称赞。

法则 8 在《原则》中已经说得够多，可讲真话的痛苦远大于撒谎。人是社会动物，无论什么行动，都会受到一个社会群体的制约。千万人在前，你往得了么。

法则 9 也有《原则》中一句话相关：听别人对你的评论时，不要被情绪左右，要听哪些是对的（真的），哪些是错的（假的）。

法则 10 也难以做到；精确用词的问题我在前面《[趣味化学](/cn/2018/03/chemistry/)》中提到过。我没太明白后面恐怖片的例子跟这条法则有什么本质联系。

法则 11 和法则 5 都是关于成人视角下的孩子教育问题。关于危险动作的问题，成人可能是过虑了，这一点我自己有些体会，因为我小时候爬树、上房揭瓦的事情干了不少。到上初中时，骑车上学路上自个儿学会了丢开车把手，还会两脚站在前面横梁上。这样的事情放现在，前者我还敢，后者是打死也不敢了，想想都吓人。

这样的书能畅销，应该又一次瞄准了现代人的焦虑。它讲了一些看似浅显的法则（之所以浅显，只是因为语言浅显而已），但我觉得多数读者应该读的时候会觉得，哦，你说的好有道理啊，但读完一扔，不会采取行动，静候下一本畅销书的到来。所以还是机智的彼得森看穿了一切：最重要的是投入，并试着采取实际行动。没有行动，看再多书、聆听多少人生智慧都是白搭。

又及：为什么是数字 12？这让我想起去年《[香农](/cn/2017/08/shannon/)》那篇文章，刚好也是 12 条规则，是不是西方人眼中 12 刚好是个整数？也就是一打。一般过于“整数”的总结（比如十条、二十条）我都不会看，因为有拼凑之嫌。还有，那篇文章的规则 5（赞同杂乱）与这里的 6（要求整洁）是相反的，而规则 7 与这里的 3 相同（谨慎择友）。所以究竟听谁的、如何实践，我觉得各人会有各人自己的路，世上没有什么普世的黄金法则。
