---
title: 第五届靠谱厮奖：谭显英
date: '2018-03-19'
slug: copss-5
---

距上次靠谱厮奖颁奖典礼已经过去大半年。自[上次颁奖](/cn/2017/08/copss-4/)给戚风蛋糕糕主之后，这大半年里连我这种跟烘焙绝缘的人都从不知道什么是戚风蛋糕到会用电饭锅做戚风蛋糕了（虽然基本上每次都会塌陷得惨不忍睹），可见时间如蛋糕下肚，本来看似一大口，但其实蓬蓬松松的，很快就没了。我脑子里有靠谱厮候选者名单，只须等恰当的时机把他们列出来。

过去一周遭遇[一个关于 R Markdown 的极为诡异的八阿哥](https://github.com/rstudio/rmarkdown/issues/1285)（bug），显然它是真实存在的，因为好些人都来汇报了这个问题。而我很是抓狂，因为我在 Windows 下怎么也无法重现这个问题。直到今天早上看见谭显英壮士的[另一个报告](https://github.com/rstudio/tinytex/issues/28)，才终于有了头绪，发现它是只能在 RStudio 的 R 控制台中用命令行方式结合 MiKTeX 才能重现的一个问题。我之前之所以不能重现，一方面是我是通过点 Knit 按钮编译的 R Markdown 文档，另一方面是我测试的是 TinyTeX。这两种方式都不能命中这个[奇特的八阿哥](https://github.com/rstudio/rstudio/issues/2446)，必须在安装 MiKTeX 的条件下手敲 `rmarkdown::render()` 才能出错。多亏显英壮士的提示，我才摸清这个问题的底细。最新版本的 rmarkdown 推荐使用 R 包 tinytex 来编译 PDF，tinytex 有超级牛力，但我心里不是很有底气，因为测试的人还不够多，我总觉得还会有什么问题，果然问题就来了。之前 rmarkdown 是尽量让 Pandoc 调用 LaTeX 去编 PDF；如果文档含有参考文献需要用 natbib 或 biblatex 处理，那么再另外单独调用 LaTeX 去编；tinytex 里面编 PDF 的代码其实是从原来的 rmarkdown 中[移植出来的](https://github.com/rstudio/rmarkdown/commit/00318592d5c1)，这个移植过程中作了一些改进，跟原来的代码不完全等价，所以可能会出问题。说到底，就是

```r
system2('pdflatex', 'test.tex', stdout = FALSE)
```

在 RStudio 中会报错。我用 `stdout = FALSE` 的原因是为了隐藏 LaTeX 的冗长日志消息；在我的同事的建议下，我在 Windows 下换成了：

```r
system2('pdflatex', 'test.tex', stdout = tempfile())
```

也就是把标准输出重定向到临时文件中（对标准错误输出 `stderr` 也一样处理）。这样一样可以达成隐藏控制台输出的效果，只是略微低效一丢丢（写空设备比写文件应该快一丢丢）。

这个问题前后已经快有十个人报告，但只有显英一个人找出了关键问题。（谢）子在川上曰：不亦壮士乎？

我今年的前三周时间奉献给了我[丢下两年多的 DT 包](/en/2018/01/back-to-dt/)，主要是扫荡了一大批用户问题，以及修正一些比较容易的八阿哥。在这个艰难的扫荡过程中，我留意到显英大人帮我回答了不少问题，是个热心用户，于是我操起键盘就给他写了一封邀请入坑的邮件。后来他陆续给我带来了[八个补丁](https://github.com/rstudio/DT/pulls?utf8=%E2%9C%93&q=is%3Apr+author%3Ashrektan)，比较重要的是实现了在表格中“[Shift + 点击](https://github.com/rstudio/DT/pull/475)”连续选择的模式；这也是我上次说的[异或问题](/cn/2018/01/logical-xor/)的来源。显英大人的补丁都很清楚，有例子有图（如果是修理八阿哥，则还有修理前后对比图），一目了然，是我比较喜欢的补丁形式：憋说话，看例子看图，然后合并。

借一句苏轼描述韩愈的话：匹夫而为百世师，一言而为天下法。我觉得这位看似普通的靠谱厮应该为天下码农所效法：细心、乐于助人、钻研[极为深入](https://shrektan.com/post/2018/03/18/strings-encodings-in-r/)（极为深入的意思是会钻到一个全世界大概只剩他一个人的前无古人后无来者的地方去，而解决的问题却很重要）。我说我一般不跟没有个人网站的人说话，他二话不说，回去立马卷起袖子就[搭了个网站](https://shrektan.com)。

虽说沧海横流，方显英雄本色，但世上哪儿那么多沧海给你横流，小水沟里一样可以显英。我写软件的原则是只要它对一个人非常有用即可，不必什么软件都要去改变世界；这“一个人”很可能是我自己。在运气好的时候，对一个人有用的软件，也会对很多其他人有用（如果这个人恰好很有代表性）。

我们且看这位靠谱厮何日一搏沧海。

![沧海横流方显你娃儿本色](https://slides.yihui.org/gif/kid-waves.gif)
