---
title: 唯快不破？
date: '2018-03-14'
slug: speed
---

湘云在我[前面一篇日志](/cn/2018/01/remove-all-gems/)下留言说 `list.files(.libPaths())` 比 `.packages(TRUE)` 快。码农界总有比天比地比空气的习俗，比速度更是家常便饭。窃以为在谈速度的时候当考虑下列问题，不要独孤求快：

1. 二者做的是同一件事吗？很多时候速度慢不是因为代码实现太低效，而是要照顾严谨性。看一下 `.packages()` 函数的源代码（并不长）就知道为什么它慢一些了。如果这里的严谨性不是我们需要的（换句话说，你可以承担不严谨的风险），那么你可以解开安全带自由飙车。

1. 快多少？通常码农喜欢看倍数，但倍数只是一方面；另一方面是绝对值。如果一个是 1 毫秒，另一个是 10 毫秒，而且又只需要运行一次，那我觉得不值得操这 9 毫秒的心，9 毫秒连眨一下眼都来不及。当然不只是码农，宣传工具里也常用这个伎俩，比如吃某种食物会让你患癌的概率增加一百倍，这种话听起来让人毛骨悚然（或是反过来，某种食物让某癌症几率降低十倍），但就是不说从多少增加到多少，要是五百亿分之一到五亿分之一，虽是百倍，貌似也没什么值得操心的。

最早的时候我开高速喜欢超速，当然不会超很多，只是比限速多五迈十迈的样子。后来有一天开车的时候一想，限速 70 迈，就算我一路开 80 迈，其实到头来也省不了几分钟时间。就算省这几分钟，下了高速要是路上碰上两个红灯，或者在中途休息站里上个厕所伸个懒腰，这时间马上就回来了。超这 10 迈不仅难以省时间，而且还面临吃罚单的高风险，实在不划算。于是在没什么急事的时候就老老实实开，如果有开的稍快的车超了我（不是飙车的那种），我就跟他屁股后面开一会儿，反正打死不做领头羊。

写代码跟开车一样，不要只求快而不系安全带，也要想想超速究竟能省多少时间。我并不是说一定要时刻系好安全带，我自己很多时候也写不严谨的代码，但我通常已考虑过损失并且认为损失可承受才那样写。
