---
title: 费曼的写轮眼
date: '2017-12-08'
slug: feynman-sharingan
---

费曼的一篇文章“[The Dignified Professor](http://calteches.library.caltech.edu/52/2/dignified.htm)”中讲了一个小故事，而这只是关于他惊人观察力的众多故事中的一个：

> Within a week I was in the cafeteria and some guy, fooling around, throws a plate in the air.  As the plate went up in the air I saw it wobble, and I noticed the red medallion of Cornell on the plate going around.  It was pretty obvious to me that the medallion went around faster than the wobbling.

他的这种观察力简直就是血继限界的写轮眼，不经意间就可以发动：在咖啡馆闲坐都能注意到扔到天上的盘子旋转的速度比抖动的速度快，而且是“很明显”。当然，也许世上有很多观察力惊人的人，也有这样的血继限界，但费曼更厉害的是看到这种现象会想从科学的角度研究和解释它。那些所谓的“最强大脑”拥有者里，大概也只能停留在观察层面上而不会进一步利用他们观察到的事实和现象。

> I had nothing to do, so I start to figure out the motion of the rotating plate.  I discover that when the angle is very slight, the medallion rotates twice as fast as the wobble rate—two to one.  It came out of a complicated equation!  Then I thought, "Is there some way I can see in a more fundamental way, by looking at the forces or the dynamics, why it's two to one?"
> 
> I don't remember how I did it, but I ultimately worked out what the motion of the mass particles is, and how all the accelerations balance to make it come out two to one.

研究明白这个现象还没完。他把这个故事讲给别人听之后，别人会觉得很无聊，一个扔到天上的盘子怎么个转法有什么意义？

> I still remember going to Hans Bethe and saying, "Hey, Hans! I noticed something interesting.  Here the plate goes around so, and the reason it's two to one is..." and I showed him the accelerations.
> 
> He says, "Feynman, that's pretty interesting, but what's the importance of it? Why are you doing it?"
> 
> "Hah!" I say.  "There's no importance whatsoever.  I'm just doing it for the fun of it."  His reaction didn't discourage me; I had made up my mind I was going to enjoy physics and do whatever I liked.

费曼是非常有个性的人，擅长忽略别人的看法：我就喜欢物理，我想怎么玩就怎么玩，至于它有什么意义，不是当下我要操心的事。最后，这么一个旋转的盘子，成了打通任督二脉的初始内力。

> I went on to work out equations of wobbles.  Then I thought about how electron orbits start to move in relativity.  Then there's the Dirac Equation in electrodynamics.  And then quantum electrodynamics.  And before I knew it (it was a very short time) I was "playing"—working, really with the same old problem that I loved so much, that I had stopped working on when I went to Los Alamos: my thesis‑type problems; all those old‑fashioned, wonderful things.

本来我看这篇文章是为了查找费曼的下面这句引言的来源，不过误打误撞看到了上面的故事，挺有启发。他是一个少有的为自己活的人，却又有强烈的内驱力。我等普罗众生，既没有他的写轮眼，也没有他那无以伦比的与物理学相连的好奇心，还时时在乎别人的眼光和看法。

> It was a brilliant idea: You have no responsibility to live up to what other people think you ought to accomplish.  I have no responsibility to be like they expect me to be.
> 
> It's their mistake, not my failing.

据说（[我尚未仔细查证](http://www.sohu.com/a/169151018_358836)）阿德勒说过，“你并不是为了满足他人的期待而活着，别人也不是为了满足你的期待而活着。”跟费曼的话简直雷同。
