---
title: 网页文字的颜色选择
date: '2017-08-04'
slug: web-font-color
---

前段时间看了一篇文章，谈[现在的网页为什么可读性越来越差](https://www.wired.com/2016/10/how-the-web-became-unreadable/)。我有些同感。这几个月我经历了好几个网站的改版，先是 RViews，然后是 RStudio 官方博客，最后是统计之都。每一轮改版最耗时又耗神的事情就是辩论样式；内容方面我通常短短几天就做完了，而样式却是永恒的辩论话题，非常难达成一致。某种程度上，这可能是[自行车棚的颜色](https://en.wikipedia.org/wiki/Law_of_triviality)问题，即：重要或困难的事情太费脑子，所以大众不会参与讨论（如是否该在某地建一个核电站）；不重要但明显的事情，讨论的人就会如潮水般涌进来（就像讨论某处一个自行车棚应该刷成什么颜色）。

关于网页可读性可谈论的话题有很多，今日只谈颜色，也就是那篇文章主要抱怨的话题。我也不太懂为什么现在流行的文本颜色是越来越淡（比如深灰而不是纯黑），不仅如此，在淡色的基础上偏偏还要加上灰度背景色。当时我刚转入现在的 Hugo 主题时，就有一位读者[留言](/cn/2017/03/unix-philosophy/#comment-3198753174)说我的文字颜色太浅，读起来费眼，我一看，果然颜色只是 `#555`，所以给[加深到 `#333`](https://github.com/yihui/hugo-lithium-theme/commit/7918a642)。`#333` 只是我的随意选择，没什么根据，但那些强烈反对纯黑色的人一样也没有科学根据。我倒是盼着有人来做个试验，看到底纯黑引起眼睛疲劳比深灰高多少。我有点不信这个邪。

我们公司去年开始雇了一个专业设计师，他做的各种模板、图片、特效都很漂亮，但我个人仍然不习惯阅读我们网站上的文字，我觉得太细了。主要原因应该是他启用了抗锯齿效果：`-webkit-font-smoothing: antialiased;`，这样浏览器渲染字体的时候会把文字笔划的“毛边”都削掉，导致文字变细一层。

嗨，美丑、易读与否本来就是个主观判断，而且这个判断还会不断改变，今天喜欢这种风格，明天喜欢那种。就算做了群体试验，也没法得出一个让所有人都满意的样式设计方案。我觉得最好的解决办法就是不要定死颜色，让读者自己用自己的浏览器去自定义颜色（有浏览器插件可以做到），爱看黑色看黑色，爱看灰色看灰色。可是傲娇的设计师们哪能舍得放弃自己的审美呢：我眼中好看的东西，一定要想办法传达到你眼中。
