---
title: 香农
date: '2017-08-04'
slug: shannon
---

看了一篇对香农的经验总结《[10,000 Hours With Claude Shannon: How A Genius Thinks, Works, and Lives](https://medium.com/the-mission/10-000-hours-with-claude-shannon-12-lessons-on-life-and-learning-from-a-genius-e8b9297bee8f)》，我对总结再总结一下。

1. 有意识地设计自己的生活和工作习惯，使自己免于外界干扰（如社交媒体）。香农有一大堆没有回复的信件。他在有“开门习俗”的贝尔实验室中特立独行，一般关着门。关于这个开门习俗，我在 [AT&T 实验室实习](/cn/2012/08/quo-vadis/)的时候深有体会，那里的人至今都保留着这个习惯。开门的意思是欢迎任何人任何时候进来跟我讨论任何事情。

1. 先列想法，再填充细节。怎么说呢，这一点的平衡其实有点难掌握。两个极端分别是：只有想法，空想；上来就抠细节，第一步就卡死。香农的直觉让他可以先看穿好几堵墙，但一般人没这个本事，我们只能先拿锤子敲掉第一块砖。不过这里面可学习的做事方式是，先列提纲，再安排日程，然后填充细节。譬如写书，提纲列完之后就感觉书已经写完 20% 了，细致的日程列完就感觉已经写完一半。当然更重要的是紧跟日程，把那些该死的句子一句句敲出来。这个过程有时候顺畅，有时候也让人想死的心都有。比如我巅峰效率的时候，一周可以写四五十页；低迷的时候一周一句话也写不了，但我还是感觉列细致日程是最关键的一步，否则做大事会有无比的挫败感，永远无法启动。

1. 听导师的话。这一点嘛，我感觉推广性不是很强。香农听了导师的话去搞理论遗传学，结果如何我不知道（至少应该没有信息论成就大吧）；而且导师未必都是对的。作者说的谦逊态度倒是可以借鉴。

1. 多走一些道，但不是每条道都需要走到黑。这条经验的借鉴意义在我看来也有限。香农研究了不同领域的问题，发现了糅合它们的办法。他业余也骑独轮车、扔杂耍球、下棋、作诗。我觉得只要不是在一个细枝末节的问题研究上一条道走到黑就可以了（我觉得很多博士研究有这个可能性），现代社会应该没多少人有那个福气能一生只研究一个问题了。

1. 杂乱无妨。这个不是很符合我的习惯，所以我觉得它也只是个个人习惯问题。香农喜欢摆弄小物件儿，有很多没写完的论文，可能他的脑力比较充沛。我是怕杂乱的人。我的脑子通常很杂乱，但当我摆出一件东西的时候，我通常会尽量把它理顺。

1. 时间是伟大想法生长的土壤。香农的信息论论文花了近十年时间才面世，虽然他并不是每天都是在思考这一件事。我觉得这还是因为他对这个问题有足够的好奇心的缘故。我想问题的周期也很长；虽然我目前还没什么想了十年的事情，但想了四五年的事情还是有一些的，比如我就是不服 LaTeX/Word 主宰学术界，咬牙切齿要把写作和排版这两件事撕开；内容一日不与样式分离，学术界就要多浪费一日时间。再比如我也愣是不服微信公众号，这个辣鸡而封闭的系统，也浪费了我们太多时间。

1. 朋友的实质。香农不浪费时间跟不理解他的人争辩，不虚交朋友。当然，他的左右只可能是牛 A 与牛 C。对我们凡人的启示是什么？喝酒可以，扯淡可以，但如果每次喝酒扯淡都是些无关紧要的事情，事后想想并没有什么内容，那不去也无妨。

1. 钱。君子不谈钱，君子要吃饭。香农好像用不着谈钱，反正他有的是钱，也有挣钱的本事。我等凡人当然是做不到，但我觉得避免钱的诱惑也挺重要的，因为钱也可以修改人的大脑。我对生活的要求基本上只是能保证温饱就够了；对于额外的收入，若有，我也不拒绝；若没有，也无妨。这么做并非出于淡泊名利之心，而是我觉得挣那额外的三五块钱所花的精力根本就不值得，所以譬如微信红包我现在看都不看，因为我不想把手机拿过来；又譬如我上一本书的稿费我直接叫出版社砍掉了，我不拿一分钱，你把书给我定价定便宜点就好，如果不这么做，我就要绞尽脑汁去想如何把这笔钱搞到手（以目前我在美国的身份拿版税不合法；以我中国公民的身份拿版税还得填表交税事后还要报税）；再譬如我不在我的博客里留打赏二维码，因为我不需要打赏，更不想让读者来影响我在我的私人领地写东西，不管影响正也好负也好。

1. 花哨容易，简单却很难。通过文中这短短几段文字的描述，由于没有具体示例，我不太确定作者指的简单是怎么个简单法，不过就这句话而言，我非常同意。把一件事做得简单比复杂要更难，因为要简化一件事之前，需要先全方位了解它。前段时间有人在[推特上引用费曼的话](https://twitter.com/xieyihui/status/880484692893585408)，“只有我能创造的东西，我才能理解。”费曼的确是一位前无古人后无来者的优秀教师，说话思路清晰，而且非常擅长将科学原理通俗化。我看了那句话，说“如果我无法创造一个极简示例，我就无法理解一样东西”。在写作 [blogdown 书](https://bookdown.org/yihui/blogdown)的整个过程中，最强烈的爆发时刻是当我做完 [hugo-xmin 主题](https://github.com/yihui/hugo-xmin)：直到我徒手写了一个我认为最简化的 Hugo 主题之后，我才觉得我理解了 Hugo 的核心部分。这个主题同时也打垮了我心中不敢设计网页主题的壁垒，之前从来都只会抄代码。虽然水平一般能力有限，但跨过了一个心理障碍，终于有勇气跟 Bootstrap 和 jQuery 说不了。趁着春风得意马蹄疾，设计了[第二个主题 hugo-xmag](https://github.com/yihui/hugo-xmag)（杂志样式），继而改吧改吧成就了[统计之都](https://cosx.org)的新站主题。虽然改了很多，但总代码量仍然非常小，这是我最得意的地方。当然，样式问题每个人都可以来挑刺，这个防守工作实在是很难做。比如小轩哥提交了一个合并请求“[优化首页样式](https://github.com/cosname/cosx.org/pull/624)”被我无情拒绝了，我也很过意不去，感觉快把小轩哥逼哭了。加图标、加字体、加 CSS、加 JS 都是很容易的事情，可总该有个喊停（至少临时喊停）的时刻。尤其是 JS 法力无边，极易成瘾，玩下去可以玩成无底洞。

1. 少宣传。这条经验恐怕对多数凡人也不适用，香农的信息论不需要他自己卖力宣传。他选择了冷静地继续他的研究，这是值得学习的。在我看来，在这个时代宣传其实也没什么鸟用了，因为世界太嘈杂。不宣传不是因为不想宣传，而是宣传花的精力放在办事上可能更实际。咦，不宣传听起来[好像有点耳熟](/cn/2010/04/no-advertisement/)。

1. 自由比身份地位重要。说白了，就是解名缰。

1. 寻找恼人的刺激而不是灵感。睁大你的狗眼，看看这世上到底什么事情刺激你让你不顺心、睡不着觉，然后去解决它。香农对天才的解释是：天才就是一个接受有用的刺激的人。我感觉多数人可能都会咬牙接受不顺心的东西（比如软件），可能对刺激的反应不太激烈。按香农的定义，最近我发现的一个天才是[冯俊晨](https://d.cosx.org/d/419314)。这厮有点意思。

这一篇文章读下来，有些收获，但不如我以前看[阿西莫夫那篇文章](https://qz.com/886038/isaac-asimov-wrote-almost-500-books-in-his-lifetime-these-are-the-6-ways-he-did-it/)震撼。一生写了五百本书的人，是怎样一种体验。文中有一句：

> By thinking and thinking and thinking till I'm ready to kill myself. [...] Did you ever think it was easy to get a good idea?

从看了那篇文章之后，我就多了一个轻微口头禅：发死力。比如某件事情你发死力去做了没有？
