---
title: 等宽字体中的合体字
date: '2017-08-01'
slug: firacode-ligatures
---

我们知道代码排版一般用等宽字体，而所谓等宽字体就是每个字符宽度相等。这是它与衬线、非衬线字体的最显著区别，而在衬线、非衬线字体中，排版时容易见到两种字形变异现象，一种叫合体（[Ligatures](https://en.wikipedia.org/wiki/Typographic_ligature)），一种叫互嵌[^1]（[Kerning](https://en.wikipedia.org/wiki/Kerning)）。前一种的意思是当某两个或多个字符靠在一起时，它们会互相有局部连接的现象，比如 fi 在一起的话，f 上面的弯弯就会和 i 上面的点重合，而 f 的横线也会伸到 i 那一竖的起始位置；又比如两个 ff 靠在一起，它们的横线会连成一条线。后一种的意思是根据两个字母的形态，一个字母可能会伸入另一个字母的边界内，比如 AV 在一起的时候（不要想多了），A 右上方空间大，V 左下方空间大，把它们俩稍微挤一挤，会显得好看一点。

根据定义，等宽字体一般不会做这些变形，否则字符宽度就不相等了。前些日子刚发现几款面向程序员、支持合体的等宽字体，例如 [FiraCode](https://github.com/tonsky/FiraCode)。它挺有意思，比如不等号 `!=` 这两个字符在一起时（看起来）会自动变成真正的不等号 &ne;。那些 R 里面的等号党应该会喜欢这个字体，因为他们梦中的[箭头赋值](/cn/2012/09/equal-and-arrow/)符号终于可以看起来是一个真的箭头而不是小于减号了。为了保存我等号党的实力，我还是不跳到树上对着这款字体狂吠了。

[^1]: 我瞎翻译的。
