---
title: 一百人每人一百元随机互相送钱最终的结果
date: '2017-07-21'
slug: random-giveaway
---

在 Decision Science News 的博客上看见一篇文章用动画显示[一个反直觉的问题](http://www.decisionsciencenews.com/2017/06/19/counterintuitive-problem-everyone-room-keeps-giving-dollars-random-others-youll-never-guess-happens-next/)。大意如下：一个房间里有一百人，每人手里一百块钱，每隔一定时间所有人都拿出手里的一块钱随机送给另外一个人，问过一阵子之后这房间里的钱的分布是怎样的。

我跟这个博主 2008 年在德国的 R 会议上见过一次，他应该还记得我，因为我发现他这些年来一直对动画都很有兴趣。我从黑客新闻上看见的这篇文章；粗读之后觉得是有点反直觉，因为随机送钱最后的分布应该还是会保持均匀分布。后来我仔细想了想，觉得不对劲，可能被这里的动画给骗了，尤其是下面蓝色的分布图。他想展示的结论大概是最终这些钱的分布会很不均匀，即使随机互相给钱，最后也会有贫富差距；然而问题可能就出在这个“分布”上。虽然我很讨厌统计学的学术训练（读博读研）总是要从源头学起，但偶尔从源头想问题还是值得的。比如每当说分布的时候，需要问清楚随机变量是什么，到底是谁的分布？我认为这篇文章里并没有定义清楚。

上图的意义很清楚，显示每个时刻每个人手里的钱的数量。下图的欺骗性来自于它把所有人排序了，而每一个时刻，横轴实质上都在变化。比如上一个时刻排名第 10 的人，下一时刻可能会换到 28。这个变化并没有在动画中显示出来，让人很容易误解为最左边最穷的那个人一直是同一个人，最右边最富的那个人也一直是同一个人，所以这个系统里有稳定的贫富差距。

那到底是谁的分布？如果看 `$\mathrm{P}(X_1=m_1,X_2=m_2,\ldots,X_n=m_n)$` 这个分布（其中 `$X_i$` 表示第 `$i$` 个人的钱数随机变量，`$\sum m_i=100*100$`），我感觉应该会是一个多元均匀分布，但我也不太确定，因为这些 `$X$` 之间不独立，它们的和为一个定值。不过有一点应该是确定的，该文中下图显示的是顺序统计量 `$X_{(i)}$` 的取值情况。对单个的顺序统计量来说，它的分布肯定不会是在原来随机变量取值区间上的均匀分布。

说白了，画一幅图 `plot(runif(100))` 可能不会吓到人，一眼看去很随机很均匀，很符合直觉；画排序之后的图给人感觉就不一样了，尽管仍然是均匀分布，但 `plot(sort(runif(100)))` 会给人造成一种很不均匀的错觉。

所以图形虽然直观，但骗起人来也是妥妥的。我 2009 年就[自己骗过自己一回](/cn/2009/02/cumsum-of-normal-var-and-uniform-var/)，以为发现了什么不得了的关系，到头来只是一场空。
