---
title: 数据与效率
date: '2017-07-20'
slug: data-and-efficiency
---

狗熊会的熊大貌似非常喜欢举他那个信用卡的例子：国内的人出国期间，在国外收到信用卡的邮件账单，里面的广告竟然还在推荐国内的麦当劳和电影院。熊大感慨，要是他们稍微用那么一丁点持卡人的地理信息数据，就不至于插这种毫无意义的广告在账单中。

我深以为然。这世上很多极其没有效率的事情，背后的原因只有一个，就是没有数据或者没利用数据。比如我每个月看见水电天然气账单，都很想知道到底这些总的电量、水量在房子里是怎么个分布。就像优化代码一样，如果没有细节测速，就不能知道从哪里优化。我不知道到底什么电器耗电最多，如果想省电也不知从何省起，所以只能两眼蒙圈交电费。很可能天然气的消耗在多数时间里都没有意义，比如上午和下午以及夜里都几乎不可能需要锅炉烧热水，是不是我的天然气账单上的大部分费用都花在了这些没意义的时间里，我也不知道。我付得起账单，所以也就没有动力去探个究竟。

再比如保险。我想应该没有多少人对保险公司有正面印象，看起来就像是这样：没出事时，他们追着你收保费，各种吓唬忽悠；出事之后，又是这样那样，反正是赔不了多少钱。这也不能全怪保险公司，问题还是来自于数据。就像[这篇文章](https://blog.ycombinator.com/thoughts-on-insurance/)里谈到的，如果保险公司清楚知道你家的电路结构，可能对失火的风险评估就会精确得多，但他们拿不到这么精细的数据，只能从外观大概看看（甚至只是从网络图片观察一下一栋房子）就给个保费标准。当然，保险的事情已经有进步了，比如车保险可以用追踪工具记录行车习惯，评估个人层面上的驾驶风险。不过我目前用的车保险在这方面也只是流于形式，我要了他们的追踪仪器，但从来就没打开过，只是为了省三二十块钱保费而已，而他们也从来不问我为什么我的仪器不产生数据（因为软件应用做得太差了，实在忍不了不想安装）。

又如出租车行业。滴滴、Uber 之类的为什么能迅速火起来，最重要的还不是因为地理数据么。乘客和司机都有了对方的地理数据之后，简直是太方便了。现在要是到了一个不支持用手机软件打车的地方，我心里简直是堵得要死。上次在澳大利亚，因为我导师的学校只能报销传统出租车费用，所以她打电话叫了车，然后我们就在寒风中等啊等，司机和乘客就在电话中一遍一遍确认对方到底在哪里，而我们的 Uber 上显示周围好些车在转悠，真是宁可不要报销打一辆算了。

还比如医疗。所谓精准医疗，应该无非也就是最大程度收集自变量数据；传统形式下去医院，医生无非也只能大概问问家族病史和个人病史，都是很模糊的数据。

还有自动驾驶技术，没有超大规模的数据训练和积累，车怎么可能会“聪明”。

扯得有点远。回到熊大的例子，其实有些问题解决起来应该没那么难，不是所有的数据收集都那么困难。他的例子呼应了我在 COS 论坛里以前经常念叨的一句话：人脑一小步，电脑一大步。意思是稍微对自己的脑子狠那么一点点多想一步，程序就可能清晰或者快很多。另一个类似的例子是服务器技术中的服务器预传送（[Server Push](https://next.smashingmagazine.com/2017/04/guide-http2-server-push/)），传统网页加载需要先从服务器端拿到 HTML，然后浏览器才能解析里面的依赖（如 CSS、JS 等），预传送的原理就是你事先告诉服务器，如果用户加载某个页面，浏览器一定会需要下载的依赖文件。这样就不必等第一轮 HTML 加载完毕再分析依赖了，而是 HTML 和依赖同时加载；在依赖文件相对较大的情况下，网页加载起来就会快一些。
