---
title: 命名
date: '2017-07-12'
slug: naming
---

关于命名，我有无数的例子想举，但时间有限，先举一例。以后要是得闲，再举一些。其实在《[管道时代](/cn/2017/07/long-live-the-pipe/)》一文中我已经举了 `n_distinct` 的例子了，它跟我下面要说的例子有非常类似的问题（单字一个 `n` 意义太模糊）。

COS 急先锋大为同志日前[上传了](https://github.com/cosname/uploads/commit/77c9189780)一个统计之都微信二维码的图片，路径和文件名为 `2017/01/qrcode.png`。我看了给[改了一下](https://github.com/cosname/uploads/commit/2ed4c2f25)。

我在《[域名起名服务](/cn/2017/03/domain-name/)》中提过计算机界的那句经典名言：计算机科学里有两大顶级难事，一是变量命名，二是刷新缓存（[以后有机会](/en/2018/06/cache-invalidation/)我也想说一下这个缓存刷新问题为什么难）。我觉得多数人对命名这件事的做法可以用这句话概括：

> 只是欢喜随意而至

因为随意，所以什么方便、或者什么是第一个映入脑海的名称，就直接用了。大为用这个路径的原因是以前我们还在 WordPress 时代的时候，这个二维码图片通过网页界面上传在一个年月文件夹下，当然其文件名[更加奇葩](https://github.com/cosname/cosx.org/pull/568/files)，我不知道是谁干的，但从这个意义上来说，大为的命名已经前进一大步了。一般情况下我的 GIT 消息都会比较详细，我重命名为 `images/wechat-qrcode.png` 的时候写了：

> 重命名，原因有二：一、该文件为通用类型文件，无须放在年月文件夹下；二、qrcode.png 名称太模糊，应该体现“微信”二维码

这样将来要是想在什么别的地方引用这个图片，我不到网站上去找大概也能记起来它的地址是 `https://uploads.cosx.org/images/wechat-qrcode.png`。这个路径基本上可以靠文字翻译过来：在 COS 网站的上传站点中的图片文件夹下，找一个微信二维码图片。关键词：COS、上传、图片文件夹、微信、二维、码、图片。如果用 `2017/01/qrcode.png`，可以想象将来会有几个问题：一是需要回忆更多细节：我是放在哪年哪月文件夹下？某年某月后面有没有跟着某日？二是如果有一个新的二维码（比如支付宝）需要上传，我该如何给它命名？因为前面有 `qrcode.png` 站在道上了，我是用 `qrcode2.png` 还是 `alipay-qrcode.png`？如果用了前者，等到回忆的时候又要想，因为支付宝是 qrcode2，微信二维码是不是 qrcode1？如果用了后者，就会想微信那个是不是 wechat-qrcode？从此就混乱了。

火影中我最喜欢的一个角色应该是云隐村的重（这种只有一个单字的名字好别扭啊），他那脑洞大开登峰造极的杞人忧天碎碎念非常有趣。上面这一段也算是我的杞人忧天。一个文件没有命名好，仿佛会导致时钟失灵山体滑坡火车出轨飞机坠毁地球爆炸[宇宙毁灭](http://langdawei.com/2017/03/14/bugs.html)。

变量、函数、参数命名都是一个道理。要是图一时之方便，不考虑未来、他人、撞名的可能性，变量一律用 x/y/z，函数一律用 f。过一阵子再来看，星星咋不像那颗星星哟， 月亮也不像那个月亮，河也不是那条河哟， 房也不是那座房。

面前摆着一堆代码，红红火火恍恍惚惚。
