---
title: 是谁带来了水平滚动条
date: '2017-07-03'
slug: horizontal-overflow
---

是谁……带来了水平滚动条，是那圆圆的明月明月，还是那潺潺的山泉山泉？

最近在改版公司博客，调样式的时候发现在一定页面宽度下，窗口底端老是出现水平滚动条。水平滚动条是网页的大忌，因为读者需要横着向右滚然后滚回去然后滚下去然后再向右滚……周而复始。这也是为什么我讨厌电子刊物双栏排版的原因（以前 The R Journal 就是这样的样式）。

我看到的滚动条并不是太夸张，应该是只有某个元素略微超过了页宽，可能只超过了 1 像素，这种情况下就很难用肉眼看出来是哪个元素超宽了。于是放狗搜，找到[这篇文章](https://css-tricks.com/findingfixing-unintended-body-overflow/)。嚯，这几行 JS 代码真是帅得不要不要的，我一下子就找出了超宽的元素。

超宽的是一条水平线（`<hr/>`）。这个故事倒是有点意思，因为我设置了水平线的最大宽度是 100%，理论上不应该超宽，但可能是因为我设置了样式是虚线的缘故，浏览器在渲染这条线的时候，到了末端可能会略微多出去一点虚线线段（因为虚线的一个线段不能被折断），导致撑破页面。这只是我的猜想，没有去研究验证。

解决方案很简单，告诉浏览器这个元素的大小应该由它的外边框决定即可：

```css
hr {
  box-sizing: border-box;
}
```

这样，100% 宽度的意思就是算上外边框，一共宽度是 100%，所以这个元素再也逃不出如来佛的手掌心。
