---
title: 再谈 LaTeX 数学公式的输入
date: '2017-05-24'
slug: lyx-math
---

前面我提了一个[莽撞人项目](/cn/2017/04/r-latex-math/)，谈到简化 LaTeX 数学公式语法的问题。底下有客官提到 Carson Sievert[^1] 的一篇 [RPubs 文章](http://rpubs.com/cpsievert/268872)，是个不错的开头。

今日看到大鹏提到 MathJax 的[显示 LaTeX 源码功能](http://www.pzhao.org/zh/post/equations/)，他表示很震惊。我就不得不重提 LyX 了。关于 LyX，我只能说别的项目一直在追赶，从未被超越，它至今仍然是 LaTeX 编辑器中的战斗机，哪怕就是单单就数学公式编辑而言，也是无人能及：数学工具栏、命令自动补全、查看 LaTeX 源代码，三项功能都登峰造极。MathJax 这么大的项目，也做不到前两项。

为了公式输入更便利，基本只有两条路可走：一是简化后端（源码），也就是我说的莽撞人项目；二是强化前端（编辑器），也就是 LyX 的路。在 LyX 中输入数学公式，有工具栏的辅助，再也不必担心忘了什么命令了，哪里不会点哪里；有自动补全，再也不必一个 `\epsilon` 敲到底了，敲完 `\eps` 就能看见 `$\epsilon$` 的倩影了，直接回车搞定。更不必说什么分子分母、求和积分，全都是可视化输入；怎么可能出现敲了这个括号然后在八百里之后忘了回括号的情况，诸如 `$X_ijk$` 的错误不可能在 LyX 输入中发生，只要你敲下划线，LyX 自动提供大括号，所以 `$X_{ijk}$` 一定不会错。

LyX 再好，也是一个基于 Qt 和 C++ 写出来的桌面端应用，无法直接移植到网页端使用，所以我们只能望洋兴叹。不过呢，虽然目标很远，但目前也不是一步也走不出去。去年我有一天吃完晚饭拿手机随便一搜，发现一个 [MathQuill 项目](http://mathquill.com)，就是为了解决公式的前端问题。当然，被 LyX 宠溺惯了之后，很难找到一个真心满意的工具，MathQuill 只是解决了一部分问题，不是那么完善，只能说聊胜于无了。于是我操起键盘在 bookdown 包中写了一个 [RStudio 插件](https://bookdown.org/yihui/bookdown/rstudio-ide.html)给 MathQuill 做了个包装，实质上也就是个微型 Shiny 应用，上面可视化敲公式，下面显示源码。用这个插件并不意味你必须得用 bookdown，它可以在 RStudio 的任何文档中使用。

且看啥时候能有真的莽撞人出世，用 JS 重复 LyX 的辉煌吧。这事情可能也没有我想象的那么难，但作为一个三天两头抄 JS 代码的 R 码畜，我对写大型 JS 应用一点信心都没有，也没这个闲工夫，只能把想法先码出来，然后坐等脚底板有三颗痣的人。如果再等两年还没有人来，我就只能用我去年想到的一个[折中的办法](https://github.com/yihui/knitr/issues/1168)了。

[^1]: 算是我的师弟一枚。
