---
title: 盘古之白
subtitle: 中英文之间自动加空格
date: '2017-05-09'
slug: pangu
---

因为看到有人评论我的老文章，我跑去瞄了一眼那文章，不看不要紧，看了就失去了活下去的勇气。我大约从 2015 年开始患上[空格强迫症](/cn/2017/04/space/)，那之前的文章里中英文之间都没有空格，通体不舒畅，于是心想着能不能写个 JS 脚本自动添加空格。

这种轮子大概也轮不到我区区一个 R 码畜来造，放狗一搜，早有人做了，名叫“盘古” [pangu.js](https://github.com/vinta/pangu.js)。于是操起键盘就把它[加到](https://github.com/yihui/yihui.org/commit/6de91d0a)我的旧文章页面中了。正常加载办法应该是[如此这般](/cn/2017/04/do-this/)：

```html
<script src="https://cdn.bootcss.com/pangu/3.3.0/pangu.min.js">
</script>

<script>
  pangu.spacingPage();
</script>
```

然而我怎么可能让这 7K 的“巨型”脚本阻挡我的页面载入？必须异步加载，否则会浪费十毫秒的加载时间。于是用高射炮打蚊子（不支持 IE 8 及更低版本的 IE，但我会在乎 IE 吗）：

```html
<script>
(function(u, c) {
  var d = document, t = 'script', o = d.createElement(t),
      s = d.getElementsByTagName(t)[0];
  o.src = u;
  if (c) { o.addEventListener('load', function(e) { c(e); }); }
  s.parentNode.insertBefore(o, s);
})('//cdn.bootcss.com/pangu/3.3.0/pangu.min.js', function() {
  pangu.spacingPage();
});
</script>
```

我这是何苦来哉。

盘古脚本的介绍中有一段一本正经的胡说八道，这作者真特么能扯，估计很多客官看了之后会患上跟我们一样的强迫症：

> 【……】另有研究顯示，打字的時候不喜歡在中文和英文之間加空格的人，感情路都走得很辛苦，有七成的比例會在 34 歲的時候跟自己不愛的人結婚，而其餘三成的人最後只能把遺產留給自己的貓。畢竟愛情跟書寫都需要適時地留白。

好，HTML 和 LaTeX 里都有了自动加空格的方案，这下世界算是完美了。
