---
title: 中英文混排中的空格
date: '2017-04-07'
slug: space
---

第十届中国 R 会议在轰轰隆隆准备中，会务让我看看赞助商 RStudio 的介绍文字是否需要修改：

> RStudio 公司成立于2008 年，创始人为JJ Allaire，R 社区领军人物Hadley Wickham 现任RStudio 首席 科学家。RStudio 旨在为R 语言提供更便利的开发环境和数据分析工具，例如RStudio 集成开发环境（IDE）、 RStudio 服务器、Shiny、Shiny 服务器、ShinyApps.io、R Markdown、RStudio Connect 等。RStudio 坚定支 持开源软件和社区，其产品多为免费开源软件，但同时RStudio 也提供相应的企业级软件应用（如RStudio 服 务器专业版、Shiny 服务器专业版等），以满足商业使用需求（如企业内部RStudio 服务器管理、售后服务支 持）。自2012 年起，RStudio 为世界各地的R 会议提供了大量赞助和支持，包括官方R 语言会议和中国R 语 言会议。为了R 语言能更持续稳定发展，RStudio 倡议与微软、Tibco、Google 等几家商业公司成立了R 联合 团体（R Consortium），每年为R 社区的开源项目提供大量资助，召集优秀人才解决R 语言现存的重要且有 挑战性的问题。

我定睛一看，嚯~我~喔！蓝瘦！这里面该空格的地方不空格、不该空格的地方反空格。空格空得不要太销魂哦。操起键盘改了一下：

> RStudio 公司成立于 2008 年，创始人为 JJ Allaire，R 社区领军人物 Hadley Wickham 现任 RStudio 首席科学家。RStudio 旨在为 R 语言提供更便利的开发环境和数据分析工具，例如 RStudio 集成开发环境（IDE）、RStudio 服务器、Shiny、Shiny 服务器、ShinyApps.io、R Markdown、RStudio Connect 等。RStudio 坚定支持开源软件和社区，其产品多为免费开源软件，但同时 RStudio 也提供相应的企业级软件应用（如 RStudio 服务器专业版、Shiny 服务器专业版等），以满足商业使用需求（如企业内部 RStudio 服务器管理、售后服务支持）。自 2012 年起，RStudio 为世界各地的 R 会议提供了大量赞助和支持，包括官方 R 语言会议和中国 R 语 言会议。为了 R 语言能更持续稳定发展，RStudio 倡议与微软、Tibco、Google 等几家商业公司成立了 R 联合团体（R Consortium），每年为 R 社区的开源项目提供大量资助，召集优秀人才解决 R 语言现存的重要且有挑战性的问题。

当然这里面有个人习惯的原因。我习惯在中文中的英文单词和数字前后空格，除非前后是标点符号，显然这是沿用了纯英文写作的习惯。其实也有点受 CTeX 的影响。默认情况下，CTeX 文档用 `xelatex` 编译出来的 PDF 中，中文里的英文单词前后会自动空格。

中英文之间加入空格的一个好处体现在网页排版中。如今还没有任何浏览器真的很好支持中英文混排时的断行问题。空格对浏览器来说是一个重要的断行提示。要是没有空格，英文单词可能会紧紧贴在中文上，导致它处在页面边缘时会连带着上一行的一个中文字符被断到下一行去，例如：

```
假装这是很长很长很长很长很长的一句话sentence。
```

英文前没有空格的时候可能会被这样断行：

```
| 假装这是很长很长很长 |
| 很长很长很长的一句　 |
| 话sentence。
```

而不是你预期的这样：

```
| 假装这是很长很长很长 |
| 很长很长很长的一句话 |
| sentence。
```

方块字都对不齐，人生还有什么意义。

断行问题在 CSS 中有几种可能的设定，但没有任何一种选项真的适合中英文混排。上面的例子显示的是默认的断句换行效果。你也可以选择让浏览器不顾一切在每个可能的字符后面尝试断行（即：只要到了边缘就断行），不管单词，但那样可能会导致这样的后果：

```
| 假装这是很长很长很长很长 |
| 很长很长的一句话sentenc |
| e。
```

就问你看了香不香菇。

你可能要问，为啥浏览器不能智能地把英文单词和中文字符分别当做整体对待呢？不要让英文粘在中文上，也不要让英文破碎成字母。我也不造啊，大概[是个难题](http://jonibologna.com/word-wrapping-woes/)吧。好几年前 LyX 邮件列表里有人报告了[类似的问题](http://lyx-devel.lyx.narkive.com/Brs5BbQz/word-wrapping-problem)，貌似 Qt 也有同样的问题。

平时我用搜狗中文输入法，里面我选上了“中文英文间加入空格”的选项，所以每当我切换中英文输入的时候（按 Shift），就会自动空格。

好了，又到了歌颂 LaTeX 的时间了（这次纯粹是躺着中枪，因为说实话 LaTeX 的换行能力比浏览器强多了）：

[![精美 LaTeX 排版](https://db.yihui.org/images/o-rly-latex.png)](http://dirkriehle.com/2016/05/14/o-rly-latex-beautiful-typesetting/)
