---
title: HTML 代码中图片的 alt 属性
date: '2017-04-02'
slug: img-alt
---

审阅余博士的文章时，他[问到](https://github.com/cosname/cosx.org/pull/198#discussion_r108698510) Markdown 的图片语法 `![]()` 方括号中为啥要填文字。这是个很好的问题。要回答这个问题，必须理解 Markdown 语法和 HTML 语法的对应关系。虽然说 Markdown 语法简单，但如果完全不懂 HTML，那我觉得仍难以透彻理解 Markdown。

Markdown 语法 `![文字描述](图片地址)` 在转换 HTML 的过程中会被翻译为 HTML 图片标签 `<img src="图片地址" alt="文字描述" />`。这个 alt 属性的最大功效是为盲人或视力障碍的人提供一个文字描述，因为他们看不见图，只能靠屏幕阅读器读网页。如果图上没有 alt 属性，他们无法知道图是关于什么的，因为屏幕阅读工具只能把文字读给他们，无法把图的内容信息传递给他们。

alt 属性的次要功效是给搜索引擎提示。同样的道理，搜索引擎无法阅读位图信息，只能靠文字提示。当然，这话现在已经不完全对了，因为一方面图片有上下文的文字可以用来推断图片信息，另一方面随着深度学习技术的进步，位图里表达的信息也不是完全不能被机器理解出来。

所以方括号里要尽量添加文字描述，尽管视力正常的人在看网页时看不见这些文字；除非图片无法加载，这种情况下有些浏览器会显示 alt 文字[^1]。

关于此事，其实我以前也没有特别注意过，直到 [2014 年](/cn/2014/07/user-2014/)我在洛杉矶的 R 会议上真正碰到一个盲人 R 用户。

[^1]: 以前微软的 IE 浏览器会显示著名的红叉叉，现在不知道 IE 显示什么了。
