---
title: 抨击 UNIX 哲学
date: '2017-03-11'
slug: unix-philosophy
---

有人写了一篇文章[《论 UNIX 哲学的倒掉》](https://kukuruku.co/post/the-collapse-of-the-unix-philosophy/)，我居然看完了。我曾经也是 UNIX 哲学的坚定信徒，当然现在我是什么都不会绝对信从了。

信仰这东西有很多奇妙的心理现象，比如[斯德哥尔摩综合征](https://zh.wikipedia.org/wiki/%E6%96%AF%E5%BE%B7%E5%93%A5%E7%88%BE%E6%91%A9%E7%97%87%E5%80%99%E7%BE%A4)，也就是你被人绑架时间长了之后，你会对绑匪逐渐产生同情心，进而变成帮助他、卫护他。最典型的例子应该是我经常吐槽的 LaTeX。我们投入大量的精力和时间去学习 LaTeX，最后就会变成骑虎难下，也就是中国人的一句口头禅和杀手锏：**来都来了**。学都学了，PDF 文档也这么漂亮，于是我们就要卫护任何 LaTeX 的缺点，那些惨无人道的规则都能让人挖出理由来解释，并且还要引以为豪。等我们用 Markdown 去解救 LaTeX 人质时，人质会紧紧抓着绑匪的手不肯离开，反过来还要攻击解救人员：你们这么弱，凭什么抢走我们的 LaTeX。

命令行则是另一个典型的例子。学会用命令行操纵对象的人很容易陷入命令行万能的幻觉中，其实有时候点两下鼠标更方便，但因为学习命令行比点鼠标更痛苦，痛苦的时间一长，就回不了头了，心想来都来了，再奇葩的命令行规则我也要去理解它，理解之后我的智力水平就会上一个新的台阶。然而机智的 XKCD 作者[早已](https://xkcd.com/1638/)看穿了这一切：

![Backslashes](https://imgs.xkcd.com/comics/backslashes.png)

R 社区有一个著名人物，某次我跟他说：教新手创建 R 包不能从 `R CMD build` 教起，有些人连怎么打开命令行窗口都不知道。然而他素来有点瞧不起我，自然也不愿意采纳我的意见，讲课的时候一意孤行给学生先讲 `R CMD build`，于是我在下面眼见他起高楼，还没见他宴宾客，就眼见他楼塌了。这便是 RStudio 菜单 `File -> New Project -> New Directory -> R Package` 和按钮 `Build & Reload` 的意义。命令行是有能力统治世界，但有时候真没那必要。

其实文章说的是 UNIX 的一些具体实现上的（荒谬）问题，并不是抨击哲学本身；[UNIX 哲学](https://en.wikipedia.org/wiki/Unix_philosophy)本身还是很有借鉴意义的，只是到了实现层面，人就要面临各种取舍，更糟糕的是多人合作时，各有各的脾气和偏好，于是一致性就会成问题。有时候为了少数几个人的习惯，更多人就要牺牲，越多人牺牲，就会让那些烂规则变成越来越难改变的规则，最后变成所有人集体牺牲。Makefile 特特么滴到底为什么必须用 Tab 字符……Shell 脚本语言几乎比任何一门正常的程序语言都诡异，有时候我实在没耐心去看帮助文档，直接写个 R 脚本代替 Shell 脚本了事，尽管这不是 R 的强项。
