---
title: 楷体
date: '2017-02-11'
slug: kaiti
---

上周我花了一整周的时间把我各个散乱的 R 包网页、博客以及项目网站都归置到了[一处](https://github.com/yihui/yihui.org)，顿时感觉世界终于清静而有序了。

正如时间长了椅子上会长衣服的道理一样，网站的时间长了，各个页面也会长得跟蘑菇似的，东一撮西一撮；中文博客一个库，英文博客一个库，首页一个库，R 包各自有各自的 `gh-pages` 分支，还有这个那个子域名。像我这种有轻微整理癖的人，一直在这样一团混沌中忍着，终于 [blogdown](https://github.com/rstudio/blogdown) 的核心代码开发部分基本上已经完成，所以我拿自己的网站做了小白鼠试验，把所有页面一气搬到了同一个库中，由 Hugo 统一编译，所有页面样式也统一了[^1]。

我对 Jekyll 最大的不满就是本地预览速度实在太慢，像我这好几百篇日志的博客，动不动预览要花 30 秒，而 Hugo 编译整个网站只需要不到 1 秒。Hugo 另外一个吸引我的地方是它安装实在比 Jekyll 方便了几个数量级，它提供单个可执行文件，下载下来就可以用，我用 `blogdown::install_hugo()` 写了个封装，可以自动化下载安装 Hugo，而 `blogdown::new_site()` 直接把 Hugo 官方的 12 步快速入门步骤简化成了 1 步，让你简直没有理由不建个网站。

整个搬家过程略有些复杂，需要一些背景知识，所以就不详述了，还是留着时间赶紧写文档。这次搬家让我最满意的一件事是我突然找到了楷体在网页中的用武之地。折腾网站这么些年，我很少见有网站用楷体的，但我在琢磨引用文字的样式时，脑子一抽，心想为啥不能换个字体呢？引用块的样式最常见的就是左右两边缩进（比如两字符），然后就是左边一粗灰竖线，再不然就是显示一个引号图片在左边，表明这段文字属于引用。英文样式从来都简单，因为网络字体的体积很小，可选的网络字体也很多，而中文则比较麻烦，通常没有人用网络字体[^2]（太大）。因为我的正文在苹果系统下用了宋体，所以我试了一下对引用块文字用楷体，结果让我非常满意。瘟到死系统没什么好看的字体，微软雅黑适合小字号，而我用了大字号，雅黑在大字情况下也很难看，于是我选了仿宋，然后发现仿宋比宋体和雅黑都更适合显示大字（怪不得红头文件都用仿宋），引用块仍然用楷体，虽然不如苹果系统漂亮，但也算能忍，反正我也不会用瘟到死看自己的网页，就把头埋进沙子当不知道好了。Ubuntu / Linux 顾不上了，默认只有文泉驿字体，所以引用块的字体不会有变化。

具体的例子可以看我前面的博客或者首页，这里可以再举几个栗子。比如引用尼采的话：

> 这句名人名言我特么从来就没说过。
> 
> --- 尼采

再比如我 [2014 年说](/cn/2014/06/perspective/)要写一写左宗棠对联的读后感，一晃两三年过去了也没抽出时间。借这个显示字体的机会先节选一段他对胡林翼的祭文：

> 悠悠我思，不宁惟是。交公弱年，哭公暮齿。自公云亡，无与为善，孰拯我穷，孰救我褊？我忧何诉，我喜何告？我苦何怜，我死何吊？追维畴昔，历三十年，一言 一笑，愈思愈妍……陈词酹酒，聊以志恸。有酒如池，有泪如丝，尽此一哀，公其鉴兹。
> 
> --- 左宗棠《祭胡文忠公文》

好呀么一个“有酒如池，有泪如丝”……

后来我想了想为什么我这么中意楷体，其实还是因为触动了 LaTeX 神经。CTeX 的中文文档类中，引用文字就是用的楷体。

[^1]: Hugo 支持任意模板，所以理论上样式可以做到不统一。

[^2]: 有提供这种服务的商业公司。
