---
title: 软件之死
date: '2016-12-28'
slug: software-death
---

有人画了一幅图表达[软件之死](http://tinyletter.com/programming-beyond-practices/letters/the-sad-graph-of-software-death)，大意是，用户提交的事项数量会逐渐远超开发者能完成的事项数量，最后软件被用户无穷尽的新问题给拖死。

我也观察到了同样的现象，但软件也不至于就真的死掉。不同开发者有不同的习惯，比如我是属于那种不能容忍用户提太多新事项的（主要是 GitHub 事项），所以我会尽力杀掉它们，有八阿哥的话尽快修理，问问题的一律赶到 Stack Overflow 上，邮件问题只回复第一次，后面要是继续追问则往 StackOverflow 赶或弃之不理。要是看我的 GitHub 项目，残留事项一般不会超过一页（25项）。这样做有个很大的坏处，就是比较消耗开发时间，不能集中精力想大事。鉴于这个原因，我杀事项的刀会尽量锋利，能关闭的事项尽量关闭。若不确定要不要关，先关了再说，若用户抗议，再考虑重新打开。我怕上来一眼看见有三百个八阿哥报告，那样让我觉得耳根不清静，就像桌子没收拾干净就开始写代码一样。多数开发者好像都不像我这样，所以经常看见三百项未解决问题列在项目里，比如敝厂几个流行的项目 rmarkdown / shiny 都是这样。

极少数情况下会碰到一些暴躁的用户，关了他提交的事项后会不开森，说你凭咩关掉我的问题。这就涉及到网络世界的情绪控制了，现在这已经是我的强项，我非常擅长忽略网络上别人传递给我的负能量，尤其是暴躁的用户。你敢吼我，我就不应战，看我憋不死你。当然，多数情况下，用户们还是很讲道理、体谅人的，画风通常是“不好意思给您添麻烦了”“哪里哪里慢走慢走”。

用户提的新事项通常分两种：新功能请求和八阿哥报告。后者通常得修复，前者的处理就略复杂了。我现在给自己设定的默认模式就是说不，除非是很有意思的功能。啥是有意思的功能呢？比如有好事者在推特上说，你能否提供一个选项让用户在幻灯片中随机插入 Karl Broman 的[蓄须皂片](https://github.com/yihui/xaringan/issues/1)，我一看，诶，这个有趣，恶搞嘛，是我非常感兴趣的，况且这个实现起来只是几分钟的事。于是乎，Karl 的皂片就[可以出现在幻灯片中了](http://slides.yihui.org/xaringan/zh-CN.html)。更多情况是用户的新功能请求更像是个人品味或一些犄角旮旯的小功能，这些东西是时间的吸血鬼，即使初看好像有用，但细想只是让世界变复杂了，所以要有勇气先拒绝之，直到他多花一些时间自己琢磨并为自己辩护，很多人不会走这一步，那在我看来就是不是真爱了，既然不是真爱，那我也不必累死累活为一个不重要的功能付出时间和精力。Karl 前些日子感叹请老天赐予他力量说不（类似于不要答应审稿），我给他举了几个我说不的例子（[一](https://github.com/rstudio/bookdown/issues/238)、[二](https://github.com/rstudio/bookdown/issues/259)、[三](https://github.com/rstudio/bookdown/issues/251)）。讲真，当这么个坏人还是需要一些心理上的挣扎的，但想到能把省下来的时间用在更有意思的问题上，理性便能战胜情感。

简言之，人人生而平等，软件事项并非如此。
