---
title: 中华字经
date: '2014-02-12'
slug: zhong-hua-zi-jing
---

微信上一位朋友转发了一篇《中华字经》，看起来很神奇：

> “只学一篇韵文便识天下汉字”这句话说的似乎大了，但事实的确如此。郑州大学郭保华教授用三年多的时间将4000汉字著成一篇韵文《中华字经》全文共一千句，用字4000无一字相重，涵盖了百科又韵语成章，高难度的写作换来了识字教材的全方位突破，小学6年的识字量，二个半月就可完成。

放狗搜了一下，找了一篇[全文](http://xh.5156edu.com/page/z4631m9119j18708.html)。显然这一定程度上是在模仿[《千字文》](http://www.china.com.cn/aboutchina/txt/2008-11/24/content_16815668.htm)，比如千字文开头说“天地玄黄，宇宙洪荒”，他就说“乾坤有序，宇宙无疆”，千字文说“寒来暑往，秋收冬藏”，他就说“春生夏长，秋收冬藏”。古色古香的文字中间时不时会有奇怪的东西混进来，比如“瓜果蔬菜，葱蒜韭姜，茴椒芹葵，皮芥辣酱”，虽然感觉有点掉价，但本着文字们的字权平等精神以及小朋友们识字的考虑，瓜果蔬菜就瓜果蔬菜吧。再往后读，冒出来一句“惨遭牺牲，素裹席卷，坟棺尸闹，魂魄寝眠”，呃，这个，这个好像会吓着小朋友吧……什么叫“惨遭牺牲”，牺牲还能“遭”？似乎有点不通；马革草席裹尸可以，可用“素裹”来形容是不是有点不合适，以后小朋友长大成妙龄女郎万一某天穿一身白衣进入白衣飘飘的年代，难免让人想起这衣服里面裹的是……

凑四千字是一件辛苦活儿，人家凑千字文凑了大半辈子，要用三年时间赶超前辈的话，难免在中间弄些凑数的东西，比如：

> 虱蚤蛆蛔，茅厕臭便，钾钠钙铝，锌钢锡铅。  
> 镍锑锗钨，铬钡铂钒，硼汞硅硫，苯氰锰碳。  
> 氯氢氦氟，烯烃炔烷，砒砷硒矽，酚酞酮醛。

只差把元素周期表搬进来了。再往后我们还可以看见百家姓，好嘛，又凑足了上百字。不为无益之事，何以遣有涯之生？这事儿的文字意义就不多说了，这不是我的强项，说多了容易露馅儿。作为理科生，我的第一反应其实不是这些，而是“用字4000无一字相重”，这句话立马勾起了我的兴趣，于是乎，手指未动，代码先行。

```r
con = 'http://pastebin.com/raw.php?i=ZaQiHU1m'
x = readLines(con, warn = FALSE, encoding = 'UTF-8')
close(con)
# 去掉注音，在奇数行
x = x[seq(2, length(x), 2)]
# 去掉空格
x = gsub('\\s+', '', x)
# 去掉标点
x = gsub('，|。', '', x)
# 数数一共多少字
sum(nchar(x))
```

实际上正文的字数是3984，客官们不用扳指头数了，缺16个字，这16个字是什么呢？答案很简单，它们是“第一部分”、“第二部分”、“第三部分”、“第四部分”。看，悟空你又调皮了，元素周期表和百家姓凑进来就算了，这“第几部分”四个字也要算进来，叫为师说什么好呢。

最后到底是不是3984个字都不重复呢？答案是否定的，有28个字重复了，它们是（鼓声响起，有请）：

```r
# 拆分成单字，作频数表
y = table(unlist(strsplit(x, '')))
# 哪些字的频数大于1
names(y[y > 1])
#  [1] "乐" "享" "传" "勇" "哥" "圈" "塞" "已" "弟" "弹" "日" "朝" "朴"
# [14] "核" "漫" "灸" "率" "畜" "糜" "腋" "膀" "藏" "行" "解" "调" "长"
# [27] "阿" "陆"
```

字经的宣传语又称：

> 《中华字经》是一种超级识字教材，以四字一句、分门别类、字不重用、韵语连篇的方法编撰而成。全文收录汉字4000个，涵盖了国家教育部、国家语委联合颁布的常用汉字和HSK考试大纲规定的四级汉字。集识字、组词、习韵、正音、学知于一体，可使普通儿童学习4-6个月掌握一生常用的全部汉字，并经教育部语言文字研究所实验基地、多家幼儿园所验证，经公证处公证，5岁儿童4个月学完《中华字经》，巩固率为74.6%，即2984个字，提高现有识字速度的15-20倍。

其实这跟背GRE单词有什么区别呢？短时间强行背些莫名其妙的东西，长时间又很难用上，对小朋友们真的好吗？不知道这个“巩固率”怎么定义。作为[裸考GRE](/cn/2008/10/i-hate-gre/)的人，我从来觉得硬背大量的东西很浪费时间，我推崇的是按概率去背，也就是自然选择——跟你有关的词总会高频率出现，你自然会记住。专家们就别拿小朋友下手了，该撒丫子玩的就让撒丫子玩去，大人们总是觉得在做对小朋友好的事情，其实谁知道是好事还是坏事呢。

类似这种听起来牛掰哄哄的东西网上到处都是，大概是“你认真就输了”，大家都是转而不语，今儿个是字经益智，明儿个是[秋裤误国](http://www.guokr.com/post/81755/)，后天是[泰戈尔](http://www.douban.com/group/topic/1252656/)（世界上最远的距离 不是 生与死的距离 而是张小娴的小说和泰戈尔的诗篇），无休无止。
