---
title: 再论开源
date: '2013-11-27'
slug: open-source-again
---

几年前我写过一些关于开源的[想法](/cn/2010/08/sas-against-wpl-and-my-thoughts-on-open-source/)，如今再来看开源，我觉得问题已经不在说教上，而是在趋势上。倒退十年或更久，那时候程序员相对还比较稀缺，软件闭源开发出来之后别人模仿的成本高，而这些年计算机教育的普及让码农数量变得越来越多，更多人懂编程了，模仿的成本大幅下降。写软件作为谋生的目的已经在弱化，更多的是为了自己的实际需求，或社区名声：你不开源？好，那我操起键盘重写一个好了，你自己觉得凉快就永远在那里呆着吧，哥不等你了。

Sublime Text是一款据说有超级牛力的文本编辑器（不开源），可是它几个月不更新用户就受不了了，马上有人操起键盘[重写了一个](https://github.com/limetext/lime)，GitHub上点赞的一路飙升到5000多。程序员就是这样的动物，控制狂，啥事儿都想控制。如果他没有办法影响一款软件，逼急了他就拿键盘投票。这样会诞生优质开源软件，当然不可避免也会造成各路兵马混战，浪费人力。所以当今的程序主们必须转向合作的模式，没有谁能永垂不朽。GitHub合并请求（Pull requests）给这样的合作提供了方便的平台，让每个有能力、有意愿的用户都能揣着代码来投票，而不是传统的一个或少数几个开发者和一群用户在邮件群里战斗。

开源的含义已经不是开放源代码，而是开放态度。在这方面，有几位R核心团队成员的态度糟糕透顶，当年的R & R（Ross/Robert）开源的成功如今变成了另一个姓氏以R开头的日不落教授的霸权（就不用说是谁了，大家都知道），这让R陷入一个尴尬的境地。如谢梁大侠所预测的，R的竞争对手已经不是SAS，而是Python，我对此表示完全同意。如果R核心团队能有更开放的态度，也许还有希望和Python在统计领域一搏，毕竟有强大的先发优势，但如今我们只能面对Python神教的不断奚落去曲线救国，R本身我们动不了，只能从R包入手。

什么是开放态度呢？R核心团队多年不加新人了，近年加入的是Uwe Ligges，因为他维护CRAN的Windows编译很多年了，估计深得教授欢心（一样的倔强脾气），我不觉得他加入能有多大的实质性贡献。Radford Neal在百般无奈下自己开发了pqR，因为R核心团队要么不搭理他的建议，要么过很久才有一个人出来说话。像这样有计算机背景而且做贝叶斯的人（这样的人更注重计算速度）才是R核心团队最需要添加的人，而不是整天捣鼓出更多`R CMD check`的规则，把R包作者赶得鸡飞狗跳。

要论R团队中最具有开放态度的人，我认为是Douglas Bates，前些日子他[无情吐了CRAN一脸](http://comments.gmane.org/gmane.comp.lang.r.rcpp/6518)，然后华丽转身投入Julia阵营了。CRAN承认也好，不承认也好，它对用户的伤害是显而易见的。公平地讲，CRAN这帮人当然也有着不可否认的巨大的的历史贡献，所有人都该感激。教授经常抱怨有些用户不尊重他的劳动，我觉得这有什么好抱怨的呢，林子大了总是这样的，有些人确实很无礼，但有些人只是不懂规则而已，并不是有心冒犯，话说回来，谁让你制定那么多规矩呢，不是所有人都有闲心去读懂那长篇大论的CRAN政策的。很多规则本来都可以通过自动化的方式解决而不必写出来，CRAN非要坚持以古老的邮件加FTP方式维护，管理者和作者都累都烦，却又都没错，都没错的时候打仗是最激烈的，这就要了命了。有时候教授也在[玻璃房子里扔石头](https://bugs.r-project.org/bugzilla3/show_bug.cgi?id=15480)，修正R的bug的借用了别人的代码不致谢（好吧，有可能是看了别人的补丁然后自己闭眼重写出来的），还要顺便抹黑另一个R包，我不知道他为什么那么恨维克汉姆，我不是维大人的粉丝，但我觉得真没必要这么深仇大恨。

开放态度也包括使用开放的工具，包括版本控制工具和交流工具，而变化总是让人感到痛苦。指望R搬到[GIT世界](https://github.com/wch/r-source)可能希望不大，习惯SVN的人似乎总是与GIT势不两立（从此可以看出LyX团队的开放精神），其实GIT要是没有GitHub撑腰，可能也火不起来，好东西要火起来除了确实是好东西之外，还需要合适的介质，就如同LyX之于LaTeX，RStudio之于R，Markdown之于可重复研究——尽管后者是实质，前者是表象，用户天生就是外貌协会的，再好的东西只要不好看就没戏。再说交流工具，邮件列表是传统工具，我认为它应该退出历史舞台了，弊病太多，作为吐嘈达人，我又忍不住[吐了邮件列表一脸](http://article.gmane.org/gmane.comp.lang.r.general/303009)。

总而言之，我觉得开源世界的大致势头就是：老一辈倾向于系统控制狂，什么邮件系统版本控制系统bug报告系统，统统自己配置，但现在的系统越来越先进和复杂，想要控制整个系统需要花费越来越多的精力，这些杂碎的事情将耗尽主力队员的精力，而且越来越落后；新一辈摩拳擦掌，虽然经验不足，但解决局部区域的问题还是可以的，而且能有效利用更现代化的工具提高生产力和影响力。未来自由软件的竞争，将不仅是专业实力的竞争，更是综合素质的竞争。在你尽情鄙视社交网络和各种酷炫网站并坚守“一切皆纯文本文件”的时候，你也会被时代浪潮淹没。不公平？确实不公平，但事情就是这样。
