---
title: 回村
date: '2012-08-12'
slug: quo-vadis
---

周五结束了在AT&T实验室的十周实习，却遭遇了一次天留人，原本周五下午的航班因为大雨给取消改到周六，害我在办公室打了一夜地铺。公司安排实习生住在Drew大学（这名字在中文里讲起来很麻烦：你住哪儿？我住在“住”，又或我住在猪大学），条件简陋，一栋楼就一个简单的厨房，冰箱冷藏是室温，于是只好把冷冻当冷藏用，里面塞的东西简直可以考古（气味曼妙，我忍不了的时候偷偷扔了不少别人过期的东西），好歹挨过了两个月。周五下午Drew要赶走所有人，因为要粉刷房子准备开学住新生了，于是几个要搬家的实习生就在门口一堆行李旁胡侃，侃得群情激愤，声泪俱下控诉这苦逼的地方，要吃没得吃，要喝没得喝。扳指一算，吃住行交学费除去，工资所剩无几，实你妹习啊。

当然有一些玩笑成分。生活之所以苦逼，我想和IT民工有关。其实纽约就一个小时火车那么远，以IT民工之宅，定是不愿意进城的。我这两个月一共也就去了两次纽约，一次去[做报告](/cn/2012/06/quick-notes/)，一次见同学（Eva同学从大西洋彼岸来）。纽约这地儿我走在其中感到压抑，熙熙攘攘的人群，抬头不见天日，经常出了地铁就迷失方向，所以也不太乐意去。备受赞誉的中央公园在我眼中也就是个相对论问题：纽约太拥挤了，所以这个大公园显得珍贵，对从村里过去的人来说，俺们有一望无际的大农场，这一片绿地也就没什么稀奇了。

上次说到实习让我加强了写Shell脚本的功力，AT&T的科学家们有用Shell脚本处理文本数据的传统（而不是用数据库），我问老板Simon，他说这种方式比数据库快，于是我整天在awk/sed/grep和管道`|`中折腾（要知道Awk和R都和AT&T实验室有深厚渊源，我的办公室就是S语言作者之一Allan Wilks退休前的办公室，我隔壁是S语言另外一位作者Rick Becker）。Simon一直说内存问题不是R的大问题，我这次才算知道为什么不是大问题了，因为他们有超大内存的服务器（问百姓没饭吃为什么不喝肉粥的皇帝）。实习中我生平第一次把一个6G的文本文件一口气读进R居然没说内存不够，这上哪儿说理去啊？对我等普通青年和普通机器来说，多数时候撑死还是只能读几百M的数据。最后实习汇报的时候，我引用了这幅图说明一个普通青年使用他们的大型服务器的感觉：

![乌龟太快了](https://db.yihui.org/imgur/U8KI6.jpg)

每次谈话都能看到Simon的聪明之处，他说话我经常跟不上（等他走了半小时了我才醒悟过来他是咋整的），而我话说一半他的思维就已经超出我一大截了。这家伙的脑子里装的东西真不是一般的多（比如地球纬度上1度大约是多少公里），各类命令背得滚瓜烂熟了如指掌。有一件小事我直到看他操作才意识到：在Linux下鼠标选中文本，然后鼠标中键点下去就可以粘贴了，这在很多程序中都是默认规范。想想过去我浪费了多少次 `Ctrl + C` 按键操作啊！

太聪明的人也会有被聪明误的问题，因为太聪明意味着你什么都可以做，我看S大人就有这种倾向：看一些工具不顺眼就开始琢磨自己写个工具替代它。另一个表现就是“配置狂”，意思是不管什么软件都要自定义配置，好像非得自定义一下什么设置才算是真正使用这个软件一样。有时候想想，知道的太多也不一定是好事。

因为数据涉及到隐私问题，实习这事儿不能说太细，不过大数据还是挺好玩的，比如直方图中在59秒挂电话的频数就略微比前后两秒的频数高一点，这让我想起来当年手机刚开始时兴起来的时候，打电话打了59秒就得意洋洋，1分零1秒就要骂娘。这世上有很多把连续数据人为离散化的情形看似自然但我觉得完全不合理，比如电话为什么要以分钟为单位收费，学生的学分为什么要分ABCD(+|-)，奥运成绩为什么要分金银铜，等等；金银是质的区别，但如果金牌是9.98秒而银牌是9.99秒，人的感知可能就很不一样了，而且从统计的意义上来说，二者可能并没有显著差异，如果再跑一次，银牌可能会胜过金牌。苦命的银牌铜牌们，都是统计学发展还不够害的，否则大家也许都并列金牌了。咳咳，我这是说到哪儿去了？

无论如何，没谱的实习结束了，回到了自己的狗窝，还是村里惬意。

附实习期间令我无语的截图两张：

![没有错误的错误](https://db.yihui.org/imgur/OGreD.png)

![成功的错误](https://db.yihui.org/imgur/OdIWF.png)

外接几篇：

## 圣地亚哥JSM

今年JSM在圣地亚哥开，这个会议我是越来越没兴趣，这次连会议手册都完全没打开过，除了自己的报告之外，纯粹在那边打酱油，不是找认识的人瞎聊几句，就是出去吃饭观光。各类人见了一堆，有些是知道名字但不知面貌，如夏凡、王芳坡（路上偶遇，被叫师兄，我还心想介四谁啊，一起的还有翁银虹，不过时隔几年我已然忘记长啥模样了，汗），人大军团在美帝越来越壮大了；有些人是知名知面但没见过活人，这次好不容易见到活人，如Duncan Temple Lang和John Chambers，我逮到Chambers说你三年前[欠我一张照片](/cn/2009/04/won-john-chambers-award/)，于是老大欣然给我补了一张：

![拜见John Chambers](https://db.yihui.org/imgur/B05Sh.jpg)

我觉得他应该有七十多岁了（本科毕业五十年了），可是看着也就五十岁的样子，莫非十几岁就读完本科了？其它各种会面会餐暂且不表。

## 翻书

自从[有了Kindle](/cn/2011/09/ny-strata-and-nj-att/)，翻了一些闲书。作为一俗人，我真心觉得《明朝那些事儿》写得好，喜感与历史的结合，大赞，这作者不简单（虽然我不知道也不关心是谁）。这个暑假翻完《曾国藩》那三部曲，心理描写太多且细，我也就不关心它的历史性了，作为文学作品看也还不错。曾老爷子留下遗训四条：

- 慎独则心安
- 主敬则身强
- 求仁则人悦
- 习劳则神钦

遗训中尽管充满迷信，但精神和原则都值得敬仰。这书到现在有三点印象：

1. 运气：曾老爷子晚年反思一生（当然，可能只是本书作者在“反思”），觉得官场上的成功可能还是运气使然（例如太平天国内部腐化）；这让我联想到Michael Lewis（《说谎者的扑克》作者）在普林斯顿的[毕业典礼演讲](http://v.youku.com/v_show/id_XNDExNDk1NzY0.html)，其主题便是运气；听起来这有点消极，可谁知道呢？
2. 仁：具体细节不记得了，他最后和某山中大师谈话时，如五雷轰顶般意识到此生战战兢兢顺从满清王室也许未必是真的仁，他不反，可能反而害了天下百姓；
3. 洋务运动：尤其是对容闳办留美幼童的支持，这一百多个幼童里，出了多少绝世将才；

<embed src="https://player.youku.com/player.php/sid/XNDExNDk1NzY0/v.swf" allowFullScreen="true" quality="high" width="480" height="400" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash">

最近在机场出入较多，候机无聊之中补了几本金庸武侠，发现兴趣已经不如初高中那时那么大了（还不如看塔屋王世子和深夜食堂），不过倒是在《书剑恩仇录》和《天龙八部》中瞥见小轩哥的网名“解名缰”，有点意思。

## 软件外包

Cameron发了一则通知，[pgfSweave求包养](http://cameron.bracken.bz/who-wants-to-maintain-pgfsweave)，想当年我也是积极地给他提交补丁，现在这个包的功能已经完全被knitr涵盖了，所以我琢磨着是否还有人会真的去包养；虽说是后浪推前浪，前浪沙滩上，我还是得感谢pgfSweave赐给我的灵感。

我上次[也](/cn/2012/06/quick-notes/)求人包养我不想维护的[iBUGS](https://github.com/yihui/iBUGS)包，立刻就有[彪哥](https://github.com/randel)来包了。我同样求人简化MSG包中的一个示例代码，经过[漫长的讨论](https://github.com/yihui/MSG/pull/22)，终于把肖楠肖帮主出品的[拿破仑行军图](https://github.com/yihui/MSG/blob/master/demo/Napoleon.R)的代码清理好了；其实这事情我自己来做的话花的时间会少得多，但潜在的好处是鼓励别人参与你的代码开发，一旦这个能形成趋势，我就等着接受补丁好了。介，揍是[社交化编程](https://db.yihui.org/docs/social-coding-Yihui-Xie-2012.pdf)。

## 科学与法律

科学的最高意义[莫过于此](http://www.ted.com/talks/scott_fraser_the_problem_with_eyewitness_testimony.html)：

<iframe src="https://embed.ted.com/talks/scott_fraser_the_problem_with_eyewitness_testimony" width="854" height="480" frameborder="0" scrolling="no" allowfullscreen></iframe>

这位演讲者提到“法律与科学长期以来相克”，正义和公平到底是主观还是客观的？老子蹲大牢的时候儿子还在娘胎里，老子被释放之后儿子已经可以跟他一起上大学了。

## 抛硬币

颜大站长在[这个帖子里](https://cosx.org/cn/topic/107768)间接表扬了我几年前的代码，颜站就是颜站，把代码解释得清清楚楚；我回头来看，难免想起肖帮主最近提到的程序的可读性与效率的平衡，那时候写的代码可读性不高，只是在追求简洁。如果换作今天来写同样的代码，我会这样写：

```r
coin_seq = function(v) {
  x = rbinom(n <- length(v), 1, 0.5)
  while (!all(x == v)) {
    x = c(x[-1], rbinom(1, 1, 0.5))
    n = n + 1
  }
  n
}
set.seed(1024)
mean(htt <- replicate(1e+05, coin_seq(c(1, 0, 0))))
mean(hth <- replicate(1e+05, coin_seq(c(1, 0, 1))))
```

## Quo Vadis

最后解释一下这篇日志链接中的Quo Vadis，拉丁语，意思是“何处去”，从Bill Venables长老那里学来的，他在useR! 2012上的[邀请报告](http://biostat.mc.vanderbilt.edu/wiki/pub/Main/UseR-2012/VenablesRQuoVadis.pdf)的标题就是这个，意思是想说R何处去。长老表达了对R的几个担忧，我感觉他隐隐剑指某位如日中天的R领军人物，称之为帝国主义。

这些都是闲话。为啥用这个词组作链接呢？其实也没啥特殊原因，本来是想以这个为主题写的，但后来只是觉得它很酷，于是便记载与此。

