---
title: 像猪一样战斗（统计之都改版背后的故事）
date: '2010-12-18'
slug: fighting-like-a-pig
---

注：这本来是11月的文章，当时没写完，现在拣出来继续。有时候觉得文章放一段时间再写也有好处——让记忆去自选择，忘掉不重要的细节。

猪是一种被广泛误解的动物。以前某童鞋形容另外一位童鞋“跑得比猪还慢”，我听了立即反驳，猪是跑得很快的动物，我是看着猪长大的，那些小猪崽，整天一愣一愣地到处拱土；关于此事，有诗为证：

> 远看山无色，近听水无声。  
春去花还在，人来猪不惊。

人来猪不惊只是很短暂的现象。那一群猪往往是抬起头看你三秒，然后一哄而散，四处逃窜，跑得比兔子还快。我从来不知道猪到底是怎么想的，总之猪是一种很奇特的动物。这是标题党对猪的介绍。

感恩节放假，照旧宅家里，所谓躲进小楼成一统，管它春夏与秋冬。前四天干了一件事：重新盖了一下统计之都。这活儿就跟拱土的猪一样，要拱就拱到底，早上爬起来就开始拱，一直拱到半夜睡觉。江湖上总是传说这位大牛三小时写出了豆瓣网，那大神四小时创建了啥网，这等神话对我等小辈，也只能当故事听听，听罢该拱猪还得拱。我是个对网站外观非常挑剔的人，我理想中的网站外观应该有这样的效果：当读者打开网页之后，十秒之内必须在口头或心里说“真他爷爷的震撼”，甚至心生买椟还珠之意。

这是统计之都主站的第三次改版：第一次用的主题跟个个人博客差不多；第二次改了个像杂志一样的模板，大家都说好，去年底被黑了一回，费了牛鼻子劲又把模板重新改写了一遍，自那时起心里就觉得不爽，因为页面的布局并不精确，CSS太混乱，纯属快速应付，但应付完也就这样又用了近一年，后来逐渐发现有几个网站都在用这个主题，毕竟是免费的嘛，很容易就被大家采用了，看到这个心里又不爽了（尽管r-bloggers那个网站的美工实在不敢恭维），赶上放假，于是再去扒Wordpress主题，这回不从免费主题里找了，而是看商业主题。【跑题一下：我之所以欣赏WP，原因主要不在于它的名气，我看中的是他们的程序员的气质，例如他们的口号“Code is poetry”，我觉得真的做到了代码如诗，WP这套系统，其逻辑结构的安排之精巧，令人不得不佩服；往后编程课若要讲什么是API，就以WP为例好了，它是最好的API示例。看商业主题时看到他们关于提交商业主题的要求时，其中有一条，说的是模板的说明文字必须是俳句（haiku），若你不知道什么是俳句，那么请赶紧去看樱桃小丸子，那里面爷爷时不时就来一段俳句。本小子天天看樱桃小丸子，看到WP上还有俳句要求，自然很惊讶又觉得很搞笑。】商业主题果然是一分钱一分货，可能随便拿一个都比免费主题强。最终挑选的结果就是目前的主站样式。刚拿来的时候小问题一大堆，CSS上的，PHP上的……于是乎埋头改啊改。反反复复上传修改估计超过五百遍，这其中发现了几样新东西：

1. PHP函数`mb_strcut()`：多字节字符串被截断时，这个函数能保证不会截出半个字节的怪物来（而`mb_substr()`就有可能）；两年前我还不敢用mb_类的PHP函数，因为担心扩展性不好，因为多字节的函数不是必装的模块，现在看来这种担心该移除了；
2. Google有个[字体API](https://fonts.google.com)，怪不得我看这个主题的字体觉得挺特别呢，原来是OFL Sorts Mill Goudy TT，我尤其喜欢这个字体中的W的写法，不过后来发现这个字体的数字很难看，所以就换成了Cardo，效果近似，但数字好多了；网页中的英文还是衬线字体好看，棱角分明，倍儿精神；Google这几款字体都还挺有新鲜感的；许久不关注CSS，没想到现在已经可以使用服务器字体了（当然，幕后实际上需要下载）；
3. 很多网页浏览器都支持字体阴影了，所以这次主站的部分字体有了雕刻效果；如果你还在老掉牙的IE6中上网，那就没办法享受现代浏览器带来的美观效果了（如圆角元素）；网页开发者最恨的估计就是IE6，它是最难伺候的；如果你必须用IE，那么至少还是升级IE8吧，或者用Firefox；
4. jQuery名副其实地简洁好用，这是我第一次碰jQuery，以前都是一律`document.getElementById()`啥啥的；现在主站那些豆腐块的高度都是通过jQuery调整才变得整齐一致的，否则有时候会出现对不齐的情况，这事情给编辑部砍掉了一个艰巨的任务，也让我逐渐加固我的一个理念：**能用技术手段解决，就不要浪费人力，多留点脑子做更有价值的事情**；在解决这个问题时遇到了一个极其隐蔽的bug，不过还是被我挖出来了，这可算是这次改版解决的问题中我觉得有点得意的一个（见后面附注）；

现在的主站页面排版质量，自认为差不多赶上LaTeX了（这话再过一年可能又要被自己推翻了）。排版漂亮，腰不酸腿不痛，写文章也才有劲儿。这次改版与前两次的一个不同之处在于参考了Google Analytics的访问数据，例如看哪些链接的点击频率高，用来决定如何布局；本来标签云的点击量太小，而且它的排版不整齐，我决定去掉，后来江堂说这玩意儿有Web 2.0气息，还是保留下来了。还有字体问题，参考用户操作系统比例，决定不要过于照顾Win XP + IE6的用户，对Windows用户优先使用雅黑字体，这样的阅读体验比宋体要强很多，尤其是在不太古董的笔记本上。英文字体的选择纯属个人偏好，尽管有研究显示非衬线字体比衬线字体易读（看Google或雅虎等大网站），但一来我们没有太多的英文字符，二来这种研究也没有确切的结论，而且大多数书籍和长篇文章都会按衬线字体排版，所以也不必太迂腐。我个人喜欢看衬线字体，加上Google那几款字体还挺有新鲜感，所以就用了。

豆腐块的缩略图是另一改进，原版模板中缩略图算法在这几年来一直都有点迂腐：它默认对文章中的第一幅图生成缩略图。若第一幅图是站外的图片或是文章没有任何图片，则缩略图算法会失败，这在伟大的Windows下的表现大家都知道——那幅著名的红叉叉图片（即我在人人网的头像）。为了克服这个问题，只需要做一点小的改动：找文章中的所有图片，匹配一下看哪一幅是站内的，而不是死板找第一幅图；另外，如果没有图片，那么就用自定义的缩略图替代。这些改动都很简单，属于事半功倍的事情。最后，主站中便暗藏了一个故事：有很多“伪缩略图”都来自于COS会员的贡献，这些贡献在缩略图的小角落可以被发现——有些缩略图上悄悄打了个印记；比如bo代表波波头版主、w表示王晓伟版主、q表示小邱、z表示主伟呈，等等。

伴随着主站改版，统计之都也开始启动社交网络工具，如[人人网](http://www.renren.com/cosname)和[新浪微博](http://weibo.com/cosname)，这些工具开启了COS的SNS元年。此前我们是“不宣传就是不宣传”政策，今后可以逐渐放开低调宣传了。

其它细节都忘了，正好省点时间打字。

最后是logo问题，寻寻觅觅多少年，没有结果。这事儿说难也难，说不难也不难；随便拖个动物就可以，犀牛羚羊丹顶鹤青蛙蜥蜴壁虎什么的，不必非得限制在和统计有关的东西上。由于没有结果，只好随便拿个东西填充在那里，于是我选择了一个“伪彩蛋”，暗暗和广大人民群众开了个玩笑。当新的logo出现在那里时，有童鞋说，嚯，白宫顶啊（这正是我想误导的效果），还有童鞋说，咋放个坟头在那儿啊，最后有童鞋似乎看出真相了，说那哪里是坟头啊，明明是个毛线绒帽。我心想，嗯，你得到了它。

## 附：在对齐豆腐块过程中的bug

对齐豆腐块这个问题也就是用JavaScript将每个豆腐块的高度都调整到最大高度，所以事情很简单：遍历所有豆腐块，计算最高的高度（找最大值是任何语言编程中都会有的简单案例），然后都设置为这个高度。代码不难，尽管jQuery不像R那样支持向量化编程，让我浪费了一点时间学习循环的语法，总之还是搞定了，但调试的时候发现不能如愿，又死活想不出原因：手工设置每个豆腐块的高度为特定像素是没问题的，为什么查询所有豆腐块的最大高度就不行呢？

于是我一遍又一遍刷新页面，终于发现一个细节：浏览器其实调整了豆腐块的高度，在刷新页面后的瞬间，豆腐块高度有跳动，所以问题出在最大值上。为什么最大值的计算会出问题呢？绞尽脑汁想到了答案，就在那“跳动”上。jQuery查询的是实时的高度，而页面内字体（Cardo）的应用会有所滞后，所以这个最大高度只是字体被应用之前的高度，并非页面加载完成之后的高度。因此，这个高度调整需要放在页面的onload事件上执行，保证计算的是最终呈现给用户的高度。

```html
<script>
  jQuery(window).load(function () {
  var maxHeight = 0;
  jQuery("div.entry-content.clearfix").each(function(i, domEle) {
    maxHeight = Math.max(maxHeight, jQuery(domEle).height());
  })
  .height(maxHeight);
  });
</script>
```    
