---
title: roxygen杂记以及如何写文档
date: '2010-12-10'
slug: notes-on-roxygen-and-software-documentation
---

这两天不时遇到一个问题，就是软件的文档。编程工作中，写代码只是一部分工作，其实写文档未必比写代码简单，这工作就像做网页一样，必须时刻牢记这不是给自己看的，而是给别人看的。如何从读者的角度来写文档，在我看来是一门高级艺术。或曰，写帮助文档如同写论文，你要想办法把最有用的功能以最简单最快速的方式展现给用户（想一想论文的摘要应该怎样写、电梯演讲应该怎样讲），这其实是一件非常困难的事情。

上次李丰推荐了Emacs的帮手ECB，我在Ubuntu下用Synaptic安装之后面临的第一个问题就是，如何使用它？帮助文档说，请阅读帮助文档。好嘛，我看，我看。帮助文档长得要命，就像吃个肉包子，吃了三公里面皮，见一牌子，上书“此处离馅儿还有六公里”。作罢，开始Google，果然得到结果M-x ecb-activate；然后呢，看见文件列表框了，甚好甚好，正是我想要的东西（Emacs真的很磨练记忆力，要不然时不时得看一下Buffer列表看现在开着哪几个文件），问题是咋用？鼠标双击文件名，文件不能通过这种方式打开；焦点放在列表项上，回车，文件还是打不开。然后想把列表框弄窄一点（默认设置太宽，占用了太多编辑器空间），鼠标还是没法用，看了帮助文档，不明白。至此，我就没耐性了。

相信很多人对R的感觉也是类似。我相对熟悉R一点，所以知道答案经常能在帮助文档中找到；在论坛混迹这么些年，看了无数这样的例子：答案就在帮助文档的第10行，可是用户只有看到第3行的耐心，或者根本不愿意看帮助文档。我们该怪罪用户太懒，还是怪罪开发者太固执（按他们的方式写文档）？前一阵子，R-help里又出了一个小小的风波，`integrate(dnorm, 0, 20000)`的结果在很多系统下都是0（不要太震惊），有一位顽固的用户向顽固的R core们建议修改一下帮助文档增加一个警告，R core认为目前的文档已经很好地强调了这个问题（谁爱改谁改去）。从严谨的角度来说，R core们写的文档一般都是非常严谨的，而从人性化角度来说呢？后者也不能推得太远，因为“人性化”过度通常会纵容用户，紧接下来就是培养傻瓜，“傻瓜软件”的名字大概就是这个意思。

回到roxygen，这个包本来是用来帮助开发者写文档的，可是不幸的是它自身的文档也写得不太清楚，以至于一些功能我需要很长时间才能发现。例如我一直以为这里面的Rd2概念和R自身文档的版本有关系，直到今天才发现是两回事。前一阵子我还一直在想怎么把两个函数的文档合并到一个文档中，甚至有自己动刀的冲动，而今天发现它的Rd2中有个新标签`@rdname`，只要指定了同一个`@rdname`的文档都会被合并到一起。我对它的文档的期望就是给一个完整的例子，让用户了解所有的标签的用法，可是它的vignette中只有高度简化的例子。


**外一篇：函数命名**


讲个好多天前的事情：（编随机数模拟程序）601课的老爷子袖子一捋，“那我们开始编吧，第一步，给我们的函数命个名，这是最难的一步（笑），你们有什么建议？”当时是编Logistic分布的随机数程序，于是我提议rlogistic（因为R已经有rlogis函数了，我们只是在重复劳动而已），老爷子说，好，于是开始呼哧呼哧写反函数，编完了，为了检查一下生成的随机数是不是服从Logistic分布，我们得画个理论密度曲线，那么先写个密度函数吧。言毕，老爷子袖子一捋，又开始写：

```r
logisticdensity <- function(...)
```

我当时心就凉了。

我以为他明白我的意思了，会用dlogistic作密度函数名。r随机数，d密度，p概率分布，q分位数。他愣是活生生啖出个logisticdensity来，我真是被噎死了。
