---
title: Rd2roxygen：结束R包开发者的文档噩梦
date: '2010-12-02'
slug: rd2roxygen-to-convenient-r-documentation
---

本来我是计划先写统计之都改版背后的一些故事的，可是太长，还没写完，于是先发这篇短的（[刚写了英文版](/en/2010/12/rd2roxygen-convert-rd-to-roxygen-documentation/)）。说来各位客官也许不相信，但长期以来，我很不情愿更新R包，种种不情愿的事情中，以写文档为首。写两三个函数的文档还能忍受，可是写到一定数量之后就倦了，一方面原因是我的懒惰，就像我愿意用LyX而不愿意用原始LaTeX代码一样，我不喜欢写基于源代码的文档，痛恨敲 `\title{} \author{} \description{}` 之类的命令；另一方面，一个包中若函数写多了，相应的文档文件也多了，更新文档还得来回看，切来切去，写着很不顺手。

对于开发者来说，roxygen是个方便的助手，它借用了Doxygen的概念，把文档以注释的形式直接写在函数源代码之前，事后再用特别的函数处理这些特殊的注释，把它们翻译为真正的R文档。例如`##' @author Yihui Xie`就会被翻译为 `\author{Yihui Xie}`。文档和源代码放在一起自然就使得写文档顺手多了，上下对着看看，就能很快明白函数是干什么的，文档该怎样写。随便[抓个例子看看](https://github.com/yihui/animation/blob/master/R/BM.circle.R)就知道我的意思了。

如果只有roxygen，我还不会正式考虑用它来写文档，原因仍然会让各位客官大跌眼镜：我不喜欢重复敲这样的字符`##'`，或者我希望我敲回车到下一行的时候，编辑器能自动生成`##'`；另外我作为新手也记不住标签的名字是什么，不想每次写文档都重新敲一遍所有需要的标签。而六指琴魔的训练工具——Emacs，就出场了。

过去一些年头里，Emacs这个“神器”我装了卸卸了装，始终没搞明白它是怎么用的。这玩意儿就像Linux一样，没有人指导一下的话，要想玩儿转对一般人来说并不容易。也许是近一年多以来大规模用Ubuntu的原因，对命令行工作有了一定的理解，终于有一天顿悟了。那感觉就是噗嗤一团白烟腾起，你看到了一个长着翅膀的白胡子老头儿在向你招手，那就是上帝。Emacs本身并没有实质性贡献，但插件ESS可是帮了大忙，这两者结合之后，写文档变得异常轻松：写个函数，按一下`C-c C-o`，roxygen文档就生成了，填一填注释中的内容就完事；若函数添加了新参数，再按一下`C-c C-o`，新参数就被自动添加到roxygen文档注释中去了。更要命的是，它真的有换行自动填充`##'`的功能，这下我没话说了。

问题是我已经陷在老的R文档中了，怎么切换到roxygen的工作方式呢？前些日子在R-help发了个邮件问，结果Hadley说他有两段可参考的代码片段，我拿来一看，嚯，已经有了解析R文档的函数，尽管不完整，好几处bug，但基本框架已经有了，于是乎，克隆下来研究一番并改进了很多地方，最终放出了一个新R包，叫[Rd2roxygen](http://cran.r-project.org/package=Rd2roxygen)。给个老包的目录，`Rd2roxygen()`可以解析原文档，生成roxygen注释并插入相应的函数代码前（更新包的R文件夹下的文件）。这下才能真的投奔roxygen。

用同门一位同学的话说，这叫“为了懒惰而勤奋”（work hard to be lazy）。【完】

## 附一篇：又在掐架

现在又有两处战场。一处是个老问题，也许以前有客官听说过Rcpp的历史故事，它的第一任作者几年没更新这个包了，所以后来被Dirk和Romain接手继续开发，后来这位作者一直在纠缠署名、GPL之类的问题，今天又来了；我也不知道他想要啥。GPL协议并非对所有人都合适啊。另一处，有童鞋列举了Sweave的十大罪状，这事儿有点过了，尽管我也觉得Sweave在设计上一点都不聪明，我最不满的是它的扩展性太弱了，可能当初设计的时候并没有按照一个API的思路去写，还有很多细节问题我也颇为不满，但那娃儿写的十大罪状我都觉得不在点子上。顺带一个消息，LyX 2.0将以原生态的形式支持Sweave，目前已经有测试版，估计明年初发布正式版吧；我觉得LyX 2.0对Sweave的支持方式有点死板。
