---
title: 统计计算与数学推导及逻辑分析
date: '2010-04-14'
slug: stat-computation-math-logic
---

> 本文论点在于计算机自动化的可能性以及对长久以来的数学推导传统的疑惑，并非为了贬低经济学论文。

陈丽云这篇博客“[真的是只大狐狸吗？对江西财经陈军昌博士的探究](http://www.loyhome.cn/928.html)”让我想起一个长期以来我关心的一个话题。我对陈军昌这个人本身不如我对他的摘要的兴趣大，此君提到：

> 本文预言：在不久的未来，计算机技术将会借助非线性问题的进展彻底占据经济学的主流地位。这项技术不再是简单的用于经验数据的回归预测，而将成为主流形式化逻辑。 本文作者甚至计划在将来使用纯计算机程序的形式化逻辑写作一篇经济学论文。

我完全相信这段预言。倒不是说我觉得这种做法是对的，只是在目前可见的范围内，我严重怀疑堆积如山的经济学论文是否还需要人的脑子，我甚至想象，给一个Sweave模板，提供几个参数（如欲选择用什么模型、生成什么样式的图形），然后把数据读进来用R跑一遍，一篇论文就自动生成了，加上LaTeX本身就显得正式，这种论文一定人模狗样的，很能忽悠人。比如：

> `\Sexpr{names(dat)[1]}` 的均值为 `\Sexpr{mean(dat[  ,1])}`，标准差为 xxx。图 \ref{...} 为 `\Sexpr{figname[1]}`：
> 
> ……
> 
> `\Sexpr{modname[1]}`模型显示，斜率项为`\Sexpr{coef(dat.lm)[2]}`（t 检验结果为`\Sexpr{ifelse{coef(summary(dat.lm))[2,4]<0.05, '显著',  '不显著'}}`）。

把目前主流杂志上的经济学论文遍历一下，总结一个八股规则，生成统计分析部分。至于结尾嘛，就把所有论文的结论部分分条存在一个数据库中，随机抽取5条就可以了，反正大家的结论都很NB，都对社会主义建设有重大意义。

调侃归调侃。如果这位陈博士的论文真的能被广为接受的话，我估摸着将来大多数期刊是不是要去喝西北风了。以上是经济学界的事情，与我没啥关系，暂不多说。还是回头说统计。

统计计算和模拟在统计界一直都是小弟，大佬仍然是搞数学的，而且似乎数学搞得越深越瞧不起做计算的。可以理解，学术跟宗教其实没有太多区别，人人都有信仰，而且只要有江湖，就一定会有名门正派和歪门邪道旁门左道之分。不过我倒是有两个有趣的例子：

1. Andrew Gelman在他的论文_A Bayesian Formulation of Exploratory Data Analysis and Goodness-of-fit Testing_中提到Efron & Tibshirani的_An  Introduction to the Bootstrap_。论文374页说：

    > [...] This is related to the idea from the bootstrap literature that simulation can replace mathematical analysis.

    我没考证原书，不过我没想到两位作者能放出这样的话（也许被Gelman夸大了，也许是断章取义）。

2. 有个人叫Julian L. Simon，他在他的书 "[Resampling: the New  Statistics](http://www.resample.com/content/text/index.shtml)" 序言中放出一个赌注，愿意下注$5000赌一位以传统统计理论教学方式教统计学的老师，他自己以统计模拟的方式教同一个主题，看各自的学生在解决相关的数值问题谁更快得到答案。到现在为止没有人能应接这场赌局。也许是这本书太不出名了，也许是数学真的有某些方面的弱势。

统计计算之于传统统计学，就如同那位陈博士的想法之于传统经济学一样。人的逻辑思维未必是最有效的解决问题的方式，只不过在远古时代，人只有自己的脑子可用，所以就一直用一直用，总不肯承认除了脑子之外有其它替代方式来解决问题。不过也许若干年后，计算机的方式也会落后于时代。后之视今，犹如今之视昔。谁知道呢？

话说回来，我觉得计算机不可能完全替代经济学论文中的逻辑分析，但是用计算机做一些常规性的自动化报告也未尝不可。

附：本文中“经济学论文”大约可以推广到“社会科学论文”。
