---
title: 统计之都新年构想（杂碎篇）
date: '2009-12-31'
slug: cos-in-2010
---

在家宅得快发芽了。这几天考虑着COS的发展计划，每次想这件事都觉得脑子里的想法装不下了，可每一个想法的实施往往至少要一年时间，甚至两三年都没法实现。在2010年，我希望可以实现下面这些事情。本文写得不是一般的意识流，读者慎阅：

1. 全面提升网站功能，主要包括对三大软件的支持：
    1. <del>SVN</del>GIT：目的在于会员合作，大家可以共同编写一些小册子，<del>SVN</del>GIT使得工作可以并行而不会互相牵制、依赖。按胡子同学的IT小小鸟模式，我觉得COS的会员们根据COS论坛的帖子足以合力写出好几本统计小小鸟了。

        ```sh
        ## need libapr, libapr-util, then subversion
        wget http://apache.cs.utah.edu/apr/apr-1.3.9.tar.gz
        wget http://apache.cs.utah.edu/apr/apr-util-1.3.9.tar.gz
        tar -zxf apr-1.3.9.tar.gz
        cd apr-1.3.9
        ./configure --prefix=$HOME/bin/apache/apr
        make & make install
        cd ..
        tar -zxf apr-util-1.3.9.tar.gz
        cd apr-util-1.3.9
        ./configure --prefix=$HOME/bin/apache/apr-util --with-apr=$HOME/bin/apache/apr/
        make & make install
        wget http://subversion.tigris.org/downloads/subversion-1.6.6.tar.gz
        ## tar, cd, then
        ./configure –prefix=$HOME/bin/subversion –with-apr=$HOME/bin/apache/apr –with-apr-util=$HOME/bin/apache/apr-util

        ## SVN把老夫折腾得接近崩溃，终于痛苦地转向GIT
        wget http://kernel.org/pub/software/scm/git/git-1.6.6.tar.gz
        tar xf... & ./configure & make & make install
        ```

        习惯了用SVN，但过去一直是用别人的服务，轮到自己架设SVN服务器才知道这叫一个崩溃，其实主要原因可能是因为自己没有root权限，未必真的那么难。由于是用别人的服务器，只好转向GIT。
        GIT安装使用都没问题<del>，而且貌似服务器上都不用装GIT……现在一个有挑战的问题是：GIT通过SSH从服务器上读写文件，而我们的服务器上貌似不能设置多种SSH登录权限，即：只要有Key，就可以SSH进去任意操作。大家要是都守规矩保证不乱动服务器当然最好，万一某天某些童鞋不小心对服务器上别的东西误操作了咋办，这个问题目前还不好解决……</del>昨晚睡觉想到一个办法，把真正的GIT服务器放到别的地方去（比如GitHub），然后在COS服务器上定时运行`git clone`，这样就解决帐户问题了。

    2. LaTeX：要正儿八经写东西怎么能不用LateX呢？

        ```sh
        ## install texlive from internet
        wget http://mirrors.med.harvard.edu/ctan/systems/texlive/tlnet/install-tl-unx.tar.gz
        tar -zxf install-tl-unx.tar.gz
        cd install-tl-20091229/
        ## need configuration here
        ./install-tl
        export PATH=$PATH:$HOME/bin/texlive/bin/x86_64-linux
        export MANPATH=$MANPATH:$HOME/bin/texlive/texmf/doc/man
        export INFOPATH=$INFOPATH:$HOME/bin/texlive/texmf/doc/info
        ```

        据说texlive对中文支持很好，有待测试。有了LaTeX之后，结合R/Sweave以及GIT、cron job就可以在服务器上定期生成动态PDF文档了。有一朵“云”前两天给我Email说计划写计量与R的书并免费公开发布，我心想这个事情可以作为COS书籍的第一个项目，大家有钱的捧个钱场，没钱的捧个LaTeX场。

    3. R：当服务器端支持R之后，便可以实现很多想法了，上面写书是其中之一；还可以建设Rweb，或者让维基页面支持动态生成R运行的结果。

        ```r
        ## need freetype-2.3.7.tar.bz2, expat-2.0.1.tar.gz, fontconfig-2.4.2.tar.gz, cairo-1.4.14.tar.gz, glib-2.12.12.tar.bz2, pango-1.16.4.tar.bz2, libpng-1.2.29.tar.bz2
        ## dependency
        pango <-- cairo + fontconfig + glib
                              ^
                              |
                     freetype + expat
        ## environment variable
        export TMPDIR=~/tmp
        export PKG_CONFIG_PATH=$HOME/bin/fontconfig/lib/pkgconfig/:$HOME/bin/freetype/lib/pkgconfig/:$HOME/bin/libpng/lib/pkgconfig/:$HOME/bin/cairo/lib/pkgconfig/:$HOME/bin/pixman/lib/pkgconfig/:$HOME/bin/glib/lib/pkgconfig/:$HOME/bin/pango/lib/pkgconfig/
        ./configure --prefix=$HOME/bin/R
        make & make install
        ```

        还是没有root权限的原因，装R可是费了牛鼻子劲，关键是png和cairo配不好，如果不装这两个图形设备的话，其实R还是很容易装的。现在好不容易根据一大摞依赖关系配置好了，又发现`png()`中pango的字体库貌似有问题，不能支持文本生成，再次崩溃。没有`yum`或`apt-get`的世界一片漆黑，一切都得从头编译。

2. 整顿论坛，精兵简政
    1. 大规模删帖+编辑帖子。我过去一直没有公开讲我的一个想法，就是我希望这个论坛是帖子数最少和注册人数最少的论坛（前两天写在主站的“关于”页面中了），原因同德鲁克说的公司企业管理类似，一个好的企业应该是看上去平淡无奇的，没有什么轰轰烈烈的事情发生，因为其内部已经井然有序了。我认为一个论坛如果帖子数目**过多**，只能说明这个论坛的管理太差，帖子质量太低。如果有强大的管理系统，帖子应该被经常整理，比如汇编成册，让后来者无需注册、无需发帖。如果一个访问者到了一个网站，被迫要注册（更恶劣的是盛行的积分制度）发帖才能解决他/她的问题，那么我并不看好这个网站的价值。大多数论坛用各种手段拼命攒人气，我想其理念绝非为访问者服务。我们要果断舍弃短期利益（如广告），放长线钓大鱼。

        太云还有fan等编辑部成员得好好琢磨一下，然后广泛招兵买马，准备下学期有所行动。至于整理的形式，我想一方面可为主站服务（发文章），另一方面视整理的规模与内容可考虑朝出版的方向走。

    2. 精兵简政的意思是我一直认为目前的PHPWind论坛系统过于臃肿，想投奔bbPress，这一点半年前已经和颜林林及其他版主们沟通过，可惜我当时没顾得上测试颜林林的SQL脚本，前两天试了一下，发现还是有问题，等他考研结束再说（在此顺带为他烧高香愿考研顺利）。
        当今网上的论坛系统都有个特点，就是越做越复杂，进了后台一看铺天盖地的选项简直他娘的昏了头，论坛就是个发帖的地方，整那些回帖才能看帖的东西干嘛，还有那山寨校内系统，搞得论坛成了四不像，还有各种论坛币，我最不愿看见的帖子就是问各种积分怎么挣，有这时间，找本书自己都能想出问题的答案了。

        bbPress是一套极度简练的系统，在前台基本上除了发帖就什么功能都没有了，后台则可以有Askimet等插件支持，注册的时候有判断机器人的程序，注册的密码会发送邮箱，这几大杀手锏应该足够杀掉大多数广告。bbPress的会员身份只有有限的几种：普通会员和版主及管理员，版主不分是哪个版的版主，这样所有的版主都可以管理任意版块的帖子，这一点便可提升管理人员的效率。它默认没有bbcode，这一点我也很喜欢，我现在觉得bbcode是人类代码史上最糟糕的发明，有写那代码的功夫，用原始的HTML早写出来了。

    3. 论坛数据库应该dump下来做做统计分析，我们天天用统计解决别人的问题，为什么不统计一下自身呢？总是不知道该怎样任命版主，其实分析一下会员数据库，看看谁发帖多、在线时间长、登录最频繁，候选人也就很明了了，剩下的便只是“人际公关”问题；当数据积累多的时候，也许能分析出很重要的信息，地球人都知道统计里面有大数定律，但面对海量信息就想不起来这“大数”有什么用。像bit.ly等提供网址缩写服务的网站，它们没法打广告，靠什么吃饭？只能靠分析大家缩写了哪些网址看大家在关心什么，有了信息就有了财富（几乎是单变量的数据啊）。我们能否通过分析R版块的帖子IP来寻找一个合适的明年R会议的地点？能否文本挖掘一下大家关心的统计方法，成立一个相应的专门的统计咨询小团队（给自己挣点口粮或完全免费只当锻炼自己了）？能否统计出会员登录时间的规律，专门安排定期的网上答疑？……

3. 加强与主站作者的联系，让大家有主人意识，并挖掘更多稿件来源

    1. 目前主站看起来像模像样（某几位领导数次大赞之），但没达到我的预期，这里面的原因我想还是和作者们没有建立常态联系，大家没有自觉写作的意识，这是管理的问题。我对人的假定是，不贡献是对的，但不去挖掘他可能的贡献的话则就是管理者的不对了。我知道作者们并非写不出文章，只是没有人去给出这种“刺激”。谁（们）来做这件事呢？

    2. 关于文章的方向与内容，我一直在思考松鼠会的模式。但统计这种“科学”，有多少内容能和人民大众的生活联系起来并引起他们的兴趣？现在提起统计，人们的反应就是“tmd都是假的”。Numb3rs这种剧肯定远比不上那越狱之类的剧流行，但我们的目标也不必定位在广大人民群众，没必要真做到老妪能懂的地步。技术文、科普文都得抓。从论坛到主站的渠道一定要打通（如同“营销4P”中的“渠道”），还得有几双眼睛观察身边的统计。

    3. 我相信主站文章的水平超越期刊是迟早的事情，看看现在那《统计研究》整个儿就是本《经济研究》，苏联模式的统计对我中原统计的影响真是根深蒂固。很早以前我就对经济类统计论文形成了一个阅读观点：翻开论文，直接看最后一节，如果那里面的结论和建议看起来就像某届某中全会的讲稿，或者宏观得不着边际，或者压根儿就是常识，那就不要看了，里面的统计方法只是找借口的工具而已，可惜以我坐井观天的阅读，很多论文貌似都属于这一类。当你看一篇论文，用了一大堆你懂或不懂的模型，这边际弹性啊，那N阶段最小二乘法啊，最后说（我不给出处了，客官也勿搜，我只是随便举一例）：

        > 本研究的实证结果表明，改善这些地方的营养状况和医疗卫生条件，将会极大地有助于这些地方农民收入的增加。


        你老实说，你有没有想抽他的冲动？MD，农民有钱吃燕窝有钱看病了，他收入能不增加么？

        纸质期刊的诞生历史原因之一是印刷太贵，只能选择一些论文来印刷、分发，如今期刊的功能发生了本质性变化，我们要重新考虑纸质期刊究竟有多大的存在必要性？之所以想到这些问题是因为前些日子看到这篇文章[Why Journals?](http://blog.repec.org/2009/12/16/why-journals/)，甚合我意。

        主站文章不仅要力争超越期刊，而且应该充分发挥网络平台的优势，即：可随时修改、改进，有无数的匿名“评委”在读这篇文章，有用没用大家可以马上反馈。

    4. 我作为捣鼓了几年网站的人，眼睛对网页比较挑剔，有点容不得不规范的格式。主站的文章一定要有一个熟悉HTML的编辑队伍，把文章打理得漂漂亮亮、干净利落。

4. 维基新模式

    1. 维基站是COS中最难打通的关节，这玩意儿必定起步困难，而且运营起来也会很费力，要不然那Wikipedia怎么天天喊着募捐几百万呢。过去的一年多里大家也看到了，COS维基几乎没有任何动作。原因之一是到现在还没设计好发展方向，过去陆陆续续有些会员对此表示了兴趣，但我自己都不知道该请他们做什么。最近与一位Yifan老兄邮件往来，渐渐有了些启发。既然Wikipedia已经发展很成熟了，我们就没太大必要去按那种传统的词条解释的道路去走，我的想法是，也许可以把R嵌入这个维基，发挥它的统计计算与作图功能，把那些词条用一些计算和图示来解释（比如置信区间），并提供相应的R代码，读者甚至可以动态编辑代码看演示。

    2. 关于内容，过去想把R的函数帮助都翻译进来，现在看来没有这个必要，因为我觉得这个工作的价值有限；另外，翻译软件Manual还不如重写，对翻译的东西，大多数读者恐怕永远只有一条意见，就是“tmd翻译得太差了，还不如看英文”。我们仍然可以从论坛中挖掘会员关心的概念，比如标准差/标准误什么的，当这些帖子的问题被回答之后，就应该有人将它收录到维基中。问题依然是，谁（们）来做这件事呢？

5. 高校联系人何去何从
    本来这个想法是为了促进国内高校统计专业之间的交流，现在看来恐怕是很困难。一来，善用网络的老师不太多，老爷子老太太就甭指望了，年轻老师貌似也很忙，哪顾得上来这小庙发发帖；二来，我们至今没有找到一个领头羊，改革开放还得先有试验呢，咱这小庙要发起一项行动，必然也得先建好一个模板。高校联系人报名人不少，但我疏于管理和安排事情，各位参加的童鞋可能就更不知道该干啥了。咋个办。

6. 英文论坛暂缓

    这论坛起步啊，就一个字：难。

7. 整个网站的文化建设

    耐着性子看到这里的客官一定最终忍不住了，是不是在默念“丫一定疯了”或者“丫太扯淡了”……我也不是纯粹扯淡（意即：有扯淡成分）。世上能人有很多，让能人能聚到一起并创造价值，靠什么？长远来看，只能靠文化。短期可以以利益驱动，可我们这一小破穷网站，拿啥给人家，啥都木有。人家凭什么要在这穷破地方呆着？统计的学习交流只是一方面，除此之外，我希望营造一种COS文化，具体是什么，我也说不清，也许它往大了说包含人的修养修为，往小了说包含在力所能及的时候要帮人一把、或者乐于分享你的有用经验经历，往粗了说包含立志肩担引领一门学科的发展，往细了说包含对某种统计模型的使用有自己的主见而不随波逐流。

    这些玩意儿都是玄而又玄的东西，说出来容易被人嗤之以鼻。比如我说要十年磨一剑，也许没几位客官会想，靠，你小子真的要从2006年磨到2016年啊？我倒是想回答一句“嗯呐”，不过这话不能公开讲，怕误导不明真相的群众。

    这文化建设先从头目抓起，形式呢，可以随意一些，我个人非常不喜欢宗教式的文化建设。不知从何时起，北京一些餐馆饭店也开始了“文化建设”，每天下午四五点，哗啦啦厨师杂役全叫出来，排成三排，大家齐喊“为XX服务”之类的口号，我估摸着也许是喊给路人听的吧，要真有那心，早该体现在店里有没有苍蝇、服务员有没有微笑、大厨有没有在菜里放铁丝上了。COS要建设文化，可以通过定期分享点小文章资料等方式实现。总之，这件没谱的事情要尽量淡定，莫走过头了。一帮乳臭未干的小子和黄毛丫头，还是老老实实做事比较靠谱。

    目前天朝的网络环境貌似令人担忧，我心里很没底，估计封站也是说不准的事情。到那时，这些想法都成了彻底的扯淡。万一发生这种事情，啷个儿办呢？
