---
title: 正态分布变量和均匀分布变量分别的累加有什么关系
date: '2009-02-19'
slug: cumsum-of-normal-var-and-uniform-var
---

理论上应该是独立的啊，但今天偶然发现这么个现象：

![正态随机数累加与均匀分布随机数累加的散点图](https://db.yihui.org/imgur/AZ2m5y5.png)

不管怎么重复这幅散点图，两个累加变量之间总是有某种说不清的关系。怪哉，怪哉。

```r
n = 1e+05
x = cumsum(rnorm(n, 0, 1))
y = cumsum(runif(n, -1, 1))
cl = gray(seq(0, 1, length = n))
plot(x, y, pch = ".", col = cl, xlab = 'CUM-Norm',
  ylab = 'CUM-Uniform')
```

数学公式推得快的看官请帮忙解释一下，谢谢！

* * *

下午2:00的补充：

我想明白这个道理了，因为累加之后数据的极差比较大，而每次点的位置与上一次点的位置之间的距离相对于这个极差来说就非常小，因此点的移动就是一小步一小步的，而整幅散点图看起来就会有聚类的现象，似乎两个累加变量之间有什么依随关系，实际上跟布朗运动差不多。
