---
title: 用R画中国地图并标注城市位置
date: '2008-10-07'
slug: china-map-and-city-locations-with-r
---

从[cloud_wei的博客](http://hi.baidu.com/cloud_wei/blog/item/b26cbfa9b8e601fa1e17a295.html)上看到一批数据，拿来放在R里面跑一下：

```r
par(mar=rep(0,4))
dat = read.csv(text = "城市,jd,wd
    北 京,116.4666667,39.9
    上 海,121.4833333,31.23333333
    天 津,117.1833333,39.15
    重 庆,106.5333333,29.53333333
    哈尔滨,126.6833333,45.75
    长 春,125.3166667,43.86666667
    沈 阳,123.4,41.83333333
    呼和浩特,111.8,40.81666667
    石家庄,114.4666667,38.03333333
    太 原,112.5666667,37.86666667
    济 南,117,36.63333333
    郑 州,113.7,34.8
    西 安,108.9,34.26666667
    兰 州,103.8166667,36.05
    银 川,106.2666667,38.33333333
    西 宁,101.75,36.63333333
    乌鲁木齐,87.6,43.8
    合 肥,117.3,31.85
    南 京,118.8333333,32.03333333
    杭 州,120.15,30.23333333
    长 沙,113,28.18333333
    南 昌,115.8666667,28.68333333
    武 汉,114.35,30.61666667
    成 都,104.0833333,30.65
    贵 阳,106.7,26.58333333
    福 州,119.3,26.08333333
    台 北,121.5166667,25.05
    广 州,113.25,23.13333333
    海 口,110.3333333,20.03333333
    南 宁,108.3333333,22.8
    昆 明,102.6833333,25
    拉 萨,91.16666667,29.66666667
    香 港,114.1666667,22.3
    澳门,113.5,22.2")
library(maps)
library(mapdata)
map("china", col = "darkgray", ylim = c(18, 54), panel.first = grid())
points(dat$jd, dat$wd, pch = 19, col = rgb(0, 0, 0, 0.5))
text(dat$jd, dat$wd, dat[, 1], cex = 0.9, col = rgb(0,
    0, 0, 0.7), pos = c(2, 4, 4, 4, 3, 4, 2, 3, 4, 2, 4, 2, 2,
    4, 3, 2, 1, 3, 1, 1, 2, 3, 2, 2, 1, 2, 4, 3, 1, 2, 2, 4, 4, 2))
axis(1, lwd = 0); axis(2, lwd = 0); axis(3, lwd = 0); axis(4, lwd = 0)
```

效果如下：

![用R画中国地图并标注城市位置](https://db.yihui.org/imgur/LE4I8.png)

写这篇日志的目的是征人同投论文，写一些用R获取生活中的“边角料”数据并利用起来做点事情的例子。点击[这里](http://images.ruc.edu.cn/other/2008-10-07/1223373806156.zip)下载论文。关于R会议，请随时[关注通知](https://cosx.org/cn/topic/12064)。有同写意向的请速速联系我。
